# 电话子系统错误码

> **说明：**
>
> 以下仅介绍本模块特有错误码，通用错误码请参考[通用错误码说明文档](errorcode-universal.md)。

## 8300001 输入参数不在处理范围内

**错误信息**

The input parameter value is out of range.

**错误描述**

输入参数不在处理范围内，如slotId无效等，将无法进行相应的操作。

**可能原因**

输入参数无效。

**处理步骤**

请输入正确的有效参数。



## 8300002 服务连接失败

**错误信息**

Operation failed. Cannot connect to service.

**错误描述**

操作失败。无法连接到服务。

**可能原因**

服务启动失败，IPC连接失败等。

**处理步骤**

本次操作异常，请稍后重试。



## 8300003 系统内部错误

**错误信息**

System internal error.

**错误描述**

系统内部错误。

**可能原因**

网络异常，数据读写失败等。

**处理步骤**

本次操作异常，请稍后重试。


## 8300004 未识别SIM卡

**错误信息**

Do not have sim card.

**错误描述**

没有识别到sim卡。

**可能原因**

未插入SIM卡或未正常插入SIM卡。

**处理步骤**

请插卡或重新拔插SIM卡。


## 8300999 未知错误

**错误信息**

Unknown error code.

**错误描述**

未知的错误。

**可能原因**

系统内部出现了意料之外的错误，可能是由于底层的错误码不在处理范围内。

**处理步骤**

操作异常，请稍后再试。


## 8301001 SIM卡未激活

**错误信息**

SIM card is not activated.

**错误描述**

SIM卡未激活。

**可能原因**

没有激活SIM卡。

**处理步骤**

请激活SIM卡。


## 8301002 SIM卡读取数据或者更新数据失败

**错误信息**

SIM card operation error.

**错误描述**

SIM卡读取数据或者更新数据失败。

**可能原因**

SIM不支持该操作，或者SIM卡已损坏。

**处理步骤**

请联系SIM卡运营商，或者更换SIM卡。


## 8301003 随卡配置错误

**错误信息**

Operator config error.

**错误描述**

随卡配置错误。

**可能原因**

未预置对应SIM卡的随卡配置文件。

**处理步骤**

请检查是否插入正确的SIM卡。

## 8401001 UT连接失败

**错误信息**

UT is not connected.

**错误描述**

UT未连接

**可能原因**

当前运营商不支持从WIFI下发UT请求，但是当前设备WIFI已连上。

**处理步骤**

断开WIFI，再重发UT请求。
