# 资源管理错误码

> **说明：**
>
> 以下仅介绍本模块特有错误码，通用错误码请参考[通用错误码说明文档](errorcode-universal.md)。

## 9001001 无效的资源id

**错误信息**

The resId invalid.

**错误描述**

当传入的资源id符合类型校验，但却是一个不存在的资源id时，会报出此错误。

**可能原因**

传入的是一个不存在的id值。

**处理步骤**

检查传入参数的资源id是否已有。

## 9001002 根据当前资源id，找不到匹配的资源

**错误信息**

The resource not found by resId.

**错误描述**

当传入的资源id符合类型校验，但是根据此资源id匹配不到资源时，会报出此错误。

**可能原因**

1、传入的是资源id有误。

2、资源解析有误。

**处理步骤**

检查传入的资源id是否符合预期。

## 9001003 无效的资源名称

**错误信息**

The resName invalid.

**错误描述**

当传入的资源名称符合类型校验，但却是一个不存在的资源名称时，会报出此错误。

**可能原因**

传入的是一个不存在的资源名称。

**处理步骤**

检查传入的资源名称是否符合预期。

## 9001004 根据当前资源名称，找不到匹配的资源

**错误信息**

The resource not found by resName.

**错误描述**

当传入的资源名称符合类型校验，但是根据此资源名称，匹配不到资源。

**可能原因**

1、传入的是资源名称有误。

2、资源解析有误。

**处理步骤**

可先检查传入的资源名称是否符合预期。

## 9001005 无效的相对路径

**错误信息**

The resource not found by path.

**错误描述**

根据参数相对路径, 找不到对应的资源。

**可能原因**

传入的相对路径有误。

**处理步骤**

可检查传入的相对路径是否符合预期。

## 9001006 循环引用

**错误信息**

the resource re-ref too much.

**错误描述**

解析引用次数过高。

**可能原因**

出现资源循环引用的情况。

**处理步骤**

查看资源$引用的地方，去除循环引用的情况。