# 通知错误码

> **说明：**
>
> 以下仅介绍本模块特有错误码，通用错误码请参考[通用错误码说明文档](errorcode-universal.md)。

## 1600001 内部错误

**错误信息**

Internal error.

**错误描述**

多线程处理异常、内部指针校验错误等内部处理错误时，方法将返回该错误码。

**可能原因**

多线程处理、内部处理异常等内核通用错误。

**处理步骤**

确认系统资源是否足够。

## 1600002 序列化或反序列化错误

**错误信息**

marshalling or unmarshalling error.

**错误描述**

数据传输前，进行序列化或反序列化错误，方法将返回该错误码。

**可能原因**

应用与通知服务字段未匹配。

**处理步骤**

检查应用sdk版本与系统版本是否匹配。

## 1600003 连接通知服务失败

**错误信息**

Failed to connect service.

**错误描述**

应用连接通知服务失败，方法将返回该错误码。

**可能原因**

通知服务繁忙或异常。

**处理步骤**

重启系统。

## 1600004 通知开关关闭

**错误信息**

Notification is not enabled.

**错误描述**

当通知开关为关闭状态时，方法将返回该错误码。

**可能原因**

应用的通知开关为关闭状态。

**处理步骤**

通知设置里开启应用通知开关。

## 1600005 通知渠道关闭

**错误信息**

Notification slot is not enabled.

**错误描述**

当通知渠道关闭时，方法将返回该错误码。

**可能原因**

通知渠道关闭状态，或未添加该类型渠道。

**处理步骤**

1、通知设置里查看应用是否有该类型渠道，没有需要新增。

2、通知设置里查看应用该类型渠道状态，要保持开启状态。

## 1600006 通知删除失败

**错误信息**

Notification is not allowed to remove.

**错误描述**

通知设置了禁止删除属性，方法将返回该错误码。

**可能原因**

通知设置了禁止删除属性。

**处理步骤**

参考[NotificationRequest](../apis/js-apis-notificationManager.md#notificationrequest)通知禁止删除属性。

## 1600007 通知不存在

**错误信息**

The notification is not exist.

**错误描述**

通知服务未找到该通知，方法将返回该错误码。

**可能原因**

通知已被取消或删除。

**处理步骤**

无

## 1600008 用户不存在

**错误信息**

The user is not exist.

**错误描述**

传入的用户信息系统里未查询到，方法将返回该错误码。

**可能原因**

传入用户信息有误。

**处理步骤**

检查传入的用户信息。

## 1600009 通知发布频度超过限制

**错误信息**

Over max number notifications per second.

**错误描述**

通知发送频率超过限制，方法将返回该错误码。

**可能原因**

通知发送频率超过每秒10个。

**处理步骤**

降低通知发送频率。

## 16000010 分布式操作失败

**错误信息**

Distributed operation failed.

**错误描述**

分布式数据库操作异常或分布式接口调用异常，方法将返回该错误码。

**可能原因**

分布式数据库操作异常或分布式接口调用异常。

**处理步骤**

检查分布式连接是否正常。

## 16000011 读模板配置文件错误

**错误信息**

Read template config failed.

**错误描述**

模板配置文件读取异常，方法将返回该错误码。

**可能原因**

系统中模板配置文件丢失。

**处理步骤**

请检查系统中模板配置文件是否存在，配置文件路径：/system/etc/notification_template/external.json。

## 16000012 内存空间不够

**错误信息**

No memory space.

**错误描述**

内存申请出现错误，方法将返回该错误码。

**可能原因**

内存申请出现错误。

**处理步骤**

确认系统内存是否足够。
