# Socket 错误码

> **说明：**
>
> 以下仅介绍本模块特有错误码，通用错误码请参考[通用错误码说明文档](errorcode-universal.md)。

## 2301001 操作不允许

**错误信息**

Operation not permitted.

**错误描述**

操作不允许。

**可能原因**

非法操作。

**处理步骤**

检查操作步骤。

## 2301002 文件不存在

**错误信息**

No such file or directory.

**错误描述**

文件不存在。

**可能原因**

文件不存在。

**处理步骤**

检查文件名或文件路径。

## 2301003 进程不存在

**错误信息**

No such process.

**错误描述**

进程不存在。

**可能原因**

进程不存在

**处理步骤**

排查进程信息。

## 2301004 系统调用中断

**错误信息**

Interrupted system call.

**错误描述**

系统调用中断。

**可能原因**

系统调用中断。

**处理步骤**

排查系统调用。

**TCP/UDP 错误码说明：**
> TCP/UDP Socket其余错误码映射形式为：2301000 + Linux系统内核错误码errno，关键信息请参考Linux系统内核错误码。

## 2300002 系统内部错误

**错误信息**

System internal error.

**错误描述**

系统内部错误。

**可能原因**

1.内存异常。

2.空指针。

**处理步骤**

1.检查内存空间是否充足，清理内存后重试。

2.系统异常，请稍后重试或重启设备。

## 2303104 中断系统调用

**错误信息**

Interrupted system call.

**错误描述**

中断系统调用。

**可能原因**

调有connect时，可能会导致阻塞时间过长，所以系统产生中断信号，返回EINTR错误。

**处理步骤**

尝试重新走网络连接流程。

## 2303109 错误文件编号

**错误信息**

Bad file number.

**错误描述**

在本地关闭的套接字上进行操作将返回该错误。

**可能原因**

socket fd可能被关闭了，所以发生参数无效的错误。

**处理步骤**

检查socket是否被意外关闭。

## 2303111 资源暂时不可用，请重试

**错误信息**

Resource temporarily unavailable try again.

**错误描述**

系统资源暂时不可用，尝试再次调用。

**可能原因**

系统资源繁忙。

**处理步骤**

重新调用接口。

## 2303188 非套接字的套接字操作

**错误信息**

Socket operation on non-socket.

**错误描述**

参数socket未指定一个套接字描述符。

**可能原因**

参数不是套接字类型的描述符。

**处理步骤**

检查代码描述符的获取是否正确。

## 2303191 socket协议类型错误

**错误信息**

Protocol wrong type for socket.

**错误描述**

参数设置的协议类型错误。

**可能原因**

标识了协议的Socket函数在不支持的socket上进行操作。
如Internet UDP协议不能被标识为SOCK_STREAM socket类型。

**处理步骤**

检查参数设置是否符合协议类型。

## 2303198 网络地址已被使用

**错误信息**

Address already in use.

**错误描述**

地址已被使用。

**可能原因**

如果应用程序试图将套接字绑定到已用于现有套接字的IP地址/端口，或未正确关闭的套接字，或仍在关闭过程中的套接字，则会发生此错误。

**处理步骤**

尝试其他地址。

## 2303199 不能分配请求的地址

**错误信息**

Cannot assign requested address.

**错误描述**

请求的地址在其上下文中无效。

**可能原因**

当远程地址或端口对远程计算机无效时，可能发生该问题。

**处理步骤**

检查地址或端口是否正确。

## 2303210 连接超时

**错误信息**

Connection timed out.

**错误描述**

长时间不能和远程服务器建立连接。

**可能原因**

这种情况一般发生在服务器主机崩溃。

**处理步骤**

本地处理不了，需要确认远程服务器是否发生问题。

## 2303501 SSL为空

**错误信息**

SSL is null.

**错误描述**

参数错误。

**可能原因**

当内部发生函数执行失败时，会获取错误信息，当获取信息为null时，发生该错误。

**处理步骤**

尝试重新执行一遍流程。

## 2303502 tls读取错误

**错误信息**

Error in tls reading.

**错误描述**

等待套接字可读。

**可能原因**

底层socket阻塞。

**处理步骤**

重新执行接收数据的操作。

## 2303503 tls写入错误

**错误信息**

Error in tls writing.

**错误描述**

等待套接字可写。

**可能原因**

发送端缓冲区已满时，底层套接字发送将给出EWOUDLBLOCK错误，这意味着服务器没有读取从客户端发送的消息。

**处理步骤**

需要检查服务器并修复它。

## 2303504 查找x509时出错

**错误信息**

Error looking up x509.

**错误描述**

认证x509证书发生错误，操作未完成。

**可能原因**

本地证书和服务器证书不匹配。

**处理步骤**

检查本地CA跟证书和服务器证书是否匹配。

## 2303505 tls系统调用错误

**错误信息**

Error occurred in the tls system call.

**错误描述**

发生了一些不可恢复的致命I/O错误。

**可能原因**

网络问题，导致通信失败。

**处理步骤**

请参阅Linux系统内核错误码errno以了解详细信息。

## 2303506 清除tls连接出错

**错误信息**

Error clearing tls connection.

**错误描述**

TLS/SSL连接已关闭。

**可能原因**

协议中出现关闭警报时，即连接已完全关闭时，才会返回此结果代码。

**处理步骤**

尝试重新发起连接。