# HTTP错误码

> **说明：**
>
> 以下仅介绍本模块特有错误码，通用错误码请参考[通用错误码说明文档](errorcode-universal.md)。

## 2300001 不支持的协议

**错误信息**

Unsupported protocol.

**错误描述**

协议版本服务器不支持。

**可能原因**

传入的协议版本，服务器不支持。

**处理步骤**

请检查传入的协议版本是否合理，排查服务器实现。

## 2300003 URL格式错误

**错误信息**

URL using bad/illegal format or missing URL.

**错误描述**

URL格式错误。

**可能原因**

可能传入的url格式不正确。

**处理步骤**

检查传入的url格式是否正确。

## 2300005 代理服务器域名解析失败

**错误信息**

Couldn't resolve proxy name.

**错误描述**

代理服务器的域名无法解析。

**可能原因**

服务器的URL不正确

**处理步骤**

排查代理服务器的URL是否正确。

## 2300006 域名解析失败

**错误信息**

Couldn't resolve host name.

**错误描述**

服务器的域名无法解析。

**可能原因**

1.传入的服务器的URL不正确。

2.网络不通畅。

**处理步骤**

1.请检查输入的服务器的URL是否合理。

2.请检查网络连接情况

## 2300007 无法连接到服务器

**错误信息**

Couldn't connect to server.

**错误描述**

服务器无法连接。

**可能原因**

可能传入的url格式不正确。

**处理步骤**

检查传入的url格式是否正确。

## 2300008 服务器返回非法数据

**错误信息**

Weird server reply.

**错误描述**

服务器返回非法数据。

**可能原因**

服务器出错，返回了非HTTP格式的数据。

**处理步骤**

排查服务器实现。

## 2300009 拒绝对远程资源的访问

**错误信息**

Access denied to remote resource.

**错误描述**

拒绝对远程资源的访问。

**可能原因**

指定的内容被服务器拒绝访问。

**处理步骤**

排查请求内容。

## 2300016 HTT2帧层错误

**错误信息**

Error in the HTTP2 framing layer.

**错误描述**

HTTP2层级的错误。

**可能原因**

服务器不支持HTTP2。

**处理步骤**

抓包分析、排查服务器是否支持HTTP2。

## 2300018 服务器返回数据不完整

**错误信息**

Transferred a partial file.

**错误描述**

服务器返回的数据不完整。

**可能原因**

可能与服务器实现有关

**处理步骤**

排查服务器实现。

## 2300023 向磁盘/应用程序写入接收数据失败

**错误信息**

Failed writing received data to disk/application.

**错误描述**

向磁盘/应用程序写入接收数据失败。

**可能原因**

应用没有写文件权限。

**处理步骤**

排查应用权限。

## 2300025 上传失败

**错误信息**

Upload failed.

**错误描述**

上传失败。

**可能原因**

文件过大或者网络问题。对于FTP，服务器通常会拒绝STOR命令。错误缓冲区通常包含服务器的解释。

**处理步骤**

排查文件大小及网络状况。

## 2300026 从文件/应用程序中打开/读取本地数据失败

**错误信息**

Failed to open/read local data from file/application.

**错误描述**

从文件/应用程序中打开/读取本地数据失败。

**可能原因**

应用没有读文件权限

**处理步骤**

排查应用权限。

## 2300027 内存不足

**错误信息**

Out of memory.

**错误描述**

内存不足。

**可能原因**

内存不足。

**处理步骤**

排查系统内存。

## 2300028 操作超时

**错误信息**

Timeout was reached.

**错误描述**

操作超时。

**可能原因**

TCP连接超时或读写超时。

**处理步骤**

排查网络问题。

## 2300047 重定向次数达到最大值

**错误信息**

Number of redirects hit maximum amount.

**错误描述**

重定向次数达到最大值。

**可能原因**

重定向次数过多

**处理步骤**

排查服务器实现。

## 2300052 服务器没有返回内容

**错误信息**

Server returned nothing (no headers, no data).

**错误描述**

服务器没有返回内容。

**可能原因**

可能与服务器实现有关。

**处理步骤**

排查服务器实现。

## 2300055 发送网络数据失败

**错误信息**

Failed sending data to the peer.

**错误描述**

无法往对端发送数据，发送网络数据失败。

**可能原因**

网络问题。

**处理步骤**

排查网络。

## 2300056 接收网络数据失败

**错误信息**

Failure when receiving data from the peer.

**错误描述**

无法往从对端收到数据，接收网络数据失败。

**可能原因**

网络问题

**处理步骤**

排查网络问题。

## 2300058 本地SSL证书错误

**错误信息**

Problem with the local SSL certificate.

**错误描述**

本地SSL证书错误。

**可能原因**

SSL证书格式有错误。

**处理步骤**

检查SSL证书格式。

## 2300059 无法使用指定的密码

**错误信息**

Couldn't use specified SSL cipher.

**错误描述**

无法使用指定的密码。

**可能原因**

client和sever协商的加密算法系统不支持。

**处理步骤**

抓包分析协商的算法。

## 2300060 远程服务器SSL证书或SSH秘钥不正确

**错误信息**

SSL peer certificate or SSH remote key was not OK.

**错误描述**

远程服务器SSL证书或SSH秘钥不正确。

**可能原因**

无法校验服务器身份，有可能是证书过期了

**处理步骤**

检查证书有效性。

## 2300061 无法识别或错误的HTTP编码格式

**错误信息**

Unrecognized or bad HTTP Content or Transfer-Encoding.

**错误描述**

无法识别或错误的HTTP编码格式。

**可能原因**

HTTP编码格式不正确。

**处理步骤**

排查服务器实现，目前仅支持gzip编码。

## 2300063 超出最大文件大小

**错误信息**

Maximum file size exceeded.

**错误描述**

超出最大文件大小。

**可能原因**

下载的文件过大。

**处理步骤**

排查服务器实现。

## 2300070 服务器磁盘空间不足

**错误信息**

Remote disk full or allocation exceeded.

**错误描述**

服务器磁盘空间不足。

**可能原因**

服务器磁盘已满

**处理步骤**

检查服务器磁盘空间。

## 2300073 服务器返回文件已存在

**错误信息**

Remote file already exists.

**错误描述**

服务器返回文件已存在。

**可能原因**

上传文件的时候，服务器返回文件已经存在。

**处理步骤**

排查服务器。

## 2300077 SSL CA证书不存在或没有访问权限

**错误信息**

Problem with the SSL CA cert (path? access rights?).

**错误描述**

SSL CA证书不存在或没有访问权限。

**可能原因**

证书不存在或者没有访问权限。

**处理步骤**

检查证书是否存在或者有没有访问权限。

## 2300078 URL请求的文件不存在

**错误信息**

Remote file not found.

**错误描述**

URL请求的文件不存在。

**可能原因**

URL请求的文件不存在

**处理步骤**

检查URL请求的文件是否存在。

## 2300094 身份校验失败

**错误信息**

An authentication function returned an error.

**错误描述**

身份校验失败。

**可能原因**

传入的校验身份的字段与服务器不匹配。

**处理步骤**

排查传入的校验身份的字段是否与服务器匹配。

## 2300999 未知错误

**错误信息**

Unknown Other Error.

**错误描述**

未知错误。

**可能原因**

未知错误。

**处理步骤**

未知错误。
