# Media错误码

> **说明：**
>
> 以下仅介绍本模块特有错误码，通用错误码请参考[通用错误码说明文档](errorcode-universal.md)。

## 5400101 内存分配失败

**错误信息**

No memory.

**错误描述**

分配内存失败。

**可能原因**

1. 实例数量超过16个。
2. new或者malloc流程失败导致空指针。

**处理步骤**

销毁当前实例，并重新创建，如果重新创建失败，则停止相关操作。

## 5400102 当前状态机不支持此操作

**错误信息**

Operation not allowed.

**错误描述**

当前操作不允许。

**可能原因**

当前状态机不支持此操作。

**处理步骤**

确认当前状态是否支持当前操作，把实例切换到正确的状态进行正确的操作。

## 5400103 出现IO错误

**错误信息**

I/O error.

**错误描述**

出现IO错误。

**可能原因**

媒体与其他模块的数据交互发生问题(图形、音频、网络、HDI、相机)。

**处理步骤**

确认网络是否通畅，并销毁当前实例，并重新创建，如果重新创建失败，则停止相关操作。

## 5400104 操作超时

**错误信息**

Operation timeout.

**错误描述**

操作超时。

**可能原因**

1. 网络超时。
2. 访问其他模块超时。

**处理步骤**

1. 确认网络是否通畅。
2. 销毁当前实例，并重新创建，如果重新创建失败，则停止相关操作。

## 5400105 播放服务死亡

**错误信息**

Service died.

**错误描述**

播放服务死亡。

**可能原因**

播放服务死亡。

**处理步骤**

销毁当前实例，并重新创建，如果重新创建失败，则停止相关操作。

## 5400106 不支持的规格

**错误信息**

Unsupport format.

**错误描述**

不支持的规格。

**可能原因**

不支持的文件或者格式。

**处理步骤**

当前使用的格式规格不支持，用户需要切换为支持的规格。



