# 系统事件错误码

> **说明：**
>
> 以下仅介绍本模块特有错误码，通用错误码请参考[通用错误码说明文档](errorcode-universal.md)。

## 1120001 非法的事件领域

**错误信息**

Invalid event domain.

**错误描述**

在调用write接口进行系统事件打点时，由于传入了非法的事件领域名称，系统将忽略此次系统事件打点。

**可能原因**

1.系统事件领域名称长度超过16个字符；
2.系统事件领域名称包含特殊字符；
3.系统事件领域名称为空。

**处理步骤**

检查系统事件领域名称是否合法。

## 1120002 非法的事件名称

**错误信息**

Invalid event name.

**错误描述**

在调用write接口进行系统事件打点时，由于传入了非法的事件名称，系统将忽略此次系统事件打点。

**可能原因**

1.系统事件名称长度超过32个字符；
2.系统事件名称包含特殊字符；
3.系统事件名称为空。

**处理步骤**

检查系统事件名称是否合法。

## 11200003 环境异常

**错误信息**

Abnormal environment.

**错误描述**

在调用write接口进行系统事件打点时，由于环境异常，系统将忽略此次系统事件打点。

**可能原因**

1.hiview服务未成功启动；
2.hiview服务socket异常。

**处理步骤**

尝试重新调用write接口进行打点。

## 11200004 事件长度超过限制

**错误信息**

Length of the event is over limit.

**错误描述**

在调用write接口进行系统事件打点时，由于传入的事件总长度超过限制，系统将忽略此次系统事件打点。

**可能原因**

系统事件总长度超过384K。

**处理步骤**

检查系统事件总长度是否大于384K。

## 11200051 非法的事件参数

**错误信息**

Invalid event parameter.

**错误描述**

在调用write接口进行系统事件打点时，由于传入了非法的参数名称，系统以抛出错误的形式提示，但会完成此次系统事件打点。

**可能原因**

1.系统事件参数名称长度超过32个字符；
2.系统事件参数名称包含特殊字符；
3.系统事件参数名为空。

**处理步骤**

检查系统事件参数名称是否合法。

## 11200052 字符串类型的事件参数值的长度超过限制

**错误信息**

Size of the event parameter of the string type is over limit.

**错误描述**

在调用write接口进行系统事件打点时，由于传入了长度超限的字符串类型参数，系统以抛出错误的形式提示，但会完成此次系统事件打点。

**可能原因**

字符串类型的参数值的长度超过10K。

**处理步骤**

检查系统事件中字符串类型的参数值的长度是否超过10K。

## 11200053 事件参数的数量超过限制

**错误信息**

Count of event parameters is over limit.

**错误描述**

在调用write接口进行系统事件打点时，由于传入的事件参数数量超过限制，系统以抛出错误的形式提示，但会完成此次系统事件打点。

**可能原因**

系统事件的参数数量超过128个。

**处理步骤**

检查系统事件的参数数量是否超过了128个。

## 11200054 数组类型的事件参数值的长度超过限制

**错误信息**

Count of event parameter of the array type is over limit.

**错误描述**

在调用write接口进行系统事件打点时，由于传入了长度超过限制的数组类型的参数，系统以抛出错误的形式提示，但会完成此次系统事件打点。

**可能原因**

系统事件中有数组类型的参数值的长度超过100。

**处理步骤**

检查数组类型的参数值的长度是否超过100.

## 11200101 事件监听者的数量超过限制

**错误信息**

Count of watchers is over limit.

**错误描述**

在调用addWatcher接口添加系统事件监听者时，由于添加的监听者数量超过限制，系统将拒绝此系统事件监听者的添加。

**可能原因**

hiview服务已添加30个系统事件监听者，无法添加新的系统事件监听者。

**处理步骤**

检查已成功添加的系统事件监听者数量是否超过了30个。

## 11200102 事件监听者包含的监听规则数量超过限制

**错误信息**

Count of watch rules is over limit.

**错误描述**

在调用addWatcher接口添加系统事件监听者时，由于该系统事件监听者包含的监听规则数量超过限制，系统将拒绝此系统事件监听者的添加。

**可能原因**

系统事件监听者包含的监听规则的数量超过20个。

**处理步骤**

检查系统事件监听者包含的监听规则数量是否超过20个。

## 11200201 事件监听者不存在

**错误信息**

The watcher does not exist.

**错误描述**

在调用removeWatcher移除系统事件监听者时，由于该系统事件监听者不在监听队列，系统将拒绝此系统事件监听者的移除。

**可能原因**

1.尝试移除的系统事件监听者为空；
2.尝试移除的系统事件监听者没有被成功添加过。

**处理步骤**

检查移除的系统事件监听者是否为空，或者是否成功添加过此系统事件监听者。

## 11200301 查询规则的数量超过限制

**错误信息**

Count of query rules is over limit.

**错误描述**

在调用query接口查询系统事件时，由于传入的查询规则数量超限，系统将忽略此次系统事件的查询。

**可能原因**

查询规则个数超过10个。

**处理步骤**

检查查询规则数量是否超过10个。


## 11200302 非法的查询规则

**错误信息**

Invalid query rule.


**错误描述**

在调用query接口查询系统事件时，由于传入了非法的查询规则，系统将忽略此次系统事件的查询。

**可能原因**

1.查询规则中的事件领域名称长度超过16个字符或者事件名称长度超过32个字符；
2.查询规则中的事件领域名称或者事件名称包含特殊字符；
3.查询规则中的事件领域名称或者事件名称为空。

**处理步骤**

检查查询规则中配置的事件领域名称及事件名称是否合法。

## 11200303 并发查询的数量超过限制

**错误信息**

Count of concurrent queriers is over limit.

**错误描述**

在调用query接口查询系统事件时，由于在同一时间点并发查询的数量超过限制，系统将忽略此次系统事件的查询。

**可能原因**

并发查询的数量超过4个。

**处理步骤**

检查在同一时间点是否有4个以上的查询操作。

## 11200304 查询频率超过限制

**错误信息**

Query frequency is over limit.

**错误描述**

在调用query接口查询系统事件时，由于查询频率超过限制，系统将忽略此次系统事件的查询。

**可能原因**

查询频率超过1次/秒。

**处理步骤**

检查是否在1秒内进行1次以上的查询。
