# 位置服务子系统错误码

> **说明：**
>
> 以下仅介绍本模块特有错误码，通用错误码请参考[通用错误码说明文档](errorcode-universal.md)。

## 3301000 位置服务不可用

**错误信息**

Location service is unavailable.

**错误描述**

位置服务不可用,位置服务相关的接口无法调用.

**可能原因**

1.位置服务启动异常,导致应用和位置服务子系统通信失败,导致位置服务不可用.

2.GNSS芯片初始化失败导致GNSS定位功能失效.

3.网络定位服务异常,导致网络定位功能失效.

**处理步骤**

请停止调用该接口.

## 3301100 位置功能的开关未开启导致功能失败

**错误信息**

The location switch is off.

**错误描述**

位置功能的开关未开启导致功能失败.

**可能原因**

位置功能的开关未开启,导致持续定位,单次定位等基本功能不可用.

**处理步骤**

请提示用户开启位置功能的开关.

## 3301200 定位失败,未获取到定位结果

**错误信息**

Failed to obtain the geographical location.

**错误描述**

定位失败,未获取到定位结果.

**可能原因**

1.GNSS信号弱,导致定位超时.

2.网络定位异常导致定位超时.

**处理步骤**

请重新发起定位请求.

## 3301300 逆地理编码查询失败

**错误信息**

Reverse geocoding query failed.

**错误描述**

逆地理编码查询失败.

**可能原因**

数据网络比较卡顿,导致端侧的请求发送失败或者云端的结果未返回到端侧.

**处理步骤**

请重试逆地理编码查询.

## 3301400 地理编码查询失败

**错误信息**

Geocoding query failed.

**错误描述**

地理编码查询失败.

**可能原因**

数据网络比较卡顿,导致端侧的请求发送失败或者云端的结果未返回到端侧.

**处理步骤**

请重试地理编码查询.

## 3301500 区域信息（包含国家码）查询失败

**错误信息**

Failed to query the area information.

**错误描述**

区域信息（包含国家码）查询失败.

**可能原因**

未查询到正确的区域信息.

**处理步骤**

请停止调用查询区域码的接口.

## 3301600 地理围栏操作失败

**错误信息**

Failed to operate the geofence.

**错误描述**

地理围栏操作失败,包含添加,删除,暂停和恢复等操作.

**可能原因**

1.GNSS芯片不支持地理围栏功能.

2.底层业务逻辑异常导致操作地理围栏失败.

**处理步骤**

请停止调用地理围栏操作接口.

## 3301700 请求无响应

**错误信息**

No response to the request.

**错误描述**

某些异步请求需要用户点击按钮确认,或者需要GNSS芯片和网络服务器响应,这些场景下未收到响应导致业务失败.

**可能原因**

1.用户未点击按钮确认.

2.GNSS芯片未响应.

3.网络服务器未响应.

**处理步骤**

请停止调用相关接口.