﻿# 媒体会话管理错误码

> **说明：**
>
> 以下仅介绍本模块特有错误码，通用错误码请参考[通用错误码说明文档](errorcode-universal.md)。

## 6600101 会话服务端异常

**错误信息**

Session service exception.

**错误描述**

会话服务端异常，应用端无法获取服务端的消息响应。如会话服务未运行或者会话服务通信失败。

**可能原因**

会话重启过程中服务被杀。

**处理步骤**

1.定时重试，超过3s仍失败时，停止对该会话或者控制器进行操作。

2.销毁当前会话或者会话控制器，并重新创建，如果重新创建失败，则停止会话相关操作。

## 6600102 会话不存在

**错误信息**

The session does not exist.

**错误描述**

会话对象不存在时，向该会话设置参数或者发送命令。

**可能原因**

会话已被销毁，服务端无会话记录。

**处理步骤**

1.如果在会话被控端产生该错误，请重新创建会话；如果是会话控制端，请停止向该会话发送查询或者控制命令。

2.如果在会话管理端产生该错误，请重新查询系统当前会话记录，在创建控制器时传入正确的会话ID。

## 6600103 会话控制器不存在

**错误信息**

The session controller does not exist.

**错误描述**

会话控制器不存在时，向该控制器发送控制命令或者事件。

**可能原因**

控制器已被销毁。

**处理步骤**

请重新查询系统当前会话记录，并创建对应的会话控制器。

## 6600104 远端会话连接失败

**错误信息**

The remote session connection failed.

**错误描述**

本端会话与远端会话通信失败。

**可能原因**

设备间通信断开。

**处理步骤**

停止对该会话发送控制命令，并监听输出设备变化，当输出设备发送变化后恢复发送。

## 6600105 无效会话命令

**错误信息**

Invalid session command.

**错误描述**

会话被控端不支持该被控命令或事件。

**可能原因**

被控端不支持该命令。

**处理步骤**

停止发送该命令或事件，并查询被控会话支持的命令集，发送被控端支持的命令。

## 6600106 会话未激活

**错误信息**

The session is not activated.

**错误描述**

会话没有激活时，向会话发送控制命令或者事件。

**可能原因**

会话处于未激活状态。

**处理步骤**

停止发送该命令或事件，监听会话的激活状态，会话激活后恢复发送该命令或事件。

## 6600107 命令&消息过载

**错误信息**

Too many commands or events.

**错误描述**

会话客户端在一段时间内向服务端发送了过多的消息或者命令，引起服务端消息过载。

**可能原因**

服务端消息过载。

**处理步骤**

检查自身命令发送是否过于频繁，控制自身查询和控制命令的发送频度。