# Audio错误码

> **说明：**
>
> 以下仅介绍本模块特有错误码，通用错误码请参考[通用错误码说明文档](errorcode-universal.md)。

## 6800101 无效入参

**错误信息**

Invalid parameter.

**错误描述**

调用接口时，传入的参数无效。

**可能原因**

参数无效，比如值不在边界范围内，没有使用指定的枚举范围等。

**处理步骤**

根据接口文档，传入正确的入参。

## 6800102 分配内存失败

**错误信息**

Memory allocation failure.

**错误描述**

调用接口时，分配内存失败或者出现空指针。

**可能原因**

1. 系统内存压力大，没有足够的内存用来映射。
2. 对于失效的实例，没有及时销毁释放内存。

**处理步骤**

1. 销毁当前实例。
2. 重新创建实例，如果重新创建失败，则停止相关操作。

## 6800103 状态不支持

**错误信息**

Unsupported state.

**错误描述**

当前状态不支持此操作。

**可能原因**

当前状态机不支持操作。比如未启动流就播放数据等。

**处理步骤**

1. 确认当前状态是否支持当前操作。
2. 把实例切换到正确的状态进行正确的操作。

## 6800104 参数选项不支持

**错误信息**

Unsupported parameter value.

**错误描述**

参数选项不支持。

**可能原因**

入参选值不在系统支持规格范围内。

**处理步骤**

1. 确认当前api支持的枚举或其他入参。
2. 改用支持的参数选项。

## 6800105 处理超时

**错误信息**

Processing timeout.

**错误描述**

等待处理超时。

**可能原因**

等待外部处理超时，比如等待应用填写音频数据超时。

**处理步骤**

控制数据填写的时间，例如增加延迟处理。

## 6800201 音频流数量达到极限

**错误信息**

Too many audio streams.

**错误描述**

达到系统可支持的最大数量。

**可能原因**

无效的音频流没有及时释放。

**处理步骤**

释放其他不再使用的音频流资源。

## 6800301 系统处理异常

**错误信息**

System error.

**错误描述**

系统处理异常。

**可能原因**

系统处理异常，比如系统服务重启、跨进程调用异常等。

**处理步骤**

系统内部通用错误，出现的情况不明确，建议尝试重新创建业务。

