# 帐号管理错误码

> **说明：**
>
> 以下仅介绍本模块特有错误码，通用错误码请参考[通用错误码说明文档](errorcode-universal.md)。

以下错误码包括系统帐号、分布式帐号和应用帐号错误码。

## 12300001 系统服务异常

**错误信息**

System service works abnormally.

**可能原因**

该错误码表示系统服务异常，可能原因如下：
1. 帐号管理服务无法正常启动。
2. 帐号管理的IPC对象无法获取。
3. 帐号管理依赖的其他服务无法正常启动或者IPC对象无法获取。
4. 服务未初始化。
5. 磁盘空间不足。
6. 读写文件异常。
7. 创建目录异常。
8. 创建删除文件异常。
9. 读写数据库异常。

**处理步骤**

请稍后重试，或重启设备。

## 12300002 无效参数

**错误信息**

Invalid parameter. 

**可能原因**

该错误码表示传入无效的参数，可能原因如下：
1. 用户名为空。
2. 系统帐号用户名长度大于1024。
3. 分布式帐号用户名长度大于256。
4. 系统帐号id小于0、小于100或大于1099。
5. 分布式帐号id长度大于512。
6. 分布式帐号传入不支持的事件类型。
7. 域名为空。
8. 域名长度大于128。
9. 域帐号为空。
10. 域帐号长度大于512。
11. 约束为空。
12. 约束长度大于128。
13. 传入无效的认证和查询参数。
14. 提供的系统帐号头像编码字符串长度超过4KB。
15. 提供的分布式帐号头像编码字符串长度超过2MB。
16. 提供非jpg和png的图片。
17. 应用帐号名长度超过512。
18. 鉴权类型长度超过1024。
19. 令牌长度超过1024。
20. 键名长度超过1024。
21. 自定义数据值长度超过1024。
22. 无效的令牌。
23. 无效的上下文标识。
24. 无效的凭据标识。

**处理步骤**

请传入正确的参数。

## 12300003 帐号不存在

**错误信息**

The account does not exist.

**可能原因**

该错误码表示操作的帐号不存在，可能原因如下:
1. 查询/激活/删除未创建的帐号。
2. 查询/激活/删除已删除的帐号。
3. 为已删除的帐号设置约束/用户名/头像。
4. 更新未创建的帐号。
5. 为不存在的帐号设置/取消帐号信息访问授权。
6. 为不存在的帐号设置/删除/查询密码。
7. 为不存在的帐号设置/删除令牌。
8. 为不存在的帐号设置额外信息。
9. 为不存在的帐号设置/删除凭据。
10. 为不存在的帐号设置自定义数据。
11. 为不存在的帐号使能分布式同步功能。

**处理步骤**

请检查帐号是否存在。

## 12300004 帐号已存在

**错误信息**

The account already exists.

**可能原因**

该错误码表示帐号已存在，可能原因如下:
创建已存在的帐号。

**处理步骤**

请取消创建，或使用其他账户号名重试。

## 12300005 不支持多用户

**错误信息**

Multi-user is not supported.

**可能原因**

该错误码表示不支持多用户，可能原因如下:
当前设备不支持多用户，无法创建帐号

**处理步骤**

无法创建其他帐号，请取消创建

## 12300006 不支持的帐号类型

**错误信息**

The account type is not supported.

**可能原因**

该错误码表示提供了不支持的帐号类型，可能原因如下:
当前设备不支持创建指定类型的帐号

**处理步骤**

请创建其他类型的帐号

## 12300007 帐号数量已达上限

**错误信息**

The account number has reached the upper limit.  

**可能原因**

该错误码表示帐号数量已达上限，可能原因如下:
创建系统帐号/应用帐号时，已存在1000个帐号。

**处理步骤**

请删除其他帐号后再创建。

## 12300008 受限的帐号

**错误信息**

The specified account is restricted.

**可能原因**

该错误码表示操作的是受限帐号，可能原因如下:
1. 删除系统保留用户。
2. 查询系统保留用户的约束源类型。
3. 创建id为0-100的帐号。

**处理步骤**

指定id为系统保留用户，无法操作。

## 12300009 帐号已激活

**错误信息**

The account has been activated.

**可能原因**

该错误码表示帐号已激活，可能原因如下:
激活已激活的帐号。

**处理步骤**

当前帐号已激活，请勿重复操作。

## 12300010 帐号服务忙碌

**错误信息**

The account service is busy.

**可能原因**

该错误码表示帐号服务忙，可能原因如下:
1. 短时间提交重复请求，如重复激活、重复设置等。
2. 应用帐号的认证会话数量超过256，无法处理新的认证请求。

**处理步骤**

请等待一段时间后重试，并降低调用频率。

## 12300011 事件监听器已注册

**错误信息**

The event listener has been registered.

**可能原因**

该错误码表示监听器已注册，可能原因如下:
当前应用向系统注册一个已经注册过的监听器，无法重复注册。

**处理步骤**

请取消注册，或使用未注册过的监听器重新注册。

## 12300012 事件监听器未注册

**错误信息**

The event listener has not been registered.

**可能原因**

该错误码表示监听器未注册，可能原因如下:
解注册一个未注册过的监听器。

**处理步骤**

请使用注册的监听器执行解注册操作

## 12300101 凭据不正确

**错误信息**

The credential is incorrect.

**可能原因**

该错误码表示凭据不正确，可能原因如下:
1. 密码输入错误；
2. 生物特征不匹配；
2. 令牌失效；

**处理步骤**

请输入正确有效的凭据重试。

## 12300102 凭据不存在

**错误信息**

The credential does not exist.

**可能原因**

该错误码表示凭据不存在，可能原因如下:
1. 认证未录入的凭据类型。
2. 查询未录入的凭据类型。
3. 删除未录入的凭据类型。

**处理步骤**

请确认凭据类型是否存在。

## 12300103 凭据输入器已注册

**错误信息**

The crdential inputer already exists.

**可能原因**

该错误码表示凭据输入器已注册，可能原因如下:
PIN码输入器已注册，解注册之前无法重复注册。

**处理步骤**

凭据输入器已存在，请勿重复操作。

## 12300104 凭据输入器不存在

**错误信息**

The crdential inputer not found.

**可能原因**

该错误码表示凭据输入器不存在，可能原因如下:
认证、添加、修改凭据时，未注册凭据输入器。

**处理步骤**

注册凭据输入器。

## 12300105 可信等级不支持

**错误信息**

The trust level is not supported.

**可能原因**

该错误码表示提供了可信等级不支持，可能原因如下:
传入系统不支持的可信等级。

**处理步骤**

请输入正确的可信等级。

## 12300106 认证类型不支持

**错误信息**

The auth type is not supported.

**可能原因**

该错误码表示提供了认证类型不支持，可能原因如下:
传入系统不支持的认证类型。

**处理步骤**

请提供系统支持的认证类型。

## 12300107 认证类型不存在

**错误信息**

The auth type does not exist.

**可能原因**

该错误码表示认证类型不存在，可能原因如下:
查询/删除令牌时，指定的鉴权类型不存在。

**处理步骤**

请使用存在的认证类型查询/删除。

## 12300108 认证会话不存在

**错误信息**

The authentication session does not exist.

**可能原因**

该错误码表示会话不存在，可能原因如下:

查询不存在的会话回调。

**处理步骤**

请使用已成功打开的会话标识查询会话回调。

## 12300109 认证被取消

**错误信息**

The authentication is canceled.

**可能原因**

该错误码表示认证被取消，可能原因如下:
认证过程中，用户取消认证操作。

**处理步骤**

重新或结束认证操作。

## 12300110 认证被锁定

**错误信息**

The authentication is locked.

**可能原因**

该错误码表示认证被锁定，可能原因如下:
认证类型错误次数超过上限。

**处理步骤**

认证错误次数超过上限，请在freezingTime之后重试。

## 12300111 认证超时

**错误信息**

The authentication is timeout.

**可能原因**

该错误码表示认证超时，可能原因如下:
1. 对于系统帐号，认证、录入超过三分钟。
2. 认证服务因网络原因无法及时响应而超时。

**处理步骤**

1. 认证录入超时，请重试。
2. 请确认网络环境无问题后重试。

## 12300112 认证服务忙

**错误信息**

The auth service is busy.

**可能原因**

该错误码表示认证服务忙，可能原因如下:
系统帐号认证时，认证总数超过5个。
应用帐号认证时，三方应用的认证器服务忙碌（根据实际情况决定）。

**处理步骤**

当前认证服务忙，请稍后重试。

## 12300113 认证服务不存在

**错误信息**

The account authenticator service does not exist.

**可能原因**

该错误码表示认证服务不存在，可能原因如下:
对于应用帐号：
1. 请求鉴权时，帐号所属应用不支持认证器服务。
2. 隐式添加帐号时，帐号所属应用不支持认证器服务。
3. 验证指定帐号的凭据时，该帐号所属应用不支持认证器服务。
4. 设置应用的认证器属性时，指定的应用不支持认证器服务。
5. 检查帐号标签时，指定的应用不支持认证器服务。

**处理步骤**

请取消操作，或向支持认证服务的应用进行认证。

## 12300114 认证服务异常

**错误信息**

The account authenticator service works abnormally.

**可能原因**

该错误码表示帐号认证服务异常，可能原因如下:
1. 身份认证服务出现未知错误；
2. 应用认证器不符合规范；

**处理步骤**

1. 请重试或重启系统。
2. 按照规范开发应用认证器。

## 12400001 应用不存在

**错误信息**

The application does not exist.

**可能原因**

该错误码表示应用不存在，可能原因如下:
1. 设置访问权限时，目标应用不存在。
2. 设置开放授权时，目标应用不存在。

**处理步骤**

请取消设置，或使用已安装的应用包名重试。

## 12400002 自定义数据不存在

**错误信息**

The custom data does not exist.

**可能原因**

该错误码表示自定义数据不存在，可能原因如下:
查询帐号的自定义数据时，输入的键名不存在。

**处理步骤**

请使用存在的自定义数据的键名查询。

## 12400003 自定义数据的数量已达上限

**错误信息**

The number of custom data reaches upper limit.

**可能原因**

该错误码表示自定义数据的数量已达上限，可能原因如下:
设置自定义数据时，目标帐号的自定义数据数量已达512。

**处理步骤**

请取消设置操作，或者删除已存在的自定义数据。

## 12400004 令牌数量已达上限

**错误信息**

The number of token reaches upper limit.

**可能原因**

该错误码表示令牌数量已达上限，可能原因如下:
添加令牌时，目标帐号的令牌数量已达1024。

**处理步骤**

请取消添加操作，或者删除已存在的令牌后再添加。

## 12400005 授权列表已达上限

**错误信息**

The size of authorization list reaches upper limit.

**可能原因**

该错误码表示授权列表已达上限，可能原因如下:
设置访问/开放授权时，授权列表的大小超过1024。

**处理步骤**

1. 请取消设置操作，或者撤销已存在的访问/开放授权后再设置。