# 无障碍子系统错误码

> **说明：**
>
> 以下仅介绍本模块特有错误码，通用错误码请参考[通用错误码说明文档](errorcode-universal.md)。

## 9300001 输入无效的包名称或者Ability名称

**错误信息**

Invalid bundle name or ability name.

**错误描述**

当输入的包名称或者Ability名称无效时，方法将返回该错误码。

**可能原因**

该错误码表示输入无效的包名称或者Ability名称，可能原因如下：
1. 包名称不存在。
2. 包里面没有对应的Ability。

**处理步骤**

1. 检查包名称是否正确。
2. 检查包名对应的Ability是否正确。

## 9300002 目标Ability已启用

**错误信息**

Target ability already enabled.

**错误描述**

当目标Ability已启用时，方法将返回该错误码。

**可能原因**

该错误码表示目标Ability已启用，可能原因是目标Ability已经启用，无法再次启用。

**处理步骤**

1. 停止该目标Ability。
2. 重新启用该目标Ability。

## 9300003 不具备执行该操作的无障碍权限

**错误信息**

Do not have accessibility right for this operation.

**错误描述**

当应用执行了用户在启用无障碍扩展应用时没有开启的辅助操作时，方法将返回该错误码。

**可能原因**

该错误码表示应用不具备该操作的无障碍权限，可能原因是应用执行了用户在启用无障碍扩展应用时没有开启的辅助操作。

**处理步骤**

1. 尝试向用户提示请求执行无障碍辅助操作的必要性，并获取用户授权。
2. 重新启用无障碍扩展应用，并开启所需的辅助操作。

## 9300004 属性不存在

**错误信息**

This property does not exist.

**错误描述**

当输入无障碍节点元素中不存在的属性时，方法将返回该错误码。

**可能原因**

该错误码表示输入了无效的无障碍节点元素的属性，可能原因是无障碍节点元素中不存在该属性。

**处理步骤**

检查无障碍节点元素中是否存在该属性。

## 9300005 不支持该操作

**错误信息**

This action is not supported.

**错误描述**

当应用执行无障碍节点元素不支持的操作时，方法将返回该错误码。

**可能原因**

该错误码表示执行了无障碍节点元素不支持的操作，可能原因是无障碍节点元素不支持执行该操作。

**处理步骤**

确认该无障碍节点元素支持的操作列表中是否包含该操作。