# 应用模型

- 应用模型概述
  - [OpenHarmony应用模型的构成要素](application-model-composition.md)
  - [OpenHarmony应用模型解读](application-model-description.md)
- Stage模型开发指导
  - [Stage模型开发概述](stage-model-development-overview.md)
  - Stage模型应用组件
    - [应用/组件级配置](application-component-configuration-stage.md)
    - UIAbility组件
      - [UIAbility组件概述](uiability-overview.md)
      - [UIAbility组件生命周期](uiability-lifecycle.md)
      - [UIAbility组件启动模式](uiability-launch-type.md)
      - [UIAbility组件基本用法](uiability-usage.md)
      - [UIAbility组件与UI的数据同步](uiability-data-sync-with-ui.md)
      - [UIAbility组件间交互（设备内）](uiability-intra-device-interaction.md)
    - ExtensionAbility组件
      - [ExtensionAbility组件概述](extensionability-overview.md)
      - [ServiceExtensionAbility](serviceextensionability.md)
      - [DataShareExtensionAbility（仅对系统应用开放）](datashareextensionability.md)
      - [FormExtensionAbility（服务卡片）](widget-development-stage.md)
      - [AccessibilityExtensionAbility](accessibilityextensionability.md)
      - [EnterpriseAdminExtensionAbility](enterprise-extensionAbility.md)
      - [InputMethodExtensionAbility](inputmethodextentionability.md)
      - [WindowExtensionAbility](windowextensionability.md)
    - [AbilityStage组件容器](abilitystage.md)
    - [应用上下文Context](application-context-stage.md)
    - 信息传递载体Want
      - [Want概述](want-overview.md)
      - [显式Want与隐式Want匹配规则](explicit-implicit-want-mappings.md)
      - [常见action与entities](actions-entities.md)
      - [使用显式Want启动Ability](ability-startup-with-explicit-want.md)
      - [使用隐式Want打开网址](ability-startup-with-implicit-want.md)
      - [应用间使用Want分享数据](data-share-via-want.md)
    - [组件启动规则（Stage模型）](component-startup-rules.md)
    - 应用组件跨设备交互（流转）
      - [流转概述](inter-device-interaction-hop-overview.md)
      - [跨端迁移（仅对系统应用开放）](hop-cross-device-migration.md)
      - [多端协同（仅对系统应用开放）](hop-multi-device-collaboration.md)
  - 进程间通信
    - [进程模型](process-model-stage.md)
    - 公共事件
      - [公共事件简介](common-event-overview.md)
      - 公共事件订阅
        - [公共事件订阅概述](common-event-subscription-overview.md)
        - [动态订阅公共事件](common-event-subscription.md)
        - [静态订阅公共事件（仅对系统应用开放）](common-event-static-subscription.md)
        - [取消动态订阅公共事件](common-event-unsubscription.md)
      - [公共事件发布](common-event-publish.md)
    - [后台服务](background-services.md)
  - 线程间通信
    - [线程模型](thread-model-stage.md)
    - [使用Emitter进行线程间通信](itc-with-emitter.md)
    - [使用Worker进行线程间通信](itc-with-worker.md)
  - 任务管理
    - [任务管理场景介绍](mission-management-overview.md)
    - [任务管理与启动模式](mission-management-launch-type.md)
    - [页面栈及任务链](page-mission-stack.md)
- FA模型开发指导
  - [FA模型开发概述](fa-model-development-overview.md)
  - FA模型应用组件
    - [应用/组件级配置](application-component-configuration-fa.md)
    - PageAbility组件开发指导
      - [PageAbility组件概述](pageability-overview.md)
      - [PageAbility组件配置](pageability-configuration.md)
      - [PageAbility的生命周期](pageability-lifecycle.md)
      - [PageAbility的启动模式](pageability-launch-type.md)
      - [创建PageAbility](create-pageability.md)
      - [启动本地PageAbility](start-local-pageability.md)
      - [停止PageAbility](stop-pageability.md)
      - [启动远程PageAbility（仅对系统应用开放）](start-remote-pageability.md)
      - [启动指定页面](start-page.md)
      - [窗口属性](window-properties.md)
      - [申请授权](request-permissions.md)
      - [跳转规则](redirection-rules.md)
    - ServiceAbility组件开发指导
      - [ServiceAbility组件概述](serviceability-overview.md)
      - [ServiceAbility组件配置](serviceability-configuration.md)
      - [ServiceAbility的生命周期](serviceability-lifecycle.md)
      - [创建ServiceAbility](create-serviceability.md)
      - [启动ServiceAbility](start-serviceability.md)
      - [连接ServiceAbility](connect-serviceability.md)
    - DataAbility组件开发指导
      - [DataAbility组件概述](dataability-overview.md)
      - [DataAbility组件配置](dataability-configuration.md)
      - [DataAbility的生命周期](dataability-lifecycle.md)
      - [创建DataAbility](create-dataability.md)
      - [启动DataAbility](start-dataability.md)
      - [访问DataAbility](access-dataability.md)
      - [DataAbility权限控制](dataability-permission-control.md)
    - [服务卡片开发指导](widget-development-fa.md)
    - [FA模型的Context](application-context-fa.md)
    - [信息传递载体Want](want-fa.md)
    - [组件启动规则（FA模型）](component-startup-rules-fa.md)
  - 进程间通信
    - [进程模型](process-model-fa.md)
    - [公共事件](common-event-fa.md)
    - [后台服务](rpc.md)
  - 线程间通信
    - [线程模型](thread-model-fa.md)
    - [线程间通信](itc-fa-overview.md)
  - [任务管理](mission-management-fa.md)
- FA模型与Stage模型应用组件互通指导
  - [FA模型与Stage模型应用组件互通综述](fa-stage-interaction-overview.md)
  - [FA模型启动Stage模型UIAbility](start-uiability-from-fa.md)
  - [FA模型绑定Stage模型ServiceExtensionAbility](bind-serviceextensionability-from-fa.md)
  - [FA模型访问Stage模型DataShareExtensionAbility](access-datashareextensionability-from-fa.md)
  - [Stage模型启动FA模型PageAbility](start-pageability-from-stage.md)
  - [Stage模型绑定FA模型ServiceAbility](bind-serviceability-from-stage.md)
- FA模型切换Stage模型指导
  - [模型切换概述](model-switch-overview.md)
  - 配置文件切换
    - [配置文件的差异](configuration-file-diff.md)
    - [app和deviceConfig的切换](app-deviceconfig-switch.md)
    - [module的切换](module-switch.md)
  - 组件切换
    - [PageAbility切换](pageability-switch.md)
    - [ServiceAbility切换](serviceability-switch.md)
    - [DataAbility切换](dataability-switch.md)
  - [卡片切换](widget-switch.md)
  - API切换
    - [API切换概述](api-switch-overview.md)
    - [Context接口切换](context-switch.md)
    - [featureAbility接口切换](featureability-switch.md)
    - [particleAbility接口切换](particleability-switch.md)
    - [LifecycleForm接口切换](lifecycleform-switch.md)
    - [LifecycleApp接口切换](lifecycleapp-switch.md)
    - [LifecycleService接口切换](lifecycleservice-switch.md)
    - [LifecycleData接口切换](lifecycledata-switch.md)
    - [DataAbilityHelper接口切换](dataabilityhelper-switch.md)
    - [mediaLibrary接口切换](medialibrary-switch.md)
    - [request接口切换](request-switch.md)
    - [resourceManager接口切换](resourcemanager-switch.md)
    - [window接口切换](window-switch.md)
    - [Storage接口切换](storage-switch.md)
