# JS API Changes of the Multimedia Subsystem

The table below lists the APIs changes of the multimedia subsystem in OpenHarmony 3.2 Beta3 over OpenHarmony 3.2 Beta2.

## API Changes

| Module| Class| Method/Attribute/Enumeration/Constant| Change Type|
|---|---|---|---|
| ohos.multimedia.audio | VolumeEvent           | networkId: string;                                                                                                                                                                                                                                               | Added|
| ohos.multimedia.audio | VolumeEvent           | volumeGroupId: number;                                                                                                                                                                                                                                           | Added|
| ohos.multimedia.audio | AudioDeviceDescriptor | readonly volumeGroupId: number;                                                                                                                                                                                                                                  | Added|
| ohos.multimedia.audio | AudioDeviceDescriptor | readonly interruptGroupId: number;                                                                                                                                                                                                                               | Added|
| ohos.multimedia.audio | AudioDeviceDescriptor | readonly networkId: string;                                                                                                                                                                                                                                      | Added|
| ohos.multimedia.audio | VolumeGroupInfo       | readonly type: ConnectType;                                                                                                                                                                                                                                      | Added|
| ohos.multimedia.audio | VolumeGroupInfo       | readonly groupName: string;                                                                                                                                                                                                                                      | Added|
| ohos.multimedia.audio | VolumeGroupInfo       | readonly mappingId: number;                                                                                                                                                                                                                                      | Added|
| ohos.multimedia.audio | VolumeGroupInfo       | readonly groupId: number;                                                                                                                                                                                                                                        | Added|
| ohos.multimedia.audio | VolumeGroupInfo       | readonly networkId: string;                                                                                                                                                                                                                                      | Added|
| ohos.multimedia.audio | ConnectType           | CONNECT_TYPE_DISTRIBUTED = 2                                                                                                                                                                                                                                     | Added|
| ohos.multimedia.audio | ConnectType           | CONNECT_TYPE_LOCAL = 1                                                                                                                                                                                                                                           | Added|
| ohos.multimedia.audio | AudioGroupManager     | isMute(volumeType: AudioVolumeType, callback: AsyncCallback\<boolean>): void;<br>isMute(volumeType: AudioVolumeType): Promise\<boolean>;                                                                                                                        | Added|
| ohos.multimedia.audio | AudioGroupManager     | mute(volumeType: AudioVolumeType, mute: boolean, callback: AsyncCallback\<void>): void;<br>mute(volumeType: AudioVolumeType, mute: boolean): Promise\<void>;                                                                                                    | Added|
| ohos.multimedia.audio | AudioGroupManager     | getMaxVolume(volumeType: AudioVolumeType, callback: AsyncCallback\<number>): void;<br>getMaxVolume(volumeType: AudioVolumeType): Promise\<number>;                                                                                                              | Added|
| ohos.multimedia.audio | AudioGroupManager     | getMinVolume(volumeType: AudioVolumeType, callback: AsyncCallback\<number>): void;<br>getMinVolume(volumeType: AudioVolumeType): Promise\<number>;                                                                                                              | Added|
| ohos.multimedia.audio | AudioGroupManager     | getVolume(volumeType: AudioVolumeType, callback: AsyncCallback\<number>): void;<br>getVolume(volumeType: AudioVolumeType): Promise\<number>;                                                                                                                    | Added|
| ohos.multimedia.audio | AudioGroupManager     | setVolume(volumeType: AudioVolumeType, volume: number, callback: AsyncCallback\<void>): void;<br>setVolume(volumeType: AudioVolumeType, volume: number): Promise\<void>;                                                                                        | Added|
| ohos.multimedia.audio | AudioRoutingManager   | selectOutputDeviceByFilter(filter: AudioRendererFilter, outputAudioDevices: AudioDeviceDescriptors, callback: AsyncCallback\<void>): void;<br>selectOutputDeviceByFilter(filter: AudioRendererFilter, outputAudioDevices: AudioDeviceDescriptors): Promise\<void>; | Added|
| ohos.multimedia.audio | AudioRoutingManager   | selectOutputDevice(outputAudioDevices: AudioDeviceDescriptors, callback: AsyncCallback\<void>): void;<br>selectOutputDevice(outputAudioDevices: AudioDeviceDescriptors): Promise\<void>;                                                                        | Added|
| ohos.multimedia.audio | AudioRoutingManager   | off(type: 'deviceChange', callback?: Callback\<DeviceChangeAction>): void;                                                                                                                                                                                       | Added|
| ohos.multimedia.audio | AudioRoutingManager   | on(type: 'deviceChange', deviceFlag: DeviceFlag, callback: Callback\<DeviceChangeAction>): void;                                                                                                                                                                 | Added|
| ohos.multimedia.audio | AudioRoutingManager   | getDevices(deviceFlag: DeviceFlag, callback: AsyncCallback\<AudioDeviceDescriptors>): void;<br>getDevices(deviceFlag: DeviceFlag): Promise\<AudioDeviceDescriptors>;                                                                                            | Added|
| ohos.multimedia.audio | AudioManager          | getRoutingManager(callback: AsyncCallback\<AudioRoutingManager>): void;<br>getRoutingManager(): Promise\<AudioRoutingManager>;                                                                                                                                  | Added|
| ohos.multimedia.audio | AudioManager          | getGroupManager(groupId: number, callback: AsyncCallback\<AudioGroupManager>): void;<br>getGroupManager(groupId: number): Promise\<AudioGroupManager>;                                                                                                          | Added|
| ohos.multimedia.audio | AudioManager          | getVolumeGroups(networkId: string, callback: AsyncCallback\<VolumeGroupInfos>): void;<br>getVolumeGroups(networkId: string): Promise\<VolumeGroupInfos>;                                                                                                        | Added|
| ohos.multimedia.audio | AudioRendererFilter   | rendererId?: number;                                                                                                                                                                                                                                             | Added|
| ohos.multimedia.audio | AudioRendererFilter   | rendererInfo?: AudioRendererInfo;                                                                                                                                                                                                                                | Added|
| ohos.multimedia.audio | AudioRendererFilter   | uid: number;                                                                                                                                                                                                                                                     | Added|
| ohos.multimedia.audio | DeviceType            | DEFAULT = 1000                                                                                                                                                                                                                                                   | Added|
| ohos.multimedia.audio | DeviceFlag            | ALL_DISTRIBUTED_DEVICES_FLAG = 12                                                                                                                                                                                                                                | Added|
| ohos.multimedia.audio | DeviceFlag            | DISTRIBUTED_INPUT_DEVICES_FLAG = 8                                                                                                                                                                                                                               | Added|
| ohos.multimedia.audio | DeviceFlag            | DISTRIBUTED_OUTPUT_DEVICES_FLAG = 4                                                                                                                                                                                                                              | Added|
| ohos.multimedia.audio | DeviceFlag            | NONE_DEVICES_FLAG = 0                                                                                                                                                                                                                                            | Added|
| ohos.multimedia.audio | audio                 | const LOCAL_NETWORK_ID: string;                                                                                                                                                                                                                                  | Added|
| ohos.multimedia.image | PixelMapFormat        | BGRA_8888 = 4                                                                                                                                                                                                                                                    | Added|
| ohos.multimedia.media | VideoPlayer           | on(type: 'availableBitratesCollect', callback: (bitrates: Array\<number>) => void): void;                                                                                                                                                                        | Added|
| ohos.multimedia.media | VideoPlayer | on(type: 'availableBitratesCollected', callback: (bitrates: Array\<number>) => void): void | Deleted|
| ohos.multimedia.mediaLibrary | DeviceType        | TYPE_TV                                                                                                                                                                                                                               | Deprecated|
| ohos.multimedia.mediaLibrary | DeviceType        | TYPE_CAR                                                                                                                                                                                                                              | Deprecated|
| ohos.multimedia.mediaLibrary | DeviceType        | TYPE_WATCH                                                                                                                                                                                                                            | Deprecated|
| ohos.multimedia.mediaLibrary | DeviceType        | TYPE_TABLET                                                                                                                                                                                                                           | Deprecated|
| ohos.multimedia.mediaLibrary | DeviceType        | TYPE_PHONE                                                                                                                                                                                                                            | Deprecated|
| ohos.multimedia.mediaLibrary | DeviceType        | TYPE_LAPTOP                                                                                                                                                                                                                           | Deprecated|
| ohos.multimedia.mediaLibrary | DeviceType        | TYPE_UNKNOWN = 0                                                                                                                                                                                                                      | Deprecated|
| ohos.multimedia.mediaLibrary | PeerInfo          | readonly isOnline: boolean;                                                                                                                                                                                                           | Deprecated|
| ohos.multimedia.mediaLibrary | PeerInfo          | readonly deviceType: DeviceType;                                                                                                                                                                                                      | Deprecated|
| ohos.multimedia.mediaLibrary | PeerInfo          | readonly networkId: string;                                                                                                                                                                                                           | Deprecated|
| ohos.multimedia.mediaLibrary | PeerInfo          | readonly deviceName: string;                                                                                                                                                                                                          | Deprecated|
| ohos.multimedia.mediaLibrary | Size              | height: number;                                                                                                                                                                                                                       | Deprecated|
| ohos.multimedia.mediaLibrary | Size              | width: number;                                                                                                                                                                                                                        | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | release(callback: AsyncCallback\<void>): void;<br>release(): Promise\<void>;                                                                                                                                                         | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | getAllPeers(callback: AsyncCallback\<Array\<PeerInfo>>): void;<br>getAllPeers(): Promise\<Array\<PeerInfo>>;                                                                                                                         | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | getActivePeers(callback: AsyncCallback\<Array\<PeerInfo>>): void;<br>getActivePeers(): Promise\<Array\<PeerInfo>>;                                                                                                                   | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | getAlbums(options: MediaFetchOptions, callback: AsyncCallback\<Array\<Album>>): void;<br>getAlbums(options: MediaFetchOptions): Promise\<Array\<Album>>;                                                                             | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | deleteAsset(uri: string, callback: AsyncCallback\<void>): void;<br>deleteAsset(uri: string): Promise\<void>;                                                                                                                         | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | createAsset(mediaType: MediaType, displayName: string, relativePath: string, callback: AsyncCallback\<FileAsset>): void;<br>createAsset(mediaType: MediaType, displayName: string, relativePath: string): Promise\<FileAsset>;       | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                  | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                  | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                  | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                  | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                  | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                  | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                  | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                    | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                    | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                    | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                    | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                    | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                    | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                    | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | getFileAssets(options: MediaFetchOptions, callback: AsyncCallback\<FetchFileResult>): void;<br>getFileAssets(options: MediaFetchOptions): Promise\<FetchFileResult>;                                                                 | Deprecated|
| ohos.multimedia.mediaLibrary | MediaLibrary      | getPublicDirectory(type: DirectoryType, callback: AsyncCallback\<string>): void;<br>getPublicDirectory(type: DirectoryType): Promise\<string>;                                                                                       | Deprecated|
| ohos.multimedia.mediaLibrary | DirectoryType     | DIR_DOWNLOAD                                                                                                                                                                                                                          | Deprecated|
| ohos.multimedia.mediaLibrary | DirectoryType     | DIR_DOCUMENTS                                                                                                                                                                                                                         | Deprecated|
| ohos.multimedia.mediaLibrary | DirectoryType     | DIR_AUDIO                                                                                                                                                                                                                             | Deprecated|
| ohos.multimedia.mediaLibrary | DirectoryType     | DIR_IMAGE                                                                                                                                                                                                                             | Deprecated|
| ohos.multimedia.mediaLibrary | DirectoryType     | DIR_VIDEO                                                                                                                                                                                                                             | Deprecated|
| ohos.multimedia.mediaLibrary | DirectoryType     | DIR_CAMERA = 0                                                                                                                                                                                                                        | Deprecated|
| ohos.multimedia.mediaLibrary | Album             | getFileAssets(callback: AsyncCallback\<FetchFileResult>): void;<br>getFileAssets(options: MediaFetchOptions, callback: AsyncCallback\<FetchFileResult>): void;<br>getFileAssets(options?: MediaFetchOptions): Promise\<FetchFileResult>; | Deprecated|
| ohos.multimedia.mediaLibrary | Album             | commitModify(callback: AsyncCallback\<void>): void;<br>commitModify(): Promise\<void>;                                                                                                                                               | Deprecated|
| ohos.multimedia.mediaLibrary | Album             | readonly coverUri: string;                                                                                                                                                                                                            | Deprecated|
| ohos.multimedia.mediaLibrary | Album             | readonly relativePath: string;                                                                                                                                                                                                        | Deprecated|
| ohos.multimedia.mediaLibrary | Album             | readonly count: number;                                                                                                                                                                                                               | Deprecated|
| ohos.multimedia.mediaLibrary | Album             | readonly dateModified: number;                                                                                                                                                                                                        | Deprecated|
| ohos.multimedia.mediaLibrary | Album             | readonly albumUri: string;                                                                                                                                                                                                            | Deprecated|
| ohos.multimedia.mediaLibrary | Album             | albumName: string;                                                                                                                                                                                                                    | Deprecated|
| ohos.multimedia.mediaLibrary | Album             | readonly albumId: number;                                                                                                                                                                                                             | Deprecated|
| ohos.multimedia.mediaLibrary | FetchFileResult   | getAllObject(callback: AsyncCallback\<Array\<FileAsset>>): void;<br>getAllObject(): Promise\<Array\<FileAsset>>;                                                                                                                     | Deprecated|
| ohos.multimedia.mediaLibrary | FetchFileResult   | getPositionObject(index: number, callback: AsyncCallback\<FileAsset>): void;<br>getPositionObject(index: number): Promise\<FileAsset>;                                                                                               | Deprecated|
| ohos.multimedia.mediaLibrary | FetchFileResult   | getLastObject(callback: AsyncCallback\<FileAsset>): void;<br>getLastObject(): Promise\<FileAsset>;                                                                                                                                   | Deprecated|
| ohos.multimedia.mediaLibrary | FetchFileResult   | getNextObject(callback: AsyncCallback\<FileAsset>): void;<br>getNextObject(): Promise\<FileAsset>;                                                                                                                                   | Deprecated|
| ohos.multimedia.mediaLibrary | FetchFileResult   | getFirstObject(callback: AsyncCallback\<FileAsset>): void;<br>getFirstObject(): Promise\<FileAsset>;                                                                                                                                 | Deprecated|
| ohos.multimedia.mediaLibrary | FetchFileResult   | close(): void;                                                                                                                                                                                                                        | Deprecated|
| ohos.multimedia.mediaLibrary | FetchFileResult   | isAfterLast(): boolean;                                                                                                                                                                                                               | Deprecated|
| ohos.multimedia.mediaLibrary | FetchFileResult   | getCount(): number;                                                                                                                                                                                                                   | Deprecated|
| ohos.multimedia.mediaLibrary | MediaFetchOptions | extendArgs?: string;                                                                                                                                                                                                                  | Deprecated|
| ohos.multimedia.mediaLibrary | MediaFetchOptions | networkId?: string;                                                                                                                                                                                                                   | Deprecated|
| ohos.multimedia.mediaLibrary | MediaFetchOptions | uri?: string;                                                                                                                                                                                                                         | Deprecated|
| ohos.multimedia.mediaLibrary | MediaFetchOptions | order?: string;                                                                                                                                                                                                                       | Deprecated|
| ohos.multimedia.mediaLibrary | MediaFetchOptions | selectionArgs: Array\<string>;                                                                                                                                                                                                        | Deprecated|
| ohos.multimedia.mediaLibrary | MediaFetchOptions | selections: string;                                                                                                                                                                                                                   | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | ALBUM_NAME = "bucket_display_name"                                                                                                                                                                                                    | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | ALBUM_ID = "bucket_id"                                                                                                                                                                                                                | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | ORIENTATION = "orientation"                                                                                                                                                                                                           | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | HEIGHT = "height"                                                                                                                                                                                                                     | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | WIDTH = "width"                                                                                                                                                                                                                       | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | DURATION = "duration"                                                                                                                                                                                                                 | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | AUDIOALBUM = "audio_album"                                                                                                                                                                                                            | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | ARTIST = "artist"                                                                                                                                                                                                                     | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | TITLE = "title"                                                                                                                                                                                                                       | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | DATE_TAKEN = "date_taken"                                                                                                                                                                                                             | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | DATE_MODIFIED = "date_modified"                                                                                                                                                                                                       | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | DATE_ADDED = "date_added"                                                                                                                                                                                                             | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | SIZE = "size"                                                                                                                                                                                                                         | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | MEDIA_TYPE = "media_type"                                                                                                                                                                                                             | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | MIME_TYPE = "mime_type"                                                                                                                                                                                                               | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | PARENT = "parent"                                                                                                                                                                                                                     | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | DISPLAY_NAME = "display_name"                                                                                                                                                                                                         | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | RELATIVE_PATH = "relative_path"                                                                                                                                                                                                       | Deprecated|
| ohos.multimedia.mediaLibrary | FileKey           | ID = "file_id"                                                                                                                                                                                                                        | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | isTrash(callback: AsyncCallback\<boolean>): void;<br>isTrash():Promise\<boolean>;                                                                                                                                                    | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | trash(isTrash: boolean, callback: AsyncCallback\<void>): void;<br>trash(isTrash: boolean): Promise\<void>;                                                                                                                           | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | isFavorite(callback: AsyncCallback\<boolean>): void;<br>isFavorite():Promise\<boolean>;                                                                                                                                              | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | favorite(isFavorite: boolean, callback: AsyncCallback\<void>): void;<br>favorite(isFavorite: boolean): Promise\<void>;                                                                                                               | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | getThumbnail(callback: AsyncCallback\<image.PixelMap>): void;<br>getThumbnail(size: Size, callback: AsyncCallback\<image.PixelMap>): void;<br>getThumbnail(size?: Size): Promise\<image.PixelMap>;                                  | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | close(fd: number, callback: AsyncCallback\<void>): void;<br>close(fd: number): Promise\<void>;                                                                                                                                       | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | open(mode: string, callback: AsyncCallback\<number>): void;<br>open(mode: string): Promise\<number>;                                                                                                                                 | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | commitModify(callback: AsyncCallback\<void>): void;<br>commitModify(): Promise\<void>;                                                                                                                                               | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | isDirectory(callback: AsyncCallback\<boolean>): void;<br>isDirectory():Promise\<boolean>;                                                                                                                                            | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly albumName: string;                                                                                                                                                                                                           | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly albumUri: string;                                                                                                                                                                                                            | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly albumId: number;                                                                                                                                                                                                             | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly duration: number;                                                                                                                                                                                                            | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | orientation: number;                                                                                                                                                                                                                  | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly height: number;                                                                                                                                                                                                              | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly width: number;                                                                                                                                                                                                               | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly audioAlbum: string;                                                                                                                                                                                                          | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly artist: string;                                                                                                                                                                                                              | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly dateTaken: number;                                                                                                                                                                                                           | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly dateModified: number;                                                                                                                                                                                                        | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly dateAdded: number;                                                                                                                                                                                                           | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly size: number;                                                                                                                                                                                                                | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly parent: number;                                                                                                                                                                                                              | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | relativePath: string;                                                                                                                                                                                                                 | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | title: string;                                                                                                                                                                                                                        | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | displayName: string;                                                                                                                                                                                                                  | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly mediaType: MediaType;                                                                                                                                                                                                        | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly mimeType: string;                                                                                                                                                                                                            | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly uri: string;                                                                                                                                                                                                                 | Deprecated|
| ohos.multimedia.mediaLibrary | FileAsset         | readonly id: number;                                                                                                                                                                                                                  | Deprecated|
| ohos.multimedia.mediaLibrary | MediaType         | AUDIO                                                                                                                                                                                                                                 | Deprecated|
| ohos.multimedia.mediaLibrary | MediaType         | VIDEO                                                                                                                                                                                                                                 | Deprecated|
| ohos.multimedia.mediaLibrary | MediaType         | IMAGE                                                                                                                                                                                                                                 | Deprecated|
| ohos.multimedia.mediaLibrary | MediaType         | FILE = 0                                                                                                                                                                                                                              | Deprecated|
| ohos.multimedia.mediaLibrary | mediaLibrary      | getMediaLibrary(): MediaLibrary;<br>getMediaLibrary(context: Context): MediaLibrary;                                                                                                                               | Deprecated|
