# JS API Changes of the File Management Subsystem

The table below lists the APIs changes of the file management subsystem in OpenHarmony 3.2 Beta3 over OpenHarmony 3.2 Beta2.

## API Changes

| Module| Class| Method/Attribute/Enumeration/Constant| Change Type|
|---|---|---|---|
| ohos.data.fileAccess                 | FileAccessHelper  | getRoots(): Promise\<RootIterator>;<br>getRoots(callback:AsyncCallback\<RootIterator>) : void;                                                                                                                                                                                                               | Added|
| ohos.data.fileAccess                 | FileAccessHelper  | access(sourceFileUri: string) : Promise\<boolean>;<br>access(sourceFileUri: string, callback: AsyncCallback\<boolean>) : void;                                                                                                                                                                               | Added|
| ohos.data.fileAccess                 | FileAccessHelper  | rename(uri: string, displayName: string) : Promise\<string>;<br>rename(uri: string, displayName: string, callback: AsyncCallback\<string>) : void;                                                                                                                                                           | Added|
| ohos.data.fileAccess                 | FileAccessHelper  | move(sourceFile: string, destFile: string) : Promise\<string>;<br>move(sourceFile: string, destFile: string, callback: AsyncCallback\<string>) : void;                                                                                                                                                       | Added|
| ohos.data.fileAccess                 | FileAccessHelper  | delete(uri: string) : Promise\<number>;<br>delete(uri: string, callback: AsyncCallback\<number>) : void;                                                                                                                                                                                                     | Added|
| ohos.data.fileAccess                 | FileAccessHelper  | mkDir(parentUri: string, displayName: string) : Promise\<string>;<br>mkDir(parentUri: string, displayName: string, callback: AsyncCallback\<string>) : void;                                                                                                                                                 | Added|
| ohos.data.fileAccess                 | FileAccessHelper  | createFile(uri: string, displayName: string) : Promise\<string>;<br>createFile(uri: string, displayName: string, callback: AsyncCallback\<string>) : void;                                                                                                                                                   | Added|
| ohos.data.fileAccess                 | FileAccessHelper  | openFile(uri: string, flags: OPENFLAGS) : Promise\<number>;<br>openFile(uri: string, flags: OPENFLAGS, callback: AsyncCallback\<number>) : void;                                                                                                                                                             | Added|
| ohos.data.fileAccess                 | OPENFLAGS         | WRITE_READ = 0o2                                                                                                                                                                                                                                                                                              | Added|
| ohos.data.fileAccess                 | OPENFLAGS         | WRITE = 0o1                                                                                                                                                                                                                                                                                                   | Added|
| ohos.data.fileAccess                 | OPENFLAGS         | READ = 0o0                                                                                                                                                                                                                                                                                                    | Added|
| ohos.data.fileAccess                 | RootIterator      | next(): {value: RootInfo, done: boolean}                                                                                                                                                                                                                                                                      | Added|
| ohos.data.fileAccess                 | RootInfo          | scanFile(filter?: Filter): FileIterator;                                                                                                                                                                                                                                                                      | Added|
| ohos.data.fileAccess                 | RootInfo          | listFile(filter?: Filter): FileIterator;                                                                                                                                                                                                                                                                      | Added|
| ohos.data.fileAccess                 | RootInfo          | deviceFlags: number;                                                                                                                                                                                                                                                                                          | Added|
| ohos.data.fileAccess                 | RootInfo          | displayName: string;                                                                                                                                                                                                                                                                                          | Added|
| ohos.data.fileAccess                 | RootInfo          | uri: string;                                                                                                                                                                                                                                                                                                  | Added|
| ohos.data.fileAccess                 | RootInfo          | deviceType: number;                                                                                                                                                                                                                                                                                           | Added|
| ohos.data.fileAccess                 | FileIterator      | next(): {value: FileInfo, done: boolean}                                                                                                                                                                                                                                                                      | Added|
| ohos.data.fileAccess                 | FileInfo          | scanFile(filter?: Filter): FileIterator;                                                                                                                                                                                                                                                                      | Added|
| ohos.data.fileAccess                 | FileInfo          | listFile(filter?: Filter): FileIterator;                                                                                                                                                                                                                                                                      | Added|
| ohos.data.fileAccess                 | FileInfo          | mimeType: string;                                                                                                                                                                                                                                                                                             | Added|
| ohos.data.fileAccess                 | FileInfo          | mtime: number;                                                                                                                                                                                                                                                                                                | Added|
| ohos.data.fileAccess                 | FileInfo          | size: number;                                                                                                                                                                                                                                                                                                 | Added|
| ohos.data.fileAccess                 | FileInfo          | mode: number;                                                                                                                                                                                                                                                                                                 | Added|
| ohos.data.fileAccess                 | FileInfo          | fileName: string;                                                                                                                                                                                                                                                                                             | Added|
| ohos.data.fileAccess                 | FileInfo          | uri: string;                                                                                                                                                                                                                                                                                                  | Added|
| ohos.data.fileAccess                 | fileAccess        | createFileAccessHelper(context: Context): FileAccessHelper;<br>createFileAccessHelper(context: Context, wants: Array\<Want>): FileAccessHelper;                                                                                                                                            | Added|
| ohos.data.fileAccess                 | fileAccess        | getFileAccessAbilityInfo(callback: AsyncCallback\<Array\<Want>>): void;<br>getFileAccessAbilityInfo(): Promise\<Array\<Want>>;                                                                                                                                                             | Added|
| ohos.fileExtensionInfo               | DocumentFlag      | const SUPPORTS_WRITE = 0b1000;                                                                                                                                                                                                                                                                                | Added|
| ohos.fileExtensionInfo               | DocumentFlag      | const SUPPORTS_READ = 0b100;                                                                                                                                                                                                                                                                                  | Added|
| ohos.fileExtensionInfo               | DocumentFlag      | const REPRESENTS_DIR = 0b10;                                                                                                                                                                                                                                                                                  | Added|
| ohos.fileExtensionInfo               | DocumentFlag      | const REPRESENTS_FILE = 0b1;                                                                                                                                                                                                                                                                                  | Added|
| ohos.fileExtensionInfo               | DeviceFlag        | const SUPPORTS_WRITE = 0b10;                                                                                                                                                                                                                                                                                  | Added|
| ohos.fileExtensionInfo               | DeviceFlag        | const SUPPORTS_READ = 0b1;                                                                                                                                                                                                                                                                                    | Added|
| ohos.fileExtensionInfo               | DeviceType        | DEVICE_EXTERNAL_CLOUD                                                                                                                                                                                                                                                                                         | Added|
| ohos.fileExtensionInfo               | DeviceType        | DEVICE_EXTERNAL_USB                                                                                                                                                                                                                                                                                           | Added|
| ohos.fileExtensionInfo               | DeviceType        | DEVICE_EXTERNAL_MTP                                                                                                                                                                                                                                                                                           | Added|
| ohos.fileExtensionInfo               | DeviceType        | DEVICE_NETWORK_NEIGHBORHOODS                                                                                                                                                                                                                                                                                  | Added|
| ohos.fileExtensionInfo               | DeviceType        | DEVICE_SHARED_TERMINAL                                                                                                                                                                                                                                                                                        | Added|
| ohos.fileExtensionInfo               | DeviceType        | DEVICE_SHARED_DISK                                                                                                                                                                                                                                                                                            | Added|
| ohos.fileExtensionInfo               | DeviceType        | DEVICE_LOCAL_DISK = 1                                                                                                                                                                                                                                                                                         | Added|
| ohos.filemanagement.userfile_manager | VirtualAlbum      | getFileAssets(type: Array\<MediaType>, options: MediaFetchOptions, callback: AsyncCallback\<FetchFileResult>): void;<br>getFileAssets(type: Array\<MediaType>, options: MediaFetchOptions): Promise\<FetchFileResult>;                                                                                       | Added|
| ohos.filemanagement.userfile_manager | VirtualAlbumType  | TYPE_TRASH                                                                                                                                                                                                                                                                                                    | Added|
| ohos.filemanagement.userfile_manager | VirtualAlbumType  | TYPE_FAVORITE                                                                                                                                                                                                                                                                                                 | Added|
| ohos.filemanagement.userfile_manager | PeerInfo          | readonly isOnline: boolean;                                                                                                                                                                                                                                                                                   | Added|
| ohos.filemanagement.userfile_manager | PeerInfo          | readonly networkId: string;                                                                                                                                                                                                                                                                                   | Added|
| ohos.filemanagement.userfile_manager | PeerInfo          | readonly deviceName: string;                                                                                                                                                                                                                                                                                  | Added|
| ohos.filemanagement.userfile_manager | Size              | height: number;                                                                                                                                                                                                                                                                                               | Added|
| ohos.filemanagement.userfile_manager | Size              | width: number;                                                                                                                                                                                                                                                                                                | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | release(callback: AsyncCallback\<void>): void;<br>release(): Promise\<void>;                                                                                                                                                                                                                                 | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | getAllPeers(callback: AsyncCallback\<Array\<PeerInfo>>): void;<br>getAllPeers(): Promise\<Array\<PeerInfo>>;                                                                                                                                                                                                 | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | getActivePeers(callback: AsyncCallback\<Array\<PeerInfo>>): void;<br>getActivePeers(): Promise\<Array\<PeerInfo>>;                                                                                                                                                                                           | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | getPrivateAlbum(type: VirtualAlbumType, callback: AsyncCallback\<Array\<VirtualAlbum>>): void;<br>getPrivateAlbum(type: VirtualAlbumType): Promise\<Array\<VirtualAlbum>>;                                                                                                                                   | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | getAlbums(type: Array\<MediaType>, options: MediaFetchOptions, callback: AsyncCallback\<Array\<Album>>): void;<br>getAlbums(type: Array\<MediaType>, options: MediaFetchOptions): Promise\<Array\<Album>>;                                                                                                   | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | deleteAsset(uri: string, callback: AsyncCallback\<void>): void;<br>deleteAsset(uri: string): Promise\<void>;                                                                                                                                                                                                 | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | createAsset(mediaType: MediaType, displayName: string, relativePath: string, callback: AsyncCallback\<FileAsset>): void;<br>createAsset(mediaType: MediaType, displayName: string, relativePath: string): Promise\<FileAsset>;                                                                               | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                                                                                          | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                                                                                          | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                                                                                          | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                                                                                          | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                                                                                          | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                                                                                          | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                                                                                          | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                                                                                            | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                                                                                            | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                                                                                            | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                                                                                            | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                                                                                            | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                                                                                            | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                                                                                            | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | getFileAssets(type: Array\<MediaType>, options: MediaFetchOptions, callback: AsyncCallback\<FetchFileResult>): void;<br>getFileAssets(type: Array\<MediaType>, options: MediaFetchOptions): Promise\<FetchFileResult>;                                                                                       | Added|
| ohos.filemanagement.userfile_manager | UserFileManager   | getPublicDirectory(type: DirectoryType, callback: AsyncCallback\<string>): void;<br>getPublicDirectory(type: DirectoryType): Promise\<string>;                                                                                                                                                               | Added|
| ohos.filemanagement.userfile_manager | DirectoryType     | DIR_DOWNLOAD                                                                                                                                                                                                                                                                                                  | Added|
| ohos.filemanagement.userfile_manager | DirectoryType     | DIR_DOCUMENTS                                                                                                                                                                                                                                                                                                 | Added|
| ohos.filemanagement.userfile_manager | DirectoryType     | DIR_AUDIO                                                                                                                                                                                                                                                                                                     | Added|
| ohos.filemanagement.userfile_manager | DirectoryType     | DIR_IMAGE                                                                                                                                                                                                                                                                                                     | Added|
| ohos.filemanagement.userfile_manager | DirectoryType     | DIR_VIDEO                                                                                                                                                                                                                                                                                                     | Added|
| ohos.filemanagement.userfile_manager | DirectoryType     | DIR_CAMERA = 0                                                                                                                                                                                                                                                                                                | Added|
| ohos.filemanagement.userfile_manager | Album             | getFileAssets(type: Array\<MediaType>, callback: AsyncCallback\<FetchFileResult>): void;<br>getFileAssets(type: Array\<MediaType>, options: MediaFetchOptions, callback: AsyncCallback\<FetchFileResult>): void;<br>getFileAssets(type: Array\<MediaType>, options?: MediaFetchOptions): Promise\<FetchFileResult>; | Added|
| ohos.filemanagement.userfile_manager | Album             | commitModify(callback: AsyncCallback\<void>): void;<br>commitModify(): Promise\<void>;                                                                                                                                                                                                                       | Added|
| ohos.filemanagement.userfile_manager | Album             | readonly coverUri: string;                                                                                                                                                                                                                                                                                    | Added|
| ohos.filemanagement.userfile_manager | Album             | readonly relativePath: string;                                                                                                                                                                                                                                                                                | Added|
| ohos.filemanagement.userfile_manager | Album             | readonly count: number;                                                                                                                                                                                                                                                                                       | Added|
| ohos.filemanagement.userfile_manager | Album             | readonly dateModified: number;                                                                                                                                                                                                                                                                                | Added|
| ohos.filemanagement.userfile_manager | Album             | readonly albumUri: string;                                                                                                                                                                                                                                                                                    | Added|
| ohos.filemanagement.userfile_manager | Album             | albumName: string;                                                                                                                                                                                                                                                                                            | Added|
| ohos.filemanagement.userfile_manager | FetchFileResult   | getPositionObject(index: number, callback: AsyncCallback\<FileAsset>): void;<br>getPositionObject(index: number): Promise\<FileAsset>;                                                                                                                                                                       | Added|
| ohos.filemanagement.userfile_manager | FetchFileResult   | getLastObject(callback: AsyncCallback\<FileAsset>): void;<br>getLastObject(): Promise\<FileAsset>;                                                                                                                                                                                                           | Added|
| ohos.filemanagement.userfile_manager | FetchFileResult   | getNextObject(callback: AsyncCallback\<FileAsset>): void;<br>getNextObject(): Promise\<FileAsset>;                                                                                                                                                                                                           | Added|
| ohos.filemanagement.userfile_manager | FetchFileResult   | getFirstObject(callback: AsyncCallback\<FileAsset>): void;<br>getFirstObject(): Promise\<FileAsset>;                                                                                                                                                                                                         | Added|
| ohos.filemanagement.userfile_manager | FetchFileResult   | close(): void;                                                                                                                                                                                                                                                                                                | Added|
| ohos.filemanagement.userfile_manager | FetchFileResult   | isAfterLast(): boolean;                                                                                                                                                                                                                                                                                       | Added|
| ohos.filemanagement.userfile_manager | FetchFileResult   | getCount(): number;                                                                                                                                                                                                                                                                                           | Added|
| ohos.filemanagement.userfile_manager | MediaFetchOptions | selectionArgs: Array\<string>;                                                                                                                                                                                                                                                                                | Added|
| ohos.filemanagement.userfile_manager | MediaFetchOptions | selections: string;                                                                                                                                                                                                                                                                                           | Added|
| ohos.filemanagement.userfile_manager | AlbumKey          | DATE_MODIFIED = "date_modified"                                                                                                                                                                                                                                                                               | Added|
| ohos.filemanagement.userfile_manager | AlbumKey          | DATE_ADDED = "date_added"                                                                                                                                                                                                                                                                                     | Added|
| ohos.filemanagement.userfile_manager | AlbumKey          | DISPLAY_NAME = "display_name"                                                                                                                                                                                                                                                                                 | Added|
| ohos.filemanagement.userfile_manager | AlbumKey          | RELATIVE_PATH = "relative_path"                                                                                                                                                                                                                                                                               | Added|
| ohos.filemanagement.userfile_manager | AlbumKey          | URI = "uri"                                                                                                                                                                                                                                                                                                   | Added|
| ohos.filemanagement.userfile_manager | ImageVideoKey     | DATE_TAKEN = "date_taken"                                                                                                                                                                                                                                                                                     | Added|
| ohos.filemanagement.userfile_manager | ImageVideoKey     | HEIGHT = "height"                                                                                                                                                                                                                                                                                             | Added|
| ohos.filemanagement.userfile_manager | ImageVideoKey     | WIDTH = "width"                                                                                                                                                                                                                                                                                               | Added|
| ohos.filemanagement.userfile_manager | ImageVideoKey     | DURATION = "duration"                                                                                                                                                                                                                                                                                         | Added|
| ohos.filemanagement.userfile_manager | ImageVideoKey     | TITLE = "title"                                                                                                                                                                                                                                                                                               | Added|
| ohos.filemanagement.userfile_manager | ImageVideoKey     | DATE_MODIFIED = "date_modified"                                                                                                                                                                                                                                                                               | Added|
| ohos.filemanagement.userfile_manager | ImageVideoKey     | DATE_ADDED = "date_added"                                                                                                                                                                                                                                                                                     | Added|
| ohos.filemanagement.userfile_manager | ImageVideoKey     | DISPLAY_NAME = "display_name"                                                                                                                                                                                                                                                                                 | Added|
| ohos.filemanagement.userfile_manager | ImageVideoKey     | RELATIVE_PATH = "relative_path"                                                                                                                                                                                                                                                                               | Added|
| ohos.filemanagement.userfile_manager | ImageVideoKey     | URI = "uri"                                                                                                                                                                                                                                                                                                   | Added|
| ohos.filemanagement.userfile_manager | AudioKey          | DURATION = "duration"                                                                                                                                                                                                                                                                                         | Added|
| ohos.filemanagement.userfile_manager | AudioKey          | AUDIOALBUM = "audio_album"                                                                                                                                                                                                                                                                                    | Added|
| ohos.filemanagement.userfile_manager | AudioKey          | ARTIST = "artist"                                                                                                                                                                                                                                                                                             | Added|
| ohos.filemanagement.userfile_manager | AudioKey          | TITLE = "title"                                                                                                                                                                                                                                                                                               | Added|
| ohos.filemanagement.userfile_manager | AudioKey          | DATE_MODIFIED = "date_modified"                                                                                                                                                                                                                                                                               | Added|
| ohos.filemanagement.userfile_manager | AudioKey          | DATE_ADDED = "date_added"                                                                                                                                                                                                                                                                                     | Added|
| ohos.filemanagement.userfile_manager | AudioKey          | DISPLAY_NAME = "display_name"                                                                                                                                                                                                                                                                                 | Added|
| ohos.filemanagement.userfile_manager | AudioKey          | RELATIVE_PATH = "relative_path"                                                                                                                                                                                                                                                                               | Added|
| ohos.filemanagement.userfile_manager | AudioKey          | URI = "uri"                                                                                                                                                                                                                                                                                                   | Added|
| ohos.filemanagement.userfile_manager | FileKey           | TITLE = "title"                                                                                                                                                                                                                                                                                               | Added|
| ohos.filemanagement.userfile_manager | FileKey           | DATE_MODIFIED = "date_modified"                                                                                                                                                                                                                                                                               | Added|
| ohos.filemanagement.userfile_manager | FileKey           | DATE_ADDED = "date_added"                                                                                                                                                                                                                                                                                     | Added|
| ohos.filemanagement.userfile_manager | FileKey           | DISPLAY_NAME = "display_name"                                                                                                                                                                                                                                                                                 | Added|
| ohos.filemanagement.userfile_manager | FileKey           | RELATIVE_PATH = "relative_path"                                                                                                                                                                                                                                                                               | Added|
| ohos.filemanagement.userfile_manager | FileKey           | URI = "uri"                                                                                                                                                                                                                                                                                                   | Added|
| ohos.filemanagement.userfile_manager | FileAsset         | isTrash(callback: AsyncCallback\<boolean>): void;<br>isTrash():Promise\<boolean>;                                                                                                                                                                                                                            | Added|
| ohos.filemanagement.userfile_manager | FileAsset         | trash(isTrash: boolean, callback: AsyncCallback\<void>): void;<br>trash(isTrash: boolean): Promise\<void>;                                                                                                                                                                                                   | Added|
| ohos.filemanagement.userfile_manager | FileAsset         | isFavorite(callback: AsyncCallback\<boolean>): void;<br>isFavorite():Promise\<boolean>;                                                                                                                                                                                                                      | Added|
| ohos.filemanagement.userfile_manager | FileAsset         | favorite(isFavorite: boolean, callback: AsyncCallback\<void>): void;<br>favorite(isFavorite: boolean): Promise\<void>;                                                                                                                                                                                       | Added|
| ohos.filemanagement.userfile_manager | FileAsset         | getThumbnail(callback: AsyncCallback\<image.PixelMap>): void;<br>getThumbnail(size: Size, callback: AsyncCallback\<image.PixelMap>): void;<br>getThumbnail(size?: Size): Promise\<image.PixelMap>;                                                                                                          | Added|
| ohos.filemanagement.userfile_manager | FileAsset         | close(fd: number, callback: AsyncCallback\<void>): void;<br>close(fd: number): Promise\<void>;                                                                                                                                                                                                               | Added|
| ohos.filemanagement.userfile_manager | FileAsset         | open(mode: string, callback: AsyncCallback\<number>): void;<br>open(mode: string): Promise\<number>;                                                                                                                                                                                                         | Added|
| ohos.filemanagement.userfile_manager | FileAsset         | commitModify(callback: AsyncCallback\<void>): void;<br>commitModify(): Promise\<void>;                                                                                                                                                                                                                       | Added|
| ohos.filemanagement.userfile_manager | FileAsset         | isDirectory(callback: AsyncCallback\<boolean>): void;<br>isDirectory():Promise\<boolean>;                                                                                                                                                                                                                    | Added|
| ohos.filemanagement.userfile_manager | FileAsset         | displayName: string;                                                                                                                                                                                                                                                                                          | Added|
| ohos.filemanagement.userfile_manager | FileAsset         | readonly mediaType: MediaType;                                                                                                                                                                                                                                                                                | Added|
| ohos.filemanagement.userfile_manager | FileAsset         | readonly uri: string;                                                                                                                                                                                                                                                                                         | Added|
| ohos.filemanagement.userfile_manager | MediaType         | AUDIO                                                                                                                                                                                                                                                                                                         | Added|
| ohos.filemanagement.userfile_manager | MediaType         | VIDEO                                                                                                                                                                                                                                                                                                         | Added|
| ohos.filemanagement.userfile_manager | MediaType         | IMAGE                                                                                                                                                                                                                                                                                                         | Added|
| ohos.filemanagement.userfile_manager | MediaType         | FILE = 0                                                                                                                                                                                                                                                                                                      | Added|
| ohos.filemanagement.userfile_manager | userfile_manager  | getUserFileMgr(): UserFileManager;<br>getUserFileMgr(context: Context): UserFileManager;                                                                                                                                                                                                   | Added|
| ohos.document | document | show(uri: string, type: string): Promise\<void>;<br>show(uri: string, type: string, callback: AsyncCallback\<void>): void;                                              | Deprecated|
| ohos.document | document | choose(types?: string[]): Promise\<string>;<br>choose(callback: AsyncCallback\<string>): void;<br>choose(types: string[], callback: AsyncCallback\<string>): void; | Deprecated|
