# JS API Changes of the Compiler and Runtime Subsystem

The table below lists the APIs changes of the compiler and runtime subsystem in OpenHarmony 3.2 Beta3 over OpenHarmony 3.2 Beta2.

## API Changes

| Module| Class| Method/Attribute/Enumeration/Constant| Change Type|
|---|---|---|---|
| ohos.buffer | Blob        | text(): Promise\<string>;                                                                                                                                                                                                                                                                                                                                                      | Added|
| ohos.buffer | Blob        | slice(start?: number, end?: number, type?: string): Blob;                                                                                                                                                                                                                                                                                                                      | Added|
| ohos.buffer | Blob        | arrayBuffer(): Promise\<ArrayBuffer>;                                                                                                                                                                                                                                                                                                                                          | Added|
| ohos.buffer | Blob        | type: string;                                                                                                                                                                                                                                                                                                                                                                  | Added|
| ohos.buffer | Blob        | size: number;                                                                                                                                                                                                                                                                                                                                                                  | Added|
| ohos.buffer | Blob        | constructor(sources: string[] \| ArrayBuffer[] \| TypedArray[] \| DataView[] \| Blob[] , options?: Object);                                                                                                                                                                                                                                                                        | Added|
| ohos.buffer | Buffer      | writeUIntLE(value: number, offset: number, byteLength: number): number;                                                                                                                                                                                                                                                                                                        | Added|
| ohos.buffer | Buffer      | writeUIntBE(value: number, offset: number, byteLength: number): number;                                                                                                                                                                                                                                                                                                        | Added|
| ohos.buffer | Buffer      | writeUInt32LE(value: number, offset?: number): number;                                                                                                                                                                                                                                                                                                                         | Added|
| ohos.buffer | Buffer      | writeUInt32BE(value: number, offset?: number): number;                                                                                                                                                                                                                                                                                                                         | Added|
| ohos.buffer | Buffer      | writeUInt16LE(value: number, offset?: number): number;                                                                                                                                                                                                                                                                                                                         | Added|
| ohos.buffer | Buffer      | writeUInt16BE(value: number, offset?: number): number;                                                                                                                                                                                                                                                                                                                         | Added|
| ohos.buffer | Buffer      | writeUInt8(value: number, offset?: number): number;                                                                                                                                                                                                                                                                                                                            | Added|
| ohos.buffer | Buffer      | writeIntLE(value : number, offset: number, byteLength: number): number;                                                                                                                                                                                                                                                                                                        | Added|
| ohos.buffer | Buffer      | writeIntBE(value: number, offset: number, byteLength: number): number;                                                                                                                                                                                                                                                                                                         | Added|
| ohos.buffer | Buffer      | writeInt32LE(value: number, offset?: number): number;                                                                                                                                                                                                                                                                                                                          | Added|
| ohos.buffer | Buffer      | writeInt32BE(value: number, offset?: number): number;                                                                                                                                                                                                                                                                                                                          | Added|
| ohos.buffer | Buffer      | writeInt16LE(value: number, offset?: number): number;                                                                                                                                                                                                                                                                                                                          | Added|
| ohos.buffer | Buffer      | writeInt16BE(value: number, offset?: number): number;                                                                                                                                                                                                                                                                                                                          | Added|
| ohos.buffer | Buffer      | writeInt8(value: number, offset?: number): number;                                                                                                                                                                                                                                                                                                                             | Added|
| ohos.buffer | Buffer      | writeFloatLE(value: number, offset?: number): number;                                                                                                                                                                                                                                                                                                                          | Added|
| ohos.buffer | Buffer      | writeFloatBE(value: number, offset?: number): number;                                                                                                                                                                                                                                                                                                                          | Added|
| ohos.buffer | Buffer      | writeDoubleLE(value: number, offset?: number): number;                                                                                                                                                                                                                                                                                                                         | Added|
| ohos.buffer | Buffer      | writeDoubleBE(value: number, offset?: number): number;                                                                                                                                                                                                                                                                                                                         | Added|
| ohos.buffer | Buffer      | writeBigUInt64LE(value: bigint, offset?: number): number;                                                                                                                                                                                                                                                                                                                      | Added|
| ohos.buffer | Buffer      | writeBigUInt64BE(value: bigint, offset?: number): number;                                                                                                                                                                                                                                                                                                                      | Added|
| ohos.buffer | Buffer      | writeBigInt64LE(value: bigint, offset?: number): number;                                                                                                                                                                                                                                                                                                                       | Added|
| ohos.buffer | Buffer      | writeBigInt64BE(value: bigint, offset?: number): number;                                                                                                                                                                                                                                                                                                                       | Added|
| ohos.buffer | Buffer      | write(str: string, offset?: number, length?: number, encoding?: string): number;                                                                                                                                                                                                                                                                                               | Added|
| ohos.buffer | Buffer      | toString(encoding?: string, start?: number, end?: number): string;                                                                                                                                                                                                                                                                                                             | Added|
| ohos.buffer | Buffer      | toJSON(): Object;                                                                                                                                                                                                                                                                                                                                                              | Added|
| ohos.buffer | Buffer      | swap64(): Buffer;                                                                                                                                                                                                                                                                                                                                                              | Added|
| ohos.buffer | Buffer      | swap32(): Buffer;                                                                                                                                                                                                                                                                                                                                                              | Added|
| ohos.buffer | Buffer      | swap16(): Buffer;                                                                                                                                                                                                                                                                                                                                                              | Added|
| ohos.buffer | Buffer      | subarray(start?: number, end?: number): Buffer;                                                                                                                                                                                                                                                                                                                                | Added|
| ohos.buffer | Buffer      | readUIntLE(offset: number, byteLength: number): number;                                                                                                                                                                                                                                                                                                                        | Added|
| ohos.buffer | Buffer      | readUIntBE(offset: number, byteLength: number): number;                                                                                                                                                                                                                                                                                                                        | Added|
| ohos.buffer | Buffer      | readUInt32LE(offset?: number): number;                                                                                                                                                                                                                                                                                                                                         | Added|
| ohos.buffer | Buffer      | readUInt32BE(offset?: number): number;                                                                                                                                                                                                                                                                                                                                         | Added|
| ohos.buffer | Buffer      | readUInt16LE(offset?: number): number;                                                                                                                                                                                                                                                                                                                                         | Added|
| ohos.buffer | Buffer      | readUInt16BE(offset?: number): number;                                                                                                                                                                                                                                                                                                                                         | Added|
| ohos.buffer | Buffer      | readUInt8(offset?: number): number;                                                                                                                                                                                                                                                                                                                                            | Added|
| ohos.buffer | Buffer      | readIntLE(offset: number, byteLength: number): number;                                                                                                                                                                                                                                                                                                                         | Added|
| ohos.buffer | Buffer      | readIntBE(offset: number, byteLength: number): number;                                                                                                                                                                                                                                                                                                                         | Added|
| ohos.buffer | Buffer      | readInt32LE(offset?: number): number;                                                                                                                                                                                                                                                                                                                                          | Added|
| ohos.buffer | Buffer      | readInt32BE(offset?: number): number;                                                                                                                                                                                                                                                                                                                                          | Added|
| ohos.buffer | Buffer      | readInt16LE(offset?: number): number;                                                                                                                                                                                                                                                                                                                                          | Added|
| ohos.buffer | Buffer      | readInt16BE(offset?: number): number;                                                                                                                                                                                                                                                                                                                                          | Added|
| ohos.buffer | Buffer      | readInt8(offset?: number): number;                                                                                                                                                                                                                                                                                                                                             | Added|
| ohos.buffer | Buffer      | readFloatLE(offset?: number): number;                                                                                                                                                                                                                                                                                                                                          | Added|
| ohos.buffer | Buffer      | readFloatBE(offset?: number): number;                                                                                                                                                                                                                                                                                                                                          | Added|
| ohos.buffer | Buffer      | readDoubleLE(offset?: number): number;                                                                                                                                                                                                                                                                                                                                         | Added|
| ohos.buffer | Buffer      | readDoubleBE(offset?: number): number;                                                                                                                                                                                                                                                                                                                                         | Added|
| ohos.buffer | Buffer      | readBigUInt64LE(offset?: number): bigint;                                                                                                                                                                                                                                                                                                                                      | Added|
| ohos.buffer | Buffer      | readBigUInt64BE(offset?: number): bigint;                                                                                                                                                                                                                                                                                                                                      | Added|
| ohos.buffer | Buffer      | readBigInt64LE(offset?: number): bigint;                                                                                                                                                                                                                                                                                                                                       | Added|
| ohos.buffer | Buffer      | readBigInt64BE(offset?: number): bigint;                                                                                                                                                                                                                                                                                                                                       | Added|
| ohos.buffer | Buffer      | lastIndexOf(value: string \| number \| Buffer \| Uint8Array, byteOffset?: number, encoding?: BufferEncoding): number;                                                                                                                                                                                                                                                             | Added|
| ohos.buffer | Buffer      | entries(): IterableIterator\<[number, number]>;                                                                                                                                                                                                                                                                                                                                | Added|
| ohos.buffer | Buffer      | values(): IterableIterator\<number>;                                                                                                                                                                                                                                                                                                                                           | Added|
| ohos.buffer | Buffer      | keys(): IterableIterator\<number>;                                                                                                                                                                                                                                                                                                                                             | Added|
| ohos.buffer | Buffer      | indexOf(value: string \| number \| Buffer \| Uint8Array, byteOffset?: number, encoding?: BufferEncoding): number;                                                                                                                                                                                                                                                                 | Added|
| ohos.buffer | Buffer      | includes(value: string \| number \| Buffer \| Uint8Array, byteOffset?: number, encoding?: BufferEncoding): boolean;                                                                                                                                                                                                                                                               | Added|
| ohos.buffer | Buffer      | equals(otherBuffer: Uint8Array \| Buffer): boolean;                                                                                                                                                                                                                                                                                                                             | Added|
| ohos.buffer | Buffer      | copy(target: Buffer \| Uint8Array, targetStart?: number, sourceStart?: number, sourceEnd?: number): number;                                                                                                                                                                                                                                                                     | Added|
| ohos.buffer | Buffer      | compare(target: Buffer \| Uint8Array, targetStart?: number, targetEnd?: number, sourceStart?: number, sourceEnd?: number): -1 \| 0 \| 1;                                                                                                                                                                                                                                          | Added|
| ohos.buffer | Buffer      | fill(value: string \| Buffer \| Uint8Array \| number, offset?: number, end?: number, encoding?: BufferEncoding): Buffer;                                                                                                                                                                                                                                                          | Added|
| ohos.buffer | Buffer      | byteOffset: number;                                                                                                                                                                                                                                                                                                                                                            | Added|
| ohos.buffer | Buffer      | buffer: ArrayBuffer;                                                                                                                                                                                                                                                                                                                                                           | Added|
| ohos.buffer | Buffer      | length: number;                                                                                                                                                                                                                                                                                                                                                                | Added|
| ohos.buffer | buffer      | function transcode(source: Buffer \| Uint8Array, fromEnc: string, toEnc: string): Buffer;                                                                                                                                                                                                                                                                                       | Added|
| ohos.buffer | buffer      | function compare(buf1: Buffer \| Uint8Array, buf2: Buffer \| Uint8Array): -1 \| 0 \| 1;                                                                                                                                                                                                                                                                                            | Added|
| ohos.buffer | buffer      | function isEncoding(encoding: string):boolean;                                                                                                                                                                                                                                                                                                                                 | Added|
| ohos.buffer | buffer      | function isBuffer(obj: Object): boolean;                                                                                                                                                                                                                                                                                                                                       | Added|
| ohos.buffer | buffer      | function from(array: number[]): Buffer;<br>function from(arrayBuffer: ArrayBuffer \| SharedArrayBuffer, byteOffset?: number, length?: number): Buffer;<br>function from(buffer: Buffer \| Uint8Array): Buffer;<br>function from(object: Object, offsetOrEncoding: number \| string, length: number): Buffer;<br>function from(string: String, encoding?: BufferEncoding): Buffer; | Added|
| ohos.buffer | buffer      | function concat(list: Buffer[] \| Uint8Array[], totalLength?: number): Buffer;                                                                                                                                                                                                                                                                                                  | Added|
| ohos.buffer | buffer      | function byteLength(string: string \| Buffer \| TypedArray \| DataView \| ArrayBuffer \| SharedArrayBuffer, encoding?: BufferEncoding): number;                                                                                                                                                                                                                                     | Added|
| ohos.buffer | buffer      | function allocUninitialized(size: number): Buffer;                                                                                                                                                                                                                                                                                                                             | Added|
| ohos.buffer | buffer      | function allocUninitializedFromPool(size: number): Buffer;                                                                                                                                                                                                                                                                                                                     | Added|
| ohos.buffer | buffer      | function alloc(size: number, fill?: string \| Buffer \| number, encoding?: BufferEncoding): Buffer;                                                                                                                                                                                                                                                                              | Added|
| ohos.util   | TextDecoder | decodeWithStream(input: Uint8Array, options?: { stream?: boolean }): string;                                                                                                                                                                                                                                                                                                   | Added|
| ohos.util   | util        | function parseUUID(uuid: string): Uint8Array;                                                                                                                                                                                                                                                                                                                                  | Added|
| ohos.util   | util        | function randomBinaryUUID(entropyCache?: boolean): Uint8Array;                                                                                                                                                                                                                                                                                                                 | Added|
| ohos.util   | util        | function randomUUID(entropyCache?: boolean): string;                                                                                                                                                                                                                                                                                                                           | Added|
| ohos.worker | DedicatedWorkerGlobalScope | postMessage(messageObject: Object, transfer: Transferable[]): void;<br>postMessage(messageObject: Object, options?: PostMessageOptions): void;<br>postMessage(messageObject: Object, transfer: ArrayBuffer[]): void; | Deprecated|
