# Native API Differences

This document describes the changes of APIs in OpenHarmony 3.1 Release when compared with OpenHarmony 3.0 LTS.

## Standard System API Changes

  | Module| API                                                    | Change Type| Change Description                                       |
  | -------- | ------------------------------------------------------------ | -------- | ----------------------------------------------- |
  | Graphics - drawing| OH_Drawing_FontCollection* OH_Drawing_CreateFontCollection(void) | Added    | Added the API for creating an **OH_Drawing_FontCollection** object.                  |
  | Graphics - drawing| void OH_Drawing_DestroyFontCollection(OH_Drawing_FontCollection*) | Added    | Added the API for releasing the memory occupied by an **OH_Drawing_FontCollection** object.  |
  | Graphics - drawing | OH_Drawing_TypographyStyle* OH_Drawing_CreateTypographyStyle(void) | Added    | Added the API for creating an **OH_Drawing_TypographyStyle** object.                 |
  | Graphics - drawing | void OH_Drawing_DestroyTypographyStyle(OH_Drawing_TypographyStyle*) | Added    | Added the API for releasing the memory occupied by an **OH_Drawing_TypographyStyle** object. |
  | Graphics - drawing | void OH_Drawing_SetTypographyTextDirection(OH_Drawing_TypographyStyle*, int /* OH_Drawing_TextDirection */) | Added    | Added the API for setting the text direction.                                   |
  | Graphics - drawing | void OH_Drawing_SetTypographyTextAlign(OH_Drawing_TypographyStyle*, int /* OH_Drawing_TextAlign */) | Added    | Added the API for setting the text alignment mode.                               |
  | Graphics - drawing | void OH_Drawing_SetTypographyTextMaxLines(OH_Drawing_TypographyStyle*, int /* maxLines */) | Added    | Added the API for setting the maximum number of lines in the text.                               |
  | Graphics - drawing | OH_Drawing_TextStyle* OH_Drawing_CreateTextStyle(void)       | Added    | Added the API for creating an **OH_Drawing_TextStyle** object.                       |
  | Graphics - drawing | void OH_Drawing_DestroyTextStyle(OH_Drawing_TextStyle*)      | Added    | Added the API for releasing the memory occupied by an **OH_Drawing_TextStyle** object.       |
  | Graphics - drawing | void OH_Drawing_SetTextStyleColor(OH_Drawing_TextStyle*, uint32_t /* color */) | Added    | Added the API for setting the text color.                                   |
  | Graphics - drawing | void OH_Drawing_SetTextStyleFontSize(OH_Drawing_TextStyle*, double /* fontSize */); | Added    | Added the API for setting the font size.                                       |
  | Graphics - drawing | void OH_Drawing_SetTextStyleFontWeight(OH_Drawing_TextStyle*, int /* OH_Drawing_FontWeight */) | Added    | Added the API for setting the font weight.                                       |
  | Graphics - drawing | void OH_Drawing_SetTextStyleBaseLine(OH_Drawing_TextStyle*, int /* OH_Drawing_TextBaseline */) | Added    | Added the API for setting the text baseline.                               |
  | Graphics - drawing | void OH_Drawing_SetTextStyleDecoration(OH_Drawing_TextStyle*, int /* OH_Drawing_TextDecoration */) | Added    | Added the API for setting the text decoration.                                       |
  | Graphics - drawing | void OH_Drawing_SetTextStyleDecorationColor(OH_Drawing_TextStyle*, uint32_t /* color */) | Added    | Added the API for setting the color for the text decoration.                                   |
  | Graphics - drawing | void OH_Drawing_SetTextStyleFontHeight(OH_Drawing_TextStyle*, double /* fontHeight */) | Added    | Added the API for setting the font height.                                   |
  | Graphics - drawing | void OH_Drawing_SetTextStyleFontFamilies(OH_Drawing_TextStyle*,int /* fontFamiliesNumber \*/, const char* fontFamilies[]); | Added    | Added the API for setting the font families.                                   |
  | Graphics - drawing | void OH_Drawing_SetTextStyleFontStyle(OH_Drawing_TextStyle*, int /* OH_Drawing_FontStyle */) | Added    | Added the API for setting the font style.                                   |
  | Graphics - drawing | void OH_Drawing_SetTextStyleLocale(OH_Drawing_TextStyle*, const char*) | Added    | Added the API for setting the locale.                                   |
  | Graphics - drawing | OH_Drawing_TypographyCreate* OH_Drawing_CreateTypographyHandler(OH_Drawing_TypographyStyle*, OH_Drawing_FontCollection*) | Added    | Added the API for creating a pointer to an **OH_Drawing_TypographyCreate** object.  |
  | Graphics - drawing | void OH_Drawing_DestroyTypographyHandler(OH_Drawing_TypographyCreate*) | Added    | Added the API for releasing the memory occupied by an **OH_Drawing_TypographyCreate** object.|
  | Graphics - drawing | void OH_Drawing_TypographyHandlerPushTextStyle(OH_Drawing_TypographyCreate*, OH_Drawing_TextStyle*) | Added    | Added the API for setting the text style.                                   |
  | Graphics - drawing | void OH_Drawing_TypographyHandlerAddText(OH_Drawing_TypographyCreate*, const char*) | Added    | Added the API for setting the text content.                                   |
  | Graphics - drawing | void OH_Drawing_TypographyHandlerPopTextStyle(OH_Drawing_TypographyCreate*) | Added    | Added the API for removing the topmost style in the stack, leaving the remaining styles in effect.                                   |
  | Graphics - drawing | OH_Drawing_Typography* OH_Drawing_CreateTypography(OH_Drawing_TypographyCreate*) | Added    | Added the API for creating an **OH_Drawing_Typography** object.                      |
  | Graphics - drawing | void OH_Drawing_DestroyTypography(OH_Drawing_Typography*)    | Added    | Added the API for releasing the memory occupied by an **OH_Drawing_Typography** object.        |
  | Graphics - drawing | void OH_Drawing_TypographyLayout(OH_Drawing_Typography*, double /* maxWidth */) | Added    | Added the API for laying out the typography.                                       |
  | Graphics - drawing | void OH_Drawing_TypographyPaint(OH_Drawing_Typography*, OH_Drawing_Canvas*, double /* potisionX */, double /\* potisionY */) | Added    | Added the API for painting text on the canvas.                                       |
| Graphics - drawing   |OH_Drawing_Bitmap* OH_Drawing_BitmapCreate(void)|Added|Added the API for creating an **OH_Drawing_Bitmap** object.|
| Graphics - drawing   |void OH_Drawing_BitmapDestroy(OH_Drawing_Bitmap*)|Added|Added the API for destroying an **OH_Drawing_Bitmap** object and reclaiming the memory occupied by the object.|
| Graphics - drawing   |void OH_Drawing_BitmapBuild(OH_Drawing_Bitmap*, const uint32_t width, const uint32_t height, const OH_Drawing_BitmapFormat*)|Added|Added the API for initializing the width and height of an **OH_Drawing_Bitmap** object and setting the pixel format for the bitmap.|
| Graphics - drawing   |uint32_t OH_Drawing_BitmapGetWidth(OH_Drawing_Bitmap*)|Added|Added the API for obtaining the width of a bitmap.|
| Graphics - drawing   |uint32_t OH_Drawing_BitmapGetHeight(OH_Drawing_Bitmap*)|Added|Added the API for obtaining the height of a bitmap.|
| Graphics - drawing   |void* OH_Drawing_BitmapGetPixels(OH_Drawing_Bitmap*)|Added|Added the API for obtaining the pixel address of a bitmap. You can use this address to obtain the pixel data of the bitmap.|
| Graphics - drawing   |OH_Drawing_Brush* OH_Drawing_BrushCreate(void)|Added|Added the API for creating an **OH_Drawing_Brush** object.|
| Graphics - drawing   |void OH_Drawing_BrushDestroy(OH_Drawing_Brush*)|Added|Added the API for destroying an **OH_Drawing_Brush** object and reclaiming the memory occupied by the object.|
| Graphics - drawing   |bool OH_Drawing_BrushIsAntiAlias(const OH_Drawing_Brush*)|Added|Added the API for checking whether anti-aliasing is enabled for a brush. If anti-aliasing is enabled, edges will be drawn with partial transparency.|
| Graphics - drawing   |void OH_Drawing_BrushSetAntiAlias(OH_Drawing_Brush*, bool)|Added|Added the API for enabling or disabling anti-aliasing for a brush. If anti-aliasing is enabled, edges will be drawn with partial transparency.|
| Graphics - drawing   |uint32_t OH_Drawing_BrushGetColor(const OH_Drawing_Brush*)|Added|Added the API for obtaining the color of a brush. The color is used by the brush to fill in a shape.|
| Graphics - drawing   |void OH_Drawing_BrushSetColor(OH_Drawing_Brush*, uint32_t color)|Added|Added the API for setting the color for a brush. The color will be used by the brush to fill in a shape.|
| Graphics - drawing   |OH_Drawing_Canvas* OH_Drawing_CanvasCreate(void)|Added|Added the API for creating an **OH_Drawing_Canvas** object.|
| Graphics - drawing   |void OH_Drawing_CanvasDestroy(OH_Drawing_Canvas*)|Added|Added the API for destroying an **OH_Drawing_Canvas** object and reclaiming the memory occupied by the object.|
| Graphics - drawing   |void OH_Drawing_CanvasBind(OH_Drawing_Canvas*, OH_Drawing_Bitmap*)|Added|Added the API for binding a bitmap to a canvas so that the content drawn on the canvas is output to the bitmap (this process is called CPU rendering).|
| Graphics - drawing   |void OH_Drawing_CanvasAttachPen(OH_Drawing_Canvas*, const OH_Drawing_Pen*)|Added|Added the API for attaching a pen to a canvas so that the canvas will use the style and color of the pen to outline a shape.|
| Graphics - drawing   |void OH_Drawing_CanvasDetachPen(OH_Drawing_Canvas*)|Added|Added the API for detaching the pen from a canvas so that the canvas will not use the style and color of the pen to outline a shape.|
| Graphics - drawing   |void OH_Drawing_CanvasAttachBrush(OH_Drawing_Canvas*, const OH_Drawing_Brush*)|Added|Added the API for attaching a brush to a canvas so that the canvas will use the style and color of the brush to fill in a shape.|
| Graphics - drawing   |void OH_Drawing_CanvasDetachBrush(OH_Drawing_Canvas*)|Added|Added the API for detaching the brush from a canvas so that the canvas will not use the style and color of the brush to fill in a shape.|
| Graphics - drawing   |void OH_Drawing_CanvasSave(OH_Drawing_Canvas*)|Added|Added the API for saving the current canvas status (canvas matrix) to the top of the stack.|
| Graphics - drawing   |void OH_Drawing_CanvasRestore(OH_Drawing_Canvas*)|Added|Added the API for restoring the canvas status (canvas matrix) saved on the top of the stack.|
| Graphics - drawing   |void OH_Drawing_CanvasDrawLine(OH_Drawing_Canvas*, float x1, float y1, float x2, float y2)|Added|Added the API for drawing a line segment.|
| Graphics - drawing   |void OH_Drawing_CanvasDrawPath(OH_Drawing_Canvas*, const OH_Drawing_Path*)|Added|Added the API for drawing a path.|
| Graphics - drawing   |void OH_Drawing_CanvasClear(OH_Drawing_Canvas*, uint32_t color)|Added|Added the API for clearing a canvas by using a specified color.|
| Graphics - drawing   |uint32_t OH_Drawing_ColorSetArgb(uint32_t alpha, uint32_t red, uint32_t green, uint32_t blue)|Added|Added the API for converting four variables (alpha, red, green, and blue) into a 32-bit (ARGB) variable that describes a color.|
| Graphics - drawing   |OH_Drawing_Path* OH_Drawing_PathCreate(void)|Added|Added the API for creating an **OH_Drawing_Path** object.|
| Graphics - drawing   |void OH_Drawing_PathDestroy(OH_Drawing_Path*)|Added|Added the API for destroying an **OH_Drawing_Path** object and reclaiming the memory occupied by the object.|
| Graphics - drawing   |void OH_Drawing_PathMoveTo(OH_Drawing_Path*, float x, float y)|Added|Added the API for setting the start point of a path.|
| Graphics - drawing   |void OH_Drawing_PathLineTo(OH_Drawing_Path*, float x, float y)|Added|Added the API for drawing a line segment from the last point of a path to the target point.|
| Graphics - drawing   |void OH_Drawing_PathArcTo(OH_Drawing_Path*, float x1, float y1, float x2, float y2, float startDeg, float sweepDeg)|Added|Added the API for drawing an arc to a path. This is done by using angle arc mode. In this mode, a rectangle that encloses an ellipse is specified first, and then a start angle and a sweep angle are specified. The arc is a portion of the ellipse defined by the start angle and the sweep angle. By default, a line segment from the last point of the path to the start point of the arc is also added.|
| Graphics - drawing   |void OH_Drawing_PathQuadTo(OH_Drawing_Path*, float ctrlX, float ctrlY, float endX, float endY)|Added|Added the API for drawing a quadratic Bezier curve from the last point of a path to the target point.|
| Graphics - drawing   |void OH_Drawing_PathCubicTo(OH_Drawing_Path*, float ctrlX1, float ctrlY1, float ctrlX2, float ctrlY2, float endX, float endY)|Added|Added the API for drawing a cubic Bezier curve from the last point of a path to the target point.|
| Graphics - drawing   |void OH_Drawing_PathClose(OH_Drawing_Path*)|Added|Added the API for closing a path. A line segment from the start point to the last point of the path is added.|
| Graphics - drawing   |void OH_Drawing_PathReset(OH_Drawing_Path*)|Added|Added the API for resetting path data.|
| Graphics - drawing   |OH_Drawing_Pen* OH_Drawing_PenCreate(void)|Added|Added the API for creating an **OH_Drawing_Pen** object.|
| Graphics - drawing   |void OH_Drawing_PenDestroy(OH_Drawing_Pen*)|Added|Added the API for destroying an **OH_Drawing_Pen** object and reclaiming the memory occupied by the object.|
| Graphics - drawing   |bool OH_Drawing_PenIsAntiAlias(const OH_Drawing_Pen*)|Added|Added the API for checking whether anti-aliasing is enabled for a pen. If anti-aliasing is enabled, edges will be drawn with partial transparency.|
| Graphics - drawing   |void OH_Drawing_PenSetAntiAlias(OH_Drawing_Pen*, bool)|Added|Added the API for enabling or disabling anti-aliasing for a pen. If anti-aliasing is enabled, edges will be drawn with partial transparency.|
| Graphics - drawing   |uint32_t OH_Drawing_PenGetColor(const OH_Drawing_Pen*)|Added|Added the API for obtaining the color of a pen. The color is used by the pen to outline a shape.|
| Graphics - drawing   |void OH_Drawing_PenSetColor(OH_Drawing_Pen*, uint32_t color)|Added|Added the API for setting the color for a pen. The color is used by the pen to outline a shape.|
| Graphics - drawing   |float OH_Drawing_PenGetWidth(const OH_Drawing_Pen*)|Added|Added the API for obtaining the thickness of a pen. This thickness determines the width of the outline of a shape.|
| Graphics - drawing   |void OH_Drawing_PenSetWidth(OH_Drawing_Pen*, float width)|Added|Added the API for setting the thickness for a pen. This thickness determines the width of the outline of a shape.|
| Graphics - drawing   |float OH_Drawing_PenGetMiterLimit(const OH_Drawing_Pen*)|Added|Added the API for obtaining the stroke miter limit of a polyline drawn by a pen. When the corner type is bevel, a beveled corner is displayed if the miter limit is exceeded, and a mitered corner is displayed if the miter limit is not exceeded.|
| Graphics - drawing   |void OH_Drawing_PenSetMiterLimit(OH_Drawing_Pen*, float miter)|Added|Added the API for setting the stroke miter limit for a polyline drawn by a pen. When the corner type is bevel, a beveled corner is displayed if the miter limit is exceeded, and a mitered corner is displayed if the miter limit is not exceeded.|
| Graphics - drawing   |OH_Drawing_PenLineCapStyle OH_Drawing_PenGetCap(const OH_Drawing_Pen*)|Added|Added the API for obtaining the line cap style of a pen.|
| Graphics - drawing   |void OH_Drawing_PenSetCap(OH_Drawing_Pen*, OH_Drawing_PenLineCapStyle)|Added|Added the API for setting the line cap style for a pen.|
| Graphics - drawing   |OH_Drawing_PenLineJoinStyle OH_Drawing_PenGetJoin(const OH_Drawing_Pen*)|Added|Added the API for obtaining the line join style of a pen.|
| Graphics - drawing   |void OH_Drawing_PenSetJoin(OH_Drawing_Pen*, OH_Drawing_PenLineJoinStyle)|Added|Added the API for setting the line join style for a pen.|
| Graphics - NativeWindow   | struct NativeWindow* OH_NativeWindow_CreateNativeWindow(void* pSurface) | Added| Added the API for creating a **NativeWindow** instance.|
| Graphics - NativeWindow   | void OH_NativeWindow_DestroyNativeWindow(struct NativeWindow* window) | Added| Added the API for decreasing the reference count of a **NativeWindow** instance by 1 and, when the reference count reaches 0, destroying the instance.|
| Graphics - NativeWindow   | struct NativeWindowBuffer* OH_NativeWindow_CreateNativeWindowBufferFromSurfaceBuffer(void* pSurfaceBuffer) | Added| Added the API for creating a **NativeWindowBuffer** instance.|
| Graphics - NativeWindow   | void OH_NativeWindow_DestroyNativeWindowBuffer(struct NativeWindowBuffer* buffer) | Added| Added the API for decreasing the reference count of a **NativeWindowBuffer** instance by 1 and, when the reference count reaches 0, destroying the instance.|
| Graphics - NativeWindow   | int32_t OH_NativeWindow_NativeWindowRequestBuffer(struct NativeWindow *window, struct NativeWindowBuffer **buffer, int *fenceFd) | Added| Added the API for requesting a **NativeWindowBuffer** through a **NativeWindow** instance for content production.|
| Graphics - NativeWindow   | int32_t OH_NativeWindow_NativeWindowFlushBuffer(struct NativeWindow *window, struct NativeWindowBuffer *buffer, int fenceFd, Region region) | Added| Added the API for flushing the **NativeWindowBuffer** filled with the content to the buffer queue through a **NativeWindow** instance for content consumption.|
| Graphics - NativeWindow   | int32_t OH_NativeWindow_NativeWindowAbortBuffer(struct NativeWindow *window, struct NativeWindowBuffer *buffer) | Added| Added the API for returning the **NativeWindowBuffer** to the buffer queue through a **NativeWindow** instance, without filling in any content. The **NativeWindowBuffer** can be used for another request.|
| Graphics - NativeWindow   | int32_t OH_NativeWindow_NativeWindowHandleOpt(struct NativeWindow *window, int code, ...) | Added| Added the API for setting and obtaining the attributes of a native window, including the width, height, and content format.|
| Graphics - NativeWindow   | BufferHandle *OH_NativeWindow_GetBufferHandleFromNative(struct NativeWindowBuffer *buffer) | Added| Added the API for obtaining the pointer to a **BufferHandle** of a **NativeWindowBuffer** instance.|
| Graphics - NativeWindow   | int32_t OH_NativeWindow_NativeObjectReference(void *obj) | Added| Added the API for adding the reference count of a native object.|
| Graphics - NativeWindow   | int32_t OH_NativeWindow_NativeObjectUnreference(void *obj) | Added| Added the API for decreasing the reference count of a native object and, when the reference count reaches 0, destroying this object.|
| Graphics - NativeWindow   | int32_t OH_NativeWindow_GetNativeObjectMagic(void *obj) | Added| Added the API for obtaining the magic ID of a native object.|
| DFX - HiLog   | LOG_DOMAIN                                                   | Added    | Added this hexadecimal integer macro to identify the service domain of a log file.                  |
| DFX - HiLog   | LOG_TAG                                                      | Added    | Added this string macro to identify the class or service behavior.                        |
| DFX - HiLog   | LOG_APP                                                      | Added    | Added this enumeration to identify the log type.                            |
| DFX - HiLog   | LOG_DEBUG                                                    | Added    | Added this enumeration to identify the DEBUG log level.                           |
| DFX - HiLog   | LOG_INFO                                                     | Added    | Added this enumeration to identify the INFO log level.                            |
| DFX - HiLog   | LOG_WARN                                                     | Added    | Added this enumeration to identify the WARN log level.                            |
| DFX - HiLog   | LOG_ERROR                                                    | Added    | Added this enumeration to identify the ERROR log level.                           |
| DFX - HiLog   | LOG_FATAL                                                    | Added    | Added this enumeration to identify the FATAL log level.                           |
| DFX - HiLog   | bool OH_LOG_IsLoggable(unsigned int domain, const char *tag, LogLevel level) | Added    | Added the API for checking whether logs of the specified service domain, tag, and level can be printed.|
| DFX - HiLog   | int OH_LOG_Print(LogType type, LogLevel level, unsigned int domain, const char *tag, const char *fmt, ...) | Added    | Added the API for outputting logs.                                      |
| DFX - HiLog   | OH_LOG_DEBUG(type, ...)                                      | Added    | Added this function-like macro for outputting DEBUG logs.                           |
| DFX - HiLog   | OH_LOG_INFO(type, ...)                                       | Added    | Added this function-like macro for outputting INFO logs.                            |
| DFX - HiLog   | OH_LOG_WARN(type, ...)                                       | Added    | Added this function-like macro for outputting WARN logs.                            |
| DFX - HiLog   | OH_LOG_ERROR(type, ...)                                      | Added    | Added this function-like macro for outputting ERROR logs.                           |
| DFX - HiLog   | OH_LOG_FATAL(type, ...)                                      | Added    | Added this function-like macro for outputting FATAL logs.                           |
| zlib     | ZEXTERN uLong ZEXPORT adler32 OF((uLong adler, const Bytef *buf, uInt len));<br>ZEXTERN uLong ZEXPORT adler32_z OF((uLong adler, const Bytef *buf, z_size_t len)); | Added    | Added the APIs for updating an Adler-32 checksum from the buffer.                                          |
| zlib     | ZEXTERN uLong ZEXPORT adler32_combine OF((uLong, uLong, z_off_t)); <br>ZEXTERN uLong ZEXPORT adler32_combine64 OF((uLong, uLong, z_off_t)); | Added    | Added the APIs for combining two Adler-32 checksums into one.                                             |
| zlib     | ZEXTERN int ZEXPORT compress2 OF((Bytef *dest,   uLongf *destLen,  const Bytef *source, uLong sourceLen,  int level));<br>ZEXTERN int ZEXPORT compress OF((Bytef *dest,   uLongf *destLen, const Bytef *source, uLong sourceLen)); | Added    | Added the APIs for compressing the source buffer into the destination buffer.                                  |
| zlib     | ZEXTERN uLong ZEXPORT compressBound OF((uLong sourceLen));   | Added    | Added the API for returning the upper limit of a buffer to hold the compressed data. This API must be called to determine the size of the buffer to allocate before **compress2** or **compress** is called.|
| zlib     | ZEXTERN uLong ZEXPORT crc32   OF((uLong crc, const Bytef *buf, uInt len));<br>ZEXTERN uLong ZEXPORT crc32_z OF((uLong adler, const Bytef *buf, z_size_t len)); | Added    | Added the APIs for updating a CRC-32 checksum from the buffer.                                            |
| zlib     | ZEXTERN uLong ZEXPORT crc32_combine OF((uLong, uLong, z_off_t));<br>ZEXTERN uLong ZEXPORT crc32_combine64 OF((uLong, uLong, z_off64_t)); | Added    | Added the APIs for combines two CRC-32 checksums into one.                                               |
| zlib     | ZEXTERN int ZEXPORT deflate OF((z_streamp strm, int flush)); | Added    | Added the API for compression.                                                    |
| zlib     | ZEXTERN uLong ZEXPORT deflateBound OF((z_streamp strm, uLong sourceLen)); | Added    | Added the API for returning the upper limit of a buffer to hold the compressed data. This API must be called to determine the size of the buffer to allocate before **deflateInit** or **deflateInit2** is called.|
| zlib     | ZEXTERN int ZEXPORT deflateCopy OF((z_streamp dest, z_streamp source)); | Added    | Added the API for setting the destination stream as a complete copy of the source stream.                                |
| zlib     | ZEXTERN int ZEXPORT deflateEnd OF((z_streamp strm));         | Added    | Added the API for freeing up space after the compression is complete.                                       |
| zlib     | ZEXTERN int ZEXPORT deflateGetDictionary OF((z_streamp strm, Bytef *dictionary, uInt  *dictLength)); | Added    | Added the API for obtaining the sliding dictionary maintained by **deflate**.                                 |
| zlib     | ZEXTERN int ZEXPORT deflateInit_ OF((z_streamp strm, int level, const char *version, int stream_size));<br>ZEXTERN int ZEXPORT deflateInit2_ OF((z_streamp strm, int  level, int  method, int windowBits, int memLevel, int strategy, const char *version, int stream_size)); | Added    | Added the APIs for **deflate** initialization.                                        |
| zlib     | ZEXTERN int ZEXPORT deflateParams OF((z_streamp strm, int level, int strategy)); | Added    | Added the API for dynamically updating the compression level and compression strategy.                                  |
| zlib     | ZEXTERN int ZEXPORT deflatePending OF((z_streamp strm,  unsigned *pending, int *bits)); | Added    | Added the API for returning the number of bytes and bits of output that has been generated but not yet provided in the available output.        |
| zlib     | ZEXTERN int ZEXPORT deflatePrime OF((z_streamp strm, int bits, int value)); | Added    | Added the APIs for inserting bits in the **deflate** output stream.                                       |
| zlib     | ZEXTERN int ZEXPORT deflateReset OF((z_streamp strm));       | Added    | Added this API, which is equivalent to **deflateEnd** followed by **deflateInit**, but does not free or reallocate the internal compression state.|
| zlib     | ZEXTERN int ZEXPORT deflateSetDictionary OF((z_streamp strm, const Bytef *dictionary, uInt  dictLength)); | Added    | Added the API for initializing the compression dictionary from a given sequence of bytes without producing any compression output.        |
| zlib     | ZEXTERN int ZEXPORT deflateSetHeader OF((z_streamp strm, gz_headerp head)); | Added    | Added the API for providing the gzip header information when a gzip stream is requested by **delateInit2()**.|
| zlib     | ZEXTERN int ZEXPORT deflateTune OF((z_streamp strm, int good_length, int max_lazy, int nice_length, int max_chain)); | Added    | Added the API for fine-tuning the internal compression parameters of **deflate**.                                      |
| zlib     | ZEXTERN int ZEXPORT gzbuffer OF((gzFile file, unsigned size)); | Added    | Added the API for setting the size of the internal buffer used by this library's functions. The default buffer size is 8192 bytes.  |
| zlib     | ZEXTERN void ZEXPORT gzclearerr OF((gzFile file));           | Added    | Added the API for clearing the error and end-of-file flags for a file.                                |
| zlib     | ZEXTERN int ZEXPORT    gzclose OF((gzFile file));<br>ZEXTERN int ZEXPORT gzclose_r OF((gzFile file));<br>ZEXTERN int ZEXPORT gzclose_w OF((gzFile file)); | Added    | Added the APIs for flushing all pending output, closing the compressed file, and deallocating the compression state.              |
| zlib     | ZEXTERN int ZEXPORT gzdirect OF((gzFile file));              | Added    | Added the API for returning **true** (1) if the file is being copied directly while reading, and returning **false** (0) if the file is a gzip stream being decompressed.|
| zlib     | ZEXTERN gzFile ZEXPORT gzdopen OF((int fd, const char *mode)); | Added    | Added the API for associating a **gzFile** with a file descriptor. File descriptors are obtained from calls such as **open**, **dup**, **create**, **pipe**, or **fileno** (in the file that has been opened using **fopen**). The **mode** parameter is the same as that in **gzopen**.|
| zlib     | ZEXTERN int ZEXPORT gzeof OF((gzFile file));                 | Added    | Added the API for returning **true** (1) if the end-of-file indicator has been set while reading, and returning **false** (0) otherwise.|
| zlib     | ZEXTERN const char * ZEXPORT gzerror OF((gzFile file, int *errnum)); | Added    | Added the API for returning the error message for the last error that occurred on a given compressed file.              |
| zlib     | ZEXTERN int ZEXPORT gzflush OF((gzFile file, int flush));    | Added    | Added the API for flushing all pending output into a compressed file.                            |
| zlib     | ZEXTERN z_size_t ZEXPORT gzfread OF((voidp buf, z_size_t size, z_size_t nitems, gzFile file)); | Added    | Added the API for reading a given number of bytes from a compressed file to the buffer.                            |
| zlib     | ZEXTERN z_size_t ZEXPORT gzfwrite OF((voidpc buf, z_size_t size, z_size_t nitems, gzFile file)); | Added    | Added the API for writing a given number of bytes from the buffer to a compressed file, duplicating the interface of stdio's **fwrite()**, with **size_t** request and return types.|
| zlib     | ZEXTERN int ZEXPORT gzgetc OF((gzFile file));<br>ZEXTERN int ZEXPORT gzgetc_ OF((gzFile file)); | Added    | Added the APIs for reading a byte from a compressed file.                                    |
| zlib     | ZEXTERN char * ZEXPORT gzgets OF((gzFile file, char *buf, int len)); | Added    | Added the API for reading bytes from a compressed file until **len-1** characters are read, a newline character is read and transferred to a buffer, or an end-of-file condition is encountered.|
| zlib     | ZEXTERN z_off_t ZEXPORT gzoffset OF((gzFile));<br>ZEXTERN z_off64_t ZEXPORT gzoffset64 OF((gzFile)); | Added    | Added the APIs for returning the current offset in the file being read or written.                      |
| zlib     | ZEXTERN gzFile ZEXPORT gzopen OF((const char *, const char *));<br>ZEXTERN gzFile ZEXPORT gzopen64 OF((const char *, const char *)); | Added    | Added the APIs for opening a gzip (.gz) file for reading or writing.                          |
| zlib     | ZEXTERN int ZEXPORTVA gzprintf Z_ARG((gzFile file, const char *format, ...)); | Added    | Added the API for converting, formatting, and writing the parameters to a compressed file under the control of the **format** string.      |
| zlib     | ZEXTERN int ZEXPORT gzputc OF((gzFile file, int c));<br>ZEXTERN int ZEXPORT gzputs OF((gzFile file, const char *s)); | Added    | Added the APIs for writing **c**, which is converted to an unsigned character, into a compressed file. **gzputc** returns the written value or **-1** in the case of an error.|
| zlib     | ZEXTERN int ZEXPORT gzread OF((gzFile file, voidp buf, unsigned len)); | Added    | Added the API for reading a given number of uncompressed bytes from a compressed file.                        |
| zlib     | ZEXTERN int ZEXPORT    gzrewind OF((gzFile file));           | Added    | Added the API for rewinding a file.                                            |
| zlib     | ZEXTERN z_off_t ZEXPORT gzseek OF((gzFile, z_off_t, int));<br>ZEXTERN z_off_t ZEXPORT gzseek64 OF((gzFile, z_off_t, int)); | Added    | Added the APIs for setting the start position for the next **gzread** or **gzwrite** operation of a given compressed file.           |
| zlib     | ZEXTERN int ZEXPORT gzsetparams OF((gzFile file, int level, int strategy)); | Added    | Added the API for dynamically updating the compression level or strategy.                                      |
| zlib     | ZEXTERN z_off_t ZEXPORT gztell OF((gzFile));<br>ZEXTERN z_off64_t ZEXPORT gztell64 OF((gzFile)); | Added    | Added the API for returning the start position of the next **gzread** or **gzwrite** operation of a given compressed file.           |
| zlib     | ZEXTERN int ZEXPORT gzungetc OF((int c, gzFile file));       | Added    | Added the API for pushing a character back to the stream to be read again.          |
| zlib     | ZEXTERN int ZEXPORT gzwrite OF((gzFile file, voidpc buf, unsigned len)); | Added    | Added the API for writing a given number of uncompressed bytes to a compressed file.                          |
| zlib     | ZEXTERN int ZEXPORT inflate OF((z_streamp strm, int flush)); | Added    | Added an API for decompressing as much data as possible and stopping when the input buffer becomes empty or the output buffer becomes full.|
| zlib     | ZEXTERN int ZEXPORT inflateBack OF((z_streamp strm, in_func in, void FAR *in_desc, out_func out, void FAR *out_desc));<br>ZEXTERN int ZEXPORT inflateBackEnd OF((z_streamp strm));<br>ZEXTERN int ZEXPORT inflateBackInit_ OF((z_streamp strm, int windowBits, unsigned char FAR *window, const char *version, int stream_size)); | Added    | Added the callback APIs for decompression.                                        |
| zlib     | ZEXTERN int ZEXPORT inflateCopy OF((z_streamp dest, z_streamp source)); | Added    | Added the API for setting the destination stream as a complete copy of the source stream.                                |
| zlib     | ZEXTERN int ZEXPORT inflateEnd OF((z_streamp strm));         | Added    | Added the API for freeing up all dynamically allocated data structures of this stream.                      |
| zlib     | ZEXTERN int ZEXPORT inflateGetDictionary OF((z_streamp strm, Bytef *dictionary, uInt  *dictLength)); | Added    | Added the API for obtaining the sliding dictionary maintained by **inflate**.                                 |
| zlib     | ZEXTERN int ZEXPORT inflateGetHeader OF((z_streamp strm, gz_headerp head)); | Added    | Added the API for storing the gzip header information in the provided **gz_header** structure.                   |
| zlib     | ZEXTERN int ZEXPORT inflateInit_ OF((z_streamp strm, const char *version, int stream_size));<br _>/ZEXTERN int ZEXPORT inflateInit2_ OF((z_streamp strm, int  windowBits, const char *version, int stream_size)); | Added    | Added the APIs for decompression initialization.                                              |
| zlib     | ZEXTERN long ZEXPORT inflateMark OF((z_streamp strm));       | Added    | Added the API for returning two values. One is in the lower 16 bits of the return value, and the other is in the remaining upper bits, obtained by shifting the return value down by 16 bits.|
| zlib     | ZEXTERN int ZEXPORT inflatePrime OF((z_streamp strm, int bits, int value)); | Added    | Added the API for inserting bits into the **inflate** input stream.                                     |
| zlib     | ZEXTERN int ZEXPORT inflateReset OF((z_streamp strm));<br>ZEXTERN int ZEXPORT inflateReset2 OF((z_streamp strm, int windowBits)); | Added    | Added these APIs, which are equivalent to **inflateEnd** followed by **inflateInit**, but do not free or reallocate the internal decompression state. The stream will retain attributes that may have been set by **inflateInit2**.|
| zlib     | ZEXTERN int ZEXPORT inflateSetDictionary OF((z_streamp strm, const Bytef *dictionary, uInt  dictLength)); | Added    | Added the API for initializing the decompression dictionary from a given uncompressed byte sequence.                      |
| zlib     | ZEXTERN int ZEXPORT inflateSync OF((z_streamp strm));        | Added    | Added the API for skipping invalid compressed data until a possible full flush point is found, or until all available input is skipped. There is no output.|
| zlib     | ZEXTERN int ZEXPORT uncompress OF((Bytef *dest,   uLongf *destLen, const Bytef *source, uLong sourceLen));<br>ZEXTERN int ZEXPORT uncompress2 OF((Bytef *dest,   uLongf *destLen, const Bytef *source, uLong *sourceLen)); | Added    | Added the APIs for decompressing the source buffer into the destination buffer. **sourceLen** indicates the byte length of the source buffer. |
| zlib     | ZEXTERN uLong ZEXPORT zlibCompileFlags OF((void));           | Added    | Added the API for returning flags indicating compile-time options.                                  |
| zlib     | ZEXTERN const char * ZEXPORT zlibVersion OF((void));         | Added    | Added the API for returning the zlib version.                                                |
| Globalization - resmgr  | NativeResourceManager *OH_ResourceManager_InitNativeResourceManager(napi_env env, napi_value jsResMgr) | Added    | Added the API for initializing the native resource manager.                  |
| Globalization - resmgr  | void OH_ResourceManager_ReleaseNativeResourceManager(NativeResourceManager *resMgr) | Added    | Added the API for releasing the native resource manager.                    |
| Globalization - resmgr  | RawDir *OH_ResourceManager_OpenRawDir(const NativeResourceManager *mgr, const char *dirName) | Added    | Added the API for opening a raw file directory.                   |
| Globalization - resmgr  | RawFile *OH_ResourceManager_OpenRawFile(const NativeResourceManager *mgr, const char *fileName) | Added    | Added the API for opening a raw file.                   |
| Globalization - resmgr  | const char *OH_ResourceManager_GetRawFileName(RawDir *rawDir, int index) | Added    | Added the API for obtaining a raw file name.                       |
| Globalization - resmgr  | int OH_ResourceManager_GetRawFileCount(RawDir *rawDir)       | Added    | Added the API for obtaining the number of raw files in a raw file directory.|
| Globalization - resmgr  | void OH_ResourceManager_CloseRawDir(RawDir *rawDir)          | Added    | Added the API for releasing the resources related to a raw file directory.               |
| Globalization - resmgr  | int OH_ResourceManager_ReadRawFile(const RawFile *rawFile, void *buf, size_t length) | Added    | Added the API for reading a raw file.                   |
| Globalization - resmgr  | int OH_ResourceManager_SeekRawFile(const RawFile *rawFile, long offset, int whence) | Added    | Added the API for querying data in a raw file based on a given offset.     |
| Globalization - resmgr  | long OH_ResourceManager_GetRawFileSize(RawFile *rawFile)     | Added    | Added the API for obtaining the size of a raw file.               |
| Globalization - resmgr  | void OH_ResourceManager_CloseRawFile(RawFile *rawFile)       | Added    | Added the API for releasing the resources related to a raw file.               |
| Globalization - resmgr  | long OH_ResourceManager_GetRawFileOffset(const RawFile *rawFile) | Added    | Added the API for obtaining the offset of a raw file.               |
| Globalization - resmgr  | bool OH_ResourceManager_GetRawFileDescriptor(const RawFile *rawFile, RawFileDescriptor &descriptor) | Added    | Added the API for obtaining the file descriptor of a raw file.                       |
| Globalization - resmgr  | bool OH_ResourceManager_ReleaseRawFileDescriptor(const RawFileDescriptor &descriptor) | Added    | Added the API for releasing the file descriptor of a raw file.                       |
|    Media - Multimedia     |   OH_GetImageInfo       |     Added    |    Added the API for obtaining image information based on the pixel address.     |
|    Media - Multimedia     |   OH_AccessPixels       |     Added    |    Added the API for locking the address of a given pixel.     |
|    Media - Multimedia     |   OH_UnAccessPixels     |     Added    |    Added the API for unlocking the address of a given pixel.     |
| Media - audio_standard| SL_API SLresult SLAPIENTRY slCreateEngine(<br>    SLObjectItf             *pEngine,<br>    SLuint32                numOptions,<br>    const SLEngineOption    *pEngineOptions,<br>    SLuint32                numInterfaces,<br>    const SLInterfaceID     *pInterfaceIds,<br>    const SLboolean         * pInterfaceRequired<br>); | Added    | Added the API for creating a **Engine** object.     |
| Media - audio_standard| SLObjectItf_<br>SLresult (*Realize) (<br>        SLObjectItf self,<br>        SLboolean async<br>    ); | Added    | Added the API for initializing an object.         |
| Media - audio_standard| SLObjectItf_<br>SLresult (*Resume) (<br>        SLObjectItf self,<br>        SLboolean async<br>    ); | Added    | Added the API for resuming an object.           |
| Media - audio_standard| SLObjectItf_<br>SLresult (*GetState) (<br>        SLObjectItf self,<br>        SLuint32 * pState<br>    ); | Added    | Added the API for obtaining the object state.           |
| Media - audio_standard| SLObjectItf_<br>SLresult (*GetInterface) (<br>        SLObjectItf self,<br>        const SLInterfaceID iid,<br>        void * pInterface<br>    ); | Added    | Added the API for obtaining an object based on the interface ID.|
| Media - audio_standard| SLObjectItf_<br>SLresult (*RegisterCallback) (<br>        SLObjectItf self,<br>        slObjectCallback callback,<br>        void * pContext<br>    ); | Added    | Added the API for registering a callback.             |
| Media - audio_standard| SLObjectItf_<br>void (*Destroy) (<br>        SLObjectItf self<br>    ); | Added    | Added the API for destroying an object.                 |
| Media - audio_standard| SLresult (*CreateAudioPlayer) (<br>        SLEngineItf self,<br>        SLObjectItf * pPlayer,<br>        SLDataSource *pAudioSrc,<br>        SLDataSink *pAudioSnk,<br>        SLuint32 numInterfaces,<br>        const SLInterfaceID * pInterfaceIds,<br>        const SLboolean * pInterfaceRequired<br>    ); | Added    | Added the API for creating an **AudioPlayer** object.      |
| Media - audio_standard| SLresult (*CreateOutputMix) (<br>        SLEngineItf self,<br>        SLObjectItf * pMix,<br>        SLuint32 numInterfaces,<br>        const SLInterfaceID * pInterfaceIds,<br>        const SLboolean * pInterfaceRequired<br>    ); | Added    | Added the API for creating an **OutputMix** object.        |
| Media - audio_standard| SLPlayItf_<br>SLresult (*SetPlayState) (<br>        SLPlayItf self,<br>        SLuint32 state<br>    ); | Added    | Added the API for setting the player state.         |
| Media - audio_standard| SLPlayItf_<br>SLresult (*GetPlayState) (<br>        SLPlayItf self,<br>        SLuint32 *pState<br>    ); | Added    | Added the API for obtaining the player state.         |
| Media - audio_standard| SLBufferQueueItf_<br>SLresult (*Enqueue) (<br>        SLBufferQueueItf self,<br>        const void *pBuffer,<br>        SLuint32 size<br>    ); | Added    | Added the API for filling a buffer queue.  |
| Media - audio_standard| SLBufferQueueItf_<br>SLresult (*Clear) (<br>        SLBufferQueueItf self<br>    ); | Added    | Added the API for clearing a buffer queue.    |
| Media - audio_standard| SLBufferQueueItf_<br>SLresult (*GetState) (<br>        SLBufferQueueItf self,<br>        SLBufferQueueState *pState<br>    ); | Added    | Added the API for obtaining the buffer queue state.    |
| Media - audio_standard| SLVolumeItf_<br>SLresult (*SetVolumeLevel) (<br>        SLVolumeItf self,<br>        SLmillibel level<br>    ); | Added    | Added the API for setting the volume level.           |
| Media - audio_standard| SLVolumeItf_<br>SLresult (*GetVolumeLevel) (<br>        SLVolumeItf self,<br>        SLmillibel *pLevel<br>    ); | Added    | Added the API for obtaining the volume level.           |
| Media - audio_standard| SLVolumeItf_<br>SLresult (*GetMaxVolumeLevel) (<br>        SLVolumeItf  self,<br>        SLmillibel *pMaxLevel<br>    ); | Added    | Added the API for setting the maximum volume level.     |
  | LIBUV | [LIBUV](https://gitee.com/openharmony/docs/tree/master/en/application-dev/reference/native-lib/third_party_libuv)| Added| Added the LIBUV interface.|
  | Node-API | [Node-API](https://gitee.com/openharmony/docs/blob/master/en/application-dev/reference/native-lib/third_party_napi/napi.md) | Added| The NAPI component re-implements the Node-API interface and supports some interfaces in the Node-API standard library.|
| EGL | [EGL](https://github.com/KhronosGroup/EGL-Registry/tree/main/api/EGL/)| Added| Added the EGL interface.|
| GLES3 | [GLES3](https://github.com/KhronosGroup/OpenGL-Registry/tree/main/api/GLES3/)| Added| Added the OpenGL ES 3.0 interface.|
| C++ standard library| [libc++](https://libcxx.llvm.org/)| Added| Added the C++ standard library interface.|
| C standard library| C11 standard library implemented by [libc, libm, and libdl](https://en.cppreference.com/w/c/header)| Added| Added the C standard library interface.|
