# HiDumper


## Overview

HiDumper is a tool provided by OpenHarmony for developers, testers, and IDE tool engineers to obtain system information necessary for analyzing and locating faults. This section applies only to the standard system.

## Source Code Directories

  
```
/base/hiviewdfx/hidumper
├── frameworks           # Framework code
│   ├── native           # Core function code
│   │  │── include       # Header files
│   │  │── src           # Source files
│   │      │── common    # Common function code
│   │      │── executor  # Process executor code
│   │      │── factory   # Factory code
│   │      │── manager   # Core manager code
│   │      │── util      # Utility source code
│── sa_profile           # HiDumper SA profile
│── services             # HiDumper service code
│   │── native           # C++ service code
│   │── zidl             # Communication function
│   │   │── include      # Header files of the communication function
│   │   │── src          # Source code of the communication function
├── test                 # Test cases
│   ├── unittest         # Unit test code
│   ├── moduletest       # Module-level test code
```


# Usage


## Command-Line Options

  **Table 1** HiDumper command-line options

| Option| **Description**| 
| -------- | -------- |
| -h | Shows the help Information.| 
| -t&nbsp;[timeout] | Specifies the timeout period, in seconds. The default value is **30**. Value **0** indicates no timeout limit.| 
| -lc | Shows the system information cluster list.| 
| -ls | Shows the system ability list.| 
| -c | Exports system cluster information.| 
| -c&nbsp;[base&nbsp;system] | Exports system cluster information based on **base** or **system** tags.| 
| -s | Exports all system ability information.| 
| -s&nbsp;[SA0&nbsp;SA1] | Exports ability information corresponding to SA0 and SA1.| 
| -s&nbsp;[SA]&nbsp;-a&nbsp;['-h'] | Exports the system ability information **SA** using the **-h** parameter.| 
| -e | Exports crash logs generated by the FaultLogger module.| 
| --net | Exports network information.| 
| --storage | Exports storage information.| 
| -p | Exports the process list and all process information.| 
| -p&nbsp;[pid] | Exports all information about the specified process.| 
| --cpuusage&nbsp;[pid] | Exports the CPU usage information. If **pid** is specified, the CPU usage of the corresponding process is exported.| 
| --cpufreq | Exports the actual CPU frequency.| 
| --mem&nbsp;[pid] | Export memory usage information. If **pid** is specified, the memory usage of the corresponding process is exported.| 
| --zip | Compresses the exported information to a specified folder.| 


## Development Example

HiDumper helps you export basic system information to locate and analyze faults. Complex parameters passed to sub-services and abilities must be enclosed in double quotation marks.

The procedure is as follows:

1. Access the device CLI, and run the **hidumper -h** command to obtain the help information, which includes basic information and function syntax.
     
   ```
   hidumper -h
   ```

2. Run the **hidumper -lc** command to obtain the system information cluster list.
     
   ```
   hidumper -lc
   ```

3. Run the **hidumper -c** command to obtain all information that is classified by **base** and **system**.
     
   ```
   hidumper -c
   ```

4. Run the **hidumper -c [base | system]** to obtain the system cluster information that is classified by **base** or **system**.
     
   ```
   hidumper -c base
   hidumper -c system
   ```

5. Run the **hidumper -ls** command to obtain the system ability list.
     
   ```
   hidumper -ls
   ```

6. Run the **hidumper -s** command to obtain all system ability information.
     
   ```
   hidumper -s
   ```

7. Run the **hidumper -s 3301 -a "-h"** command to obtain the help information about the ability whose ID is **3301**.
     
   ```
   hidumper -s 3301 -a "-h"
   ```

8. Run the **hidumper -s 3008** command to obtain all information about the ability whose ID is **3008**.
     
   ```
   hidumper -s 3008
   ```

9. Run the **hidumper -e** command to obtain the crash information generated by the FaultLoger module.
     
   ```
   hidumper -e
   ```

10. Run the **hidumper --net** command to obtain network information.
     
    ```
    hidumper --net
    ```

11. Run the **hidumper --storage** command to obtain storage information.
     
    ```
    hidumper --storage
    ```

12. Run the **hidumper -p** command to obtain process information, including the list and information of processes and threads.
     
    ```
    hidumper -p
    ```

13. Run the **hidumper -p 1024** command to obtain information about the process whose PID is **1024**.
     
    ```
    hidumper -p 1024
    ```

14. Run the **hidumper  --cpuusage [pid]** command to obtain the CPU usage information. If the PID of a process is specified, only the CPU usage of the process is returned.
     
    ```
    hidumper --cpuusage
    hidumper --cpuusage 1024
    ```

15. Run the **hidumper --cpufreq** command to obtain the actual operating frequency of each CPU core.
     
    ```
    hidumper --cpufreq
    ```

16. Run the **hidumper --mem [pid]** command to obtain all memory usage information. If the PID of a process is specified, only the memory usage of the process is returned.
     
    ```
    hidumper --mem [pid]
    ```

17. Run the **hidumper --zip** command to compress data to the **/data/dumper** directory.
     
    ```
    hidumper --zip
    ```

18. Run the **hidumper -t timeout** command to set the timeout period, in seconds. The default value is **30**. Value **0** indicates no timeout limit.
     
    ```
    hidumper -t [timeout]
    ```
