# RK3568 Development Board


## Overview

Bolstered by the Rockchip RK3568 chip, the RK3568 development board integrates a dual-core GPU and high-efficiency NPU. Its quad-core 64-bit Cortex-A55 processor uses the advanced 22 nm manufacturing process and is clocked at up to 2.0 GHz. The development board is packed with Bluetooth, Wi-Fi, audio, video, and camera features, with a wide range of expansion ports as well as video input and output ports. It comes with dual GE auto-sensing RJ45 ports, so it can be used in multi-connectivity products, such as NVRs and industrial gateways.

  **Figure 1** RK3568 front view 

![rk3568-front](figures/rk3568-front.png)

  **Figure 2** RK3568 rear view 

![rk3568-rear](figures/rk3568-rear.png)


## Specifications

**Table 1** RK3568 specifications

| Item| Description|
| -------- | -------- |
| Display| - 1 x HDMI 2.0 (Type-A) port, supporting 4K/60 fps output<br>- 2 x MIPI, supporting 1920 x 1080\@60 fps output<br>- 1 x eDP, supporting 2K@60 fps output|
| Audio| - 1 x 8ch I2S/TDM/PDM<br>- 1 x HDMI<br>- 1 x speaker output<br>- 1 x headset output<br>- 1 x microphone for onboard audio input|
| Ethernet| 2 x GMAC (10/100/1000M)|
| Wireless connectivity| SDIO port, supporting Wi-Fi 6 5/2.5 GHz and Bluetooth 4.2|
| Camera| MIPI-CSI2, 1 x 4-lane/2x2-lane\@2.5 Gbps/lane|
| USB | - 2 x USB 2.0 Host, Type-A<br>- 1 x USB 3.0 Host, Type-A<br>- 1 x USB3.0 OTG |
| PCIe | 1 x 2-lane PCIe 3.0 Connector (RC mode)|
| SATA | 1 x SATA 3.0 Connector |
| SDMMC | 1 x memory card 3.0 |
| Keys| - 1 x Vol+/Recovery<br>- 1 x Reset<br>- 1 x Power<br>- 1 x Vol-<br>- 1 x Mute |
| Debugging| 1 x Debugging serial port|
| RTC | 1 x RTC |
| IR | 1 x IR |
| Tri-color indicator| 3 x LED |
| G-sensor | 1 x G-sensor |
| Fan| 1 x fan|
| Expansion| The 20-pin expansion ports include:<br>- 2 x ADC<br>- 2 x I2C<br>- 7 x GPIO (or 3 x GPIO + 4 x UART)<br>- 3 x VCC power (12 V, 3.3 V, and 5 V)|
| Mother board dimensions| 180 mm x 130 mm|
| PCB| 4-laminate|
