# Getting Started

- [Quick Start Overview](quickstart-overview.md)
- Getting Started in IDE Mode
    - Setting Up the Development Environment
        - [Setting Up the Windows Environment](quickstart-ide-env-win.md)
        - [Setting Up the Ubuntu Environment](quickstart-ide-env-ubuntu.md)
        - [Configuring the Environment for Remote Access](quickstart-ide-env-remote.md)
    - [Creating a Project and Obtaining Source Code](quickstart-ide-import-project.md)
    - Mini System (Based on the Hi3861 Development Board)
        - [Writing a Hello World Program](quickstart-ide-3861-helloworld.md)
        - [Building Source Code](quickstart-ide-3861-build.md)
        - [Burning an Image](quickstart-ide-3861-burn.md)
        - [Running an Image](quickstart-ide-3861-running.md)
    - Small System (Based on the Hi3516 Development Board)
        - [Writing a Hello World Program](quickstart-ide-3516-helloworld.md)
        - [Building Source Code](quickstart-ide-3516-build.md)
        - [Burning an Image](quickstart-ide-3516-burn.md)
        - [Running an Image](quickstart-ide-3516-running.md)
    - Standard System (Based on the RK3568 Development Board)
        - [Writing a Hello World Program](quickstart-ide-3568-helloworld.md)
        - [Building Source Code](quickstart-ide-3568-build.md)
        - [Burning an Image](quickstart-ide-3568-burn.md)
        - [Running an Image](quickstart-ide-3568-running.md)
- Getting Started in CLI Mode
    - Setting Up the Development Environment
        - [Setting Up the Development Environment](quickstart-pkg-prepare.md)
        - [Installing Libraries and Tools](quickstart-pkg-install-package.md)
        - [Obtaining Source Code](quickstart-pkg-sourcecode.md)
        - [Installing the Compilation Tools](quickstart-pkg-install-tool.md)
    - Mini System (Based on the Hi3861 Development Board)
        - [Installing Tools Specially Required by the Hi3861 Development Board](quickstart-pkg-3861-tool.md)
        - [Writing a Hello World Program](quickstart-pkg-3861-helloworld.md)
        - [Building Source Code](quickstart-pkg-3861-build.md)
        - [Burning an Image](quickstart-pkg-3861-burn.md)
        - [Running an Image](quickstart-pkg-3861-running.md)
    - Small System (Based on the Hi3516 Development Board)
        - [Writing a Hello World Program](quickstart-pkg-3516-helloworld.md)
        - [Building Source Code](quickstart-pkg-3516-build.md)
        - [Burning an Image](quickstart-pkg-3516-burn.md)
        - [Running an Image](quickstart-pkg-3516-running.md)
    - Standard System (Based on the RK3568 Development Board)
        - [Writing a Hello World Program](quickstart-pkg-3568-helloworld.md)
        - [Building Source Code](quickstart-pkg-3568-build.md)
        - [Burning an Image](quickstart-pkg-3568-burn.md)
        - [Running an Image](quickstart-pkg-3568-running.md)
    - Miscellaneous
        - [Configuring the Proxy](quickstart-pkg-common-proxy.md)
        - [Building Source Code Using the build.sh Script](quickstart-pkg-common-build.md)
        - [Fixing hb Installation Errors](quickstart-pkg-common-hberr.md)
        - [Fixing Compilation and Building Errors](quickstart-pkg-common-builderr.md)
        - [Fixing Image Burning Errors](quickstart-pkg-common-burnerr.md)
- Appendix
    - [Hi3516 Development Board](quickstart-appendix-hi3516.md)
    - [Hi3861 Development Board](quickstart-appendix-hi3861.md)
    - [RK3568 Development Board](quickstart-appendix-rk3568.md)
    - [Build Form Factors](quickstart-appendix-compiledform.md)
    - [Getting Started with the Standard System with Hi3516 (IDE Mode)](quickstart-appendix-hi3516-ide.md)
    - [Getting Started with the Standard System with Hi3516 (CLI Mode)](quickstart-appendix-hi3516-pkg.md)
