# writeproc


## Command Function

This command is used to write data to the specified proc file system. The proc file system supports data of strings. The method for writing data needs to be implemented.


## Syntax

writeproc &lt;*data*&gt;  &gt;&gt;  /proc/&lt;*filename*&gt;


## Parameters

**Table 1** Parameter description

| Parameter    | Description                                                  |
| -------- | ---------------------------------------------------------- |
| data     | Specifies the string to write, which ends with a space. If you need to write a space, use **""** to enclose the space. |
| filename | Specifies the proc file to which **data** is to write.                               |


## Usage Guidelines

The proc file system implements its own **write()** function. Calling the **writeproc** command will pass input parameters to the **write()** function.

> **NOTE**<br>
> The procfs file system does not support multi-thread access.

## Note

Currently, the shell does not support this command.

## Example

Run **writeproc test >> /proc/uptime**.


## Output

```
OHOS \# writeproc test &gt;&gt; /proc/uptime

[INFO]write buf is: test

test &gt;&gt; /proc/uptime
```

> **NOTE**<br>
> The **uptime** proc file temporarily implements the **write()** function. The **INFO** log is generated by the **test()** function.

