# OpenHarmony Development Boards List

Currently, OpenHarmony supports 22 development board models, as listed in the table below.

## Standard-System Development Boards

| Board Model| Chip Model| Function Description and Use Case| Application Scenario| Code Repository and Daily Build|
| ---------- | -------- | -------- | ------------ | -------------------------------------- |
|HiHope HH-SCDAYU200| RK3568 |Function description:<br>Bolstered by the Rockchip RK3568, the HH-SCDAYU200 development board integrates the dual-core GPU and efficient NPU. Its quad-core 64-bit Cortex-A55 processor uses the advanced 22 nm fabrication process and is clocked at up to 2.0 GHz. The board is packed with Bluetooth, Wi-Fi, audio, video, and camera features, with a wide range of expansion ports to accommodate various video input and outputs. It comes with dual GE auto-sensing RJ45 ports, so it can be used in multi-connectivity products, such as network video recorders (NVRs) and industrial gateways.<br>Use case:<br>[DAYU200 Adaptation Case](porting/porting-dayu200-on_standard-demo.md)|Entertainment, easy travel, and smart home, such as kitchen hoods, ovens, and treadmills.|Code repositories:<br>[device_soc_rockchip](https://gitee.com/openharmony/device_soc_rockchip)<br>[device_board_hihope](https://gitee.com/openharmony/device_board_hihope)<br>[vendor_hihope](https://gitee.com/openharmony/vendor_hihope)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds |
|Hispark_Phoenix|Hi3751V351|Function description:<br>Hi3751 V351 is a main processor designed for FHD smart televisions, conforming to a wide range of global television standards. It supports NTSC/PAL/SECAM demodulation, DTMB/DVB-C/ATSC/ISDB-T demodulation, and DVB-T/T2/S/S2 extension. The SoC running AOSP has a built-in multi-core Arm Cortex-A53 CPU, multi-core Arm Mali-T450 GPU, and 1 GB DDR SDRAM. It can handle USB playback, video formats such as MPEG2, H.264, H.265, RMVB, and AVS+, as well as audio decoding and sound processing [including in-house super wide sound (SWS) processing]. It also supports CVBS/YPbPr/VGA/HDMI 1.4/USB inputs, LVDS/mini-LVDS interfaces, and mainstream TCONLESS panels.|Smart TVs, smart home central control screens, smart displays, commercial display advertising screens, interactive whiteboards, industrial control screens, printer screens, white good screens, and fitness device display screens.|Code repositories:<br>[device_soc_hisilicon](https://gitee.com/openharmony/device_soc_hisilicon)<br>[device_board_hisilicon](https://gitee.com/openharmony/device_board_hisilicon)<br>[vendor_hisilicon](https://gitee.com/openharmony/vendor_hisilicon)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds|
|Unionpi Tiger|Amlogic A311D|Function description:<br>Unionpi Tiger is a piece of intelligent hardware used in scenarios such as image processing, audio and video processing, and deep learning. Its main processor Amlogic A311D supports the GPU and neural network acceleration subsystem, 4K video codec engine, industry-leading HDR image processing, and all standards-based audio/video input/output interfaces. The CPU of the active system uses the big-core and small-core design with a clock speed of up to 2.2 GHz. It integrates four Cortex-A73 cores, two Cortex-A53 cores, and a standalone 5.0T NPU.|Smart home, AI facial recognition, industrial control, smart vehicle-mounted devices, multimedia processing, and AI edge computing.|Code repositories:<br>[device_soc_amlogic](https://gitee.com/openharmony/device_soc_amlogic)<br>[device_board_unionman](https://gitee.com/openharmony/device_board_unionman)<br>[vendor_unionman](https://gitee.com/openharmony/vendor_unionman)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds|
|MILOS_Standard0|NXP i.MX8M Mini|Function description:<br>MILOS_Standard0 is powered by the NXP i.MX8M Mini processor and clocked at up to 1.8 GHz. It integrates a wide range of peripheral input and output ports, including LVDS, MIPI-DSI output, and MIPI-CSI camera ports, as well as GE, multi-channel USB, and multi-serial communications ports.|High-performance instruments and meters (industry and medical care), industrial control and human-machine interaction devices, intelligent transportation, smart fire fighting, and smart buildings.|Code repositories:<br>[device_soc_nxp](https://gitee.com/openharmony/device_soc_nxp)<br>[device_board_osware](https://gitee.com/openharmony/device_board_osware)<br>[vendor_osware](https://gitee.com/openharmony/vendor_osware)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds|
|Yangfan development board|RK3399|Function description:<br>The Yangfan development board is built based on the RK3399 chip. The RK3399 CPU uses the big.LITTLE core architecture, with two Cortex-A72 big cores and four Cortex-A53 small cores. It provides significant improvements over its predecessor in terms of integers, floating point numbers, memory, overall performance, power consumption, and core area. The RK3399 GPU leverages the next-generation quad-core Arm Mali-T860 processor. The various bandwidth compression technologies (such as intelligent overlay, ASTC, and local pixel storage) and a wide array of graphics and computing interfaces make it more capable of complex graphics use cases.|Interactive advertising machines, interactive digital signage, intelligent self-service terminals, intelligent retail terminals, industrial control hosts, and robot devices.|Code repositories:<br>[device_soc_rockchip](https://gitee.com/openharmony/device_soc_rockchip)<br>[device_board_isoftstone](https://gitee.com/openharmony/device_board_isoftstone)<br>[vendor_isoftstone](https://gitee.com/openharmony/vendor_isoftstone)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds|
|ZLG development board|T507|Function description:<br>The ZLG development board is equipped with the Quanzhi industrial-grade T507 chip, which integrates the quad-core CortexTM A53 CPU, G31 MP2 GPU, multi-channel video outputs (RGB/2 x LVDS/HDMI/CVBS OUT), and multi-channel video inputs (MIPI CSI/BT.656/BT.1120). It allows for 4K@60 fps H.265 decoding, 4K@25 fps H.264 decoding, DI, and 3D noise reduction. All these features, combined with its automatic color tuning system and trapezoid correction module, contribute to a smooth user experience and professional visual effects.|Industrial control, smart cockpits, smart home, smart electricity, and online education.|Code repositories:<br>[device_soc_allwinner](https://gitee.com/openharmony/device_soc_allwinner)<br>[device_board_isoftstone](https://gitee.com/openharmony/device_board_isoftstone)<br>[vendor_isoftstone](https://gitee.com/openharmony/vendor_isoftstone)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds|
|Venus series smart TV khdvk_3566b development board|RK3566|Function description:<br>The khdvk_3566b development board comes with the Rockchip RK3566 Cortex-A55 quad-core processor. Thanks to a wide range of universal display ports and port types, it can be connected to a myriad of peripherals to meet the requirements of various man-machine interaction scenarios.|Tablets, learning machines, and facial recognition devices, including turnstiles, devices for facial recognition payment, industrial robots, medical devices, license plate recognition devices, advertising machines, digital signage, smart self-service terminals, and smart retail terminals.|Code repositories:<br>[device_soc_rockchip](https://gitee.com/openharmony/device_soc_rockchip)<br>[device_board_kaihong](https://gitee.com/openharmony/device_board_kaihong)<br>[vendor_kaihong](https://gitee.com/openharmony/vendor_kaihong)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds|

## Small-System Development Boards

| Board Model| Chip Model| Function Description and Use Case| Application Scenario| Code Repository and Daily Build|
| ---------- | -------- | -------- | ------------ | -------------------------------------- |
|Hispark_Taurus|Hi3516DV300|Function description:<br>Hi3516DV300 is the next-generation system on chip (SoC) for smart HD IP cameras. It integrates the next-generation image signal processor (ISP), H.265 video compression encoder, and high-performance NNIE engine, and delivers high performance in terms of low bit rate, high image quality, intelligent processing and analysis, and low power consumption.|Smart devices with screens, such as refrigerators with screens and head units.|Code repositories:<br>[device_soc_hisilicon](https://gitee.com/openharmony/device_soc_hisilicon)<br>[device_board_hisilicon](https://gitee.com/openharmony/device_board_hisilicon)<br>[vendor_hisilicon](https://gitee.com/openharmony/vendor_hisilicon)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds|
|BearPi-HM Micro|STM32MP157A|Function description:<br>The BearPi-HM Micro development board is equipped with the STM32MP157 chip, works with a 4.3-inch LCD capacitive touchscreen, and comes with Wi-Fi circuits and standards-based E53 interfaces. The E53 interfaces can be used to connect to smart humidifiers, smart desk lamps, smart security facilities, and intelligent smoke detectors.<br>Use case:<br>[BearPi-HM Mircro Adaptation Case](porting/porting-stm32mp15xx-on-smallsystem.md)|Smart home, smart hardware, and central control screens.|Code repositories:<br>[device_soc_st](https://gitee.com/openharmony/device_soc_st)<br>[device_board_bearpi](https://gitee.com/openharmony/device_board_bearpi)<br>[vendor_bearpi](https://gitee.com/openharmony/vendor_bearpi)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds |

## Mini-System Development Boards

| Board Model| Chip Model| Function Description and Use Case| Application Scenario| Code Repository and Daily Build|
| ---------- | -------- | -------- | ------------ | -------------------------------------- |
|BearPi-HM Nano|Hi3861|Function description:<br>The BearPi-HM_Nano development board is specially designed for OpenHarmony. It is equipped with the highly integrated 2.4 GHz WiFi SoC chip Hi3861, near field communication (NFC) circuits, and standard E53 interfaces, which can be used to connect to smart humidifiers, smart desk lamps, smart security facilities, and intelligent smoke detectors.|Connection devices like smart street lamps, smart logistics sensors, and human body infrared sensors.|Code repositories:<br>[device_soc_hisilicon](https://gitee.com/openharmony/device_soc_hisilicon)<br>[device_board_bearpi](https://gitee.com/openharmony/device_board_bearpi)<br>[vendor_bearpi](https://gitee.com/openharmony/vendor_bearpi)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds|
|Multi-modal V200Z-R|BES2600|Function description:<br>The multi-modal V200Z-R development board is a high-performance, multi-functional, and cost-effective AIoT SoC powered by the BES2600WM chip of Bestechnic. It integrates a quad-core Arm processor with a frequency of up to 1 GHz as well as dual-mode Wi-Fi and dual-mode Bluetooth. The board supports the 802.11 a/b/g/n/ and BT/BLE 5.2 standards. It is able to accommodate RAM of up to 42 MB and flash memory of up to 32 MB, and supports the MIPI display serial interface (DSI) and camera serial interface (CSI). It is applicable to various AIoT multi-modal VUI and GUI interaction scenarios.<br>Use case:<br>[Multi-modal V200Z-R Adaptation Case](porting/porting-bes2600w-on-minisystem-display-demo.md)|Smart hardware, and smart devices with screens, such as speakers and watches.|Code repositories:<br>[device_soc_bestechnic](https://gitee.com/openharmony/device_soc_bestechnic)<br>[device_board_fnlink](https://gitee.com/openharmony/device_board_fnlink)<br>[vendor_bestechnic](https://gitee.com/openharmony/vendor_bestechnic)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds |
|Langguo LANGO200|ASR582X|Function description:<br>The LANGO200 IoT development board integrates the high-performance WiFi-BLE dual-mode chip ASR5822, external storage chip, voice playing chip, and analog-to-digital converter. It supports common peripheral interfaces like SPI, and can be connected to an external OLED display and infrared remote control.<br>Use case:<br>[LANGO200 Adaptation Case](porting/porting-asr582x-combo-demo.md)|Connection modules for smart home products.|Code repositories:<br>[device_soc_asrmicro](https://gitee.com/openharmony/device_soc_asrmicro)<br>[device_board_lango](https://gitee.com/openharmony/device_board_lango)<br>[vendor_asrmicro](https://gitee.com/openharmony/vendor_asrmicro)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds |
|Goodix GR5515-STARTER-KIT|GR5515|Function description:<br>The GR5515-STARTER-KIT development board is a Bluetooth 5.1-capable single-mode Bluetooth low energy (BLE) SoC and comes with multifunctional keys and LED indicators.|Smart hardware, such as watches, wristbands, and price tags.|Code repositories:<br>[device_soc_goodix](https://gitee.com/openharmony/device_soc_goodix)<br>[device_board_goodix](https://gitee.com/openharmony/device_board_goodix)<br>[vendor_goodix](https://gitee.com/openharmony/vendor_goodix)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds|
|Niobe407|STM32F407IGT6|Function description:<br>The Niobe407 development board is powered by the STM32F407 chip, which integrates the Arm Cortex-M4 CPU with the FPU and adaptive real-time accelerator and is clocked at up to 168 MHz.<br>Use case:<br>[Niobe407 Adaptation Case](porting/porting-stm32f407-on-minisystem-eth.md)|Smart transportation and industrial control.|Code repositories:<br>[device_soc_st](https://gitee.com/openharmony/device_soc_st)<br>[device_board_talkweb](https://gitee.com/openharmony/device_board_talkweb)<br>[vendor_talkweb](https://gitee.com/openharmony/vendor_talkweb)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds |
|B91 Generic Starter Kit|TLSR9x|Function description:<br>The B91 Generic Starter Kit developed by Telink is a hardware platform that can be used to evaluate TLSR9 chipsets. You can leverage it to develop applications that comply with the 2.4 GHz interface standards, such as BLE, BLE Mesh, Zigbee 3.0, Thread, and 2.4 GHz proprietary protocols.|Connection modules for smart home products.|Code repositories:<br>[device_soc_telink](https://gitee.com/openharmony/device_soc_telink)<br>[device_board_telink](https://gitee.com/openharmony/device_board_telink)<br>[vendor_telink](https://gitee.com/openharmony/vendor_telink)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds|
|cst85_wblink|cst85f01|Function description:<br>The cst85_wblink development board is a high-performance, multi-functional, and cost-effective AIoT SoC development board developed by CHIPSEA based on the cst85f01 chip. The cst85_wblink development board integrates dual-band Wi-Fi and dual-mode Bluetooth and supports standard 802.11 a/b/g/n protocols and Bluetooth/BLE 5.0 protocols. It comes in multiple memory flavors, with up to 992 KB of RAM and up to 16 MB of flash memory. In addition, it supports MIPI DSI and CSI, which makes it a great choice for developing Wi-Fi and Bluetooth applications for IoT and smart devices.<br>Use case:<br>[cst85_wblink Adaptation Case](porting/porting-cst85f01-combo-demo.md)|IoT and smart home.|Code repositories:<br>[device_soc_chipsea](https://gitee.com/openharmony/device_soc_chipsea)<br>[device_board_chipsea](https://gitee.com/openharmony/device_board_chipsea)<br>[vendor_chipsea](https://gitee.com/openharmony/vendor_chipsea)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds |
|Neptune100| W800 |Function description:<br>Based on the WinnerMicro W800 chip, the Neptune 100 development board is a Wi-Fi & Bluetooth dual-mode SoC development board. It supports the standard 802.11 b/g/n protocols and has a complete built-in TCP/IP protocol stack. Its built-in Bluetooth baseband processor supports the Bluetooth/BLE4.2 protocols. It provides various digital interfaces, including the built-in QFlash, SPI, UART, GPIO, I2C, I2S and 7816 interfaces. The development board provides reliable security with support for a wide array of security features: hardware encryption and decryption algorithms, built-in DSP, floating-point arithmetic unit, security engine, code security permission configuration, built-in 2 MB flash memory, firmware encryption storage, firmware signature, secure debugging, and secure upgrade.<br>Use case:<br>[Neptune 100 Adaptation Case](porting/porting-w800-combo-demo.md)|IoT, smart home, and connection products.|Code repositories:<br>[device_soc_winnermicro](https://gitee.com/openharmony/device_soc_winnermicro)<br>[device_board_hihope](https://gitee.com/openharmony/device_board_hihope)<br>[vendor_hihope](https://gitee.com/openharmony/vendor_hihope)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds |
|RK2206| RK2206 |Function description:<br>The RK2206 development board uses the high-performance and cost-effective RK2206 chip as its main control board. It runs the OpenHarmony mini system and provides built-in Wi-Fi/AP and NFC features as well as LCD and E53 interfaces. The E53 interfaces are compatible with various sensor modules, facilitating diversified IoT applications. The RK2006 development board has been deployed in more than 20 mature use cases and demonstrated in comprehensive courseware.|Smart city, smart home, smart teaching, smart vehicle-mounted devices, and smart healthcare.|Code repositories:<br>[device_soc_rockchip](https://gitee.com/openharmony/device_soc_rockchip)<br>[device_board_lockzhiner](https://gitee.com/openharmony/device_board_lockzhiner)<br>[vendor_lockzhiner](https://gitee.com/openharmony/vendor-lockzhiner)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds |
|HPM6750EVK2 development board| HPM6700 |Function description:<br>The HPM6700/6400 series MCU is a high-performance real-time RISC-V microcontroller from Shanghai Xianji Semiconductor Technology Co., Ltd.. It provides high computing power, efficient control, and various multimedia functions for industrial automation and edge computing applications.|Industrial control and edge computing.|Code repositories:<br>[device_soc_hpmicro](https://gitee.com/openharmony/device_soc_hpmicro)<br>[device_board_hpmicro](https://gitee.com/openharmony/device_board_hpmicro)<br>[vendor_hpmicro](https://gitee.com/openharmony/vendor_hpmicro)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds |
|NiobeU4| ESP32U4WDH |Function description:<br>NiobeU4 is an IoT device development suite developed based on ESP32U4WDH. It integrates 2.4 GHz Wi-Fi and dual-mode Bluetooth and features ultra-high RF performance, stability, universality, reliability, and ultra-low power consumption. It works at 13.56 MHz and supports NFC contactless communication.|Contactless reader/writer applications that require low power consumption, voltage, and cost; lithium battery power supply and charge/discharge management; out-of-the-box intelligent hardware solution for developers to verify and develop their own software and functions.|Code repositories:<br>[device_soc_esp](https://gitee.com/openharmony/device_soc_esp)<br>[device_board_openvalley ](https://gitee.com/openharmony/device_board_openvalley)<br>[vendor_openvalley](https://gitee.com/openharmony/vendor_openvalley)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds |
|BK7235 development board| BK7235 |Function description:<br>BK7235 is a highly integrated Wi-Fi 6+BLE 5.2 combo SoC developed by Beken for IoT applications. It features diverse array of resources, powerful performance, and high security.|IoT, smart home, and connection products.|Code repositories:<br>[device_soc_beken](https://gitee.com/openharmony/device_soc_beken)<br>[device_board_beken](https://gitee.com/openharmony/device_board_beken)<br>[vendor_beken](https://gitee.com/openharmony/vendor_beken)<br>Daily build:<br>http://ci.openharmony.cn/dailys/dailybuilds |
