# ***ExampleName*** Development Board
*Template positioning: When a third-party development board is introduced to OpenHarmony, the board vendor needs to provide an introduction to the board for developers to quickly understand the board.*

## Introduction

*[Writing Instructions]*

*Describe the functions, scenarios, and key features supported by the development board.*

*Provide a picture to show the appearance of the development board.*

*Provide a bottom board picture.*

*Provide a functional block diagram and an introduction.*

*Name the figures after the development board.*

*Reference document: https://gitee.com/openharmony/docs/blob/master/en/device-dev/quick-start/quickstart-lite-introduction-hi3861.md*

********
## Development Board Specifications

*[Writing Instructions] Provide the module and hardware specifications of the development board.*

## (Optional) Constraints

*[Writing Instructions] Describe the restrictions and suggestions on functions, features, and specifications of the development board, if any.*

********


## Key Features
*[Writing Instructions] List supported key features of OpenHarmony.*

## Pin Definition
*[Writing Instruction] Describe the definitions of I/O pins, and how to configure pins and connect pins to external components.*  

## Setting Up the Development Environment

### System Requirements

*[Writing Instruction] Describe the dependency of the development board on the OpenHarmony system, software environment, and hardware environment.*

### Required Tools

*[Writing Instruction] Provide the paths for downloading the tools used to build and debug the development board.*

### Setup Process

*[Writing Instruction] Describe the procedure for setting up the environment step by step.*

## Building and Debugging

### Building

*[Writing Instruction] Describe how to use OpenHarmony and update OpenHarmony binary files and devices on the development board.*

### Burning

*[Writing Instruction] Describe how to burn images step by step.*

### Running

*[Writing Instruction] Describe how to check whether the lighting, running, and output of the development board are proper.*


### Debugging

*[Writing Instruction] Describe how to debug common errors on the development board.*

## First Demo

*[Writing Instruction] Provide a quick start example and running effect based on the development board, or provide the link of the demo source code.*

## References

*[Writing Instruction] Provide links to the reference documents, samples, and FAQs.*

## (Optional) Acknowledgments

*[Writing Instruction] Provide acknowledgements to third-party contributors.*
