# Code Contribution

## Start Contributions

### Design Specifications

-   [OpenHarmony API Governance Charter](../design/OpenHarmony-API-governance.md)
-   [OpenHarmony Security Design Specifications](OpenHarmony-security-design-guide.md)
-   [OpenHarmony Build Specifications](https://gitee.com/openharmony/community/blob/master/sig/sig-buildsystem/sig-build-system.md)

### Coding Style

Develop, review, and test code following the OpenHarmony coding standards. Make sure code is written in the same style.

-   [C++ Coding Style Guide](OpenHarmony-cpp-coding-style-guide.md)
-   [C Coding Style Guide](OpenHarmony-c-coding-style-guide.md)
-   [JavaScript Coding Style Guide](OpenHarmony-JavaScript-coding-style-guide.md) 
-   [Python Coding Style Guide](https://pep8.org/)
-   [C&C++ Secure Coding Guide](OpenHarmony-c-cpp-secure-coding-guide.md)
-   [Java Secure Coding Guide](OpenHarmony-Java-secure-coding-guide.md)
-   [32- and 64-Bit Portability Coding Guide](OpenHarmony-64bits-coding-guide.md)
-   [HDF Driver Coding Guide](OpenHarmony-hdf-coding-guide.md)
-   [Logging Guide](OpenHarmony-Log-guide.md)

### Introducing Open-source Software 

For details, see [Introducing Open-Source Software](introducing-open-source-software.md).
### Test Guide

[OpenHarmony Secure Test Guide](OpenHarmony-security-test-guide.md)

## Contribution Workflow

For details, see [Contribution Process](contribution-process.md).

## Security Issue Disclosure

- [OpenHarmony Security Vulnerability Governance](https://gitee.com/openharmony/security/blob/master/en/security-process/README.md)

- [OpenHarmony Security and Disclosure Statement](https://gitee.com/openharmony/security/blob/master/en/security-process/security-disclosure.md)

   <!--no_check--> 


