# Application Development
- [Application Development Overview](application-dev-guide.md)
- Quick Start
  - Getting Started
    - [Before You Start](quick-start/start-overview.md)
    - [Getting Started with ArkTS in Stage Model](quick-start/start-with-ets-stage.md)
    - [Getting Started with ArkTS in FA Model](quick-start/start-with-ets-fa.md)
    - [Getting Started with JavaScript in FA Model](quick-start/start-with-js-fa.md)
  - Development Fundamentals
    - Application Package Fundamentals
      - [Application Package Overview](quick-start/application-package-overview.md)
      - Application Package Structure
        - [Application Package Structure in Stage Model](quick-start/application-package-structure-stage.md)
        - [Application Package Structure in FA Model](quick-start/application-package-structure-fa.md)
        - [HAR File Structure](quick-start/har-structure.md)
      - Multi-HAP Mechanism
        - [Multi-HAP Design Objectives](quick-start/multi-hap-objective.md)
        - [Multi-HAP Build View](quick-start/multi-hap-build-view.md)
        - [Multi-HAP Development, Debugging, Release, and Deployment Process](quick-start/multi-hap-release-deployment.md)
        - [Multi-HAP Usage Rules](quick-start/multi-hap-rules.md)
        - [Multi-HAP Operation Mechanism and Data Communication Modes](quick-start/multi-hap-principles.md)
      - [Application Installation and Uninstallation Process](quick-start/application-package-install-uninstall.md)
      - [Application Package Update Process](quick-start/application-package-update.md)
      - Quick Fix
        - [Quick Fix Overview](quick-start/quickfix-principles.md)
        - [CLI-based Quick Fix Development](quick-start/quickfix-debug.md)
    - Application Configuration Files in Stage Model
      - [Application Configuration File Overview (Stage Model)](quick-start/application-configuration-file-overview-stage.md)
      - [app.json5 Configuration File](quick-start/app-configuration-file.md)
      - [module.json5 Configuration File](quick-start/module-configuration-file.md)
    - Application Configuration Files in FA Model
      - [Application Configuration File Overview (FA Model)](quick-start/application-configuration-file-overview-fa.md)
      - [Internal Structure of the app Tag](quick-start/app-structure.md)
      - [Internal structure of deviceConfig Tag](quick-start/deviceconfig-structure.md)
      - [Internal Structure of the module Tag](quick-start/module-structure.md)
    - [Resource Categories and Access](quick-start/resource-categories-and-access.md)
    - Learning ArkTS
      - [Getting Started with ArkTS](quick-start/arkts-get-started.md)
      - ArkTS Syntax (Declarative UI)
        - [Basic UI Description](quick-start/arkts-basic-ui-description.md)
        - State Management
          - [Basic Concepts](quick-start/arkts-state-mgmt-concepts.md)
          - [State Management with Page-level Variables](quick-start/arkts-state-mgmt-page-level.md)
          - [State Management with Application-level Variables](quick-start/arkts-state-mgmt-application-level.md)
        - [Dynamic UI Element Building](quick-start/arkts-dynamic-ui-elememt-building.md)
        - [Rendering Control](quick-start/arkts-rendering-control.md)
        - [Restrictions and Extensions](quick-start/arkts-restrictions-and-extensions.md)
- Development
  - Application Models
    - Application Model Overview
      - [Elements of the Application Model](application-models/application-model-composition.md)
      - [Interpretation of the Application Model](application-models/application-model-description.md)
    - Stage Model Development
      - [Stage Model Development Overview](application-models/stage-model-development-overview.md)
      - Stage Mode Application Components
        - [Application- or Component-Level Configuration](application-models/application-component-configuration-stage.md)
        - UIAbility Component
          - [UIAbility Component Overview](application-models/uiability-overview.md)
          - [UIAbility Component Lifecycle](application-models/uiability-lifecycle.md)
          - [UIAbility Component Launch Type](application-models/uiability-launch-type.md)
          - [UIAbility Component Usage](application-models/uiability-usage.md)
          - [Data Synchronization Between UIAbility and UI](application-models/uiability-data-sync-with-ui.md)
          - [Intra-Device Interaction Between UIAbility Components](application-models/uiability-intra-device-interaction.md)
        - ExtensionAbility Component
          - [ExtensionAbility Component Overview](application-models/extensionability-overview.md)
          - [ServiceExtensionAbility](application-models/serviceextensionability.md)
          - [DataShareExtensionAbility (for System Applications Only)](application-models/datashareextensionability.md)
          - [FormExtensionAbility (Widget)](application-models/widget-development-stage.md)
          - [AccessibilityExtensionAbility](application-models/accessibilityextensionability.md)
          - [EnterpriseAdminExtensionAbility](application-models/enterprise-extensionAbility.md)
          - [InputMethodExtensionAbility](application-models/inputmethodextentionability.md)
          - [WindowExtensionAbility](application-models/windowextensionability.md)
        - [AbilityStage Component Container](application-models/abilitystage.md)
        - [Context](application-models/application-context-stage.md)
        - Want
          - [Want Overview](application-models/want-overview.md)
          - [Matching Rules of Explicit Want and Implicit Want](application-models/explicit-implicit-want-mappings.md)
          - [Common action and entities Values](application-models/actions-entities.md)
          - [Using Explicit Want to Start an Ability](application-models/ability-startup-with-explicit-want.md)
          - [Using Implicit Want to Open a Website](application-models/ability-startup-with-implicit-want.md)
          - [Using Want to Share Data Between Applications](application-models/data-share-via-want.md)
        - [Component Startup Rules](application-models/component-startup-rules.md)
        - Inter-Device Application Component Interaction (Continuation) 
          - [Continuation Overview](application-models/inter-device-interaction-hop-overview.md)
          - [Cross-Device Migration (for System Applications Only)](application-models/hop-cross-device-migration.md)
          - [Multi-device Collaboration (for System Applications Only)](application-models/hop-multi-device-collaboration.md)
      - IPC
        - [Process Model](application-models/process-model-stage.md)
        - Common Events
          - [Introduction to Common Events](application-models/common-event-overview.md)
          - Common Event Subscription
             - [Common Event Subscription Overview](application-models/common-event-subscription-overview.md)
             - [Subscribing to Common Events in Dynamic Mode](application-models/common-event-subscription.md)
             - [Subscribing to Common Events in Static Mode (for System Applications Only)](application-models/common-event-static-subscription.md)
             - [Unsubscribing from Common Events](application-models/common-event-unsubscription.md)
          - [Publishing Common Events](application-models/common-event-publish.md)
        - [Background Services](application-models/background-services.md)
      - Inter-Thread Communication
        - [Thread Model](application-models/thread-model-stage.md)
        - [Using Emitter for Inter-Thread Communication](application-models/itc-with-emitter.md)
        - [Using Worker for Inter-Thread Communication](application-models/itc-with-worker.md)
      - Mission Management
        - [Mission Management Scenarios](application-models/mission-management-overview.md)
        - [Mission Management and Launch Type](application-models/mission-management-launch-type.md)
        - [Page Stack and MissionList](application-models/page-mission-stack.md)
    - FA Model Development
      - [FA Model Development Overview](application-models/fa-model-development-overview.md)
      - FA Mode Application Components
        - [Application- or Component-Level Configuration](application-models/application-component-configuration-fa.md)
        - PageAbility Component Development
          - [PageAbility Component Overview](application-models/pageability-overview.md)
          - [PageAbility Component Configuration](application-models/pageability-configuration.md)
          - [PageAbility Lifecycle](application-models/pageability-lifecycle.md)
          - [PageAbility Launch Type](application-models/pageability-launch-type.md)
          - [Creating a PageAbility](application-models/create-pageability.md)
          - [Starting a Local PageAbility](application-models/start-local-pageability.md)
          - [Stopping a PageAbility](application-models/stop-pageability.md)
          - [Starting a Remote PageAbility (for System Applications Only)](application-models/start-remote-pageability.md)
          - [Starting a Specified Page](application-models/start-page.md)
          - [Window Properties](application-models/window-properties.md)
          - [Requesting Permissions](application-models/request-permissions.md)
          - [Redirection Rules](application-models/redirection-rules.md)
        - ServiceAbility Component Development
          - [ServiceAbility Component Overview](application-models/serviceability-overview.md)
          - [ServiceAbility Component Configuration](application-models/serviceability-configuration.md)
          - [ServiceAbility Lifecycle](application-models/serviceability-lifecycle.md)
          - [Creating a ServiceAbility](application-models/create-serviceability.md)
          - [Starting a ServiceAbility](application-models/start-serviceability.md)
          - [Connecting to a ServiceAbility](application-models/connect-serviceability.md)
        - DataAbility Component Development
          - [DataAbility Component Overview](application-models/dataability-overview.md)
          - [DataAbility Component Configuration](application-models/dataability-configuration.md)
          - [DataAbility Lifecycle](application-models/dataability-lifecycle.md)
          - [Creating a DataAbility](application-models/create-dataability.md)
          - [Starting a DataAbility](application-models/start-dataability.md)
          - [Accessing a DataAbility](application-models/access-dataability.md)
          - [DataAbility Permission Control](application-models/dataability-permission-control.md)
        - [Widget Development](application-models/widget-development-fa.md)
        - [Context](application-models/application-context-fa.md)
        - [Want](application-models/want-fa.md)
        - [Component Startup Rules](application-models/component-startup-rules-fa.md)
      - IPC
        - [Process Model](application-models/process-model-fa.md)
        - [Common Events](application-models/common-event-fa.md)
        - [Background Services](application-models/rpc.md)
      - Inter-Thread Communication
        - [Thread Model](application-models/thread-model-fa.md)
        - [Inter-Thread Communication](application-models/itc-fa-overview.md)
      - [Mission Management](application-models/mission-management-fa.md)
    - Development of Component Interaction Between the FA Model and Stage Model
      - [Component Interaction Between the FA Model and Stage Model](application-models/fa-stage-interaction-overview.md)
      - [Starting a UIAbility from the FA Model](application-models/start-uiability-from-fa.md)
      - [Connecting to a ServiceExtensionAbility from the FA Model](application-models/bind-serviceextensionability-from-fa.md)
      - [Accessing a DataShareExtensionAbility from the FA Model](application-models/access-datashareextensionability-from-fa.md)
      - [Starting a PageAbility from the Stage Model](application-models/start-pageability-from-stage.md)
      - [Connecting to a ServiceAbility from the Stage Model](application-models/bind-serviceability-from-stage.md)
    - Switching from the FA Model to the Stage Model
      - [Model Switching Overview](application-models/model-switch-overview.md)
      - Configuration File Switching
        - [Differences in Configuration Files](application-models/configuration-file-diff.md)
        - [Switching of app and deviceConfig](application-models/app-deviceconfig-switch.md)
        - [Switching of module](application-models/module-switch.md)
      - Component Switching
        - [PageAbility Switching](application-models/pageability-switch.md)
        - [ServiceAbility Switching](application-models/serviceability-switch.md)
        - [DataAbility Switching](application-models/dataability-switch.md)
      - [Widget Switching](application-models/widget-switch.md)
      - API Switching
        - [API Switching Overview](application-models/api-switch-overview.md)
        - [Context Switching](application-models/context-switch.md)
        - [featureAbility Switching](application-models/featureability-switch.md)
        - [particleAbility Switching](application-models/particleability-switch.md)
        - [LifecycleForm Switching](application-models/lifecycleform-switch.md)
        - [LifecycleApp Switching](application-models/lifecycleapp-switch.md)
        - [LifecycleService Switching](application-models/lifecycleservice-switch.md)
        - [LifecycleData Switching](application-models/lifecycledata-switch.md)
        - [DataAbilityHelper Switching](application-models/dataabilityhelper-switch.md)
        - [mediaLibrary Switching](application-models/medialibrary-switch.md)
        - [request Switching](application-models/request-switch.md)
        - [resourceManager Switching](application-models/resourcemanager-switch.md)
        - [window Switching](application-models/window-switch.md)
        - [Storage Switching](application-models/storage-switch.md)
  - UI Development
    - [ArkUI Overview](ui/arkui-overview.md)
    - ArkTS-based Declarative Development Paradigm
      - [Overview](ui/ui-ts-overview.md)
      - [Declarative UI Development Guidelines](ui/ui-ts-developing-intro.md)
      - Declarative UI Development Examples
        - [Creating a Simple Page](ui/ui-ts-creating-simple-page.md)
        - Building a Comprehensive Example
          - [Building a Food Data Model](ui/ui-ts-building-data-model.md)
          - [Building a Food Category List Layout](ui/ui-ts-building-category-list-layout.md)
          - [Building a Food Category Grid Layout](ui/ui-ts-building-category-grid-layout.md)
          - [Implementing Page Redirection and Data Transmission](ui/ui-ts-page-redirection-data-transmission.md)
        - Adding a  Splash Screen Animation
          - [Using the Drawing Feature](ui/ui-ts-drawing-feature.md)
          - [Using the Animation Feature](ui/ui-ts-animation-feature.md)
      - [Common Components](ui/ui-ts-components-intro.md)
      - Common Layout Development
        - Adaptive Layouts
          - [Linear Layout](ui/ui-ts-layout-linear.md)
          - [Statck Layout](ui/ui-ts-layout-stack.md)
          - [Flex Layout](ui/ui-ts-layout-flex.md)
          - [Grid Layout](ui/ui-ts-layout-grid.md)
        - Responsive Layouts
          - [Grid Layout](ui/ui-ts-layout-grid-container-new.md)
          - [Media Query](ui/ui-ts-layout-mediaquery.md)
      - [Custom Component Lifecycle Callbacks](ui/ui-ts-custom-component-lifecycle-callbacks.md)
      - [Web Component Development](ui/ui-ts-components-web.md)
      - [Recommendations for Improving Performance](ui/ui-ts-performance-improvement-recommendation.md)
    - UI Development with JavaScript-compatible Web-like Development Paradigm
      - [Overview](ui/ui-js-overview.md)
      - Framework
        - [File Organization](ui/js-framework-file.md)
        - ["js" Tag](ui/js-framework-js-tag.md)
        - [app.js](ui/js-framework-js-file.md)
        - Syntax
          - [HML](ui/js-framework-syntax-hml.md)
          - [CSS](ui/js-framework-syntax-css.md)
          - [JavaScript](ui/js-framework-syntax-js.md)
        - [Lifecycle](ui/js-framework-lifecycle.md)
        - [Resource Limitations and Access](ui/js-framework-resource-restriction.md)
        - [Multi-Language Capability](ui/js-framework-multiple-languages.md)
      - Building the UI
        - [Component Overview](ui/ui-js-building-ui-component.md)
        - Building the Layout
          - [Layout Description](ui/ui-js-building-ui-layout-intro.md)
          - [Adding Title and Paragraph Text](ui/ui-js-building-ui-layout-text.md)
          - [Adding an Image](ui/ui-js-building-ui-layout-image.md)
          - [Adding a Comment](ui/ui-js-building-ui-layout-comment.md)
          - [Adding a Container](ui/ui-js-building-ui-layout-external-container.md)
        - [Adding Interactions](ui/ui-js-building-ui-interactions.md)
        - [Developing Animations](ui/ui-js-building-ui-animation.md)
        - [Defining Gesture Events](ui/ui-js-building-ui-event.md)
        - [Defining Page Routes](ui/ui-js-building-ui-routes.md)
      - Common Component Development Guidelines
        - Container Components
          - [List Development](ui/ui-js-components-list.md)
          - [Dialog Development](ui/ui-js-components-dialog.md)
          - [Form Development](ui/ui-js-components-form.md)
          - [Stepper Development](ui/ui-js-components-stepper.md)
          - [Tabs Development](ui/ui-js-component-tabs.md)
          - [Swiper Development](ui/ui-js-components-swiper.md)
        - Basic Components
          - [Text Development](ui/ui-js-components-text.md)
          - [Input Development](ui/ui-js-components-input.md)
          - [Button Development](ui/ui-js-components-button.md)
          - [Picker Development](ui/ui-js-components-picker.md)
          - [Image Development](ui/ui-js-components-images.md)
          - [Image-animator Development](ui/ui-js-components-image-animator.md)
          - [Rating Development](ui/ui-js-components-rating.md)
          - [Slider Development](ui/ui-js-components-slider.md)
          - [Chart Development](ui/ui-js-components-chart.md)
          - [Switch Development](ui/ui-js-components-switch.md)
          - [Toolbar Development](ui/ui-js-components-toolbar.md)
          - [Menu Development](ui/ui-js-components-menu.md)
          - [Marquee Development](ui/ui-js-components-marquee.md)
          - [Qrcode Development](ui/ui-js-components-qrcode.md)
          - [Search Development](ui/ui-js-components-search.md)
        - Canvas Development
          - [Canvas](ui/ui-js-components-canvas.md)
          - [CanvasRenderingContext2D](ui/ui-js-components-canvasrenderingcontext2d.md)
          - [Path2D](ui/ui-js-components-path2d.md)
          - [OffscreenCanvas](ui/ui-js-components-offscreencanvas.md)
        - [Grid-container Development](ui/ui-js-components-grid.md)
        - Svg
          - [Basics](ui/ui-js-components-svg-overview.md)
          - [Graph Drawing](ui/ui-js-components-svg-graphics.md)
          - [Path Drawing](ui/ui-js-components-svg-path.md)
          - [Text Drawing](ui/ui-js-components-svg-text.md)
      - Animation Development Guidelines
        - CSS Animation
          - [Defining Attribute Style Animations](ui/ui-js-animate-attribute-style.md)
          - [Defining Animations with the transform Attribute](ui/ui-js-animate-transform.md)
          - [Defining Animations with the background-position Attribute](ui/ui-js-animate-background-position-style.md)
          - [Defining Animations for SVG Components](ui/ui-js-animate-svg.md)
        - JS Animation
          - [Component Animation](ui/ui-js-animate-component.md)
          - Interpolator Animation
            - [Animation Effect](ui/ui-js-animate-dynamic-effects.md)
            - [Animation Frame](ui/ui-js-animate-frame.md)
      - [Custom Components](ui/ui-js-custom-components.md)
  - Notification
    - [Notification Overview](notification/notification-overview.md)
    - [Notification Subscription (for System Applications Only)](notification/notification-subscription.md)
    - [Enabling Notification](notification/notification-enable.md)
    - Publishing a Notification
      - [Publishing a Basic Notification](notification/text-notification.md)
      - [Publishing a Progress Notification](notification/progress-bar-notification.md)
      - [Adding a WantAgent Object to a Notification](notification/notification-with-wantagent.md)
  - Window Manager
    - [Window Overview](windowmanager/window-overview.md)
    - [Application Window Development (Stage Mode)](windowmanager/application-window-stage.md)
    - [Application Window Development (FA Model)](windowmanager/application-window-fa.md)
    - [System Window Development (Stage Model Only)](windowmanager/system-window-stage.md)
  - WebGL
    - [WebGL Overview](webgl/webgl-overview.md)
    - [WebGL Development](webgl/webgl-guidelines.md)
  - Media
    - Audio and Video
      - [Audio Overview](media/audio-overview.md)
      - [Audio Rendering Development](media/audio-renderer.md)
      - [Audio Stream Management Development](media/audio-stream-manager.md)
      - [Audio Capture Development](media/audio-capturer.md)
      - [OpenSL ES Audio Playback Development](media/opensles-playback.md)
      - [OpenSL ES Audio Recording Development](media/opensles-capture.md)
      - [Audio Interruption Mode Development](media/audio-interruptmode.md)
      - [Volume Management Development](media/audio-volume-manager.md)
      - [Audio Routing and Device Management Development](media/audio-routing-manager.md)
      - [AVPlayer Development (Recommended)](media/avplayer-playback.md)
      - [AVRecorder Development (Recommended)](media/avrecorder.md)
      - [Audio Playback Development (To Be Deprecated Soon)](media/audio-playback.md)
      - [Audio Recording Development (To Be Deprecated Soon)](media/audio-recorder.md)
      - [Video Playback Development (To Be Deprecated Soon)](media/video-playback.md)
      - [Video Recording Development (To Be Deprecated Soon)](media/video-recorder.md)
    - AVSession
      - [AVSession Overview](media/avsession-overview.md)
      - [AVSession Development](media/avsession-guidelines.md)
    - Image
      - [Image Development](media/image.md)
    - Camera
      - [Camera Development](media/camera.md)
      - [Distributed Camera Development](media/remote-camera.md)
  - Security
    - Access Control
      - [Access Control Overview](security/accesstoken-overview.md)
      - [Access Control Development](security/accesstoken-guidelines.md)
      - [Permission Verification Guide](security/permission-verify-guidelines.md)
      - [Permission List](security/permission-list.md)
    - User Authentication
      - [User Authentication Overview](security/userauth-overview.md)
      - [User Authentication Development](security/userauth-guidelines.md)
    - Key Management
      - [HUKS Overview](security/huks-overview.md)
      - [HUKS Development](security/huks-guidelines.md)
    - Crypto Framework
      - [Crypto Framework Overview](security/cryptoFramework-overview.md)
      - [Crypto Framework Development](security/cryptoFramework-guidelines.md)
    - Certificate
      - [Certificate Overview](security/cert-overview.md)
      - [Certificate Development](security/cert-guidelines.md)
    - hapsigner
      - [hapsigner Overview](security/hapsigntool-overview.md)
      - [hapsigner Guide](security/hapsigntool-guidelines.md)
      - [HarmonyAppProvision Configuration File](security/app-provision-structure.md)
  - Connectivity
    - Network Management
      - [Network Management Overview](connectivity/net-mgmt-overview.md)
      - [HTTP Data Request](connectivity/http-request.md)
      - [WebSocket Connection](connectivity/websocket-connection.md)
      - [Socket Connection](connectivity/socket-connection.md)
      - [Network Sharing](connectivity/net-sharing.md)
    - IPC & RPC
      - [IPC & RPC Overview](connectivity/ipc-rpc-overview.md)
      - [IPC & RPC Development](connectivity/ipc-rpc-development-guideline.md)
      - [Subscribing to State Changes of a Remote Object](connectivity/subscribe-remote-state.md)
  - Telephony
    - [Telephony Service Overview](telephony/telephony-overview.md)
    - [Redirecting to the Dial Screen](telephony/jumping-to-the-dial-screen.md)
    - [Obtaining Current Cellular Network Signal Information](telephony/cellular-network-signal-info.md)
  - Data Management 
    - Distributed Data Service
      - [Distributed Data Service Overview](database/database-mdds-overview.md)
      - [Distributed Data Service Development](database/database-mdds-guidelines.md)
    - Relational Database
      - [RDB Overview](database/database-relational-overview.md)
      - [RDB Development](database/database-relational-guidelines.md)
    - Preferences
      - [Preferences Overview](database/database-preference-overview.md)
      - [Preferences Development](database/database-preference-guidelines.md)
    - Distributed Data Object
      - [Distributed Data Object Overview](database/database-distributedobject-overview.md)
      - [Distributed Data Object Development](database/database-distributedobject-guidelines.md)
    - Data Share
      - [DataShare Overview](database/database-datashare-overview.md)
      - [DataShare Development](database/database-datashare-guidelines.md)
  - File Management
    - MediaLibrary
      - [MediaLibrary Development Overview](file-management/medialibrary-overview.md)
      - [Media Asset Management](file-management/medialibrary-resource-guidelines.md)
      - [File Path Management](file-management/medialibrary-filepath-guidelines.md)
      - [Album Management](file-management/medialibrary-album-guidelines.md)
    - File Access Framework
      - [File Access Framework Overview](file-management/file-access-framework-overview.md)
    - [FilePicker Guide](file-management/filepicker-guidelines.md)
  - Task Management
    - Background Task Management
      - [Background Task Management Overview](task-management/background-task-overview.md)
      - [Transient Task Development](task-management/transient-task-dev-guide.md)
      - [Continuous Task Development](task-management/continuous-task-dev-guide.md)
      - [Work Scheduler Development](task-management/work-scheduler-dev-guide.md)
      - [WorkSchedulerExtensionAbility Development](task-management/workscheduler-extensionability.md)
      - [Efficiency Resource Request Development](task-management/efficiency-resources-apply-dev-guide.md)
    - Agent-Powered Reminder
      - [Agent-Powered Reminder Overview](task-management/reminder-agent-overview.md)
      - [Agent-Powered Reminder Development](task-management/reminder-agent-development.md)
  - Device
    - USB Service
      - [USB Service Overview](device/usb-overview.md)
      - [USB Service Development](device/usb-guidelines.md)
    - Location
      - [Location Development](device/location-guidelines.md)
    - Sensor
      - [Sensor Overview](device/sensor-overview.md)
      - [Sensor Development](device/sensor-guidelines.md)
    - Vibrator
      - [Vibrator Overview](device/vibrator-overview.md)
      - [Vibrator Development](device/vibrator-guidelines.md)
    - Multimodal Input
      - [Input Device Development](device/inputdevice-guidelines.md)
      - [Mouse Pointer Development](device/pointerstyle-guidelines.md)
    - Update Service
      - [Sample Server Overview](device/sample-server-overview.md)
      - [Sample Server Development](device/sample-server-guidelines.md)
    - Stationary
      - [stationary Development](device/stationary-guidelines.md)
  - Device Usage Statistics
    - [Device Usage Statistics Overview](device-usage-statistics/device-usage-statistics-overview.md)
    - [Device Usage Statistics Development](device-usage-statistics/device-usage-statistics-use-guide.md)
  - DFX
    - [Development of Application Event Logging](dfx/hiappevent-guidelines.md)
    - [Development of Performance Tracing](dfx/hitracemeter-guidelines.md)
    - [Development of Distributed Call Chain Tracing](dfx/hitracechain-guidelines.md)
    - Error Management
      - [Development of Error Manager](dfx/errormanager-guidelines.md)
      - [Development of Application Recovery](dfx/apprecovery-guidelines.md)
  - Internationalization
    - [Internationalization Overview](internationalization/international-overview.md)
    - [Internationalization Development (intl)](internationalization/intl-guidelines.md)
    - [Internationalization Development (i18n)](internationalization/i18n-guidelines.md)
  - Application Test
    - [arkXtest User Guide](application-test/arkxtest-guidelines.md)
    - [SmartPerf User Guide](application-test/smartperf-guidelines.md)
    - [wukong User Guide](application-test/wukong-guidelines.md)
  - [OpenHarmony IDL Specifications and User Guide](IDL/idl-guidelines.md)
  - Native APIs
    - [Using Native APIs in Application Projects](napi/napi-guidelines.md)
    - [Drawing Development](napi/drawing-guidelines.md)
    - [Raw File Development](napi/rawfile-guidelines.md)
    - [Native Window Development](napi/native-window-guidelines.md)
    - [Using MindSpore Lite for Model Inference](napi/mindspore-lite-guidelines.md)
    - [Connecting the Neural Network Runtime to an AI Inference Framework](napi/neural-network-runtime-guidelines.md)
- Tools
  - [DevEco Studio (OpenHarmony) User Guide](quick-start/deveco-studio-user-guide-for-openharmony.md)
  - Debugging Tools
    - [Ability Assistant](tools/aa-tool.md)
    - [Bundle Manager](tools/bm-tool.md)
    - Packing and Unpacking Tools
      - [Packing Tools](tools/packing-tool.md)
      - [Unpacking Tools](tools/unpacking-tool.md)
    - [Advanced Notification Manager](tools/cem-tool.md)
    - [Common Event Manager](tools/anm-tool.md)
- Hands-On Tutorials
  - [Samples](https://gitee.com/openharmony/applications_app_samples/blob/OpenHarmony-3.2-Release/README.md)
  - [Codelabs](https://gitee.com/openharmony/codelabs)
- API References
  - [SystemCapability](reference/syscap.md)
  - [SystemCapability List](reference/syscap-list.md)
  - Component Reference (ArkTS-based Declarative Development Paradigm)
    - [Component Overview](reference/arkui-ts/ts-components-summary.md)
    - Universal Component Information
      - Universal Events
        - [Click Event](reference/arkui-ts/ts-universal-events-click.md)
        - [Touch Event](reference/arkui-ts/ts-universal-events-touch.md)
        - [Show/Hide Event](reference/arkui-ts/ts-universal-events-show-hide.md)
        - [Drag/Drop Event](reference/arkui-ts/ts-universal-events-drag-drop.md)
        - [Key Event](reference/arkui-ts/ts-universal-events-key.md)
        - [Focus Event](reference/arkui-ts/ts-universal-focus-event.md)
        - [Mouse Event](reference/arkui-ts/ts-universal-mouse-key.md)
        - [Component Area Change Event](reference/arkui-ts/ts-universal-component-area-change-event.md)
        - [Visible Area Change Event](reference/arkui-ts/ts-universal-component-visible-area-change-event.md)
      - Universal Attributes
        - [Size](reference/arkui-ts/ts-universal-attributes-size.md)
        - [Location](reference/arkui-ts/ts-universal-attributes-location.md)
        - [Layout Constraints](reference/arkui-ts/ts-universal-attributes-layout-constraints.md)
        - [Flex Layout](reference/arkui-ts/ts-universal-attributes-flex-layout.md)
        - [Border](reference/arkui-ts/ts-universal-attributes-border.md)
        - [Border Image](reference/arkui-ts/ts-universal-attributes-border-image.md)
        - [Background](reference/arkui-ts/ts-universal-attributes-background.md)
        - [Opacity](reference/arkui-ts/ts-universal-attributes-opacity.md)
        - [Visibility](reference/arkui-ts/ts-universal-attributes-visibility.md)
        - [Enable/Disable](reference/arkui-ts/ts-universal-attributes-enable.md)
        - [Overlay](reference/arkui-ts/ts-universal-attributes-overlay.md)
        - [Z-order Control](reference/arkui-ts/ts-universal-attributes-z-order.md)
        - [Transformation](reference/arkui-ts/ts-universal-attributes-transformation.md)
        - [Image Effect Configuration](reference/arkui-ts/ts-universal-attributes-image-effect.md)
        - [Shape Clipping](reference/arkui-ts/ts-universal-attributes-sharp-clipping.md)
        - [Text Style](reference/arkui-ts/ts-universal-attributes-text-style.md)
        - [Grid](reference/arkui-ts/ts-universal-attributes-grid.md)
        - [Gradient Color](reference/arkui-ts/ts-universal-attributes-gradient-color.md)
        - [Popup Control](reference/arkui-ts/ts-universal-attributes-popup.md)
        - [Menu Control](reference/arkui-ts/ts-universal-attributes-menu.md)
        - [Click Control](reference/arkui-ts/ts-universal-attributes-click.md)
        - [Focus Control](reference/arkui-ts/ts-universal-attributes-focus.md)
        - [Hover Effect](reference/arkui-ts/ts-universal-attributes-hover-effect.md)
        - [Component ID](reference/arkui-ts/ts-universal-attributes-component-id.md)
        - [Touch Target](reference/arkui-ts/ts-universal-attributes-touch-target.md)
        - [Polymorphic Style](reference/arkui-ts/ts-universal-attributes-polymorphic-style.md)
        - [Hit Test Control](reference/arkui-ts/ts-universal-attributes-hit-test-behavior.md)
        - [Background Blur](reference/arkui-ts/ts-universal-attributes-backgroundBlurStyle.md)
        - [restoreId](reference/arkui-ts/ts-universal-attributes-restoreId.md)
      - Gesture Processing
        - [Gesture Binding Methods](reference/arkui-ts/ts-gesture-settings.md)
        - Basic Gestures
          - [TapGesture](reference/arkui-ts/ts-basic-gestures-tapgesture.md)
          - [LongPressGesture](reference/arkui-ts/ts-basic-gestures-longpressgesture.md)
          - [PanGesture](reference/arkui-ts/ts-basic-gestures-pangesture.md)
          - [PinchGesture](reference/arkui-ts/ts-basic-gestures-pinchgesture.md)
          - [RotationGesture](reference/arkui-ts/ts-basic-gestures-rotationgesture.md)
          - [SwipeGesture](reference/arkui-ts/ts-basic-gestures-swipegesture.md)
        - [Combined Gestures](reference/arkui-ts/ts-combined-gestures.md)
    - Basic Components
      - [Blank](reference/arkui-ts/ts-basic-components-blank.md)
      - [Button](reference/arkui-ts/ts-basic-components-button.md)
      - [Checkbox](reference/arkui-ts/ts-basic-components-checkbox.md)
      - [CheckboxGroup](reference/arkui-ts/ts-basic-components-checkboxgroup.md)
      - [DataPanel](reference/arkui-ts/ts-basic-components-datapanel.md)
      - [DatePicker](reference/arkui-ts/ts-basic-components-datepicker.md)
      - [Divider](reference/arkui-ts/ts-basic-components-divider.md)
      - [Formcomponent](reference/arkui-ts/ts-basic-components-formcomponent.md)
      - [Gauge](reference/arkui-ts/ts-basic-components-gauge.md)
      - [Image](reference/arkui-ts/ts-basic-components-image.md)
      - [ImageAnimator](reference/arkui-ts/ts-basic-components-imageanimator.md)
      - [LoadingProgress](reference/arkui-ts/ts-basic-components-loadingprogress.md)
      - [Marquee](reference/arkui-ts/ts-basic-components-marquee.md)
      - [Menu](reference/arkui-ts/ts-basic-components-menu.md)
      - [MenuItem](reference/arkui-ts/ts-basic-components-menuitem.md)
      - [MenuItemGroup](reference/arkui-ts/ts-basic-components-menuitemgroup.md)
      - [Navigation](reference/arkui-ts/ts-basic-components-navigation.md)
      - [NavRouter](reference/arkui-ts/ts-basic-components-navrouter.md)
      - [NavDestination](reference/arkui-ts/ts-basic-components-navdestination.md)
      - [PatternLock](reference/arkui-ts/ts-basic-components-patternlock.md)
      - [PluginComponent](reference/arkui-ts/ts-basic-components-plugincomponent.md)
      - [Progress](reference/arkui-ts/ts-basic-components-progress.md)
      - [QRCode](reference/arkui-ts/ts-basic-components-qrcode.md)
      - [Radio](reference/arkui-ts/ts-basic-components-radio.md)
      - [Rating](reference/arkui-ts/ts-basic-components-rating.md)
      - [RemoteWindow](reference/arkui-ts/ts-basic-components-remotewindow.md)
      - [RichText](reference/arkui-ts/ts-basic-components-richtext.md)
      - [ScrollBar](reference/arkui-ts/ts-basic-components-scrollbar.md)
      - [Search](reference/arkui-ts/ts-basic-components-search.md)
      - [Select](reference/arkui-ts/ts-basic-components-select.md)
      - [Slider](reference/arkui-ts/ts-basic-components-slider.md)
      - [Span](reference/arkui-ts/ts-basic-components-span.md)
      - [Stepper](reference/arkui-ts/ts-basic-components-stepper.md)
      - [StepperItem](reference/arkui-ts/ts-basic-components-stepperitem.md)
      - [Text](reference/arkui-ts/ts-basic-components-text.md)
      - [TextArea](reference/arkui-ts/ts-basic-components-textarea.md)
      - [TextClock](reference/arkui-ts/ts-basic-components-textclock.md)
      - [TextInput](reference/arkui-ts/ts-basic-components-textinput.md)
      - [TextPicker](reference/arkui-ts/ts-basic-components-textpicker.md)
      - [TextTimer](reference/arkui-ts/ts-basic-components-texttimer.md)
      - [TimePicker](reference/arkui-ts/ts-basic-components-timepicker.md)
      - [Toggle](reference/arkui-ts/ts-basic-components-toggle.md)
      - [Web](reference/arkui-ts/ts-basic-components-web.md)
      - [XComponent](reference/arkui-ts/ts-basic-components-xcomponent.md)
    - Container Components
      - [AbilityComponent](reference/arkui-ts/ts-container-ability-component.md)
      - [AlphabetIndexer](reference/arkui-ts/ts-container-alphabet-indexer.md)
      - [Badge](reference/arkui-ts/ts-container-badge.md)
      - [Column](reference/arkui-ts/ts-container-column.md)
      - [ColumnSplit](reference/arkui-ts/ts-container-columnsplit.md)
      - [Counter](reference/arkui-ts/ts-container-counter.md)
      - [Flex](reference/arkui-ts/ts-container-flex.md)
      - [FlowItem](reference/arkui-ts/ts-container-flowitem.md)
      - [GridCol](reference/arkui-ts/ts-container-gridcol.md)
      - [GridRow](reference/arkui-ts/ts-container-gridrow.md)
      - [Grid](reference/arkui-ts/ts-container-grid.md)
      - [GridItem](reference/arkui-ts/ts-container-griditem.md)
      - [List](reference/arkui-ts/ts-container-list.md)
      - [ListItem](reference/arkui-ts/ts-container-listitem.md)
      - [ListItemGroup](reference/arkui-ts/ts-container-listitemgroup.md)
      - [Navigator](reference/arkui-ts/ts-container-navigator.md)
      - [Panel](reference/arkui-ts/ts-container-panel.md)
      - [Refresh](reference/arkui-ts/ts-container-refresh.md)
      - [RelativeContainer](reference/arkui-ts/ts-container-relativecontainer.md)
      - [Row](reference/arkui-ts/ts-container-row.md)
      - [RowSplit](reference/arkui-ts/ts-container-rowsplit.md)
      - [Scroll](reference/arkui-ts/ts-container-scroll.md)
      - [SideBarContainer](reference/arkui-ts/ts-container-sidebarcontainer.md)
      - [Stack](reference/arkui-ts/ts-container-stack.md)
      - [Swiper](reference/arkui-ts/ts-container-swiper.md)
      - [Tabs](reference/arkui-ts/ts-container-tabs.md)
      - [TabContent](reference/arkui-ts/ts-container-tabcontent.md)
      - [WaterFlow](reference/arkui-ts/ts-container-waterflow.md)
    - Media Component
      - [Video](reference/arkui-ts/ts-media-components-video.md)
    - Drawing Components
      - [Circle](reference/arkui-ts/ts-drawing-components-circle.md)
      - [Ellipse](reference/arkui-ts/ts-drawing-components-ellipse.md)
      - [Line](reference/arkui-ts/ts-drawing-components-line.md)
      - [Polyline](reference/arkui-ts/ts-drawing-components-polyline.md)
      - [Polygon](reference/arkui-ts/ts-drawing-components-polygon.md)
      - [Path](reference/arkui-ts/ts-drawing-components-path.md)
      - [Rect](reference/arkui-ts/ts-drawing-components-rect.md)
      - [Shape](reference/arkui-ts/ts-drawing-components-shape.md)
    - Canvas Components
      - [Canvas](reference/arkui-ts/ts-components-canvas-canvas.md)
      - [CanvasRenderingContext2D](reference/arkui-ts/ts-canvasrenderingcontext2d.md)
      - [CanvasGradient](reference/arkui-ts/ts-components-canvas-canvasgradient.md)
      - [ImageBitmap](reference/arkui-ts/ts-components-canvas-imagebitmap.md)
      - [ImageData](reference/arkui-ts/ts-components-canvas-imagedata.md)
      - [OffscreenCanvasRenderingConxt2D](reference/arkui-ts/ts-offscreencanvasrenderingcontext2d.md)
      - [Path2D](reference/arkui-ts/ts-components-canvas-path2d.md)
      - [Lottie](reference/arkui-ts/ts-components-canvas-lottie.md)
    - Animation
      - [AnimatorProperty](reference/arkui-ts/ts-animatorproperty.md)
      - [Explicit Animation](reference/arkui-ts/ts-explicit-animation.md)
      - Transition Animation
        - [Page Transition](reference/arkui-ts/ts-page-transition-animation.md)
        - [Component Transition](reference/arkui-ts/ts-transition-animation-component.md)
        - [Transition of Shared Elements](reference/arkui-ts/ts-transition-animation-shared-elements.md)
      - [Motion Path Animation](reference/arkui-ts/ts-motion-path-animation.md)
    - Global UI Methods
      - Pop-up Window
        - [Alert Dialog Box](reference/arkui-ts/ts-methods-alert-dialog-box.md)
        - [Action Sheet](reference/arkui-ts/ts-methods-action-sheet.md)
        - [Custom Dialog Box](reference/arkui-ts/ts-methods-custom-dialog-box.md)
        - [Date Picker Dialog Box](reference/arkui-ts/ts-methods-datepicker-dialog.md)
        - [Time Picker Dialog Box](reference/arkui-ts/ts-methods-timepicker-dialog.md)
        - [Text Picker Dialog Box](reference/arkui-ts/ts-methods-textpicker-dialog.md)
      - [Menu](reference/arkui-ts/ts-methods-menu.md)
    - [State Management with Application-level Variables](reference/arkui-ts/ts-state-management.md)
    - [Pixel Units](reference/arkui-ts/ts-pixel-units.md)
    - [Built-in Enums](reference/arkui-ts/ts-appendix-enums.md)
    - [Types](reference/arkui-ts/ts-types.md)
    - Deprecated Components
      - [GridContainer](reference/arkui-ts/ts-container-gridcontainer.md)
  - Component Reference (JavaScript-compatible Web-like Development Paradigm)
    - Universal Component Information
      - [Universal Attributes](reference/arkui-js/js-components-common-attributes.md)
      - [Universal Styles](reference/arkui-js/js-components-common-styles.md)
      - [Universal Events](reference/arkui-js/js-components-common-events.md)
      - [Universal Methods](reference/arkui-js/js-components-common-methods.md)
      - [Animation Styles](reference/arkui-js/js-components-common-animation.md)
      - [Gradient Styles](reference/arkui-js/js-components-common-gradient.md)
      - [Transition Styles](reference/arkui-js/js-components-common-transition.md)
      - [Media Query](reference/arkui-js/js-components-common-mediaquery.md)
      - [Custom Font Styles](reference/arkui-js/js-components-common-customizing-font.md)
      - [Atomic Layout](reference/arkui-js/js-components-common-atomic-layout.md)
    - Container Component
      - [badge](reference/arkui-js/js-components-container-badge.md)
      - [dialog](reference/arkui-js/js-components-container-dialog.md)
      - [div](reference/arkui-js/js-components-container-div.md)
      - [form](reference/arkui-js/js-components-container-form.md)
      - [list](reference/arkui-js/js-components-container-list.md)
      - [list-item](reference/arkui-js/js-components-container-list-item.md)
      - [list-item-group](reference/arkui-js/js-components-container-list-item-group.md)
      - [panel](reference/arkui-js/js-components-container-panel.md)
      - [popup](reference/arkui-js/js-components-container-popup.md)
      - [refresh](reference/arkui-js/js-components-container-refresh.md)
      - [stack](reference/arkui-js/js-components-container-stack.md)
      - [stepper](reference/arkui-js/js-components-container-stepper.md)
      - [stepper-item](reference/arkui-js/js-components-container-stepper-item.md)
      - [swiper](reference/arkui-js/js-components-container-swiper.md)
      - [tabs](reference/arkui-js/js-components-container-tabs.md)
      - [tab-bar](reference/arkui-js/js-components-container-tab-bar.md)
      - [tab-content](reference/arkui-js/js-components-container-tab-content.md)
    - Basic Components
      - [button](reference/arkui-js/js-components-basic-button.md)
      - [chart](reference/arkui-js/js-components-basic-chart.md)
      - [divider](reference/arkui-js/js-components-basic-divider.md)
      - [image](reference/arkui-js/js-components-basic-image.md)
      - [image-animator](reference/arkui-js/js-components-basic-image-animator.md)
      - [input](reference/arkui-js/js-components-basic-input.md)
      - [label](reference/arkui-js/js-components-basic-label.md)
      - [marquee](reference/arkui-js/js-components-basic-marquee.md)
      - [menu](reference/arkui-js/js-components-basic-menu.md)
      - [option](reference/arkui-js/js-components-basic-option.md)
      - [picker](reference/arkui-js/js-components-basic-picker.md)
      - [picker-view](reference/arkui-js/js-components-basic-picker-view.md)
      - [piece](reference/arkui-js/js-components-basic-piece.md)
      - [progress](reference/arkui-js/js-components-basic-progress.md)
      - [qrcode](reference/arkui-js/js-components-basic-qrcode.md)
      - [rating](reference/arkui-js/js-components-basic-rating.md)
      - [richtext](reference/arkui-js/js-components-basic-richtext.md)
      - [search](reference/arkui-js/js-components-basic-search.md)
      - [select](reference/arkui-js/js-components-basic-select.md)
      - [slider](reference/arkui-js/js-components-basic-slider.md)
      - [span](reference/arkui-js/js-components-basic-span.md)
      - [switch](reference/arkui-js/js-components-basic-switch.md)
      - [text](reference/arkui-js/js-components-basic-text.md)
      - [textarea](reference/arkui-js/js-components-basic-textarea.md)
      - [toolbar](reference/arkui-js/js-components-basic-toolbar.md)
      - [toolbar-item](reference/arkui-js/js-components-basic-toolbar-item.md)
      - [toggle](reference/arkui-js/js-components-basic-toggle.md)
      - [web](reference/arkui-js/js-components-basic-web.md)
      - [xcomponent](reference/arkui-js/js-components-basic-xcomponent.md)
    - Media Components
      - [video](reference/arkui-js/js-components-media-video.md)
    - Canvas Components
      - [canvas](reference/arkui-js/js-components-canvas-canvas.md)
      - [CanvasRenderingContext2D](reference/arkui-js/js-components-canvas-canvasrenderingcontext2d.md)
      - [Image](reference/arkui-js/js-components-canvas-image.md)
      - [CanvasGradient](reference/arkui-js/js-components-canvas-canvasgradient.md)
      - [ImageData](reference/arkui-js/js-components-canvas-imagedata.md)
      - [Path2D](reference/arkui-js/js-components-canvas-path2d.md)
      - [ImageBitmap](reference/arkui-js/js-components-canvas-imagebitmap.md)
      - [OffscreenCanvas](reference/arkui-js/js-components-canvas-offscreencanvas.md)
      - [OffscreenCanvasRenderingContext2D](reference/arkui-js/js-offscreencanvasrenderingcontext2d.md)
    - Grid Components
      - [Basic Concepts](reference/arkui-js/js-components-grid-basic-concepts.md)
      - [grid-container](reference/arkui-js/js-components-grid-container.md)
      - [grid-row](reference/arkui-js/js-components-grid-row.md)
      - [grid-col](reference/arkui-js/js-components-grid-col.md)
    - SVG Components
      - [Universal Attributes](reference/arkui-js/js-components-svg-common-attributes.md)
      - [svg](reference/arkui-js/js-components-svg.md)
      - [rect](reference/arkui-js/js-components-svg-rect.md)
      - [circle](reference/arkui-js/js-components-svg-circle.md)
      - [ellipse](reference/arkui-js/js-components-svg-ellipse.md)
      - [path](reference/arkui-js/js-components-svg-path.md)
      - [line](reference/arkui-js/js-components-svg-line.md)
      - [polyline](reference/arkui-js/js-components-svg-polyline.md)
      - [polygon](reference/arkui-js/js-components-svg-polygon.md)
      - [text](reference/arkui-js/js-components-svg-text.md)
      - [tspan](reference/arkui-js/js-components-svg-tspan.md)
      - [textPath](reference/arkui-js/js-components-svg-textpath.md)
      - [animate](reference/arkui-js/js-components-svg-animate.md)
      - [animateMotion](reference/arkui-js/js-components-svg-animatemotion.md)
      - [animateTransform](reference/arkui-js/js-components-svg-animatetransform.md)
    - Custom Components
      - [Basic Usage](reference/arkui-js/js-components-custom-basic-usage.md)
      - [props](reference/arkui-js/js-components-custom-props.md)
      - [Style Inheritance](reference/arkui-js/js-components-custom-style.md)
      - [slot](reference/arkui-js/js-components-custom-slot.md)
      - [Lifecycle Definition](reference/arkui-js/js-components-custom-lifecycle.md)
    - [Dynamic Component Creation](reference/arkui-js/js-components-create-elements.md)
    - [Data Type Attributes](reference/arkui-js/js-appendix-types.md)
  - JS Service Widget UI Components
    - JS Service Widget UI Framework
      - [File Organization](reference/js-service-widget-ui/js-service-widget-file.md)
      - Syntax
        - [HML](reference/js-service-widget-ui/js-service-widget-syntax-hml.md)
        - [CSS](reference/js-service-widget-ui/js-service-widget-syntax-css.md)
      - [Multi-Language Capability](reference/js-service-widget-ui/js-service-widget-multiple-languages.md)
      - [Version Compatibility Adaptation](reference/js-service-widget-ui/js-service-widget-version-compatibility.md)
      - [Theme Configuration](reference/js-service-widget-ui/js-service-widget-theme.md)
    - Components
      - Universal
        - [Universal Attributes](reference/js-service-widget-ui/js-service-widget-common-attributes.md)
        - [Universal Styles](reference/js-service-widget-ui/js-service-widget-common-styles.md)
        - [Universal Events](reference/js-service-widget-ui/js-service-widget-common-events.md)
        - [Gradient Styles](reference/js-service-widget-ui/js-service-widget-common-gradient.md)
        - [Media Query](reference/js-service-widget-ui/js-service-widget-common-mediaquery.md)
        - [Custom Font Styles](reference/js-service-widget-ui/js-service-widget-common-customizing-font.md)
        - [Accessibility](reference/js-service-widget-ui/js-service-widget-common-accessibility.md)
        - [Atomic Layout](reference/js-service-widget-ui/js-service-widget-common-atomic-layout.md)
      - Container Components
        - [badge](reference/js-service-widget-ui/js-service-widget-container-badge.md)
        - [div](reference/js-service-widget-ui/js-service-widget-container-div.md)
        - [list](reference/js-service-widget-ui/js-service-widget-container-list.md)
        - [list-item](reference/js-service-widget-ui/js-service-widget-container-list-item.md)
        - [stack](reference/js-service-widget-ui/js-service-widget-container-stack.md)
        - [swiper](reference/js-service-widget-ui/js-service-widget-container-swiper.md)
      - Basic Components
        - [button](reference/js-service-widget-ui/js-service-widget-basic-button.md)
        - [calendar](reference/js-service-widget-ui/js-service-widget-basic-calendar.md)
        - [chart](reference/js-service-widget-ui/js-service-widget-basic-chart.md)
        - [clock](reference/js-service-widget-ui/js-service-widget-basic-clock.md)
        - [divider](reference/js-service-widget-ui/js-service-widget-basic-divider.md)
        - [image](reference/js-service-widget-ui/js-service-widget-basic-image.md)
        - [input](reference/js-service-widget-ui/js-service-widget-basic-input.md)
        - [progress](reference/js-service-widget-ui/js-service-widget-basic-progress.md)
        - [span](reference/js-service-widget-ui/js-service-widget-basic-span.md)
        - [text](reference/js-service-widget-ui/js-service-widget-basic-text.md)
    - [Custom Component Basic Usage](reference/js-service-widget-ui/js-service-widget-custom-basic-usage.md)
    - [Data Types](reference/js-service-widget-ui/js-service-widget-appendix-types.md)
  - JS and TS APIs
    - [API Reference Document Description](reference/apis/development-intro.md)
    - Ability Framework
      - Stage Model (Recommended)
        - [@ohos.app.ability.Ability (Ability Base Class)](reference/apis/js-apis-app-ability-ability.md)
        - [@ohos.app.ability.AbilityConstant (AbilityConstant)](reference/apis/js-apis-app-ability-abilityConstant.md)
        - [@ohos.app.ability.abilityLifecycleCallback (AbilityLifecycleCallback)](reference/apis/js-apis-app-ability-abilityLifecycleCallback.md)
        - [@ohos.app.ability.AbilityStage (AbilityStage)](reference/apis/js-apis-app-ability-abilityStage.md)
        - [@ohos.app.ability.common (Context)](reference/apis/js-apis-app-ability-common.md)
        - [@ohos.app.ability.contextConstant (ContextConstant)](reference/apis/js-apis-app-ability-contextConstant.md)
        - [@ohos.app.ability.EnvironmentCallback (EnvironmentCallback)](reference/apis/js-apis-app-ability-environmentCallback.md)
        - [@ohos.app.ability.ExtensionAbility (ExtensionAbility Base Class)](reference/apis/js-apis-app-ability-extensionAbility.md)
        - [@ohos.app.ability.ServiceExtensionAbility (ServiceExtensionAbility)](reference/apis/js-apis-app-ability-serviceExtensionAbility.md)
        - [@ohos.app.ability.StartOptions (StartOptions)](reference/apis/js-apis-app-ability-startOptions.md)
        - [@ohos.app.ability.UIAbility (UIAbility)](reference/apis/js-apis-app-ability-uiAbility.md)
        - [@ohos.app.form.FormExtensionAbility (FormExtensionAbility)](reference/apis/js-apis-app-form-formExtensionAbility.md)
        - [@ohos.application.DataShareExtensionAbility (DataShare Extension Ability)](reference/apis/js-apis-application-dataShareExtensionAbility.md)
        - [@ohos.application.StaticSubscriberExtensionAbility (StaticSubscriberExtensionAbility)](reference/apis/js-apis-application-staticSubscriberExtensionAbility.md)
      - FA Model
        - [@ohos.ability.ability (Ability)](reference/apis/js-apis-ability-ability.md)
        - [@ohos.ability.featureAbility (FeatureAbility)](reference/apis/js-apis-ability-featureAbility.md)
        - [@ohos.ability.particleAbility (ParticleAbility)](reference/apis/js-apis-ability-particleAbility.md)
      - Both Models (Recommended)
        - [@ohos.app.ability.abilityDelegatorRegistry (AbilityDelegatorRegistry)](reference/apis/js-apis-app-ability-abilityDelegatorRegistry.md)
        - [@ohos.app.ability.abilityManager (AbilityManager)](reference/apis/js-apis-app-ability-abilityManager.md)
        - [@ohos.app.ability.appManager (appManager)](reference/apis/js-apis-app-ability-appManager.md)
        - [@ohos.app.ability.appRecovery (appRecovery)](reference/apis/js-apis-app-ability-appRecovery.md)
        - [@ohos.app.ability.Configuration (Configuration)](reference/apis/js-apis-app-ability-configuration.md)
        - [@ohos.app.ability.ConfigurationConstant (ConfigurationConstant)](reference/apis/js-apis-app-ability-configurationConstant.md)
        - [@ohos.app.ability.dataUriUtils (DataUriUtils)](reference/apis/js-apis-app-ability-dataUriUtils.md)
        - [@ohos.app.ability.dialogRequest (dialogRequest)](reference/apis/js-apis-app-ability-dialogRequest.md)
        - [@ohos.app.ability.errorManager (ErrorManager)](reference/apis/js-apis-app-ability-errorManager.md)
        - [@ohos.app.ability.missionManager (missionManager)](reference/apis/js-apis-app-ability-missionManager.md)
        - [@ohos.app.ability.quickFixManager (quickFixManager)](reference/apis/js-apis-app-ability-quickFixManager.md)
        - [@ohos.app.ability.Want (Want)](reference/apis/js-apis-app-ability-want.md)
        - [@ohos.app.ability.wantAgent (WantAgent)](reference/apis/js-apis-app-ability-wantAgent.md)
        - [@ohos.app.ability.wantConstant (wantConstant)](reference/apis/js-apis-app-ability-wantConstant.md)
        - [@ohos.app.form.formBindingData (formBindingData)](reference/apis/js-apis-app-form-formBindingData.md)
        - [@ohos.app.form.formHost (FormHost)](reference/apis/js-apis-app-form-formHost.md)
        - [@ohos.app.form.formInfo (FormInfo)](reference/apis/js-apis-app-form-formInfo.md)
        - [@ohos.app.form.formProvider (FormProvider)](reference/apis/js-apis-app-form-formProvider.md)
      - Both Models (To Be Deprecated Soon)
        - [@ohos.ability.dataUriUtils (DataUriUtils)](reference/apis/js-apis-ability-dataUriUtils.md)
        - [@ohos.ability.errorCode (ErrorCode)](reference/apis/js-apis-ability-errorCode.md)
        - [@ohos.ability.wantConstant (wantConstant)](reference/apis/js-apis-ability-wantConstant.md)
        - [@ohos.application.abilityDelegatorRegistry (AbilityDelegatorRegistry)](reference/apis/js-apis-application-abilityDelegatorRegistry.md)
        - [@ohos.application.abilityManager (AbilityManager)](reference/apis/js-apis-application-abilityManager.md)
        - [@ohos.application.appManager (appManager)](reference/apis/js-apis-application-appManager.md)
        - [@ohos.application.Configuration (Configuration)](reference/apis/js-apis-application-configuration.md)
        - [@ohos.application.ConfigurationConstant (ConfigurationConstant)](reference/apis/js-apis-application-configurationConstant.md)
        - [@ohos.application.formBindingData (formBindingData)](reference/apis/js-apis-application-formBindingData.md)
        - [@ohos.application.formError (FormError)](reference/apis/js-apis-application-formError.md)
        - [@ohos.application.formHost (FormHost)](reference/apis/js-apis-application-formHost.md)
        - [@ohos.application.formInfo (FormInfo)](reference/apis/js-apis-application-formInfo.md)
        - [@ohos.application.formProvider (FormProvider)](reference/apis/js-apis-application-formProvider.md)
        - [@ohos.application.missionManager (missionManager)](reference/apis/js-apis-application-missionManager.md)
        - [@ohos.application.Want (Want)](reference/apis/js-apis-application-want.md)
        - [@ohos.wantAgent (WantAgent)](reference/apis/js-apis-wantAgent.md)
      - Dependent Elements and Definitions
        - ability
          - [abilityResult](reference/apis/js-apis-inner-ability-abilityResult.md)
          - [connectOptions](reference/apis/js-apis-inner-ability-connectOptions.md)
          - [dataAbilityHelper](reference/apis/js-apis-inner-ability-dataAbilityHelper.md)
          - [dataAbilityOperation](reference/apis/js-apis-inner-ability-dataAbilityOperation.md)
          - [dataAbilityResult](reference/apis/js-apis-inner-ability-dataAbilityResult.md)
          - [startAbilityParameter](reference/apis/js-apis-inner-ability-startAbilityParameter.md)
          - [want](reference/apis/js-apis-inner-ability-want.md)
        - app
          - [appVersionInfo](reference/apis/js-apis-inner-app-appVersionInfo.md)
          - [context](reference/apis/js-apis-inner-app-context.md)
          - [processInfo](reference/apis/js-apis-inner-app-processInfo.md)
        - application
          - [abilityDelegator](reference/apis/js-apis-inner-application-abilityDelegator.md)
          - [abilityDelegatorArgs](reference/apis/js-apis-inner-application-abilityDelegatorArgs.md)
          - [abilityMonitor](reference/apis/js-apis-inner-application-abilityMonitor.md)
          - [AbilityRunningInfo](reference/apis/js-apis-inner-application-abilityRunningInfo.md)
          - [AbilityStageContext](reference/apis/js-apis-inner-application-abilityStageContext.md)
          - [AbilityStateData](reference/apis/js-apis-inner-application-abilityStateData.md)
          - [abilityStageMonitor](reference/apis/js-apis-inner-application-abilityStageMonitor.md)
          - [ApplicationContext](reference/apis/js-apis-inner-application-applicationContext.md)
          - [ApplicationStateObserver](reference/apis/js-apis-inner-application-applicationStateObserver.md)
          - [AppStateData](reference/apis/js-apis-inner-application-appStateData.md)
          - [BaseContext](reference/apis/js-apis-inner-application-baseContext.md)
          - [Context](reference/apis/js-apis-inner-application-context.md)
          - [ContinueCallback](reference/apis/js-apis-inner-application-continueCallback.md)
          - [ContinueDeviceInfo](reference/apis/js-apis-inner-application-continueDeviceInfo.md)
          - [ErrorObserver](reference/apis/js-apis-inner-application-errorObserver.md)
          - [ExtensionContext](reference/apis/js-apis-inner-application-extensionContext.md)
          - [ExtensionRunningInfo](reference/apis/js-apis-inner-application-extensionRunningInfo.md)
          - [FormExtensionContext](reference/apis/js-apis-inner-application-formExtensionContext.md)
          - [MissionCallbacks](reference/apis/js-apis-inner-application-missionCallbacks.md)
          - [MissionDeviceInfo](reference/apis/js-apis-inner-application-missionDeviceInfo.md)
          - [MissionInfo](reference/apis/js-apis-inner-application-missionInfo.md)
          - [MissionListener](reference/apis/js-apis-inner-application-missionListener.md)
          - [MissionParameter](reference/apis/js-apis-inner-application-missionParameter.md)
          - [MissionSnapshot](reference/apis/js-apis-inner-application-missionSnapshot.md)
          - [ProcessData](reference/apis/js-apis-inner-application-processData.md)
          - [ProcessRunningInfo](reference/apis/js-apis-inner-application-processRunningInfo.md)
          - [ProcessInformation](reference/apis/js-apis-inner-application-processInformation.md)
          - [ServiceExtensionContext](reference/apis/js-apis-inner-application-serviceExtensionContext.md)
          - [UIAbilityContext](reference/apis/js-apis-inner-application-uiAbilityContext.md)
          - [shellCmdResult](reference/apis/js-apis-inner-application-shellCmdResult.md)
          - [WindowExtensionContext](reference/apis/js-apis-inner-application-windowExtensionContext.md)
        - wantAgent
          - [triggerInfo](reference/apis/js-apis-inner-wantAgent-triggerInfo.md)
          - [wantAgentInfo](reference/apis/js-apis-inner-wantAgent-wantAgentInfo.md)
      - Continuation
        - [@ohos.continuation.continuationManager (continuationManager)](reference/apis/js-apis-continuation-continuationManager.md)
        - continuation
          - [continuationExtraParams](reference/apis/js-apis-continuation-continuationExtraParams.md)
          - [continuationResult](reference/apis/js-apis-continuation-continuationResult.md)
    - Common Event and Notification
      - [@ohos.commonEventManager (Common Event) (Recommended)](reference/apis/js-apis-commonEventManager.md)
      - [commonEvent-definitions (System Common Events) (Recommended)](reference/apis/commonEventManager-definitions.md)
      - [@ohos.events.emitter (Emitter)](reference/apis/js-apis-emitter.md)
      - [@ohos.notificationManager (NotificationManager) (Recommended)](reference/apis/js-apis-notificationManager.md)
      - [@ohos.notificationSubscribe (NotificationSubscribe) (Recommended)](reference/apis/js-apis-notificationSubscribe.md)
      - [@ohos.commonEvent (Common Event) (To Be Deprecated Soon)](reference/apis/js-apis-commonEvent.md)
      - [commonEvent-definitions (System Common Events) (To Be Deprecated Soon)](reference/apis/commonEvent-definitions.md)
      - [@ohos.notification (Notification) (To Be Deprecated Soon)](reference/apis/js-apis-notification.md)
      - application
        - [EventHub](reference/apis/js-apis-inner-application-eventHub.md)
      - commonEvent
        - [CommonEventData](reference/apis/js-apis-inner-commonEvent-commonEventData.md)
        - [CommonEventPublishData](reference/apis/js-apis-inner-commonEvent-commonEventPublishData.md)
        - [CommonEventSubscriber](reference/apis/js-apis-inner-commonEvent-commonEventSubscriber.md)
        - [CommonEventSubscribeInfo](reference/apis/js-apis-inner-commonEvent-commonEventSubscribeInfo.md)
      - notification
        - [NotificationActionButton](reference/apis/js-apis-inner-notification-notificationActionButton.md)
        - [NotificationCommonDef](reference/apis/js-apis-inner-notification-notificationCommonDef.md)
        - [NotificationContent](reference/apis/js-apis-inner-notification-notificationContent.md)
        - [NotificationFlags](reference/apis/js-apis-inner-notification-notificationFlags.md)
        - [NotificationRequest](reference/apis/js-apis-inner-notification-notificationRequest.md)
        - [NotificationSlot](reference/apis/js-apis-inner-notification-notificationSlot.md)
        - [NotificationTemplate](reference/apis/js-apis-inner-notification-notificationTemplate.md)
        - [NotificationUserInput](reference/apis/js-apis-inner-notification-notificationUserInput.md)
    - Bundle Management
      - [@ohos.bundle.appControl(appControl)](reference/apis/js-apis-appControl.md)
      - [@ohos.bundle.bundleManager (bundleManager)](reference/apis/js-apis-bundleManager.md)
      - [@ohos.bundle.bundleMonitor (bundleMonitor)](reference/apis/js-apis-bundleMonitor.md)
      - [@ohos.bundle.defaultAppManager (Default Application Management)](reference/apis/js-apis-defaultAppManager.md)
      - [@ohos.bundle.distributedBundle (distributedBundleManager)](reference/apis/js-apis-distributedBundleManager.md)
      - [@ohos.bundle.freeInstall (freeInstall)](reference/apis/js-apis-freeInstall.md)
      - [@ohos.bundle.installer (installer)](reference/apis/js-apis-installer.md)
      - [@ohos.bundle.launcherBundleManager (launcherBundleManager)](reference/apis/js-apis-launcherBundleManager.md)
      - [@ohos.zlib (Zip)](reference/apis/js-apis-zlib.md)
      - bundleManager
        - [abilityInfo](reference/apis/js-apis-bundleManager-abilityInfo.md)
        - [applicationInfo](reference/apis/js-apis-bundleManager-applicationInfo.md)
        - [bundleInfo](reference/apis/js-apis-bundleManager-bundleInfo.md)
        - [BundlePackInfo](reference/apis/js-apis-bundleManager-BundlePackInfo.md)
        - [dispatchInfo](reference/apis/js-apis-bundleManager-dispatchInfo.md)
        - [elementName](reference/apis/js-apis-bundleManager-elementName.md)
        - [extensionAbilityInfo](reference/apis/js-apis-bundleManager-extensionAbilityInfo.md)
        - [hapModuleInfo](reference/apis/js-apis-bundleManager-hapModuleInfo.md)
        - [launcherAbilityInfo](reference/apis/js-apis-bundleManager-launcherAbilityInfo.md)
        - [metadata](reference/apis/js-apis-bundleManager-metadata.md)
        - [permissionDef](reference/apis/js-apis-bundleManager-permissionDef.md)
        - [remoteAbilityInfo](reference/apis/js-apis-bundleManager-remoteAbilityInfo.md)
        - [shortcutInfo](reference/apis/js-apis-bundleManager-shortcutInfo.md)
    - UI Page
      - [@ohos.animator (Animator)](reference/apis/js-apis-animator.md)
      - [@ohos.curves (Interpolation Calculation)](reference/apis/js-apis-curve.md)
      - [@ohos.matrix4 (Matrix Transformation)](reference/apis/js-apis-matrix4.md)
      - [@ohos.mediaquery (Media Query)](reference/apis/js-apis-mediaquery.md)
      - [@ohos.pluginComponent (PluginComponentManager)](reference/apis/js-apis-plugincomponent.md)
      - [@ohos.promptAction (Prompt)](reference/apis/js-apis-promptAction.md)
      - [@ohos.router (Page Routing)](reference/apis/js-apis-router.md)
      - [@ohos.measure (Text Measurement)](reference/apis/js-apis-measure.md)
    - Graphics
      - [@ohos.animation.windowAnimationManager (Window Animation Management)](reference/apis/js-apis-windowAnimationManager.md)
      - [@ohos.application.WindowExtensionAbility (WindowExtensionAbility)](reference/apis/js-apis-application-windowExtensionAbility.md)
      - [@ohos.display (Display)](reference/apis/js-apis-display.md)
      - [@ohos.effectKit (Image Effects)](reference/apis/js-apis-effectKit.md)
      - [@ohos.graphics.colorSpaceManager (Color Space Management)](reference/apis/js-apis-colorSpaceManager.md)
      - [@ohos.screen (Screen)](reference/apis/js-apis-screen.md)
      - [@ohos.screenshot (Screenshot)](reference/apis/js-apis-screenshot.md)
      - [@ohos.window (Window)](reference/apis/js-apis-window.md)
      - webgl
        - [WebGL](reference/apis/js-apis-webgl.md)
        - [WebGL2](reference/apis/js-apis-webgl2.md)
    - Multimedia
      - [@ohos.multimedia.audio (Audio Management)](reference/apis/js-apis-audio.md)
      - [@ohos.multimedia.avsession (AVSession Management)](reference/apis/js-apis-avsession.md)
      - [@ohos.multimedia.camera (Camera Management)](reference/apis/js-apis-camera.md)
      - [@ohos.multimedia.image (Image Processing)](reference/apis/js-apis-image.md)
      - [@ohos.multimedia.media (Media)](reference/apis/js-apis-media.md)
    - Resource Manager
      - [@ohos.i18n (Internationalization)](reference/apis/js-apis-i18n.md)
      - [@ohos.intl (Internationalization)](reference/apis/js-apis-intl.md)
      - [@ohos.resourceManager (Resource Manager)](reference/apis/js-apis-resource-manager.md)
    - Background Task
      - [@ohos.distributedMissionManager (Distributed Mission Management)](reference/apis/js-apis-distributedMissionManager.md)
      - [@ohos.reminderAgentManager (Reminder Agent Management)](reference/apis/js-apis-reminderAgentManager.md)
      - [@ohos.resourceschedule.backgroundTaskManager (Background Task Management)](reference/apis/js-apis-resourceschedule-backgroundTaskManager.md)
      - [@ohos.resourceschedule.workScheduler (Work Scheduler)](reference/apis/js-apis-resourceschedule-workScheduler.md)
      - [@ohos.resourceschedule.usageStatistics (Device Usage Statistics)](reference/apis/js-apis-resourceschedule-deviceUsageStatistics.md)
      - [@ohos.WorkSchedulerExtensionAbility (Work Scheduler Callbacks)](reference/apis/js-apis-WorkSchedulerExtensionAbility.md)
    - Security
      - [@ohos.abilityAccessCtrl (Ability Access Control)](reference/apis/js-apis-abilityAccessCtrl.md)
      - [@ohos.privacyManager (Privacy Management)](reference/apis/js-apis-privacyManager.md)
      - [@ohos.security.cert (Certificate)](reference/apis/js-apis-cert.md)
      - [@ohos.security.cryptoFramework (Crypto Framework)](reference/apis/js-apis-cryptoFramework.md)
      - [@ohos.security.huks (HUKS)](reference/apis/js-apis-huks.md)
      - [@ohos.userIAM.faceAuth (Facial Authentication)](reference/apis/js-apis-useriam-faceauth.md)
      - [@ohos.userIAM.userAuth (User Authentication)](reference/apis/js-apis-useriam-userauth.md)
      - [@system.cipher (Cipher Algorithm)](reference/apis/js-apis-system-cipher.md)
      - security
        - [PermissionRequestResult](reference/apis/js-apis-permissionrequestresult.md)
    - Data Management
      - [@ohos.data.dataAbility (DataAbility Predicates)](reference/apis/js-apis-data-ability.md)
      - [@ohos.data.dataShare (DataShare)](reference/apis/js-apis-data-dataShare.md)
      - [@ohos.data.dataSharePredicates (DataShare Predicates)](reference/apis/js-apis-data-dataSharePredicates.md)
      - [@ohos.data.dataShareResultSet (DataShare Result Set)](reference/apis/js-apis-data-DataShareResultSet.md)
      - [@ohos.data.distributedDataObject (Distributed Data Object)](reference/apis/js-apis-data-distributedobject.md)
      - [@ohos.data.distributedKVStore (Distributed KV Store)](reference/apis/js-apis-distributedKVStore.md)
      - [@ohos.data.preferences (Preferences)](reference/apis/js-apis-data-preferences.md)
      - [@ohos.data.relationalStore (RDB Store)](reference/apis/js-apis-data-relationalStore.md)
      - [@ohos.data.ValuesBucket](reference/apis/js-apis-data-valuesBucket.md)
      - data/rdb
      - [resultSet (Result Set)](reference/apis/js-apis-data-resultset.md)
    - File Management
      - [@ohos.file.environment (Directory Environment Capability)](reference/apis/js-apis-file-environment.md)
      - [@ohos.file.fileAccess (User File Access and Management)](reference/apis/js-apis-fileAccess.md)
      - [@ohos.file.fileExtensionInfo (User File Extension Information)](reference/apis/js-apis-fileExtensionInfo.md)
      - [@ohos.file.fs (File Management)](reference/apis/js-apis-file-fs.md)
      - [@ohos.file.hash (File Hash Processing)](reference/apis/js-apis-file-hash.md)
      - [@ohos.file.picker (Picker)](reference/apis/js-apis-file-picker.md)
      - [@ohos.file.securityLabel (Data Label)](reference/apis/js-apis-file-securityLabel.md)
      - [@ohos.file.statvfs (File System Space Statistics)](reference/apis/js-apis-file-statvfs.md)
      - [@ohos.storageStatistics (Application Storage Statistics)](reference/apis/js-apis-file-storage-statistics.md)
      - [@ohos.volumeManager (Volume Management)](reference/apis/js-apis-file-volumemanager.md)
      - [@ohos.filemanagement.userFileManager (User Data Management)](reference/apis/js-apis-userFileManager.md)
    - Telephony Service
      - [@ohos.contact (Contacts)](reference/apis/js-apis-contact.md)
      - [@ohos.telephony.call (Call)](reference/apis/js-apis-call.md)
      - [@ohos.telephony.data (Cellular Data)](reference/apis/js-apis-telephony-data.md)
      - [@ohos.telephony.observer (Observer)](reference/apis/js-apis-observer.md)
      - [@ohos.telephony.radio (Network Search)](reference/apis/js-apis-radio.md)
      - [@ohos.telephony.sim (SIM Management)](reference/apis/js-apis-sim.md)
      - [@ohos.telephony.sms (SMS)](reference/apis/js-apis-sms.md)
    - Network Management
      - [@ohos.net.connection (Network Connection Management)](reference/apis/js-apis-net-connection.md)
      - [@ohos.net.ethernet (Ethernet Connection Management)](reference/apis/js-apis-net-ethernet.md)
      - [@ohos.net.http (Data Request)](reference/apis/js-apis-http.md)
      - [@ohos.net.policy (Network Policy Management)](reference/apis/js-apis-net-policy.md)
      - [@ohos.net.sharing (Network Sharing)](reference/apis/js-apis-net-sharing.md)
      - [@ohos.net.socket (Socket Connection)](reference/apis/js-apis-socket.md)
      - [@ohos.net.webSocket (WebSocket Connection)](reference/apis/js-apis-webSocket.md)
      - [@ohos.request (Upload and Download)](reference/apis/js-apis-request.md)
    - Connectivity
      - [@ohos.bluetoothManager (Bluetooth)](reference/apis/js-apis-bluetoothManager.md)
      - [@ohos.connectedTag (Active Tags)](reference/apis/js-apis-connectedTag.md)
      - [@ohos.nfc.cardEmulation (Standard NFC Card Emulation)](reference/apis/js-apis-cardEmulation.md)
      - [@ohos.nfc.controller (Standard NFC)](reference/apis/js-apis-nfcController.md)
      - [@ohos.nfc.tag (Standard NFC Tags)](reference/apis/js-apis-nfcTag.md)
      - [@ohos.rpc (RPC)](reference/apis/js-apis-rpc.md)
      - [@ohos.wifiManager (WLAN)](reference/apis/js-apis-wifiManager.md)
      - [@ohos.wifiManagerExt (WLAN Extension)](reference/apis/js-apis-wifiManagerExt.md)
      - [@ohos.wifi (To Be Deprecated Soon)](reference/apis/js-apis-wifi.md)
      - [@ohos.wifiext (To Be Deprecated Soon)](reference/apis/js-apis-wifiext.md)
      - tag
        - [nfctech (Standard NFC Technologies)](reference/apis/js-apis-nfctech.md)
        - [tagSession (Standard NFC Tag Session)](reference/apis/js-apis-tagSession.md)
    - Basic Features
      - [@ohos.accessibility (Accessibility)](reference/apis/js-apis-accessibility.md)
      - [@ohos.accessibility.config (System Accessibility Configuration)](reference/apis/js-apis-accessibility-config.md)
      - [@ohos.accessibility.GesturePath (Gesture Path)](reference/apis/js-apis-accessibility-GesturePath.md)
      - [@ohos.accessibility.GesturePoint (Gesture Point)](reference/apis/js-apis-accessibility-GesturePoint.md)
      - [@ohos.application.AccessibilityExtensionAbility (AccessibilityExtensionAbility)](reference/apis/js-apis-application-accessibilityExtensionAbility.md)
      - [@ohos.faultLogger (FaultLogger)](reference/apis/js-apis-faultLogger.md)
      - [@ohos.hichecker (HiChecker)](reference/apis/js-apis-hichecker.md)
      - [@ohos.hidebug (HiDebug)](reference/apis/js-apis-hidebug.md)
      - [@ohos.hilog (HiLog)](reference/apis/js-apis-hilog.md)
      - [@ohos.hiSysEvent (System Event Logging)](reference/apis/js-apis-hisysevent.md)
      - [@ohos.hiTraceChain (Distributed Call Chain Tracing)](reference/apis/js-apis-hitracechain.md)
      - [@ohos.hiTraceMeter (Performance Tracing)](reference/apis/js-apis-hitracemeter.md)
      - [@ohos.hiviewdfx.hiAppEvent (Application Event Logging)](reference/apis/js-apis-hiviewdfx-hiappevent.md)
      - [@ohos.inputMethod (Input Method Framework)](reference/apis/js-apis-inputmethod.md)
      - [@ohos.inputMethodEngine (Input Method Service)](reference/apis/js-apis-inputmethodengine.md)
      - [@ohos.InputMethodExtensionAbility (InputMethodExtensionAbility)](reference/apis/js-apis-inputmethod-extension-ability.md)
      - [@ohos.InputMethodExtensionContext (InputMethodExtensionContext)](reference/apis/js-apis-inputmethod-extension-context.md)
      - [@ohos.InputMethodSubtype (Input Method Subtype)](reference/apis/js-apis-inputmethod-subtype.md)
      - [@ohos.pasteboard (Pasteboard)](reference/apis/js-apis-pasteboard.md)
      - [@ohos.screenLock (Screenlock)](reference/apis/js-apis-screen-lock.md)
      - [@ohos.systemDateTime (System Time and Time Zone)](reference/apis/js-apis-system-date-time.md)
      - [@ohos.systemTimer (System Timer)](reference/apis/js-apis-system-timer.md)
      - [@ohos.wallpaper (Wallpaper)](reference/apis/js-apis-wallpaper.md)
      - [@ohos.web.webview (Webview)](reference/apis/js-apis-webview.md)
      - [console (Log)](reference/apis/js-apis-logs.md)
      - [Timer](reference/apis/js-apis-timer.md)
      - application
        - [AccessibilityExtensionContext](reference/apis/js-apis-inner-application-accessibilityExtensionContext.md)
    - Device Management
      - [@ohos.batteryInfo (Battery Information)](reference/apis/js-apis-battery-info.md)
      - [@ohos.batteryStatistics (Battery Statistics)](reference/apis/js-apis-batteryStatistics.md)
       - [@ohos.brightness (Screen Brightness)](reference/apis/js-apis-brightness.md)
       - [@ohos.deviceInfo (Device Information)](reference/apis/js-apis-device-info.md)
       - [@ohos.distributedHardware.deviceManager (Device Management)](reference/apis/js-apis-device-manager.md)
       - [@ohos.geoLocationManager (Geolocation Manager)](reference/apis/js-apis-geoLocationManager.md)
       - [@ohos.multimodalInput.inputConsumer (Input Consumer)](reference/apis/js-apis-inputconsumer.md)
       - [@ohos.multimodalInput.inputDevice (Input Device)](reference/apis/js-apis-inputdevice.md)
       - [@ohos.multimodalInput.inputDeviceCooperate (Screen Hopping)](reference/apis/js-apis-cooperate.md)
       - [@ohos.multimodalInput.inputEvent (Input Event)](reference/apis/js-apis-inputevent.md)
       - [@ohos.multimodalInput.inputEventClient (Key Event Injection)](reference/apis/js-apis-inputeventclient.md)
       - [@ohos.multimodalInput.inputMonitor (Input Monitor)](reference/apis/js-apis-inputmonitor.md)
       - [@ohos.multimodalInput.keyCode (Key Code)](reference/apis/js-apis-keycode.md)
       - [@ohos.multimodalInput.keyEvent (Key Event)](reference/apis/js-apis-keyevent.md)
       - [@ohos.multimodalInput.mouseEvent (Mouse Event)](reference/apis/js-apis-mouseevent.md)
       - [@ohos.multimodalInput.pointer (Mouse Pointer)](reference/apis/js-apis-pointer.md)
       - [@ohos.multimodalInput.touchEvent (Touch Event)](reference/apis/js-apis-touchevent.md)
       - [@ohos.power (System Power Management)](reference/apis/js-apis-power.md)
       - [@ohos.runningLock (Runninglock)](reference/apis/js-apis-runninglock.md)
       - [@ohos.sensor (Sensor)](reference/apis/js-apis-sensor.md)
       - [@ohos.settings (Data Item Settings)](reference/apis/js-apis-settings.md)
       - [@ohos.stationary (Device Status Awareness Framework)](reference/apis/js-apis-stationary.md)
       - [@ohos.systemCapability (SystemCapability)](reference/apis/js-apis-system-capability.md)
      - [@ohos.systemParameterEnhance (System Parameter)](reference/apis/js-apis-system-parameterEnhance.md)
       - [@ohos.thermal (Thermal Management)](reference/apis/js-apis-thermal.md)
       - [@ohos.update (Update)](reference/apis/js-apis-update.md)
      - [@ohos.usbManager (USB Management)](reference/apis/js-apis-usbManager.md)
       - [@ohos.vibrator (Vibrator)](reference/apis/js-apis-vibrator.md)
    - Account Management
      - [@ohos.account.appAccount (App Account Management)](reference/apis/js-apis-appAccount.md)
      - [@ohos.account.distributedAccount (Distributed Account Management)](reference/apis/js-apis-distributed-account.md)
      - [@ohos.account.osAccount (OS Account Management)](reference/apis/js-apis-osAccount.md)
    - Customization
      - [@ohos.configPolicy (Configuration Policy)](reference/apis/js-apis-configPolicy.md)
      - [@ohos.enterprise.EnterpriseAdminExtensionAbility (EnterpriseAdminExtensionAbility)](reference/apis/js-apis-EnterpriseAdminExtensionAbility.md)
      - [@ohos.enterprise.adminManager (Enterprise Device Management)](reference/apis/js-apis-enterprise-adminManager.md)
      - [@ohos.enterprise.dateTimeManager (System Time Management)](reference/apis/js-apis-enterprise-dateTimeManager.md)
    - Language Base Class Library
      - [@ohos.buffer (Buffer)](reference/apis/js-apis-buffer.md)
      - [@ohos.convertxml (XML-to-JavaScript Conversion)](reference/apis/js-apis-convertxml.md)
      - [@ohos.process (Obtaining Process Information)](reference/apis/js-apis-process.md)
      - [@ohos.taskpool (Using the Task Pool)](reference/apis/js-apis-taskpool.md)
      - [@ohos.uri (URI String Parsing)](reference/apis/js-apis-uri.md)
      - [@ohos.url (URL String Parsing)](reference/apis/js-apis-url.md)
      - [@ohos.util (util)](reference/apis/js-apis-util.md)
      - [@ohos.util.ArrayList (Linear Container ArrayList)](reference/apis/js-apis-arraylist.md)
      - [@ohos.util.Deque (Linear Container Deque)](reference/apis/js-apis-deque.md)
      - [@ohos.util.HashMap (Nonlinear Container HashMap)](reference/apis/js-apis-hashmap.md)
      - [@ohos.util.HashSet (Nonlinear Container HashSet)](reference/apis/js-apis-hashset.md)
      - [@ohos.util.LightWeightMap (Nonlinear Container LightWeightMap)](reference/apis/js-apis-lightweightmap.md)
      - [@ohos.util.LightWeightSet (Nonlinear Container LightWeightSet)](reference/apis/js-apis-lightweightset.md)
      - [@ohos.util.LinkedList (Linear Container LinkedList)](reference/apis/js-apis-linkedlist.md)
      - [@ohos.util.List (Linear Container List)](reference/apis/js-apis-list.md)
      - [@ohos.util.PlainArray (Nonlinear Container PlainArray)](reference/apis/js-apis-plainarray.md)
      - [@ohos.util.Queue (Linear Container Queue)](reference/apis/js-apis-queue.md)
      - [@ohos.util.Stack (Linear Container Stack)](reference/apis/js-apis-stack.md)
      - [@ohos.util.TreeMap (Nonlinear Container TreeMap)](reference/apis/js-apis-treemap.md)
      - [@ohos.util.TreeSet (Nonlinear Container TreeSet)](reference/apis/js-apis-treeset.md)
      - [@ohos.util.Vector (Linear Container Vector)](reference/apis/js-apis-vector.md)
      - [@ohos.worker (Worker Startup)](reference/apis/js-apis-worker.md)
      - [@ohos.xml (XML Parsing and Generation)](reference/apis/js-apis-xml.md)
    - Test
      - [@ohos.application.testRunner (TestRunner)](reference/apis/js-apis-application-testRunner.md)
      - [@ohos.uitest](reference/apis/js-apis-uitest.md)
    - APIs No Longer Maintained
      - [@ohos.backgroundTaskManager (Background Task Management)](reference/apis/js-apis-backgroundTaskManager.md)
      - [@ohos.bluetooth (Bluetooth)](reference/apis/js-apis-bluetooth.md)
      - [@ohos.bundle (Bundle)](reference/apis/js-apis-Bundle.md)
      - [@ohos.bundle.innerBundleManager (innerBundleManager)](reference/apis/js-apis-Bundle-InnerBundleManager.md)
      - [@ohos.bundleState (Device Usage Statistics)](reference/apis/js-apis-deviceUsageStatistics.md)
      - [@ohos.bytrace (Performance Tracing)](reference/apis/js-apis-bytrace.md)
      - [@ohos.data.distributedData (Distributed Data Management)](reference/apis/js-apis-distributed-data.md)
      - [@ohos.data.storage (Lightweight Data Storage)](reference/apis/js-apis-data-storage.md)
      - [@ohos.data.rdb (RDB)](reference/apis/js-apis-data-rdb.md)
      - [@ohos.distributedBundle (Distributed Bundle Management)](reference/apis/js-apis-Bundle-distributedBundle.md)
      - [@ohos.document (File Operation)](reference/apis/js-apis-document.md)
      - [@ohos.fileio (File Management)](reference/apis/js-apis-fileio.md)
      - [@ohos.geolocation (Geolocation)](reference/apis/js-apis-geolocation.md)
      - [@ohos.hiAppEvent (Application Event Logging)](reference/apis/js-apis-hiappevent.md)
      - [@ohos.prompt (Prompt)](reference/apis/js-apis-prompt.md)
      - [@ohos.reminderAgent (Reminder Agent)](reference/apis/js-apis-reminderAgent.md)
      - [@ohos.statfs (statfs)](reference/apis/js-apis-statfs.md)
      - [@ohos.systemParameter (System Parameter)](reference/apis/js-apis-system-parameter.md)
      - [@ohos.systemTime (System Time and Time Zone)](reference/apis/js-apis-system-time.md)
      - [@ohos.usb (USB Management)](reference/apis/js-apis-usb-deprecated.md)
      - [@ohos.usbV9 (USB Management)](reference/apis/js-apis-usb.md)
      - [@system.app (Application Context)](reference/apis/js-apis-system-app.md)
      - [@system.battery (Battery Information)](reference/apis/js-apis-system-battery.md)
      - [@system.bluetooth (Bluetooth)](reference/apis/js-apis-system-bluetooth.md)
      - [@system.brightness (Screen Brightness)](reference/apis/js-apis-system-brightness.md)
      - [@system.configuration (Application Configuration)](reference/apis/js-apis-system-configuration.md)
      - [@system.device (Device Information)](reference/apis/js-apis-system-device.md)
      - [@system.fetch (Data Request)](reference/apis/js-apis-system-fetch.md)
      - [@system.file (File Storage)](reference/apis/js-apis-system-file.md)
      - [@system.geolocation (Geographic Location)](reference/apis/js-apis-system-location.md)
      - [@ohos.multimedia.medialibrary (Media Library Management)](reference/apis/js-apis-medialibrary.md)
      - [@system.mediaquery (Media Query)](reference/apis/js-apis-system-mediaquery.md)
      - [@system.network (Network State)](reference/apis/js-apis-system-network.md)
      - [@system.notification (Notification)](reference/apis/js-apis-system-notification.md)
      - [@system.package (Bundle Management)](reference/apis/js-apis-system-package.md)
      - [@system.prompt (Prompt)](reference/apis/js-apis-system-prompt.md)
      - [@system.request (Upload and Download)](reference/apis/js-apis-system-request.md)
      - [@system.router (Page Routing)](reference/apis/js-apis-system-router.md)
      - [@system.sensor (Sensor)](reference/apis/js-apis-system-sensor.md)
      - [@system.storage (Data Storage)](reference/apis/js-apis-system-storage.md)
      - [@system.vibrator (Vibrator)](reference/apis/js-apis-system-vibrate.md)
      - bundle
        - [abilityInfo](reference/apis/js-apis-bundle-AbilityInfo.md)
        - [applicationInfo](reference/apis/js-apis-bundle-ApplicationInfo.md)
        - [bundleInfo](reference/apis/js-apis-bundle-BundleInfo.md)
        - [bundleInstaller](reference/apis/js-apis-bundle-BundleInstaller.md)
        - [bundleStatusCallback](reference/apis/js-apis-Bundle-BundleStatusCallback.md)
        - [customizeData](reference/apis/js-apis-bundle-CustomizeData.md)
        - [elementName](reference/apis/js-apis-bundle-ElementName.md)
        - [hapModuleInfo](reference/apis/js-apis-bundle-HapModuleInfo.md)
        - [launcherAbilityInfo](reference/apis/js-apis-bundle-LauncherAbilityInfo.md)
        - [moduleInfo](reference/apis/js-apis-bundle-ModuleInfo.md)
        - [PermissionDef](reference/apis/js-apis-bundle-PermissionDef.md)
        - [remoteAbilityInfo](reference/apis/js-apis-bundle-remoteAbilityInfo.md)
        - [shortcutInfo](reference/apis/js-apis-bundle-ShortcutInfo.md)
  - Error Codes
    - [Universal Error Codes](reference/errorcodes/errorcode-universal.md)
    - Ability Framework
      - [Ability Error Codes](reference/errorcodes/errorcode-ability.md)
      - [Distributed Scheduler Error Codes](reference/errorcodes/errorcode-DistributedSchedule.md)
      - [Form Error Codes](reference/errorcodes/errorcode-form.md)
    - Bundle Management
      - [Bundle Error Codes](reference/errorcodes/errorcode-bundle.md)
      - [zlib Error Codes](reference/errorcodes/errorcode-zlib.md)
    - Common Events and Notification
      - [Event Error Codes](reference/errorcodes/errorcode-CommonEventService.md)
      - [Notification Error Codes](reference/errorcodes/errorcode-notification.md)
      - [DistributedNotificationService Error Codes](reference/errorcodes/errorcode-DistributedNotificationService.md)
    - UI Page
      - [Animator Error Codes](reference/errorcodes/errorcode-animator.md)
      - [promptAction Error Codes](reference/errorcodes/errorcode-promptAction.md)
      - [Router Error Codes](reference/errorcodes/errorcode-router.md)
    - Graphics
      - [colorSpaceManager Error Codes](reference/errorcodes/errorcode-colorspace-manager.md)
      - [Display Error Codes](reference/errorcodes/errorcode-display.md)
      - [Window Error Codes](reference/errorcodes/errorcode-window.md)
    - Multimedia
      - [Audio Error Codes](reference/errorcodes/errorcode-audio.md)
      - [Media Error Codes](reference/errorcodes/errorcode-media.md)
      - [AVSession Management Error Codes](reference/errorcodes/errorcode-avsession.md)
    - Resource Manager
      - [I18N Error Codes](reference/errorcodes/errorcode-i18n.md)
      - [Resource Manager Error Codes](reference/errorcodes/errorcode-resource-manager.md)
    - Background Task
      - [backgroundTaskManager Error Codes](reference/errorcodes/errorcode-backgroundTaskMgr.md)
      - [DeviceUsageStatistics Error Codes](reference/errorcodes/errorcode-DeviceUsageStatistics.md)
      - [reminderAgentManager Error Codes](reference/errorcodes/errorcode-reminderAgentManager.md)
      - [workScheduler Error Codes](reference/errorcodes/errorcode-workScheduler.md)
    - Security
      - [Ability Access Control Error Codes](reference/errorcodes/errorcode-access-token.md)
      - [HUKS Error Codes](reference/errorcodes/errorcode-huks.md)
      - [Crypto Framework Error Codes](reference/errorcodes/errorcode-crypto-framework.md)
      - [Certificate Error Codes](reference/errorcodes/errorcode-cert.md)
      - [User Authentication Error Codes](reference/errorcodes/errorcode-useriam.md)
    - Data Management
      - [RDB Error Codes](reference/errorcodes/errorcode-data-rdb.md)
      - [DataShare Error Codes](reference/errorcodes/errorcode-datashare.md)
      - [Distributed Data Object Error Codes](reference/errorcodes/errorcode-distributed-dataObject.md)
      - [Distributed KV Store Error Codes](reference/errorcodes/errorcode-distributedKVStore.md)
      - [Preferences Error Codes](reference/errorcodes/errorcode-preferences.md)
    - File Management
      - [File Management Error Codes](reference/errorcodes/errorcode-filemanagement.md)
    - Telephony Service
      - [Telephony Error Codes](reference/errorcodes/errorcode-telephony.md)
    - Network Management
      - [Upload and Download Error Codes](reference/errorcodes/errorcode-request.md)
      - [HTTP Error Codes](reference/errorcodes/errorcode-net-http.md)
      - [Socket Error Codes](reference/errorcodes/errorcode-net-socket.md)
      - [Network Connection Management Error Codes](reference/errorcodes/errorcode-net-connection.md)
      - [Ethernet Connection Management Error Codes](reference/errorcodes/errorcode-net-ethernet.md)
      - [Network Sharing Error Codes](reference/errorcodes/errorcode-net-sharing.md)
      - [Network Policy Management Error Codes](reference/errorcodes/errorcode-net-policy.md)
    - Connectivity
      - [NFC Error Codes](reference/errorcodes/errorcode-nfc.md)
      - [RPC Error Codes](reference/errorcodes/errorcode-rpc.md)
      - [Bluetooth Error Codes](reference/errorcodes/errorcode-bluetoothManager.md)
    - Basic Features
      - [Accessibility Error Codes](reference/errorcodes/errorcode-accessibility.md)
      - [FaultLogger Error Codes](reference/errorcodes/errorcode-faultlogger.md)
      - [Application Event Logging Error Codes](reference/errorcodes/errorcode-hiappevent.md)
      - [HiSysEvent Error Codes](reference/errorcodes/errorcode-hisysevent.md)
      - [HiDebug Error Codes](reference/errorcodes/errorcode-hiviewdfx-hidebug.md)
      - [Input Method Framework Error Codes](reference/errorcodes/errorcode-inputmethod-framework.md)
      - [Pasteboard Error Codes](reference/errorcodes/errorcode-pasteboard.md)
      - [Time and Time Zone Service Error Codes](reference/errorcodes/errorcode-time.md)
      - [Webview Error Codes](reference/errorcodes/errorcode-webview.md)
    - Account Management
      - [Account Error Codes](reference/errorcodes/errorcode-account.md)
    - Device Management
      - [Power Consumption Statistics Error Codes](reference/errorcodes/errorcode-batteryStatistics.md)
      - [Brightness Error Codes](reference/errorcodes/errorcode-brightness.md)
      - [Power Manager Error Codes](reference/errorcodes/errorcode-power.md)
      - [Running Lock Error Codes](reference/errorcodes/errorcode-runninglock.md)
      - [Thermal Manager Error Codes](reference/errorcodes/errorcode-thermal.md)
      - [Device Management Error Codes](reference/errorcodes/errorcode-device-manager.md)
      - [Location Subsystem Error Codes](reference/errorcodes/errorcode-geoLocationManager.md)
      - [Screen Hopping Error Codes](reference/errorcodes/errorcode-multimodalinput.md)
      - [Sensor Error Codes](reference/errorcodes/errorcode-sensor.md)
      - [Vibrator Error Codes](reference/errorcodes/errorcode-vibrator.md)
      - [System Parameter Error Codes](reference/errorcodes/errorcode-system-parameterV9.md)
      - [USB Error Codes](reference/errorcodes/errorcode-usb.md)
      - [Update Error Codes](reference/errorcodes/errorcode-update.md)
    - Customization
      - [Enterprise Device Management Error Codes](reference/errorcodes/errorcode-enterpriseDeviceManager.md)
    - Language Base Class Library
      - [Utils Error Codes](reference/errorcodes/errorcode-utils.md)
    - Test
      - [UiTest Error Codes](reference/errorcodes/errorcode-uitest.md)
  - Native APIs
    - Standard Libraries Supported by Native APIs
      - [Node_API](reference/native-lib/third_party_napi/napi.md)
      - [libuv](reference/native-lib/third_party_libuv/libuv.md)
      - [Native Standard Libraries Supported by Openharmony](reference/native-lib/third_party_libc/musl.md)
      - Appendix
        - [Native API Symbols Not Exported](reference/native-lib/third_party_libc/musl-peculiar-symbol.md)
        - [EGL Symbols Exported from Native APIs](reference/native-lib/third_party_opengl/egl-symbol.md)
        - [OpenGL ES 3.0 Symbols Exported from Native APIs](reference/native-lib/third_party_opengl/openglesv3-symbol.md)  
- FAQs
  - [Full SDK Compilation Guide](quick-start/full-sdk-compile-guide.md)
  - [Guide to Switching to Full SDK](quick-start/full-sdk-switch-guide.md)
  - [Programming Languages](faqs/faqs-language.md)
  - [Ability Framework Development](faqs/faqs-ability.md)
  - [Bundle Management Development](faqs/faqs-bundle.md)
  - [ArkUI (ArkTS) Development](faqs/faqs-ui-ets.md)
  - [ArkUI Web Component (ArkTS) Development](faqs/faqs-web-arkts.md)
  - [ArkUI (JavaScript) Development](faqs/faqs-ui-js.md)
  - [Common Event and Notification Development](faqs/faqs-event-notification.md)
  - [Graphics and Image Development](faqs/faqs-graphics.md)
  - [File Management Development](faqs/faqs-file-management.md)
  - [Media Development](faqs/faqs-media.md)
  - [Network and Connection Development](faqs/faqs-connectivity.md)
  - [Device Management Development](faqs/faqs-data-management.md)
  - [Device Management Development](faqs/faqs-device-management.md)
  - [DFX Development](faqs/faqs-dfx.md)
  - [Intl Development](faqs/faqs-international.md)
  - [Native API Usage](faqs/faqs-native.md)
  - [Usage of Third- and Fourth-Party Libraries](faqs/faqs-third-party-library.md)
  - [IDE Usage](faqs/faqs-ide.md)
  - [Development Board](faqs/faqs-development-board.md)
