# UI Development

- [ArkUI Overview](arkui-overview.md)
- UI Development with ArkTS-based Declarative Development Paradigm
    - [Overview](ui-ts-overview.md)
    - [Declarative UI Development Guidelines](ui-ts-developing-intro.md)
    - Declarative UI Development Examples
      - [Creating a Simple Page](ui-ts-creating-simple-page.md)
      - Building a Comprehensive Example
        - [Building a Food Data Model](ui-ts-building-data-model.md)
        - [Building a Food Category List Layout](ui-ts-building-category-list-layout.md)
        - [Building a Food Category Grid Layout](ui-ts-building-category-grid-layout.md)
        - [Implementing Page Redirection and Data Transmission](ui-ts-page-redirection-data-transmission.md)    
      - Adding a  Splash Screen Animation
        - [Using the Drawing Feature](ui-ts-drawing-feature.md)
        - [Using the Animation Feature](ui-ts-animation-feature.md)
    - [Common Components](ui-ts-components-intro.md)
    - Common Layout Development
        - Adaptive Layouts
            - [Linear Layout](ui-ts-layout-linear.md)
            - [Statck Layout](ui-ts-layout-stack.md)
            - [Flex Layout](ui-ts-layout-flex.md)
            - [Grid Layout](ui-ts-layout-grid.md)
        - Responsive Layouts
            - [Grid Layout](ui-ts-layout-grid-container-new.md)
            - [Media Query](ui-ts-layout-mediaquery.md)
    - [Custom Component Lifecycle Callbacks](ui-ts-custom-component-lifecycle-callbacks.md)
    - [Web Component Development](ui-ts-components-web.md)
    - [Recommendations for Improving Performance](ui-ts-performance-improvement-recommendation.md)
- UI Development with JavaScript-compatible Web-like Development Paradigm
    - [Overview](ui-js-overview.md)
    - Framework Overview
        - [File Organization](js-framework-file.md)
        - ["js" Tag](js-framework-js-tag.md)
        - [app.js](js-framework-js-file.md)
        - Syntax
            - [HML](js-framework-syntax-hml.md)
            - [CSS](js-framework-syntax-css.md)
            - [JavaScript](js-framework-syntax-js.md)
        - [Lifecycle](js-framework-lifecycle.md)
        - [Resource Limitations and Access](js-framework-resource-restriction.md)
        - [Multi-Language Capability](js-framework-multiple-languages.md)
    - Building the UI
        - [Component Overview](ui-js-building-ui-component.md)
        - Building the Layout
            - [Layout Description](ui-js-building-ui-layout-intro.md)
            - [Adding Title and Paragraph Text](ui-js-building-ui-layout-text.md)
            - [Adding an Image](ui-js-building-ui-layout-image.md)
            - [Adding a Comment](ui-js-building-ui-layout-comment.md)
            - [Adding a Container](ui-js-building-ui-layout-external-container.md)
        - [Adding Interactions](ui-js-building-ui-interactions.md)
        - [Developing Animations](ui-js-building-ui-animation.md)
        - [Defining Gesture Events](ui-js-building-ui-event.md)
        - [Defining Page Routes](ui-js-building-ui-routes.md)
    - Common Component Development Guidelines
        - Container Component Development
            - [List Development](ui-js-components-list.md)
            - [Dialog Development](ui-js-components-dialog.md)
            - [Form Development](ui-js-components-form.md)
            - [Stepper Development](ui-js-components-stepper.md)
            - [Tabs Development](ui-js-component-tabs.md)
            - [Swiper Development](ui-js-components-swiper.md)
        - Basic Component Development
            - [Text Development](ui-js-components-text.md)
            - [Input Development](ui-js-components-input.md)
            - [Button Development](ui-js-components-button.md)
            - [Picker Development](ui-js-components-picker.md)
            - [Image Development](ui-js-components-images.md)
            - [Image-animator Development](ui-js-components-image-animator.md)
            - [Rating Development](ui-js-components-rating.md)
            - [Slider Development](ui-js-components-slider.md)
            - [Chart Development](ui-js-components-chart.md)
            - [Switch Development](ui-js-components-switch.md)
            - [Toolbar Development](ui-js-components-toolbar.md)
            - [Menu Development](ui-js-components-menu.md)
            - [Marquee Development](ui-js-components-marquee.md)
            - [Qrcode Development](ui-js-components-qrcode.md)
            - [Search Development](ui-js-components-search.md)
        - Canvas Development
            - [Canvas](ui-js-components-canvas.md)
            - [CanvasRenderingContext2D](ui-js-components-canvasrenderingcontext2d.md)
            - [Path2D](ui-js-components-path2d.md)
            - [OffscreenCanvas](ui-js-components-offscreencanvas.md)
        - [Grid Container Development](ui-js-components-grid.md)
        - SVG Development
            - [Basics](ui-js-components-svg-overview.md)
            - [Graph Drawing](ui-js-components-svg-graphics.md)
            - [Path Drawing](ui-js-components-svg-path.md)
            - [Text Drawing](ui-js-components-svg-text.md)
    - Animation Development Guidelines
        - CSS Animation
            - [Defining Attribute Style Animations](ui-js-animate-attribute-style.md)
            - [Defining Animations with the transform Attribute](ui-js-animate-transform.md)
            - [Defining Animations with the background-position Attribute](ui-js-animate-background-position-style.md)
            - [Defining Animations for SVG Components](ui-js-animate-svg.md)
        - JS Animation
            - [Component Animation](ui-js-animate-component.md)
            - Interpolator Animation
                - [Animation Effect](ui-js-animate-dynamic-effects.md)
                - [Animation Frame](ui-js-animate-frame.md)
    - [Custom Components](ui-js-custom-components.md)
