# SystemCapability List

SystemCapability (SysCap) is a standalone feature in the OpenHarmony system.

Before using an API for development, you are advised to familiarize yourself with [SysCap](syscap.md), and then consult the following tables to see whether the SysCap set required for the API is supported by the target device type.

## SystemCapability.ArkUI.ArkUI.Full

ArKUI standard system

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.ArkUI.ArkUI.Lite

ArkUI small system

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | Yes    | Yes    | Yes  | Yes  | Yes    | Yes          | No    |

## SystemCapability.ArkUI.ArkUI.Napi

NAPI functionality

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.ArkUI.ArkUI.Libuv

libuv functionality

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.ArkUI.UiAppearance

Appearance configuration

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BundleManager.BundleFramework

Bundle manager service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BundleManager.DistributedBundleFramework

Distributed scheduler

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BundleManager.BundleTool

Bundle manager CLI tool

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BundleManager.Zlib

zlib compression and decompression tool

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BundleManager.PackingTool

Packing and unpacking tools for bundle management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | Yes    | Yes    | Yes  | Yes  | Yes    | Yes          | No    |

## SystemCapability.Graphic.Graphic2D.WebGL

WebGL 1.0 API

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Graphic.Graphic2D.WebGL2

WebGL 2.0 API

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | No  | No  | No    | No          | No    |

## SystemCapability.WindowManager.WindowManager.Core

Window manager

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.WindowManager.WindowManager.MutiScreen

Multi-screen capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Notification.CommonEvent

Common event

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Notification.Notification

Notification

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Notification.ReminderAgent

reminderAgent

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Notification.Emitter

Event emitter service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Communication.IPC.Core

Inter-process communication (IPC)

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | Yes          | No    |

## SystemCapability.Communication.SoftBus.Core

DSoftBus

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | Yes    | Yes    | Yes  | Yes  | Yes    | Yes          | Yes    |

## SystemCapability.Communication.NetManager.Core

Basic network management services

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Communication.NetStack

Basic network stack capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Communication.WiFi.Core

Basic Wi-Fi capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Communication.WiFi.STA

Wi-Fi STA capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Communication.WiFi.AP.Core

Wi-Fi AP capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Communication.WiFi.AP.Extension

Wi-Fi AP extension capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | No    | No    | No  | No  | No    | No          | Yes    |

## SystemCapability.Communication.WiFi.P2P

Wi-Fi P2P capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Communication.Bluetooth.Core

Bluetooth service and protocol stack

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Communication.Bluetooth.Lite

Bluetooth lightweight service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | Yes    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Communication.NFC.Core

NFC

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | No    | No    | No  | No  | No    | No          | No    |

## SystemCapability.Communication.ConnectedTag

Active NFC tag service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | No    | No    | No  | No  | No    | No          | No    |

## SystemCapability.Location.Location.Core

Basic capabilities of the location service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | No    | No          | No    |

## SystemCapability.Location.Location.Geocoder

Geocoding capability
| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | No    | No          | No    |

## SystemCapability.Location.Location.Geofence

Geofencing capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | No    | No          | No    |

## SystemCapability.Location.Location.Gnss

GNSS hardware capabilities

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | No    | No          | No    |

## SystemCapability.Location.Location.Lite

Lite device capabilities of the location service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | Yes    | Yes    | Yes  | Yes  | No    | No          | No    |

## SystemCapability.MultimodalInput.Input.Core

Basic input capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.MultimodalInput.Input.InputDevice

Input device management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.MultimodalInput.Input.InputMonitor

Input event listener

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.MultimodalInput.Input.InputConsumer

Input event consumer

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.MultimodalInput.Input.InputSimulator

Input event simulator

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.PowerManager.BatteryManager.Extension

Battery manager extension capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | No    | No          | No    |

## SystemCapability.PowerManager.BatteryStatistics

Power consumption statistics

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | No    | No          | No    |

## SystemCapability.PowerManager.DisplayPowerManager

Power management display

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | Yes    | No          | No    |

## SystemCapability.PowerManager.ThermalManager

Temperature control

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.PowerManager.PowerManager.Core

Core capabilities of the system power management service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.PowerManager.PowerManager.Lite

Lite device capabilities of the system power management service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | Yes    | No    | No  | No  | No    | Yes          | Yes    |

## SystemCapability.PowerManager.BatteryManager.Core

Core capabilities of the battery service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | No    | No          | No    |

## SystemCapability.PowerManager.BatteryManager.Lite

Lite device capabilities of the battery service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | Yes    | No    | No  | No  | No    | Yes          | Yes    |

## SystemCapability.PowerManager.PowerManager.Extension

Extension capabilities of the system power management service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | Yes    | No          | No    |

## SystemCapability.Multimedia.Media.Core

Basic media capabilities

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Media.AudioPlayer

Audio player capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Media.AudioRecorder

Media audio recorder capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Media.VideoPlayer

Video player capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Media.VideoRecorder

Video recorder capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Media.CodecBase

Basic media codec capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Media.AudioDecoder

Media audio decoding capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Media.AudioEncoder

Media audio encoding capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Media.VideoDecoder

Media video decoding capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Media.VideoEncoder

Media video encoding capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Media.Spliter

Media splitter capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Media.Muxer

Media muxer capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.AVSession.Core

Basic media session capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.AVSession.Manager

Media session management capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Audio.Core

Basic audio capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Audio.Renderer

Audio output capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Audio.Capturer

Audio input capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Audio.Device

Audio device management capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Audio.Volume

Audio volume management capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Audio.Communication

Audio communication capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Camera.Core

Basic camera capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Camera.DistributedCore

Distributed camera capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Image.Core

Basic image capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Image.ImageSource

Image source decoding and parsing capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Image.ImagePacker

Image packaging capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Image.ImageReceiver

Image receiving capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.MediaLibrary.Core

Basic capabilities of the media library

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.MediaLibrary.SmartAlbum

Smart album capability of the media library

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.MediaLibrary.DistributedCore

Distributed capability of the media library

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Telephony.CoreService

Basic cellular service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | No    | No          | No    |

## SystemCapability.Telephony.CallManager

Call management service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | No    | No          | No    |

## SystemCapability.Telephony.CellularCall

Cellular call service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | No    | No          | No    |

## SystemCapability.Telephony.CellularData

Cellular data service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | No    | No          | No    |

## SystemCapability.Telephony.SmsMms

SMS and MMS services

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | No    | No          | No    |

## SystemCapability.Telephony.StateRegistry

Cellular network status registration service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | No    | No          | No    |

## SystemCapability.Global.I18n

Internationalization

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Global.ResourceManager

Resource management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Customization.ConfigPolicy

Customization framework

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | Yes    | Yes    | Yes  | Yes  | Yes    | Yes          | Yes    |

## SystemCapability.Customization.EnterpriseDeviceManager

Enterprise device management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BarrierFree.Accessibility.Core

Accessibility capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BarrierFree.Accessibility.Vision

Visual accessibility capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BarrierFree.Accessibility.Hearing

Audio accessibility capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BarrierFree.Accessibility.Interaction

Interaction assistance capability in accessibility

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | No  | Yes    | No          | No    |

## SystemCapability.ResourceSchedule.WorkScheduler

Work Scheduler

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.ResourceSchedule.BackgroundTaskManager.ContinuousTask

Continuous task management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.ResourceSchedule.BackgroundTaskManager.TransientTask

Transient task management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.ResourceSchedule.UsageStatistics.App

Application usage statistics

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.ResourceSchedule.UsageStatistics.AppGroup

Application activity group

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Utils.Lang

TS/JS language base library

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.HiviewDFX.HiLog

HiLog functionality

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.HiviewDFX.HiLogLite

Lite HiLog functionality

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | Yes    | No    | No  | No  | No    | Yes          | Yes    |

## SystemCapability.HiviewDFX.HiTrace

HiTrace for distributed tracing

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.HiviewDFX.Hiview.FaultLogger

FaultLogger for event recording

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.HiviewDFX.HiviewLite

Lightweight Hiview service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | Yes    | No    | No  | No  | No    | Yes          | Yes    |

## SystemCapability.HiviewDFX.HiChecker

HiChecker mode

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.HiviewDFX.HiCollie

HiCollie for suspension fault detection

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.HiviewDFX.HiDumper

HiDumper for system information exporting

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.HiviewDFX.HiAppEvent

HiAppEvent for application event logging

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.HiviewDFX.HiSysEvent

HiAppEvent for system event logging

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.HiviewDFX.HiEventLite

HiEventLite for lightweight event logging

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | Yes    | No    | No  | No  | No    | No          | Yes    |

## SystemCapability.HiviewDFX.HiProfiler.HiDebug

Debugging and tuning

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Update.UpdateService

Update

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | Yes    | Yes    | Yes  | Yes  | Yes    | Yes          | Yes    |

## SystemCapability.DistributedHardware.DeviceManager

Distributed Device Management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | Yes    | No          | No    |

## SystemCapability.Security.DeviceAuth

Mutual authentication between devices

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | Yes    | No          | No    |

## SystemCapability.Security.DataTransitManager

Library of data transmission management and control policies

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | Yes    | No          | No    |

## SystemCapability.Security.DeviceSecurityLevel

Device security level management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | Yes    | No          | No    |

## SystemCapability.Security.Huks

Hardware Unique Key (HUK) management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | Yes    | No          | No    |

## SystemCapability.Security.AccessToken

Access control

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Security.Cipher

Encryption and decryption

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | No    | No    | No  | No  | No    | Yes          | No    |

## SystemCapability.Account.OsAccount

Account

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Account.AppAccount

Application account

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.UserIAM.UserAuth.Core

Unified user authentication

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | Yes    | No          | No    |

## SystemCapability.UserIAM.UserAuth.PinAuth

PIN authentication

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | Yes    | No          | No    |

## SystemCapability.UserIAM.UserAuth.FaceAuth

Facial authentication

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | Yes    | No          | No    |

## SystemCapability.MiscServices.InputMethodFramework

Input method framework

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | No  | No    | No          | No    |

## SystemCapability.MiscServices.Pasteboard

Pasteboard service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | No  | No    | No          | No    |

## SystemCapability.MiscServices.Time

Time, time zone, and timing service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | Yes    | No          | No    |

## SystemCapability.MiscServices.Wallpaper

Wallpaper framework

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | No  | No    | No          | No    |

## SystemCapability.MiscServices.ScreenLock

Screen lock service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | No  | No    | No          | No    |

## SystemCapability.MiscServices.Upload

Upload service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | No  | No    | No          | No    |

## SystemCapability.MiscServices.Download

Download service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | No  | No    | No          | No    |

## SystemCapability.FileManagement.StorageService.Backup

Backup and restoration

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.FileManagement.StorageService.SpatialStatistics

Spatial statistics

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.FileManagement.StorageService.Volume

Volume management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.FileManagement.StorageService.Encryption

File encryption capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.FileManagement.File.FileIO

Basic file I/O interfaces

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | Yes    | Yes    | Yes  | Yes  | Yes    | Yes          | Yes    |

## SystemCapability.FileManagement.File.Environment

Environment-related interfaces

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | Yes    | Yes    | Yes  | Yes  | Yes    | Yes          | Yes    |

## SystemCapability.FileManagement.File.DistributedFile

Distributed file extension

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.FileManagement.AppFileService

Application file sharing

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.FileManagement.UserFileService

User file access service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.USB.USBManager

USB service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Sensors.Sensor

Sensor service subscription

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | No    | No          | No    |

## SystemCapability.Sensors.MiscDevice

Miscellaneous devices- sensors

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | No  | No    | No          | No    |

## SystemCapability.Startup.SystemInfo

Basic system information

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | Yes    | Yes    | Yes  | Yes  | Yes    | Yes          | Yes    |

## SystemCapability.DistributedDataManager.RelationalStore.Core

Basic relational database capabilities

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.DistributedDataManager.RelationalStore.Synchronize

Distributed capability of relational databases

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.DistributedDataManager.RelationalStore.Lite

Lightweight relational database

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | No    | No    | No  | No  | No    | No          | No    |

## SystemCapability.DistributedDataManager.KVStore.Core

Core capabilities of key-value databases

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.DistributedDataManager.KVStore.Lite

Core capabilities of lightweight key-value databases

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | No    | No    | No  | No  | No    | No          | No    |

## SystemCapability.DistributedDataManager.KVStore.DistributedKVStore

Distributed key-value database

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.DistributedDataManager.DataObject.DistributedObject

Distributed data object

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.DistributedDataManager.Preferences.Core

Core capabilities of preferences data storage

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.DistributedDataManager.DataShare.Core

Basic capabilities of cross-process data sharing

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.DistributedDataManager.DataShare.Consumer

Data consumer of cross-process data sharing

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.DistributedDataManager.DataShare.Provider

Data provider of cross-process data sharing

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Ability.AbilityBase

Definition of basic component running data, including wants and system configuration

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Ability.AbilityRuntime.Core

Core basic functional modules for component runtime, including application initialization and GUI-less component running

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Ability.AbilityRuntime.FAModel

Feature Ability (FA) model

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Ability.AbilityRuntime.AbilityCore

Universal components (with GUIs)

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Ability.AbilityRuntime.Mission

Task management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Ability.AbilityTools.AbilityAssistant

CLI tool

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Ability.Form

Widget management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Ability.DistributedAbilityManager

continuationManager for starting the device selection module and updating the continuation status.

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Applications.ContactsData

Contacts database

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | No    | No          | No    |

## SystemCapability.Applications.Contacts

Contacts

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | No    | No          | No    |

## SystemCapability.Applications.settings.Core

API setting

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Test.UiTest

UiTest capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | No    | No          | No    |

## SystemCapability.Web.Webview.Core

Webview component

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Cloud.AAID

AAID management service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | Yes    | Yes    | Yes  | Yes  | Yes    | Yes          | Yes    |

## SystemCapability.Cloud.OAID

OAID management service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | Yes    | Yes    | Yes  | Yes  | Yes    | Yes          | Yes    |

## SystemCapability.Cloud.VAID

VAID management service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | Yes    | Yes    | Yes  | Yes  | Yes    | Yes          | Yes    |

## SystemCapability.Security.CertificateManager

Certificate management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No   | Yes  | Yes  | Yes    | No        | No    |

## SystemCapability.Security.CryptoFramework

Cryptographic framework – basic encryption and decryption capabilities

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BundleManager.BundleFramework.Core

Core services of bundle management, including bundle information query, bundle installation, and bundle uninstallation

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BundleManager.BundleFramework.FreeInstall

Installation-free features provided by the bundle manager

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BundleManager.BundleFramework.Resource

Icon and label acquisition provided by the bundle manager

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BundleManager.BundleFramework.DefaultApp

Default application management feature provided by the bundle manager

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BundleManager.BundleFramework.Launcher

Query feature provided by the bundle manager for Launcher

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BundleManager.BundleFramework.SandboxApp

Sandbox application features provided by the bundle manager

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BundleManager.BundleFramework.QuickFix

Quick fix provided by the bundle manager

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BundleManager.BundleFramework.AppControl

Application control features provided by the bundle manager

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Graphic.Graphic2D.ColorManager.Core

Wide color gamut management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | No  | Yes    | No          | No    |

## SystemCapability.ResourceSchedule.BackgroundTaskManager.EfficiencyResourcesApply

Efficiency resource application

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Media.AVPlayer

Audio and video player capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Multimedia.Media.AVRecorder

Audio and video recorder capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Security.Cert

Cryptographic framework – certificate capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Security.DataLossPrevention

Data leakage prevention

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | No  | No    | No          | No    |

## SystemCapability.Communication.NFC.Tag

NFC tag service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | No    | No    | No  | No  | No    | No          | No    |

## SystemCapability.Communication.NFC.CardEmulation

NFC card emulation service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | No    | No    | No  | No  | No    | No          | No    |

## SystemCapability.Multimedia.Image.ImageCreator

Image creation capability

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Developtools.Syscap

System capability encoding and decoding

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | Yes    | Yes    | Yes  | Yes  | Yes    | Yes          | No    |

## SystemCapability.Communication.NetManager.Ethernet

Ethernet connectivity

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Communication.NetManager.NetSharing

Network sharing

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | No  | Yes    | No          | No    |

## SystemCapability.Communication.NetManager.MDNS

mDNS service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Communication.NetManager.Vpn

VPN

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | No  | Yes    | No          | No    |

## SystemCapability.XTS.DeviceAttest

Device attestation

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.XTS.DeviceAttestLite

Lightweight device attestation

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | Yes    | No    | No  | No  | No    | Yes          | Yes    |

## SystemCapability.FileManagement.UserFileManager.Core

Basic capabilities of public user file management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.FileManagement.UserFileManager.DistributedCore

Distributed capabilities of public user file management

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.DistributedDataManager.UDMF.Core

Distributed data management – core capabilities of the Unified Data Management Framework (UDMF)

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.BundleManager.BundleFramework.Overlay

Overlay feature provided by the bundle manager

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Cloud.Push

Push management service

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | Yes          | No    |

## SystemCapability.Multimedia.SystemSound.Core

System sound management, covering ringtones, notifications, alarms, and more

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Ability.AbilityRuntime.QuickFix

Quick fix

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | Yes    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.MultimodalInput.Input.Pointer

Pointer input enhancement

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Communication.SecureElement

Secure element access

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| No     | No    | No    | No  | No  | No    | No          | No    |

## SystemCapability.Msdp.DeviceStatus.Stationarty

Device status awareness

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | No    | No    | Yes  | Yes  | Yes    | No          | No    |

## SystemCapability.Base

General type

| Default | Sports Watch| Smart Watch| Tablet| Head Unit| Smart TV| Smart Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| Yes     | Yes    | Yes    | Yes  | Yes  | Yes    | Yes          | Yes    |
