# Quick Start

- Getting Started
  - [Before You Start](start-overview.md)
  - [Getting Started with ArkTS in Stage Model](start-with-ets-stage.md)
  - [Getting Started with ArkTS in FA Model](start-with-ets-fa.md)
  - [Getting Started with JavaScript in FA Model](start-with-js-fa.md)  
- Development Fundamentals
  - Application Package Fundamentals
    - [Application Package Overview](application-package-overview.md)
    - Application Package Structure
      - [Application Package Structure in Stage Model](application-package-structure-stage.md)
      - [Application Package Structure in FA Model](application-package-structure-fa.md)
    - Multi-HAP Mechanism
      - [Multi-HAP Design Objectives](multi-hap-objective.md)
      - [Multi-HAP Build View](multi-hap-build-view.md)
      - [Multi-HAP Development, Debugging, Release, and Deployment Process](multi-hap-release-deployment.md)
      - [Multi-HAP Usage Rules](multi-hap-rules.md)
      - [Multi-HAP Operation Mechanism and Data Communication Modes](multi-hap-principles.md)
    - [Application Installation and Uninstallation Process](application-package-install-uninstall.md)
    - [Application Package Update Process](application-package-update.md)
    - Shared Package
      - [Shared Package Overview](shared-guide.md)
      - [HAR](har-package.md)
      - HSP
        - [In-Application HSP Development](in-app-hsp.md)
    - Quick Fix
      - [Quick Fix Overview](quickfix-principles.md)
      - [CLI-based Quick Fix Development](quickfix-debug.md)
  - Application Configuration Files in Stage Model
    - [Application Configuration File Overview (Stage Model)](application-configuration-file-overview-stage.md)
    - [app.json5 Configuration File](app-configuration-file.md)
    - [module.json5 Configuration File](module-configuration-file.md)
  - Application Configuration Files in FA Model
    - [Application Configuration File Overview (FA Model)](application-configuration-file-overview-fa.md)
    - [Internal Structure of the app Tag](app-structure.md)
    - [Internal Structure of deviceConfig Tag](deviceconfig-structure.md)
    - [Internal Structure of the module Tag](module-structure.md)
  - [Resource Categories and Access](resource-categories-and-access.md)
- Learning ArkTS
    - [Getting Started with ArkTS](arkts-get-started.md)
    - ArkTS Syntax (Declarative UI)
      - [Basic UI Description](arkts-basic-ui-description.md)
      - State Management
        - [Basic Concepts](arkts-state-mgmt-concepts.md)
        - [State Management with Page-level Variables](arkts-state-mgmt-page-level.md)
        - [State Management with Application-level Variables](arkts-state-mgmt-application-level.md)
      - [Dynamic UI Element Building](arkts-dynamic-ui-elememt-building.md)
      - [Rendering Control](arkts-rendering-control.md)
      - [Restrictions and Extensions](arkts-restrictions-and-extensions.md)
- FAQs
    - [Full SDK Compilation Guide](full-sdk-compile-guide.md)
    - [Guide to Switching to Full SDK](full-sdk-switch-guide.md)
- Tools
    - [DevEco Studio (OpenHarmony) User Guide](deveco-studio-user-guide-for-openharmony.md)