# FA Model Development Overview


During application development based on the Feature Ability (FA) model, the following tasks are involved in the application model.

**Table 1** FA model development process

| Task| Introduction| Guide|
| -------- | -------- | -------- |
| Application component development| Use the PageAbility, ServiceAbility, DataAbility, and widgets of the FA model to develop applications.| - [Application- or Component-Level Configuration](application-component-configuration-fa.md)<br>- [PageAbility Component](pageability-overview.md)<br>- [ServiceAbility Component](serviceability-overview.md)<br>- [DataAbility Component](dataability-overview.md)<br>- [Widget Development](Widget-development-fa.md)<br>- [Context](application-context-fa.md)<br>- [Want](want-fa.md) |
| Inter-process communication (IPC)| Learn the process model and common IPC modes of the FA model.| [Common Events](common-event-fa.md)<br>[Background Services](rpc.md) |
| Inter-thread communication| Learn the thread model and common inter-thread communication modes of the FA model.| [Inter-Thread Communication](itc-fa-overview.md)|
| Mission management| Learn the basic concepts and typical scenarios of mission management in the FA model.| [Mission Management](mission-management-fa.md)|
| Application configuration file| Learn the requirements for developing application configuration files in the FA model.| [Application Configuration File](../quick-start/application-configuration-file-overview-fa.md) |
