# UI

- [ArkUI Overview](arkui-overview.md)
- JavaScript-based Web-like Development Paradigm
    - [Overview](ui-js-overview.md)
    - Framework
        - [File Organization](js-framework-file.md)
        - ["js" Tag](js-framework-js-tag.md)
        - [app.js](js-framework-js-file.md)
        - Syntax
            - [HML](js-framework-syntax-hml.md)
            - [CSS](js-framework-syntax-css.md)
            - [JavaScript](js-framework-syntax-js.md)
        - [Lifecycle](js-framework-lifecycle.md)
        - [Resource Limitations and Access](js-framework-resource-restriction.md)
        - [Multi-Language Capability](js-framework-multiple-languages.md)
    - Building the UI
        - [Component Overview](ui-js-building-ui-component.md)
        - Building the Layout
            - [Layout Description](ui-js-building-ui-layout-intro.md)
            - [Adding Title and Paragraph Text](ui-js-building-ui-layout-text.md)
            - [Adding an Image](ui-js-building-ui-layout-image.md)
            - [Adding a Comment](ui-js-building-ui-layout-comment.md)
            - [Adding a Container](ui-js-building-ui-layout-external-container.md)
        - [Adding Interactions](ui-js-building-ui-interactions.md)
        - [Developing Animations](ui-js-building-ui-animation.md)
        - [Defining Events](ui-js-building-ui-event.md)
        - [Defining Page Routes](ui-js-building-ui-routes.md)
    - Common Component Development Guidelines
        - [&lt;text&gt; Development](ui-js-components-text.md)
        -   [&lt;input&gt; Development](ui-js-components-input.md)
        -   [&lt;button&gt; Development](ui-js-components-button.md)
        -   [&lt;list&gt; Development](ui-js-components-list.md)
        -   [&lt;picker&gt; Development](ui-js-components-picker.md)
        -   [&lt;dialog&gt; Development](ui-js-components-dialog.md)
        -   [&lt;form&gt; Development](ui-js-components-form.md)
        -   [&lt;stepper&gt; Development](ui-js-components-stepper.md)
        -   [&lt;tabs&gt; Development](ui-js-component-tabs.md)
        -   [&lt;image&gt; Development](ui-js-components-images.md)
    - Animation Development Guidelines
        - CSS Animation
            - [Defining Attribute Style Animations](ui-js-animate-attribute-style.md)
            - [Defining Animations with the transform Attribute](ui-js-animate-transform.md)
            - [Defining Animations with the background-position Attribute](ui-js-animate-background-position-style.md)
            - [Defining Animations for SVG Components](ui-js-animate-svg.md)
        - JS Animation
            - [Component Animation](ui-js-animate-component.md)
            - Interpolator Animation
                - [Animation Effect](ui-js-animate-dynamic-effects.md)
                - [Animation Frame](ui-js-animate-frame.md)
    - [Custom Components](ui-js-custom-components.md)
- TypeScript-based Declarative Development Paradigm
    - [Overview](ui-ts-overview.md)
    - Framework Overview
        - File Organization
            - [Directory Structure](ts-framework-directory.md)
            - [Rules for Accessing Application Code Files](ts-framework-file-access-rules.md)
        - ["js" Tag](ts-framework-js-tag.md)
        - Resource Access
            - [Accessing Application Resources](ts-application-resource-access.md)
            - [Accessing System Resources](ts-system-resource-access.md)
            - [Media Resource Types](ts-media-resource-type.md)
        - [Pixel Units](ts-pixel-units.md)
        - [Types](ts-types.md)
    - Declarative Syntax
        - [Overview](ts-syntax-intro.md)
        - General UI Description Specifications
            - [Basic Concepts](ts-general-ui-concepts.md)
            - Declarative UI Description Specifications
                - [Configuration Without Parameters](ts-parameterless-configuration.md)
                - [Configuration with Mandatory Parameters](ts-configuration-with-mandatory-parameters.md)
                - [Attribute Configuration](ts-attribution-configuration.md)
                - [Event Configuration](ts-event-configuration.md)
                - [Child Component Configuration](ts-child-component-configuration.md)
            - Componentization
                - [@Component](ts-component-based-component.md)
                - [@Entry](ts-component-based-entry.md)
                - [@Preview](ts-component-based-preview.md)
                - [@Builder](ts-component-based-builder.md)
                - [@Extend](ts-component-based-extend.md)
                - [@CustomDialog](ts-component-based-customdialog.md)
                - [@Styles](ts-component-based-styles.md)
        - About UI State Management
            - [Basic Concepts](ts-ui-state-mgmt-concepts.md)
            - Managing Component States
                - [@State](ts-component-states-state.md)
                - [@Prop](ts-component-states-prop.md)
                - [@Link](ts-component-states-link.md)
            - Managing Application States
                - [AppStorage](ts-application-states-appstorage.md)
                - [PersistentStorage](ts-application-states-apis-persistentstorage.md)
                - [Environment](ts-application-states-apis-environment.md)
            - Managing Other States
                - [@Observed and @ObjectLink](ts-other-states-observed-objectlink.md)
                - [@Consume and @Provide](ts-other-states-consume-provide.md)
                - [@Watch](ts-other-states-watch.md)
            - About Rendering Control Syntax
                - [if/else](ts-rending-control-syntax-if-else.md)
                - [ForEach](ts-rending-control-syntax-foreach.md)
                - [LazyForEach](ts-rending-control-syntax-lazyforeach.md)
        - About @Component
            - [build Function](ts-function-build.md)
            - [Initialization of Custom Components' Member Variables](ts-custom-component-initialization.md)
            - [Custom Component Lifecycle Callbacks](ts-custom-component-lifecycle-callbacks.md)
            - [Component Creation and Re-initialization](ts-component-creation-re-initialization.md)
        - [About Syntactic Sugar](ts-syntactic-sugar.md)
    - Common Component Development Guidelines
        - [&lt;web&gt; Development](ui-ts-components-web.md)
    - Experiencing the Declarative UI
        - [Creating a Declarative UI Project](ui-ts-creating-project.md)
        - [Getting to Know Components](ui-ts-components.md)
        - [Creating a Simple Page](ui-ts-creating-simple-page.md)
    - Defining Page Layout and Connection
        - [Building a Food Data Model](ui-ts-building-data-model.md)
        - [Building a Food Category List Layout](ui-ts-building-category-list-layout.md)
        - [Building a Food Category Grid Layout](ui-ts-building-category-grid-layout.md)
        - [Implementing Page Redirection and Data Transmission](ui-ts-page-redirection-data-transmission.md)
