# OpenHarmony 2.0 Canary（2021-06-01）

## 版本概述

当前版本在OpenHarmony 1.1.0的基础上，增加标准系统版本，具备的主要功能如下：

-   新增22个子系统，支持全面的OS能力，支持内存大于128M的带屏设备开发等。
-   提供系统三大应用：桌面、设置和SystemUI。
-   提供全新的OpenHarmony应用框架能力、Ability Cross-platform Engine能力。
-   提供JS应用开发能力。
-   提供媒体框架，支持音视频功能开发。
-   提供图形框架能力，支持窗口管理和合成，支持GPU能力。

## 配套关系

**表 1**  版本软件和工具配套关系

| 软件                              | 版本                        | 备注                                      |
| --------------------------------- | --------------------------- | ----------------------------------------- |
| OpenHarmony                       | 2.0 Canary                  | NA                                        |
| HUAWEI DevEco Studio（可选）      | DevEco Studio 2.1 Release   | OpenHarmony应用开发推荐使用。             |
| HUAWEI DevEco Device Tool（可选） | Deveco DeviceTool 2.2 Beta1 | OpenHarmony智能设备集成开发环境推荐使用。 |


## 源码获取


### 通过repo下载

 **方式一（推荐）** 

通过repo + ssh 下载（需注册公钥，请参考[码云帮助中心](https://gitee.com/help/articles/4191)）。

 ```shell
repo init -u git@gitee.com:openharmony/manifest.git -b refs/tags/OpenHarmony-2.0-Canary --no-repo-verify
repo sync -c
repo forall -c 'git lfs pull'
 ```

 **方式二** 

通过repo + https 下载。

```shell
repo init -u https://gitee.com/openharmony/manifest.git -b refs/tags/OpenHarmony-2.0-Canary --no-repo-verify
repo sync -c
repo forall -c 'git lfs pull'
```

### 通过镜像站点获取

**表2** 源码获取路径

| 版本源码 | 版本信息 | 下载站点 | SHA256校验码 |
| -------- | -------- | -------- | -------- |
| 全量代码 | 2.0 | [站点](https://repo.huaweicloud.com/harmonyos/os/2.0/code-2.0-canary_20210601.tar.gz) | [SHA256校验码](https://repo.huaweicloud.com/harmonyos/os/2.0/code-2.0-canary_20210601.tar.gz.sha256) |
| Release&nbsp;Notes | 2.0 | [站点](https://gitee.com/openharmony/docs/blob/master/zh-cn/release-notes/OpenHarmony-2-0-Canary.md) | - |

## 更新说明

本版本完全继承了OpenHarmony 1.1.0的所有特性，并在OpenHarmony 1.1.0版本的基础上，新增标准系统版本形态，详情请参考下表 。

**表 3**  版本新增特性表

| 子系统名称     | 新增特性                                                     |
| -------------- | ------------------------------------------------------------ |
| 内核           | 基于Linux Kernel LTS社区开源基线，回合CVE补丁，包含了OpenHarmony上层特性适配。 |
| 分布式文件     | 提供本地同步文件 JS 接口，包括文件读写、目录访问以及文件Stat。 |
| 图形图像       | - 新增窗口管理功能，包括创建、销毁和窗口栈管理等。<br/>- 新增合成器功能，包括CPU、GPU和TDE合成。<br/>- 新增bufferqueue功能，支持进程间传递。<br/>- 新增vsync管理功能。 |
| 驱动           | 新增用户态驱动框架。                                         |
| 电源管理服务   | 新增电源管理能力，包括关机服务、亮灭屏管理、亮度调节、电池状态查询、系统电源管理、休眠锁管理等功能。 |
| 多模输入子系统 | 新增支持单指触屏输入能力。                                   |
| 启动恢复子系统 | 系统属性管理新增JS API。                                     |
| 升级服务       | - 新增recovery系统升级服务能力。<br/>- 新增差分包升级能力。<br/>- 新增系统属性管理JS API。 |
| 帐号           | 提供分布式云帐号登录状态管理功能。                           |
| 编译构建       | - 支持按照部件名或模块名编译指定目标。<br/>- 支持不同芯片平台接入，配置产品部件列表。 |
| 测试           | 新增开发者自测试能力，支持C++ API单元测试，API性能测试等。   |
| 数据管理       | 提供轻量级Key-Value操作，支持本地应用存储少量数据，数据存储在本地文件中，同时也加载在内存中的，所以访问速度更快，效率更高。 |
| 语言编译运行时 | 提供了JS、C/C++语言程序的编译、执行环境，提供支撑运行时的基础库，以及关联的API接口、编译器和配套工具。 |
| 分布式任务调度 | 提供系统服务的启动、注册、查询及管理能力。                   |
| JS UI框架      | - 提供40+UI基础组件和容器组件。<br/>- 提供标准CSS动画。<br/>- 支持原子化布局、栅格布局。<br/>- 提供类Web开发范式的UI编程框架。<br/>- JS API扩展机制。 |
| 媒体           | - 新增媒体播放和录制基本功能。<br/>- 新增相机管理和相机采集基本功能。<br/>- 新增音频音量和设备管理基本功能。 |
| 事件通知       | 新增发布、订阅、接收公共事件的基本功能。                     |
| 杂散软件服务   | 新增设置时间的能力。                                         |
| 用户程序框架   | 新增包安装、卸载、运行及管理能力。                           |
| 电话服务       | - 新增获得信号强度、获得驻网状态能力。<br/>- 新增获得SIM卡状态能力。<br/>- 新增拨打电话、拒接电话、挂断电话能力。<br/>- 新增发送短信、接收短信能力。 |
| 公共基础类库   | 提供了一些常用的C、C++开发增强API。                          |
| 研发工具链     | - 新增设备连接调试器。<br/>- 新增性能跟踪能力。<br/>- 新增实时内存和trace调优工具，和端侧插件能力。 |
| 分布式软总线   | - 新增跨进程通信(IPC)和跨设备的远程过程调用(RPC)能力。<br/>- 新增支持设备发现、组网、传输能力的软总线服务。<br/>- 新增WiFi服务，可提供STA开关、扫描、连接等基本能力。 |
| XTS            | 新增各业务特性公共API兼容性看护用例套件。                    |
| 系统应用       | 桌面:<br/>- 新增全量应用图标展示、启动和卸载应用能力。<br/>- 新增桌面管理界面，可切换网格布局与列表布局。<br/>- 新增最近任务管理能力，可热启动和清理任务。<br/>设置：<br/>- 新增设置应用，包括亮度设置，应用信息，时间设置和关于设备。<br/>SystemUI：<br/>- 新增系统栏展示，包括时间、电量信息。<br/>- 新增系统导航展示。 |
| DFX            | - 新增流水日志。<br/>- 新增应用故障收集和订阅。<br/>- 新增系统事件记录接口。<br/>- 新增应用事件记录接口及框架。 |
| 全球化子系统   | - 新增支持资源解析读取能力。<br/>- 新增支持时间日期格式化能力。 |
| 安全           | - 新增系统权限管理，包括系统权限声明，应用安装时申请或申明的权限解析，权限查询，权限授予。<br/>- 新增应用签名和验签能力。<br/>- 新增点对点设备连接时的互信认证能力和设备群组管理能力。 |


