# OpenHarmony设备开发文档
- [设备开发导读](device-dev-guide.md)

- 快速开始
  - 轻量和小型系统快速入门（IDE方式，推荐）
    - [轻量与小型系统入门概述](quick-start/quickstart-ide-lite-overview.md)
    - 准备轻量与小型系统环境
        - [搭建Windows+Ubuntu混合开发环境](quick-start/quickstart-ide-lite-env-setup-win-ubuntu.md)
        - [获取源码](quick-start/quickstart-ide-lite-sourcecode-acquire.md)
    - [导入源码工程](quick-start/quickstart-ide-lite-create-project.md)
    - 运行“Hello World”
        - Hi3861开发板
            - [编写“Hello World”程序](quick-start/quickstart-ide-lite-steps-hi3861-helloworld.md)
            - [编译](quick-start/quickstart-ide-lite-steps-hi3861-building.md)
            - [烧录](quick-start/quickstart-ide-lite-steps-hi3861-burn.md)
            - [联网](quick-start/quickstart-ide-lite-steps-hi3861-netconfig.md)
            - [调试验证](quick-start/quickstart-ide-lite-steps-hi3861-debug.md)
            - [运行](quick-start/quickstart-ide-lite-steps-hi3861-running.md)
        - Hi3516开发板
            - [编写“Hello World”程序](quick-start/quickstart-ide-lite-steps-hi3516-helloworld.md)
            - [编译](quick-start/quickstart-ide-lite-steps-hi3516-building.md)
            - [烧录](quick-start/quickstart-ide-lite-steps-hi3516-burn.md)
            - [运行](quick-start/quickstart-ide-lite-steps-hi3516-running.md)
    - 附录
        - [Hi3861开发板介绍](quick-start/quickstart-ide-lite-introduction-hi3861.md)
        - [Hi3516开发板介绍](quick-start/quickstart-ide-lite-introduction-hi3516.md)
        - [编译形态整体说明](quick-start/quickstart-build.md)
  - 轻量和小型系统快速入门（安装包方式）
    - [轻量与小型系统入门概述](quick-start/quickstart-lite-overview.md)
    - [搭建轻量与小型系统环境](quick-start/quickstart-lite-env-setup.md)
    - 运行“Hello World”
        - Hi3861开发板
            - [安装Hi3861开发板环境](quick-start/quickstart-lite-steps-hi3861-setting.md)
            - [编写“Hello World”程序](quick-start/quickstart-lite-steps-hi3861-helloworld.md)
            - [编译](quick-start/quickstart-lite-steps-hi3861-building.md)
            - [烧录](quick-start/quickstart-lite-steps-hi3861-burn.md)
            - [联网](quick-start/quickstart-lite-steps-hi3861-netconfig.md)
            - [调试验证](quick-start/quickstart-lite-steps-hi3861-debug.md)
            - [运行](quick-start/quickstart-lite-steps-hi3861-running.md)
        - Hi3516开发板
            - [安装Hi3516开发板环境](quick-start/quickstart-lite-steps-hi3516-setting.md)
            - [编写“Hello World”程序](quick-start/quickstart-lite-steps-hi3516-helloworld.md)
            - [编译](quick-start/quickstart-lite-steps-hi3516-building.md)
            - [烧录](quick-start/quickstart-lite-steps-hi3516-burn.md)
            - [运行](quick-start/quickstart-lite-steps-hi3516-running.md)
    - 常见问题
        - [hb安装异常](quick-start/quickstart-lite-faq-hb.md)
        - [编译异常](quick-start/quickstart-lite-faq-compose.md)
        - [烧录异常](quick-start/quickstart-lite-faq-burning.md)
    - 附录
        - 开发板介绍
            - [Hi3861开发板介绍](quick-start/quickstart-lite-introduction-hi3861.md)
            - [Hi3516开发板介绍](quick-start/quickstart-lite-introduction-hi3516.md)
        - [参考信息](quick-start/quickstart-lite-reference.md)
        - [使用HiTool烧录代码](quick-start/quickstart-lite-hitool.md)
        - [编译形态整体说明](quick-start/quickstart-build.md)
  - 标准系统快速入门（IDE方式，推荐）
    - [标准系统入门概述](quick-start/quickstart-ide-standard-overview.md)
    - 准备标准系统环境
        - [搭建Windows+Ubuntu混合开发环境](quick-start/quickstart-ide-standard-env-setup-win-ubuntu.md)
        - [获取源码](quick-start/quickstart-ide-standard-sourcecode-acquire.md)
    - [导入源码工程](quick-start/quickstart-ide-standard-create-project.md)
    - 运行“Hello World”
        - Hi3516开发板
            - [编写“Hello World”程序](quick-start/quickstart-ide-standard-running-hi3516-create.md)
            - [编译](quick-start/quickstart-ide-standard-running-hi3516-build.md)
            - [烧录](quick-start/quickstart-ide-standard-running-hi3516-burning.md)
            - [运行](quick-start/quickstart-ide-standard-running-hi3516-running.md)
        - RK3568开发板
            - [编写“Hello World”程序](quick-start/quickstart-ide-standard-running-rk3568-create.md)
            - [编译](quick-start/quickstart-ide-standard-running-rk3568-build.md)
            - [烧录](quick-start/quickstart-ide-standard-running-rk3568-burning.md)
            - [运行](quick-start/quickstart-ide-standard-running-rk3568-running.md)
    - 附录
        - [Hi3516开发板介绍](quick-start/quickstart-ide-standard-board-introduction-hi3516.md)
        - [RK3568开发板介绍](quick-start/quickstart-ide-standard-board-introduction-rk3568.md)
        - [编译形态整体说明](quick-start/quickstart-build.md)
  - 标准系统快速入门（安装包方式）
    - [标准系统入门概述](quick-start/quickstart-standard-overview.md)
    - [搭建标准系统环境](quick-start/quickstart-standard-env-setup.md)
    - 运行“Hello World”
        - Hi3516开发板
            - [编写“Hello World”程序](quick-start/quickstart-std-3516-create.md)
            - [编译](quick-start/quickstart-standard-running-hi3516-build.md)
            - [烧录](quick-start/quickstart-standard-running-hi3516-burning.md)
            - [运行](quick-start/quickstart-standard-running-hi3516-running.md)
        - RK3568开发板
            - [编写“Hello World”程序](quick-start/quickstart-standard-running-rk3568-create.md)
            - [编译](quick-start/quickstart-standard-running-rk3568-build.md)
            - [烧录](quick-start/quickstart-standard-running-rk3568-burning.md)
            - [运行](quick-start/quickstart-standard-running-rk3568-running.md)
    - 常见问题
        - [hb安装异常](quick-start/quickstart-standard-faq-hb.md)
        - [编译异常](quick-start/quickstart-standard-faq-compose.md)
        - [烧录异常](quick-start/quickstart-standard-faq-burning.md)
    - 附录
        - 开发板介绍
            - [Hi3516开发板介绍](quick-start/quickstart-standard-board-introduction-hi3516.md)
            - [RK3568开发板介绍](quick-start/quickstart-standard-board-introduction-rk3568.md)
        - [参考信息](quick-start/quickstart-standard-reference.md)
        - [使用HiTool烧录代码](quick-start/quickstart-standard-hitool.md)
        - [编译形态整体说明](quick-start/quickstart-build.md)
 
  - [获取源码](get-code/sourcecode-acquire.md)

- 兼容性与安全

  - [隐私保护](security/security-privacy-protection.md)
  - [安全指南](security/security-guidelines-overall.md)

- 移植

  - 轻量系统芯片移植指导
    - [概述](porting/porting-minichip-overview.md)
    - [移植准备](porting/porting-minichip-prepare.md)
    - [移植内核](porting/porting-minichip-kernel.md)
    - 移植子系统
      - [移植子系统概述](porting/porting-minichip-subsys-overview.md)
      - [移植启动恢复子系统](porting/porting-minichip-subsys-startup.md)
      - [移植文件子系统](porting/porting-minichip-subsys-filesystem.md)
      - [移植安全子系统](porting/porting-minichip-subsys-security.md)
      - [移植通信子系统](porting/porting-minichip-subsys-communication.md)
      - [移植外设驱动子系统](porting/porting-minichip-subsys-driver.md)
      - [配置其他子系统](porting/porting-minichip-subsys-others.md)
    - [移植验证](porting/porting-minichip-verification.md)
    - [常见问题](porting/porting-chip-faqs.md)

  - 小型系统芯片移植指导

    - 移植准备
      - [移植须知](porting/porting-smallchip-prepare-needs.md)
      - [编译构建](porting/porting-smallchip-prepare-building.md)
    - 移植内核
      - [LiteOS-A内核](porting/porting-smallchip-kernel-a.md)
      - [Linux内核](porting/porting-smallchip-kernel-linux.md)
    - 驱动移植
      - [移植概述](porting/porting-smallchip-driver-overview.md)
      - [平台驱动移植](porting/porting-smallchip-driver-plat.md)
      - [器件驱动移植](porting/porting-smallchip-driver-oom.md)

  - 标准系统芯片移植指导

    - [标准系统移植指南](porting/standard-system-porting-guide.md)
    - [一种快速移植OpenHarmony Linux内核的方法](porting/porting-linux-kernel.md)

  - 轻量和小型系统三方库移植指导
    - [概述](porting/porting-thirdparty-overview.md)
    - [CMake方式组织编译的库移植](porting/porting-thirdparty-cmake.md)
    - [Makefile方式组织编译的库移植](porting/porting-thirdparty-makefile.md)

  - 轻量系统芯片移植案例
    - [带屏解决方案之恒玄芯片移植案例](porting/porting-bes2600w-on-minisystem-display-demo.md)
    - [Combo解决方案之ASR芯片移植案例](porting/porting-asr582x-combo-demo.md)
    - [物联网解决方案之芯海cst85芯片移植案例](porting/porting-cst85f01-combo-demo.md)
    - [轻量系统STM32F407芯片移植案例](porting/porting-stm32f407-on-minisystem-eth.md)
    - [Combo解决方案之W800芯片移植案例](porting/porting-w800-combo-demo.md)
  - 小型系统芯片移植案例
    - [小型设备STM32MP1芯片移植案例](porting/porting-stm32mp15xx-on-smallsystem.md)
- 子系统开发

  - 内核
    - 轻量系统内核
      - [内核概述](kernel/kernel-mini-overview.md)
      - 基础内核
        - [中断管理](kernel/kernel-mini-basic-interrupt.md)
        - [任务管理](kernel/kernel-mini-basic-task.md)
        - 内存管理
          - [基本概念](kernel/kernel-mini-basic-memory-basic.md)
          - [静态内存](kernel/kernel-mini-basic-memory-static.md)
          - [动态内存](kernel/kernel-mini-basic-memory-dynamic.md)
        - 内核通信机制
          - [事件](kernel/kernel-mini-basic-ipc-event.md)
          - [互斥锁](kernel/kernel-mini-basic-ipc-mutex.md)
          - [消息队列](kernel/kernel-mini-basic-ipc-queue.md)
          - [信号量](kernel/kernel-mini-basic-ipc-sem.md)
        - [时间管理](kernel/kernel-basic-mini-time.md)
        - [软件定时器](kernel/kernel-mini-basic-soft.md)
      - 扩展组件
        - [C++支持](kernel/kernel-mini-extend-support.md)
        - [CPU占用率](kernel/kernel-mini-extend-cpup.md)
        - [动态加载](kernel/kernel-mini-extend-dynamic-loading.md)
        - 文件系统
          - [FAT](kernel/kernel-mini-extend-file-fat.md)
          - [LittleFS](kernel/kernel-mini-extend-file-lit.md)
      - 内核调测
        - 内存调测
          - [内存信息统计](kernel/kernel-mini-memory-debug-mes.md)
          - [内存泄漏检测](kernel/kernel-mini-memory-debug-det.md)
          - [踩内存检测](kernel/kernel-mini-memory-debug-cet.md)
        - [异常调测](kernel/kernel-mini-memory-exception.md)
        - [Trace调测](kernel/kernel-mini-memory-trace.md)
        - [LMS调测](kernel/kernel-mini-memory-lms.md)
      - 附录
        - [内核编码规范](kernel/kernel-mini-appx-code.md)
        - [双向链表](kernel/kernel-mini-appx-data-list.md)
        - 标准库支持
          - [CMSIS支持](kernel/kernel-mini-appx-lib-cmsis.md)
          - [POSIX支持](kernel/kernel-mini-appx-lib-posix.md)
    - 小型系统内核
      - [内核概述](kernel/kernel-small-overview.md)
      - 内核启动
        - [内核态启动](kernel/kernel-small-start-kernel.md)
        - [用户态启动](kernel/kernel-small-start-user.md)
      - 基础内核
        - [中断及异常处理](kernel/kernel-small-basic-interrupt.md)
        - 进程管理
          - [进程](kernel/kernel-small-basic-process-process.md)
          - [任务](kernel/kernel-small-basic-process-thread.md)
          - [调度器](kernel/kernel-small-basic-process-scheduler.md)
        - 内存管理
          - [堆内存管理](kernel/kernel-small-basic-memory-heap.md)
          - [物理内存管理](kernel/kernel-small-basic-memory-physical.md)
          - [虚拟内存管理](kernel/kernel-small-basic-memory-virtual.md)
          - [虚实映射](kernel/kernel-small-basic-inner-reflect.md)
        - 内核通信机制
          - [事件](kernel/kernel-small-basic-trans-event.md)
          - [信号量](kernel/kernel-small-basic-trans-semaphore.md)
          - [互斥锁](kernel/kernel-small-basic-trans-mutex.md)
          - [消息队列](kernel/kernel-small-basic-trans-queue.md)
          - [读写锁](kernel/kernel-small-basic-trans-rwlock.md)
          - [用户态快速互斥锁](kernel/kernel-small-basic-trans-user-mutex.md)
          - [信号](kernel/kernel-small-basic-trans-user-signal.md)
        - [时间管理](kernel/kernel-small-basic-time.md)
        - [软件定时器](kernel/kernel-small-basic-softtimer.md)
        - [原子操作](kernel/kernel-small-basic-atomic.md)
      - 扩展组件
        - [系统调用](kernel/kernel-small-bundles-system.md)
        - [动态加载与链接](kernel/kernel-small-bundles-linking.md)
        - [虚拟动态共享库](kernel/kernel-small-bundles-share.md)
        - [轻量级进程间通信](kernel/kernel-small-bundles-ipc.md)
        - 文件系统
          - [虚拟文件系统](kernel/kernel-small-bundles-fs-virtual.md)
          - 支持的文件系统
            - [FAT](kernel/kernel-small-bundles-fs-support-fat.md)
            - [JFFS2](kernel/kernel-small-bundles-fs-support-jffs2.md)
            - [NFS](kernel/kernel-small-bundles-fs-support-nfs.md)
            - [Ramfs](kernel/kernel-small-bundles-fs-support-ramfs.md)
            - [Procfs](kernel/kernel-small-bundles-fs-support-procfs.md)
          - [适配新的文件系统](kernel/kernel-small-bundles-fs-new.md)
      - 调测与工具
        - Shell
          - [Shell介绍](kernel/kernel-small-debug-shell-overview.md)
          - [Shell命令开发指导](kernel/kernel-small-debug-shell-guide.md)
          - [Shell命令编程实例](kernel/kernel-small-debug-shell-build.md)
          - Shell命令使用详解
            - 系统命令
              - [cpup](kernel/kernel-small-debug-shell-cmd-cpup.md)
              - [date](kernel/kernel-small-debug-shell-cmd-date.md)
              - [dmesg](kernel/kernel-small-debug-shell-cmd-dmesg.md)
              - [exec](kernel/kernel-small-debug-shell-cmd-exec.md)
              - [free](kernel/kernel-small-debug-shell-cmd-free.md)
              - [help](kernel/kernel-small-debug-shell-cmd-help.md)
              - [hwi](kernel/kernel-small-debug-shell-cmd-hwi.md)
              - [kill](kernel/kernel-small-debug-shell-cmd-kill.md)
              - [log](kernel/kernel-small-debug-shell-cmd-log.md)
              - [memcheck](kernel/kernel-small-debug-shell-cmd-memcheck.md)
              - [oom](kernel/kernel-small-debug-shell-cmd-oom.md)
              - [pmm](kernel/kernel-small-debug-shell-cmd-pmm.md)
              - [reset](kernel/kernel-small-debug-shell-cmd-reset.md)
              - [sem](kernel/kernel-small-debug-shell-cmd-sem.md)
              - [stack](kernel/kernel-small-debug-shell-cmd-stack.md)
              - [su](kernel/kernel-small-debug-shell-cmd-su.md)
              - [swtmr](kernel/kernel-small-debug-shell-cmd-swtmr.md)
              - [systeminfo](kernel/kernel-small-debug-shell-cmd-sysinfo.md)
              - [task](kernel/kernel-small-debug-shell-cmd-task.md)
              - [uname](kernel/kernel-small-debug-shell-cmd-uname.md)
              - [vmm](kernel/kernel-small-debug-shell-cmd-vmm.md)
              - [watch](kernel/kernel-small-debug-shell-cmd-watch.md)
              - [reboot](kernel/kernel-small-debug-shell-cmd-reboot.md)
              - [top](kernel/kernel-small-debug-shell-cmd-top.md)
            - 文件命令
              - [cat](kernel/kernel-small-debug-shell-file-cat.md)
              - [cd](kernel/kernel-small-debug-shell-file-cd.md)
              - [chgrp](kernel/kernel-small-debug-shell-file-chgrp.md)
              - [chmod](kernel/kernel-small-debug-shell-file-chmod.md)
              - [chown](kernel/kernel-small-debug-shell-file-chown.md)
              - [cp](kernel/kernel-small-debug-shell-file-cp.md)
              - [format](kernel/kernel-small-debug-shell-file-format.md)
              - [ls](kernel/kernel-small-debug-shell-file-ls.md)
              - [lsfd](kernel/kernel-small-debug-shell-file-lsfd.md)
              - [mkdir](kernel/kernel-small-debug-shell-file-mkdir.md)
              - [mount](kernel/kernel-small-debug-shell-file-mount.md)
              - [partinfo](kernel/kernel-small-debug-shell-file-partinfo.md)
              - [partition](kernel/kernel-small-debug-shell-file-partition.md)
              - [pwd](kernel/kernel-small-debug-shell-file-pwd.md)
              - [rm](kernel/kernel-small-debug-shell-file-rm.md)
              - [rmdir](kernel/kernel-small-debug-shell-file-rmdir.md)
              - [statfs](kernel/kernel-small-debug-shell-file-statfs.md)
              - [sync](kernel/kernel-small-debug-shell-file-sync.md)
              - [touch](kernel/kernel-small-debug-shell-file-touch.md)
              - [writeproc](kernel/kernel-small-debug-shell-file-write.md)
              - [umount](kernel/kernel-small-debug-shell-file-umount.md)
              - [du](kernel/kernel-small-debug-shell-file-du.md)
              - [mv](kernel/kernel-small-debug-shell-file-mv.md)
            - 网络命令
              - [arp](kernel/kernel-small-debug-shell-net-arp.md)
              - [dhclient](kernel/kernel-small-debug-shell-net-dhclient.md)
              - [ifconfig](kernel/kernel-small-debug-shell-net-ifconfig.md)
              - [ipdebug](kernel/kernel-small-debug-shell-net-ipdebug.md)
              - [netstat](kernel/kernel-small-debug-shell-net-netstat.md)
              - [ntpdate](kernel/kernel-small-debug-shell-net-ntpdate.md)
              - [ping](kernel/kernel-small-debug-shell-net-ping.md)
              - [ping6](kernel/kernel-small-debug-shell-net-ping6.md)
              - [telnet](kernel/kernel-small-debug-shell-net-telnet.md)
              - [tftp](kernel/kernel-small-debug-shell-net-tftp.md)
          - [魔法键使用方法](kernel/kernel-small-debug-shell-magickey.md)
          - [用户态异常信息说明](kernel/kernel-small-debug-shell-error.md)
        - [Trace](kernel/kernel-small-debug-trace.md)
        - [Perf调测](kernel/kernel-mini-memory-perf.md)
        - [LMS调测](kernel/kernel-small-memory-lms.md)
        - [CPU占用率](kernel/kernel-small-debug-process-cpu.md)
        - 内核态内存调测
          - [内存信息统计](kernel/kernel-small-debug-memory-info.md)
          - [内存泄漏检测](kernel/kernel-small-debug-memory-leak.md)
          - [踩内存检测](kernel/kernel-small-debug-memory-corrupt.md)
        - 用户态内存调测
          - [基本概念](kernel/kernel-small-debug-user-concept.md)
          - [运行机制](kernel/kernel-small-debug-user-function.md)
          - 使用指导
            - [接口说明](kernel/kernel-small-debug-user-guide-api.md)
            - 使用说明
              - [接口调用方式](kernel/kernel-small-debug-user-guide-use-api.md)
              - [命令行参数方式](kernel/kernel-small-debug-user-guide-use-cli.md)
          - [常见问题场景](kernel/kernel-small-debug-user-faqs.md)
        - 其他内核调测手段
          - [临终遗言](kernel/kernel-small-debug-trace-other-lastwords.md)
          - [常见问题定位方法](kernel/kernel-small-debug-trace-other-faqs.md)
      - 附录
        - 基本数据结构
          - [双向链表](kernel/kernel-small-apx-dll.md)
          - [位操作](kernel/kernel-small-apx-bitwise.md)
        - [标准库](kernel/kernel-small-apx-library.md)
    - 标准系统内核
      - [Linux内核概述](kernel/kernel-standard-overview.md)
      - [开发板Patch使用指导](kernel/kernel-standard-patch.md)
      - [Linux内核编译与构建指导](kernel/kernel-standard-build.md)
      - 内核增强特性
        - [Enhanced SWAP特性介绍](kernel/kernel-standard-mm-eswap.md)
        - 任务调度
          - [关联线程组调度](kernel/kernel-standard-sched-rtg.md)
          - [CPU轻量级隔离](kernel/kernel-standard-sched-cpuisolation.md)
  - 驱动
    - HDF驱动框架
      - [HDF开发概述](driver/driver-hdf-overview.md)
      - [驱动开发](driver/driver-hdf-development.md)
      - [驱动服务管理](driver/driver-hdf-servicemanage.md)
      - [驱动消息机制管理](driver/driver-hdf-message-management.md)
      - [配置管理](driver/driver-hdf-manage.md)
      - [HDF开发实例](driver/driver-hdf-sample.md)
    - 平台驱动开发
      - [ADC](driver/driver-platform-adc-develop.md)
      - [DAC](driver/driver-platform-dac-develop.md)
      - [GPIO](driver/driver-platform-gpio-develop.md)
      - [HDMI](driver/driver-platform-hdmi-develop.md)
      - [I2C](driver/driver-platform-i2c-develop.md)
      - [I3C](driver/driver-platform-i3c-develop.md)
      - [MIPI CSI](driver/driver-platform-mipicsi-develop.md)
      - [MIPI DSI](driver/driver-platform-mipidsi-develop.md)
      - [MMC](driver/driver-platform-mmc-develop.md)
      - [PIN](driver/driver-platform-pin-develop.md)
      - [PWM](driver/driver-platform-pwm-develop.md)
      - [Regulator](driver/driver-platform-regulator-develop.md)
      - [RTC](driver/driver-platform-rtc-develop.md)
      - [SDIO](driver/driver-platform-sdio-develop.md)
      - [SPI](driver/driver-platform-spi-develop.md)
      - [UART](driver/driver-platform-uart-develop.md)
      - [WatchDog](driver/driver-platform-watchdog-develop.md)
    - 平台驱动使用
      - [ADC](driver/driver-platform-adc-des.md)
      - [DAC](driver/driver-platform-dac-des.md)
      - [GPIO](driver/driver-platform-gpio-des.md)
      - [HDMI](driver/driver-platform-hdmi-des.md)
      - [I2C](driver/driver-platform-i2c-des.md)
      - [I3C](driver/driver-platform-i3c-des.md)
      - [MIPI CSI](driver/driver-platform-mipicsi-des.md)
      - [MIPI DSI](driver/driver-platform-mipidsi-des.md)
      - [PIN](driver/driver-platform-pin-des.md)
      - [PWM](driver/driver-platform-pwm-des.md)
      - [Regulator](driver/driver-platform-regulator-des.md)
      - [RTC](driver/driver-platform-rtc-des.md)
      - [SDIO](driver/driver-platform-sdio-des.md)
      - [SPI](driver/driver-platform-spi-des.md)
      - [UART](driver/driver-platform-uart-des.md)
      - [WatchDog](driver/driver-platform-watchdog-des.md)
    - 外设驱动使用
      - [Audio](driver/driver-peripherals-audio-des.md)
      - [Camera](driver/driver-peripherals-camera-des.md)
      - [Face_auth](driver/driver-peripherals-face_auth-des.md)
      - [Fingerprint_auth](driver/driver-peripherals-fingerprint_auth-des.md)
      - [LCD](driver/driver-peripherals-lcd-des.md)
      - [Light](driver/driver-peripherals-light-des.md)
      - [Pin_auth](driver/driver-peripherals-pinauth-des.md)
      - [Sensor](driver/driver-peripherals-sensor-des.md)
      - [Touchscreen](driver/driver-peripherals-touch-des.md)
      - [USB](driver/driver-peripherals-usb-des.md)
      - [User_auth](driver/driver-peripherals-user-auth-des.md)
      - [Vibrator](driver/driver-peripherals-vibrator-des.md)
      - [WLAN](driver/driver-peripherals-external-des.md)
  - 编译构建
    - [编译构建指导](subsystems/subsys-build-all.md)
    - [构建系统编码规范和最佳实践指导](subsystems/subsys-build-gn-coding-style-and-best-practice.md)
    - [编译构建Kconfig可视化配置指导](subsystems/subsys-build-gn-kconfig-visual-config-guide.md)
  - [分布式远程启动](subsystems/subsys-remote-start.md)
  - 图形图像
    - [图形图像概述](subsystems/subsys-graphics-overview.md)
    - [容器类组件开发指导](subsystems/subsys-graphics-container-guide.md)
    - [布局容器类组件开发指导](subsystems/subsys-graphics-layout-guide.md)
    - [普通组件开发指导](subsystems/subsys-graphics-common-guide.md)
    - [动画开发指导](subsystems/subsys-graphics-animation-guide.md)
  - 媒体
    - 相机
      - [相机开发概述](subsystems/subsys-multimedia-camera-overview.md)
      - [拍照开发指导](subsystems/subsys-multimedia-camera-photo-guide.md)
      - [录像开发指导](subsystems/subsys-multimedia-camera-record-guide.md)
      - [预览开发指导](subsystems/subsys-multimedia-camera-preview-guide.md)
    - 音视频
      - [音视频开发概述](subsystems/subsys-multimedia-video-overview.md)
      - [音视频播放开发指导](subsystems/subsys-multimedia-video-play-guide.md)
      - [音视频录制开发指导](subsystems/subsys-multimedia-video-record-guide.md)
  - 公共基础
    - [公共基础库概述](subsystems/subsys-utils-overview.md)
    - [公共基础库开发指导](subsystems/subsys-utils-guide.md)
    - [公共基础库常见问题](subsystems/subsys-utils-faqs.md)
  - AI框架
    - [AI引擎框架开发指南](subsystems/subsys-aiframework-guide.md)
    - [搭建环境](subsystems/subsys-aiframework-envbuild.md)
    - 技术规范
      - [代码管理规范](subsystems/subsys-aiframework-tech-codemanage.md)
      - [命名规范](subsystems/subsys-aiframework-tech-name.md)
      - [接口开发规范](subsystems/subsys-aiframework-tech-interface.md)
    - 开发指导
      - [SDK开发过程](subsystems/subsys-aiframework-devguide-sdk.md)
      - [插件的开发过程](subsystems/subsys-aiframework-devguide-plugin.md)
      - [配置文件的开发过程](subsystems/subsys-aiframework-devguide-conf.md)
    - 开发示例
      - [唤醒词识别SDK的开发示例](subsystems/subsys-aiframework-demo-sdk.md)
      - [唤醒词识别插件的开发示例](subsystems/subsys-aiframework-demo-plugin.md)
      - [唤醒词识别配置文件的开发示例](subsystems/subsys-aiframework-demo-conf.md)
  - 数据管理
    - 关系型数据库
      - [关系型数据库概述](subsystems/subsys-data-relational-database-overview.md)
      - [关系型数据库开发指导](subsystems/subsys-data-relational-database-guide.md)
    - 轻量级数据存储
      - [轻量级数据存储概述](subsystems/subsys-data-storage-overview.md)
      - [轻量级数据存储开发指导](subsystems/subsys-data-storage-guide.md)
  - Sensor服务
    - [Sensor服务概述](subsystems/subsys-sensor-overview.md)
    - [Sensor服务使用指导](subsystems/subsys-sensor-guide.md)
    - [Sensor服务使用实例](subsystems/subsys-sensor-demo.md)
  - USB服务子系统
    - [USB服务概述](subsystems/subsys-usbservice-overview.md)
    - [USB服务使用指导](subsystems/subsys-usbservice-guide.md)
    - [USB服务使用实例](subsystems/subsys-usbservice-demo.md)
  - 用户程序框架
    - [概述](subsystems/subsys-application-framework-overview.md)
    - [搭建环境](subsystems/subsys-application-framework-envbuild.md)
    - [开发指导](subsystems/subsys-application-framework-guide.md)
    - [开发实例](subsystems/subsys-application-framework-demo.md)
  - [OTA升级](subsystems/subsys-ota-guide.md)
  - 电话服务
    - [电话服务概述](subsystems/subsys-tel-overview.md)
    - [电话服务开发指导](subsystems/subsys-tel-guide.md)
  - 安全
    - [概述](subsystems/subsys-security-overview.md)
    - [应用验签开发指导](subsystems/subsys-security-sigverify.md)
    - [应用权限管理开发指导](subsystems/subsys-security-rightmanagement.md)
    - [IPC通信鉴权开发指导](subsystems/subsys-security-communicationverify.md)
    - [设备安全等级管理开发指导](subsystems/subsys-security-devicesecuritylevel.md)
  - 启动恢复
    - [启动恢复子系统概述](subsystems/subsys-boot-overview.md)
    - init启动引导组件
      - [引导启动配置文件](subsystems/subsys-boot-init-cfg.md)
      - [jobs管理](subsystems/subsys-boot-init-jobs.md)
      - [服务管理](subsystems/subsys-boot-init-service.md)
      - [系统参数](subsystems/subsys-boot-init-sysparam.md)
      - [沙盒管理](subsystems/subsys-boot-init-sandbox.md)
      - [插件](subsystems/subsys-boot-init-plugin.md)
    - [appspawn应用孵化组件](subsystems/subsys-boot-appspawn.md)
    - [bootstrap服务启动组件](subsystems/subsys-boot-bootstrap.md)
    - [常见问题](subsystems/subsys-boot-faqs.md)
    - [参考](subsystems/subsys-boot-ref.md)
  - DFX
    - [DFX概述](subsystems/subsys-dfx-overview.md)
    - [HiLog开发指导](subsystems/subsys-dfx-hilog-rich.md)
    - [HiLog\_Lite开发指导](subsystems/subsys-dfx-hilog-lite.md)
    - [HiTrace开发指导](subsystems/subsys-dfx-hitrace.md)
    - [HiCollie开发指导](subsystems/subsys-dfx-hicollie.md)
    - HiSysEvent开发指导
      - [HiSysEvent打点配置指导](subsystems/subsys-dfx-hisysevent-logging-config.md)
      - [HiSysEvent打点指导](subsystems/subsys-dfx-hisysevent-logging.md)
      - [HiSysEvent订阅指导](subsystems/subsys-dfx-hisysevent-listening.md)
      - [HiSysEvent查询指导](subsystems/subsys-dfx-hisysevent-query.md)
      - [HiSysEvent工具使用指导](subsystems/subsys-dfx-hisysevent-tool.md)
    - [HiDumper开发指导](subsystems/subsys-dfx-hidumper.md)
    - [HiChecker开发指导](subsystems/subsys-dfx-hichecker.md)
    - [Faultlogger开发指导](subsystems/subsys-dfx-faultlogger.md)
    - [Hiview开发指导](subsystems/subsys-dfx-hiview.md)

- 专题
  - HPM Part
    - [HPM Part介绍](hpm-part/hpm-part-about.md)
    - [HPM Part开发指导](hpm-part/hpm-part-development.md)
    - [HPM Part参考](hpm-part/hpm-part-reference.md)

- 设备开发示例

  - 轻量和小型系统设备
    - WLAN连接类产品
      - [LED外设控制](guide/device-wlan-led-control.md)
      - [集成三方SDK](guide/device-wlan-sdk.md)
    - 无屏摄像头类产品
      - 摄像头控制
        - [概述](guide/device-iotcamera-control-overview.md)
        - 示例开发
          - [拍照开发指导](guide/device-iotcamera-control-demo-photodevguide.md)
          - [录像开发指导](guide/device-iotcamera-control-demo-videodevguide.md)
        - [应用实例](guide/device-iotcamera-control-example.md)
    - 带屏摄像头类产品
      - 屏幕和摄像头控制
        - [概述](guide/device-camera-control-overview.md)
        - 示例开发
          - [拍照开发指导](guide/device-camera-control-demo-photoguide.md)
          - [录像开发指导](guide/device-camera-control-demo-videoguide.md)
          - [预览开发指导](guide/device-camera-control-demo-previewguide.md)
        - [应用实例](guide/device-camera-control-example.md)
      - 视觉应用开发
        - [概述](guide/device-camera-visual-overview.md)
        - [开发准备](guide/device-camera-visual-prepare.md)
        - [添加页面](guide/device-camera-visual-addpage.md)
        - [开发首页](guide/device-camera-visual-firstpage.md)
        - [开发详情页](guide/device-camera-visual-details.md)
        - [调试打包](guide/device-camera-visual-debug.md)
        - [真机运行](guide/device-camera-visual-run.md)
        - [常见问题](guide/device-camera-visual-faqs.md)
  - 标准系统设备
    - [时钟应用开发指导](guide/device-clock-guide.md)
    - [平台驱动开发示例](guide/device-driver-demo.md)
    - [外设驱动开发示例](guide/device-outerdriver-demo.md)

- 调测

  - [测试用例开发](subsystems/subsys-testguide-test.md)
  - 调测工具
    - [bytrace使用指导](subsystems/subsys-toolchain-bytrace-guide.md)
    - [hdc\_std 使用指导](subsystems/subsys-toolchain-hdc-guide.md)
    - [hiperf 使用指南](subsystems/subsys-toolchain-hiperf.md)

- [XTS认证](subsystems/subsys-xts-guide.md)

- 工具

  - [Docker编译环境](get-code/gettools-acquire.md)
  - [IDE集成开发环境](get-code/gettools-ide.md)

- 示例教程

  - [Demo示例](https://growing.openharmony.cn/mainPlay/sample)
  - [Codelabs](https://gitee.com/openharmony/codelabs/blob/master/README.md) 

- 参考
  - 常见问题
    - [常见问题概述](faqs/faqs-overview.md)
    - [环境搭建常见问题](faqs/faqs-environment-setup.md)
    - [编译构建常见问题](faqs/faqs-building.md)
    - [烧录常见问题](faqs/faqs-burning.md)
    - [内核常见问题](faqs/faqs-kernel.md)
    - [移植常见问题](faqs/faqs-porting.md)
    - [启动恢复常见问题](faqs/faqs-startup.md)
    - [系统应用常见问题](faqs/faqs-system-applications.md)
  
  - HDI接口参考
    - 模块
      - [Audio](reference/hdi-apis/_audio.md)
      - [Battery](reference/hdi-apis/battery.md)
      - [Camera](reference/hdi-apis/_camera.md)
      - [Codec](reference/hdi-apis/_codec.md)
      - [Display](reference/hdi-apis/_display.md)
      - [HdfFaceAuth](reference/hdi-apis/_hdf_face_auth.md)
      - [Input](reference/hdi-apis/_input.md)
      - [Light](reference/hdi-apis/_light.md)
      - [HdfPinAuth](reference/hdi-apis/_hdf_pin_auth.md)
      - [Power](reference/hdi-apis/power.md)
      - [Sensor](reference/hdi-apis/_sensor.md)
      - [Thermal](reference/hdi-apis/thermal.md)
      - [USB](reference/hdi-apis/_u_s_b.md)
      - [HdfUserAuth](reference/hdi-apis/_hdf_user_auth.md)
      - [Vibrator](reference/hdi-apis/_vibrator.md)
      - [WLAN](reference/hdi-apis/_w_l_a_n.md)
    - 头文件和结构体
      - 头文件
        - [audio_adapter.h](reference/hdi-apis/audio__adapter_8h.md)
        - [audio_attribute.h](reference/hdi-apis/audio__attribute_8h.md)
        - [audio_capture.h](reference/hdi-apis/audio__capture_8h.md)
        - [audio_control.h](reference/hdi-apis/audio__control_8h.md)
        - [audio_manager.h](reference/hdi-apis/audio__manager_8h.md)
        - [audio_render.h](reference/hdi-apis/audio__render_8h.md)
        - [audio_scene.h](reference/hdi-apis/audio__scene_8h.md)
        - [audio_types.h](reference/hdi-apis/audio__types_8h.md)
        - [audio_volume.h](reference/hdi-apis/audio__volume_8h.md)
        - [codec_callback_if.h](reference/hdi-apis/codec__callback__if_8h.md)
        - [codec_common_type.h](reference/hdi-apis/codec__common__type_8h.md)
        - [codec_component_if.h](reference/hdi-apis/codec__component__if_8h.md)
        - [codec_component_manager.h](reference/hdi-apis/codec__component__manager_8h.md)
        - [codec_component_type.h](reference/hdi-apis/codec__component__type_8h.md)
        - [display_device.h](reference/hdi-apis/display__device_8h.md)
        - [display_gfx.h](reference/hdi-apis/display__gfx_8h.md)
        - [display_gralloc.h](reference/hdi-apis/display__gralloc_8h.md)
        - [display_layer.h](reference/hdi-apis/display__layer_8h.md)
        - [display_type.h](reference/hdi-apis/display__type_8h.md)
        - [icamera_device_callback.h](reference/hdi-apis/icamera__device__callback_8h.md)
        - [icamera_device.h](reference/hdi-apis/icamera__device_8h.md)
        - [icamera_host_callback.h](reference/hdi-apis/icamera__host__callback_8h.md)
        - [icamera_host.h](reference/hdi-apis/icamera__host_8h.md)
        - [input_controller.h](reference/hdi-apis/input__controller_8h.md)
        - [input_manager.h](reference/hdi-apis/input__manager_8h.md)
        - [input_reporter.h](reference/hdi-apis/input__reporter_8h.md)
        - [input_type.h](reference/hdi-apis/input__type_8h.md)
        - [ioffline_stream_operator.h](reference/hdi-apis/ioffline__stream__operator_8h.md)
        - [istream_operator_callback.h](reference/hdi-apis/istream__operator__callback_8h.md)
        - [istream_operator.h](reference/hdi-apis/istream__operator_8h.md)
        - [light_if.h](reference/hdi-apis/light__if_8h.md)
        - [light_type.h](reference/hdi-apis/light_8typeh.md)
        - [sensor_if.h](reference/hdi-apis/sensor__if_8h.md)
        - [sensor_type.h](reference/hdi-apis/sensor__type_8h.md)
        - [types.h](reference/hdi-apis/types_8h.md)
        - [usb_info.h](reference/hdi-apis/usb__info_8h.md)
        - [usbd_client.h](reference/hdi-apis/usbd__client_8h.md)
        - [usbd_subscriber.h](reference/hdi-apis/usbd__subscriber_8h.md)
        - [usbd_type.h](reference/hdi-apis/usbd__type_8h.md)
        - [vibrator_if.h](reference/hdi-apis/vibrator__if_8h.md)
        - [vibrator_type.h](reference/hdi-apis/vibrator__type_8h.md)
        - [wifi_hal_ap_feature.h](reference/hdi-apis/wifi__hal__ap__feature_8h.md)
        - [wifi_hal_base_feature.h](reference/hdi-apis/wifi__hal__base__feature_8h.md)
        - [wifi_hal_sta_feature.h](reference/hdi-apis/wifi__hal__sta__feature_8h.md)
        - [wifi_hal.h](reference/hdi-apis/wifi__hal_8h.md)
        - [IExecutor.idl](reference/hdi-apis/face__auth_2_i_executor_8idl.md)
        - [IExecutorCallback.idl](reference/hdi-apis/face__auth_2_i_executor_callback_8idl.md)
        - [FaceAuthTypes.idl](reference/hdi-apis/_face_auth_types_8idl.md)
        - [PinAuthTypes.idl](reference/hdi-apis/_pin_auth_types_8idl.md)
        - [IBatteryCallback.idl](reference/hdi-apis/_i_battery_callback_8idl.md)
        - [IBatteryInterface.idl](reference/hdi-apis/_i_battery_interface_8idl.md)
        - [IExecutor.idl](reference/hdi-apis/pin__auth_2_i_executor_8idl.md)
        - [IExecutorCallback.idl](reference/hdi-apis/pin__auth_2_i_executor_callback_8idl.md)
        - [IFaceAuthInterface.idl](reference/hdi-apis/_i_face_auth_interface_8idl.md)
        - [IPinAuthInterface.idl](reference/hdi-apis/_i_pin_auth_interface_8idl.md)
        - [IPowerHdiCallback.idl](reference/hdi-apis/_i_power_hdi_callback_8idl.md)
        - [IPowerInterface.idl](reference/hdi-apis/_i_power_interface_8idl.md)
        - [IThermalInterface.idl](reference/hdi-apis/_i_thermal_interface_8idl.md)
        - [IThermalCallback.idl](reference/hdi-apis/_i_thermal_callback_8idl.md)
        - [IUserAuthInterface.idl](reference/hdi-apis/_i_user_auth_interface_8idl.md)
        - [PowerTypes.idl](reference/hdi-apis/_power_types_8idl.md)
        - [ThermalTypes.idl](reference/hdi-apis/_thermal_types_8idl.md)
        - [Types.idl](reference/hdi-apis/_types_8idl.md)
        - [UserAuthTypes.idl](reference/hdi-apis/_user_auth_types_8idl.md)
      - 结构体
        - [attribute](reference/hdi-apis/____attribute____.md)
        - [Alignment](reference/hdi-apis/_alignment.md)
        - [AllocInfo](reference/hdi-apis/_alloc_info.md)
        - [AudioAdapter](reference/hdi-apis/_audio_adapter.md)
        - [AudioAdapterDescriptor](reference/hdi-apis/_audio_adapter_descriptor.md)
        - [AudioAttribute](reference/hdi-apis/_audio_attribute.md)
        - [AudioCapture](reference/hdi-apis/_audio_capture.md)
        - [AudioControl](reference/hdi-apis/_audio_control.md)
        - [AudioDevExtInfo](reference/hdi-apis/_audio_dev_ext_info.md)
        - [AudioDeviceDescriptor](reference/hdi-apis/_audio_device_descriptor.md)
        - [AudioManager](reference/hdi-apis/_audio_manager.md)
        - [AudioMixExtInfo](reference/hdi-apis/_audio_mix_ext_info.md)
        - [AudioMmapBufferDescripter](reference/hdi-apis/_audio_mmap_buffer_descripter.md)
        - [AudioPort](reference/hdi-apis/_audio_port.md)
        - [AudioPortCap](reference/hdi-apis/_audio_port_cap.md)
        - [AudioPortCapability](reference/hdi-apis/_audio_port_capability.md)
        - [AudioRender](reference/hdi-apis/_audio_render.md)
        - [AudioRoute](reference/hdi-apis/_audio_route.md)
        - [AudioRouteNode](reference/hdi-apis/_audio_route_node.md)
        - [AudioSampleAttributes](reference/hdi-apis/_audio_sample_attributes.md)
        - [AudioScene](reference/hdi-apis/_audio_scene.md)
        - [AudioSceneDescriptor](reference/hdi-apis/_audio_scene_descriptor.md)
        - [AudioSceneDescriptor::SceneDesc](reference/hdi-apis/union_audio_scene_descriptor_1_1_scene_desc.md)
        - [AudioSessionExtInfo](reference/hdi-apis/_audio_session_ext_info.md)
        - [AudioSubPortCapability](reference/hdi-apis/_audio_sub_port_capability.md)
        - [AudioTimeStamp](reference/hdi-apis/_audio_time_stamp.md)
        - [AudioVolume](reference/hdi-apis/_audio_volume.md)
        - [AuthResultInfo](reference/hdi-apis/_auth_result_info.md)
        - [AuthSolution](reference/hdi-apis/_auth_solution.md)
        - [BatteryInfo](reference/hdi-apis/_battery_info.md)
        - [BufferData](reference/hdi-apis/_buffer_data.md)
        - [CodecCallbackType](reference/hdi-apis/_codec_callback_type.md)
        - [CodecCompCapability](reference/hdi-apis/_codec_comp_capability.md)
        - [CodecComponentManager](reference/hdi-apis/_codec_component_manager.md)
        - [CodecComponentType](reference/hdi-apis/_codec_component_type.md)
        - [CompVerInfo](reference/hdi-apis/_comp_ver_info.md)
        - [CredentialInfo](reference/hdi-apis/_credential_info.md)
        - [DeviceFuncs](reference/hdi-apis/_device_funcs.md)
        - [DisplayCapability](reference/hdi-apis/_display_capability.md)
        - [DisplayInfo](reference/hdi-apis/_display_info.md)
        - [DisplayModeInfo](reference/hdi-apis/_display_mode_info.md)
        - [EnrolledInfo](reference/hdi-apis/_enrolled_info.md)
        - [EnrollParam](reference/hdi-apis/_enroll_param.md)
        - [EnrollResultInfo](reference/hdi-apis/_enroll_resultinfo.md)
        - [EventInfo](reference/hdi-apis/_event_info.md)
        - [ExecutorInfo](reference/hdi-apis/_executor_info.md)
        - [ExecutorInfo](reference/hdi-apis/_user_executor_info.md)
        - [ExecutorRegisterInfo](reference/hdi-apis/_executor_register_info.md)
        - [ExecutorSendMsg](reference/hdi-apis/_executor_send_msg.md)
        - [GetBufferHandleUsageParams](reference/hdi-apis/_get_buffer_handle_usage_params.md)
        - [GfxFuncs](reference/hdi-apis/_gfx_funcs.md)
        - [GfxOpt](reference/hdi-apis/_gfx_opt.md)
        - [GrallocFuncs](reference/hdi-apis/_gralloc_funcs.md)
        - [HdfThermalCallbackInfo](reference/hdi-apis/_hdf_thermal_callback_info.md)
        - [HDRCapability](reference/hdi-apis/_h_d_r_capability.md)
        - [HDRMetaData](reference/hdi-apis/_h_d_r_meta_data.md)
        - [IBatteryCallback](reference/hdi-apis/interface_i_battery_callback.md)
        - [IBatteryInterface](reference/hdi-apis/interface_i_battery_interface.md)
        - [ICircle](reference/hdi-apis/_i_circle.md)
        - [IdentifyResultInfo](reference/hdi-apis/_identify_result_info.md)
        - [IExecutor](reference/hdi-apis/interface_i_executor.md)
        - [IExecutor](reference/hdi-apis/interface_pin_i_executor.md)
        - [IExecutorCallback](reference/hdi-apis/interface_i_executor_callback.md)
        - [IExecutorCallback](reference/hdi-apis/interface_pin_i_executor_callback.md)
        - [IFaceAuthInterface](reference/hdi-apis/interface_i_face_auth_interface.md)
        - [IInputInterface](reference/hdi-apis/_i_input_interface.md)
        - [ILine](reference/hdi-apis/_i_line.md)
        - [InputController](reference/hdi-apis/_input_controller.md)
        - [InputDevAbility](reference/hdi-apis/_input_dev_ability.md)
        - [InputDevAttr](reference/hdi-apis/_input_dev_attr.md) 
        - [InputDevDesc](reference/hdi-apis/_input_dev_desc.md)
        - [InputDevIdentify](reference/hdi-apis/_input_dev_identify.md)
        - [InputDeviceInfo](reference/hdi-apis/_device_info.md)
        - [InputDimensionInfo](reference/hdi-apis/_input_dimension_info.md) 
        - [InputEventCb](reference/hdi-apis/_input_report_event_cb.md)
        - [InputEventPackage](reference/hdi-apis/_event_package.md)
        - [InputExtraCmd](reference/hdi-apis/_input_extra_cmd.md)
        - [InputHostCb](reference/hdi-apis/_input_host_cb.md)
        - [InputHotPlugEvent](reference/hdi-apis/_input_hotplug_event.md)
        - [InputManager](reference/hdi-apis/_input_manager.md)
        - [InputReporter](reference/hdi-apis/_input_reporter.md)
        - [IPinAuthInterface](reference/hdi-apis/interface_i_pin_auth_interface.md)
        - [IPowerHdiCallback](reference/hdi-apis/interface_i_power_hdi_callback.md)
        - [IPowerInterface](reference/hdi-apis/interface_i_power_interface.md)
        - [IRect](reference/hdi-apis/_i_rect.md)
        - [ISurface](reference/hdi-apis/_i_surface.md)
        - [IThermalCallback](reference/hdi-apis/interface_i_thermal_callback.md)
        - [IThermalInterface](reference/hdi-apis/interface_i_thermal_interface.md)
        - [IUserAuthInterface](reference/hdi-apis/interface_i_user_auth_interface.md)
        - [IWiFi](reference/hdi-apis/_i_wi_fi.md)
        - [IWiFiAp](reference/hdi-apis/_i_wi_fi_ap.md)
        - [IWiFiBaseFeature](reference/hdi-apis/_i_wi_fi_base_feature.md)
        - [IWiFiSta](reference/hdi-apis/_i_wi_fi_sta.md)
        - [LayerAlpha](reference/hdi-apis/_layer_alpha.md)
        - [LayerBuffer](reference/hdi-apis/_layer_buffer.md)
        - [LayerFuncs](reference/hdi-apis/_layer_funcs.md)
        - [LayerInfo](reference/hdi-apis/_layer_info.md)
        - [LightEffect](reference/hdi-apis/_light_effect.md)
        - [LightFlashEffect](reference/hdi-apis/_light_flash_effect.md)
        - [LightInfo](reference/hdi-apis/_light_info.md)
        - [LightInterface](reference/hdi-apis/_light_interface.md)
        - [OHOS::Camera::CaptureEndedInfo](reference/hdi-apis/_o_h_o_s_1_1_camera_1_1_capture_ended_info.md)
        - [OHOS::Camera::CaptureErrorInfo](reference/hdi-apis/_o_h_o_s_1_1_camera_1_1_capture_error_info.md)
        - [OHOS::Camera::CaptureInfo](reference/hdi-apis/_o_h_o_s_1_1_camera_1_1_capture_info.md)
        - [OHOS::Camera::ICameraDevice](reference/hdi-apis/_o_h_o_s_1_1_camera_1_1_i_camera_device.md)
        - [OHOS::Camera::ICameraDeviceCallback](reference/hdi-apis/_o_h_o_s_1_1_camera_1_1_i_camera_device_callback.md)
        - [OHOS::Camera::ICameraHost](reference/hdi-apis/_o_h_o_s_1_1_camera_1_1_i_camera_host.md)
        - [OHOS::Camera::ICameraHostCallback](reference/hdi-apis/_o_h_o_s_1_1_camera_1_1_i_camera_host_callback.md)
        - [OHOS::Camera::IOfflineStreamOperator](reference/hdi-apis/_o_h_o_s_1_1_camera_1_1_i_offline_stream_operator.md)
        - [OHOS::Camera::IStreamOperator](reference/hdi-apis/_o_h_o_s_1_1_camera_1_1_i_stream_operator.md)
        - [OHOS::Camera::IStreamOperatorCallback](reference/hdi-apis/_o_h_o_s_1_1_camera_1_1_i_stream_operator_callback.md)
        - [OHOS::Camera::StreamAttribute](reference/hdi-apis/_o_h_o_s_1_1_camera_1_1_stream_attribute.md)
        - [OHOS::Camera::StreamInfo](reference/hdi-apis/_o_h_o_s_1_1_camera_1_1_stream_info.md)
        - [OHOS::USB::UsbCtrlTransfer](reference/hdi-apis/_o_h_o_s_1_1_u_s_b_1_1_usb_ctrl_transfer.md)
        - [OHOS::USB::UsbdClient](reference/hdi-apis/_o_h_o_s_1_1_u_s_b_1_1_usbd_client.md)
        - [OHOS::USB::UsbDev](reference/hdi-apis/_o_h_o_s_1_1_u_s_b_1_1_usb_dev.md)
        - [OHOS::USB::USBDeviceInfo](reference/hdi-apis/_o_h_o_s_1_1_u_s_b_1_1_u_s_b_device_info.md)
        - [OHOS::USB::UsbdSubscriber](reference/hdi-apis/_o_h_o_s_1_1_u_s_b_1_1_usbd_subscriber.md)
        - [OHOS::USB::UsbInfo](reference/hdi-apis/_o_h_o_s_1_1_u_s_b_1_1_usb_info.md)
        - [OHOS::USB::UsbPipe](reference/hdi-apis/_o_h_o_s_1_1_u_s_b_1_1_usb_pipe.md)
        - [OmxCodecBuffer](reference/hdi-apis/_omx_codec_buffer.md)
        - [PortCap](reference/hdi-apis/union_port_cap.md)
        - [PresentTimestamp](reference/hdi-apis/_present_timestamp.md)
        - [PropertyObject](reference/hdi-apis/_property_object.md)
        - [RangeValue](reference/hdi-apis/_range_value.md)
        - [Rect](reference/hdi-apis/_rect.md)
        - [Rectangle](reference/hdi-apis/_rectangle.md)
        - [ScheduleInfo](reference/hdi-apis/_schedule_info.md)
        - [SensorEvents](reference/hdi-apis/_sensor_events.md)
        - [SensorInformation](reference/hdi-apis/_sensor_information.md)
        - [SensorInterface](reference/hdi-apis/_sensor_interface.md)
        - [StaInfo](reference/hdi-apis/_sta_info.md)
        - [SupportBufferType](reference/hdi-apis/_support_buffer_type.md)
        - [TemplateInfo](reference/hdi-apis/_template_info.md)
        - [ThermalZoneInfo](reference/hdi-apis/_thermal_zone_info.md)
        - [UseBufferType](reference/hdi-apis/_use_buffer_type.md)
        - [VerifyAllocInfo](reference/hdi-apis/_verify_alloc_info.md)
        - [VibratorInterface](reference/hdi-apis/_vibrator_interface.md)
        - [VideoPortCap](reference/hdi-apis/_video_port_cap.md)