# OpenHarmony部件设计和开发指南

## 前言

组件化、部件化、模块化是指软件基于组件、部件、模块解耦，实现各个领域软件分而治之的软件设计方法。它们的关系为：**组件**(可独立部署、二进制复用) > **部件**(可独立开发、编译和测试) > **模块**(代码级复用)。

OpenHarmony参考机械装配领域的零部件的概念将系统能力抽象为部件，通过拼装和配置部件的方式定制适用于不同设备的操作系统。

## 部件定义

部件是体现系统能力的基本单元，以源码为划分依据，具有独立的文件和目录，在不同设备上可以实例化为相应的库或可执行文件。

## 部件划分

部件按照如下原则进行划分：

- 具备独立的代码目录，可独立编译出库或可执行文件。

- 小型和标准系统中的部件应具备独立部署的能力，非必选的部件被裁剪后不会导致系统异常。

- 功能可独立测试和验证。

部件在架构上按子系统归类，子系统是逻辑概念，它由具体的部件组成。

另外，几点说明如下：

- 对于具有可配置特性的部件，特性可按需配置，特性有无不应导致部件对外提供的接口变化。

- 被依赖的第三方开源软件库和提供基础能力的部件，称为**依赖部件**，跟随其他部件一起部署。

- 如果部件可拆分出更小的功能模块并向应用提供API，称这类模块为**子部件**，跟随父部件一起部署，无法独立部署。子部件依赖父部件，但父部件不允许依赖子部件。

## 基本原则

部件在设计和开发时应遵循如下规则和建议：

**规则1.1** 部件应当实现独立自制原则，保持部件本身的解耦和独立。

**规则1.2** 部件应该去中心化治理，部件间的依赖关系应简单清晰合理。

**规则1.3** 禁止部件间反向依赖、循环依赖，下层部件禁止依赖上层部件。

**规则1.4** 禁止部件的实现依赖特定的开发板或产品形态。

**规则1.5** 部件接口应保持稳定，已发布的接口不能变化，保持接口兼容。

**建议1.1** 部件应支持自动化构建和验证的能力。

## 命名规则

#### **部件名**

英文名：名词形式，需体现部件的功能，在系统内全局唯一，不超过63个有效英文字符，使用小写加下划线的内核风格命名，例如：unix_like。<br>
中文名：名词形式，需体现部件的功能，不超过16个中文字符，不建议中英文混合。

#### **仓名**

部件仓名使用英文，命名规则：<子系统>_<部件>，例如：文件管理子系统的存储服务部件的仓名为“filemanagement_storage_service”。仓名总长度不超过100个字符。

> 说明：
>
> 1）部件和仓原则上是一一对应关系，特殊情况下多个部件可以共享一个仓，但部件的目录必须独立。
>
> 2）第三方开源的部件名保持第三方原始的命名，仓名前添加“third_party”前缀。第三方开源部件统一放到third_party目录下。
>
> 3）仓名和路径名中的子系统名均不带下划线。

#### **路径**

部件目录使用英文，路径规则：<领域>/<子系统>/<部件>， 例如：foundation/filemanagement/storage_service。

#### **部件目录结构**

```xml
├── interfaces          # 接口
│   ├── kits			# 应用接口，可选
│   │    ├── js			# JS接口，可选
│   │    └── native  	# C/C++接口，可选
│   └── inner_api       # 系统内部件间接口
├── frameworks          # 部件无独立进程的实现，可选
│   ├── native          # C/C++实现，可选
│   └── js              # JS API的实现，可选
│        ├── napi       # napi代码实现，可选
│        ├── builtin	# 仅用于LiteOS-M，可选
│        └── plugin     # Ark UI特有，可选
├── services            # 独立进程的实现，可选
├── test                # 测试代码，必选
├── BUILD.gn            # 编译入口，必选
└── bundle.json         # 部件描述文件，必选
```

## 部件增删改

部件的新增、合并、删除需经架构SIG（Special Interest Group）和[相关领域的SIG leader](https://gitee.com/openharmony/community/blob/master/sig/sigs_subsystem_list.md)评审，流程如下：

1、准备如下的部件属性列表：

表1. 部件属性评审表

| 部件属性     | 说明                                                         |
| ------------ | ------------------------------------------------------------ |
| 英文名称     | 名词形式，需体现部件的功能，在系统内全局唯一，不超过63个有效英文字符，使用小写加下划线的内核风格命名，例如：unix_like。                                           |
| 中文名称     | 名词形式，需体现部件的功能，不超过16个中文字符，不建议中英文混合。 |
| 子系统       | 部件归属的子系统。                                             |
| 功能描述     | 一句话简要描述部件功能，100字以内。                          |
| 可配置特性   | 部件对外可配置的特性。                                       |
| 适用系统类型 | 部件适用的系统类型：小型、轻量和标准，可以同时支持多种。       |
| 源码目录     | 部件的源码根目录。                                           |
| ROM          | 部件设计的ROM基线值。                                        |
| RAM          | 部件设计的RAM基线值。                                        |
| 依赖         | 部件依赖的其他部件和开源软件。                               |


2、发邮件给架构SIG(dev@openharmony.io)和[相关领域的SIG leader](https://gitee.com/openharmony/community/blob/master/sig/sigs_subsystem_list.md)进行邮件评审，邮件标题【OpenHarmony部件新增/合并/删除评审申请】，邮件正文中按部件实际情况填写“表1.部件属性评审表" 。

> 说明：部件修改/合并需提供修改/合并前后部件属性，提供待删除的部件停止维护的计划。删除和合并部件要谨慎，要评估对存量版本的影响。

3、评审通过后，请按[SIG管理章程](https://gitee.com/openharmony/community/tree/master/sig)新建部件仓和修改manifest，SIG孵化完成后合入OpenHarmony组织代码主库。