# TS组件接口说明模板

## 总体写作说明

|      | 说明项         | 细则                                       |
| ---- | ----------- | ---------------------------------------- |
| 1    | 客户化写作基本要求   | **写作中，请变身开发者，对于开发者使用该组件时所需的使用场景、参数选取原则、开发建议/经验、示例等信息进行清晰描述，达到指导开发者顺利使用本组件进行开发的目标。** |
| 2    |             | **所有的写作说明，在完成写作后，都要删除。**                 |
| 3    | 上传路径        | markdown文件：docs/zh-cn/application-dev/reference/arkui-ts<br>图片路径：docs/zh-cn/application-dev/reference/arkui-ts/figures，并在markdown文件中通过路径`![](figures/xxx.jpg)`或`![](figures/xxx.png)`引用。 |
| 4    | 文件命名        | 一个d.ts对应一个组件文档，文件名称需包含组件所属类和组件名，格式为：**ts-组件所属类名-组件名.md**。<br/>示例：<br/>基础组件text，文件命名为：ts-basic-component-text.md<br/>容器组件list，文件命名为：js-container-component-list.md |
| 5    | 目录修改        | 新增文件，需要修改对应的Readme，即`docs/zh-cn/application-dev/reference/arkui-ts/Readme-CN.md`。 |
| 6    | 文档结构        | - 模块说明<br/>- 起始版本说明<br/>- 导入模块/使用说明<br/>- 权限说明<br>- 接口、属性、事件、对象、枚举、自定义类型<br/>  描述顺序和代码保持一致，如果某些接口具有逻辑顺序，请注意排列。 |
| 7    | 接口版本说明      | 1. 每个模块要有起始版本说明，使用引用语法“>”对接口的起始版本进行说明。接口没有标记的，默认与模块同一个起始版本。<br/>2. 已有模块新增接口使用\<sup>标签标记对应版本号。写法：`<sup>版本号+</sup>`<br/> 例如`<sup>7+</sup>`<br/> 示例：API 6已有的模块，在API 7新增了一个属性字段，则在属性后加标记，即newAttribute<sup>7+</sup>。|
| 8    | 废弃接口说明      | 废弃内容不能直接删去，在废弃内容后面加标注deprecated，并使用“>”引用语法建议使用的替代方式，加上对应的链接。<br/>示例：abandonmentMethod<sup>(deprecated) </sup><br/>> 从API Version 7 开始不再维护，建议使用[newMethod]\(#newmethod)替代。 |
| 9    | 权限说明        | 以二级标题的形式，标题名为“需要权限”<br/>1. 如果仅系统应用可申请，格式：<br/>  ohos.permission.xxxx，仅系统应用可用。<br/>2. 如果该权限所有应用可申请，格式：<br/>   ohos.permission.xxxx   <br/>3. 如果该接口涉及多个权限，则采用“和、或”进行分割，格式：<br/>   ohos.permission.A 和 ohos.permission.B<br/>   ohos.permission.A 或 ohos.permission.B |
| 10   | @system api | 1. 如果某个模块全部接口均为system api，则在模块开头的版本说明下一行，增加：<br/>    - 本模块接口为系统接口。<br/>2. 如果某个接口为system api，仅供OEM厂商使用，则需要在描述中增加：<br/>    **系统接口：** 此接口为系统接口。 |
| 11   | 示例代码语言      | 所有的示例代码采用代码块的样式，并标记开发语言为ts，且在示例代码最开始添加注释`// xxx.ets` |
| 12   | 链接写法        | 格式：[链接文字]\(链接内容)<br/>跨文件夹链接：[指南]\(\.\./../xxx/xxx.md)，一个`../`表示上移一层文件夹。<br/>页面内链接：[接口A<sup>7+</sup>]\(#xxxa7)，页面内链接和需要链接到的标题保持一致，全小写无特殊符号无标签。 |

下面进入具体每个API的写作。

***

# 文档标题

> *写作说明*
>
> 1. **文档标题**：作为文档标题，要求使用中文短语概括本组件功能；但如果部分概念使用英文更便于开发者理解，可以直接使用。如Button、Silder等。
> 2. **标题层级**：文档标题为一级标题，使用`# `；其他字段如function、class、interface、enum、type为二级标题，使用`## `；class下的属性、function为三级标题，使用`### `。
> 3. **起始版本说明**：使用markdown的引用语法“>”对接口的起始版本进行说明，说明后需要换行。<br/>版本说明统一放在模块描述之后。一个模块只会有一个起始版本。<br/>采用标准句式：“本模块首批接口从API version x开始支持。后续版本的新增接口，采用上角标单独标记接口的起始版本。”x需要修改为对应的版本号。

模块描述。此处对该模块的定义、功能、使用场景、使用建议进行描述，采用如下固定句式。

（模块介绍，可选）xxx是xxx。

（功能描述，必选）提供xxx能力，包括xxx、xxx等。——当模块名不够语义化时，推荐此句式。

或 xxx组件/方法，用于xxx、xxx。——当模块名已经表达了清晰的语义时，推荐此句式。

（使用场景，可选）当需要xxx时，使用本模块xxx方法/本组件。

（使用建议或注意事项，可选）本模块可与xxx联合使用，以提升开发效率……。

**举例1**：Marquee

跑马灯组件，用于滚动展示一段单行文本，仅当文本内容宽度朝国跑马灯组件宽度时滚动。

**举例2**：SideBarContainer

提供侧边栏可以显示和隐藏的侧边栏容器，通过子组件定义侧边栏和内容区，第一个子组件表示侧边栏，第二个子组件表示内容区。

> **说明：**
>
> 该组件从API Version 8开始支持。后续版本如有新增内容，则采用上角标单独标记该内容的起始版本。

## 导入模块

> *写作说明*
>
> 1. 可选，若该模块为组件和通用方法，则删除此项。
> 2. 若该模块为需要导入的API接口，必选。
> 3. 根据实际情况填写导入模块。采用代码段的样式，给出import语句。
>

```js
import Curves from '@ohos.curves'
```

## 需要权限

> *写作说明*
>
> 1. 可选，若该模块的使用无需申请权限，则删除。
> 2. 如果仅系统应用可申请，格式：<br>
>    ohos.permission.xxxx，仅系统应用可用。
> 3. 如果该权限所有应用可申请，格式：<br>
>   ohos.permission.xxxx
> 4. 如果该接口涉及多个权限，则采用“和、或”进行分割，格式：<br>
>   ohos.permission.A 和 ohos.permission.B<br>
>   ohos.permission.A 或 ohos.permission.B

 ohos.permission.INTERNET，具体申请方式请参考[权限申请声明](../../application-dev/security/accesstoken-guidelines.md)。

## 子组件

> *写作说明*
>
> 1. 若该模块为系统内置组件，且组件包含子组件，必选。
> 2. 若该模块非系统内置组件，或组件不包含子组件，则删除。

示例：可以包含子组件。

## 接口

>*写作说明*
>
>1. 若该模块为系统内置组件，则必选，如果没有接口可删除此二级标题。
>2. 方法具体的调用形式和d.ts保持一致，需要包括参数名、参数类型。
>3. 若该参数为可选，则在参数名后添加问号（？）做以标识。
>4. 方法调用涉及到的符号均为英文符号，注意在冒号（：）后添加空格。
>5. 删除方法调用描述后的分号（；）。
>6. 参数类型如果为自定义类型（对象、枚举等），若该类型首次出现，以无序列表的形式，在此描述。若该类型在其他模块已做说明，则建立相对链接。
>7. 注意：尖括号<>可能会被识别为标签，导致界面显示失效，可增加一个\，以保证界面正常显示，如“\<>”或使用转义字符&lt; &gt; 。
>8. 注意：组件接口中的方法无返回值，不以三级/二级标题形式体现，其余要求同[方法](#方法)。
>9. 注意：默认值需要在描述中换行体现。

如果接口有两个及以上的创建方法，此处给出接口不同创建方式的差异说明。

此处给出该接口方法的具体调用形式，将options直接写进接口中。为：方法名称(参数1名称：参数1类型，参数2名称：参数2类型，……)。<br>如果接口涉及多个方法，则顺次描写，并在方法前面添加序号，例如：**方法1：**。

示例：**方法1：** Button(options?: { type?: ButtonType, stateEffect?: boolean })

此处给出该方法的功能描述。如有使用限制，进行详细说明。

**options参数：**（可选，如不涉及可删除）

| 参数名         | 参数类型       | 必填   | 描述                                       |
| ----------- | ---------- | ---- | ---------------------------------------- |
| type        | ButtonType | 否    | 按钮类型。<br>默认值：ButtonType.Capsule          |
| stateEffect | boolean    | 否    | 按钮按下时是否开启切换效果，当状态置为false时，点击效果关闭。<br>默认值：true。 |

## 属性

> *写作说明*
>
> 1. 可选，如果没有属性可删除此二级标题。
> 2. 类型如果为自定义类型（对象、枚举等）需要建立链接到对应的interface或enum中。
> 3. 注意：默认值需要在描述中换行说明。

若该模块为系统内置组件，则此处需说明该组件是否支持通用属性。

示例：

除支持通用属性（通用属性需添加相对链接）外，还支持如下属性：

| 名称         | 类型              | 描述                                       |
| ---------- | --------------- | ---------------------------------------- |
| alignItems | HorizontalAlign | 设置子组件在水平方向上的对齐格式。<br>默认值：HorizontalAlign.Center |

## 事件

> *写作说明*
>
> 1. 可选，如果没有事件可删除此二级标题。
> 2. 类型如果为自定义类型（对象、枚举等）需要建立链接到对应的interface或enum中。若该类型首次出现，以二级标题的形式，在该事件下方描述。若该类型在其他模块已做说明，则建立相对链接。

若该模块为系统内置组件，则此处需说明该组件是否支持通用事件。

示例：

除支持通用事件（通用事件需添加相对链接）外，还支持如下事件：

此处给出每个事件的具体调用形式，要求同[方法](#方法)。

### onSubmit

onSubmit(callback: (value: string) => void)

点击搜索图标、搜索按钮或者按下软键盘搜索按钮时触发。

**参数：**

| 参数名   | 参数类型   | 是否必填 | 描述          |
| ----- | ------ | ---- | ----------- |
| value | string | 是    | 当前输入文本框的内容。 |

## 方法

> *写作说明*
>
> 1. 可选，如果没有可删除。如果有多个方法，请分多个二级内容描述，并使用“##”自行新建二级标题。
>
> 2. 二级标题名为方法名，采用导入类.方法名的形式。
>
>    示例：  mediaquery.matchMediaSync
>
> 3. **方法具体调用形式**：和d.ts保持一致，需要包括参数类型、参数名、返回值类型。
>
>    示例：matchMediaSync(condition: string): MediaQueryListener
>
> 4. 尖括号<>可能会被识别为标签，导致界面显示失效，可增加一个\，以保证界面正常显示，如“\<>”或使用转义字符&lt; &gt; 。
>
> 5. **方法描述**：对方法实现的功能进行描述，包括其使用的前提条件（*如：在xx方法调用后才能调用、需要确保网络已连接……*）、使用之后的影响（*如：调用该接口后再进行xx将不起效*）、**权限限制**、**系统能力**等。
>
> 6. **表格内换行**：markdown语法中，换行采用特殊标记<br>

在此处给出方法的具体调用形式：（如果是静态方法需说明） 方法名称(参数1名称：参数1类型，参数2名称：参数2类型，……)：返回值类型

在此处给出方法描述。

**参数：**（可选，如不涉及可删除）

| 参数名       | 参数类型   | 必填   | 说明         |
| --------- | ------ | ---- | ---------- |
| condition | string | 是    | 媒体事件的匹配条件。 |

**返回值：**（可选，如不涉及可删除）

| 类型                 | 说明                     |
| ------------------ | ---------------------- |
| MediaQueryListener | 媒体事件监听句柄，用于注册和去注册监听回调。 |

**示例：**

```js
// 必选项。

// 所有的示例代码需要进行自检。
// 不能出现缺符号、变量前后不一致等低错。
// 所有的使用到的变量要进行声明。

// 不允许直接写参数名，必须是可使用、易替代的实际用例。如果非用户自定义填写，需通过注释进行说明。
// 例如：var result = xxx.createExample(parameterOne); // parameterOne由扫描自动获取

// 注释要精简直白，命中要点。需提供注释的场景：
// 1. 当代码不能说明变量命名的具体含义，或不能说明代码逻辑时，必须提供注释。
// 2. 涉及到复杂算法或特殊语法时，必须提供注释。
```

## Class

> *写作说明*
>
> 1. 可选，如果没有可删除。如果有多个，请分多个二级内容描述，并使用“##”自行新建二级标题。
> 2. 二级标题名为class的名称。
> 3. 如果该Class既有属性，又有方法，需要先进行属性的写作，并使用“###”三级标题。
> 4. 如果该Class只有属性，那么不需要新建三级标题，直接使用表格陈列属性。

此处说明该类的实现功能、使用场景、约束限制等。

### 导入对象

> *写作说明*
>
> 1. 必选，以代码段的形式说明类的创建方式

示例：

```
patternLockController: PatternLockController = new PatternLockController()
```

### 属性

> *写作说明*
>
> 1. 可选，除标题使用三级标题外，其余要求同[属性](#属性)。

### Class中的方法

> *写作说明*
>
> 1. 可选，标题名为方法名，使用三级标题，**没有前缀**。示例：scrollTo。
> 2. 无需提供示例代码和示例图，其他要求同[方法](#方法)。

## 枚举

> *写作说明*
>
> 1. 可选，以二级标题的形式体现，在涉及到的方法、属性后就近描述。

### FlexDirection枚举说明

| 名称            | 描述               |
| ------------- | ---------------- |
| Row           | 主轴与行方向一致作为布局模式。  |
| RowReverse    | 居中对齐，默认对齐方式。     |
| Column        | 主轴与列方向一致作为布局模式。  |
| ColumnReverse | 与Column方向相反进行布局。 |

## 对象

> *写作说明*
>
> 1. 可选，以二级标题的形式体现，在涉及到的方法、属性后就近描述。

### MouseEvent对象说明

| 属性名称      | 属性类型   | 描述                 |
| --------- | ------ | ------------------ |
| timestamp | number | 触发事件时的时间戳。         |
| screenX   | number | 点击触点相对于屏幕左上角的x轴坐标。 |
| screenY   | number | 点击触点相对于屏幕左上角的y轴坐标。 |

## 示例

此处说明该示例的应用效果。

> *写作说明*
>
> 1. 必选，以二级/三级标题的形式体现，需要示例代码和示例图。
> 2. 若该组件/模块功能复杂，则按照功能点划分，按照三级标题的形式分块呈现示例代码和示例图。
>
> ```tsx
> // 必选项。
>
> // 所有的示例代码需要进行自检。
> // 不能出现缺符号、变量前后不一致等低错。
> // 所有的使用到的变量要进行声明。
> // 所有示例代码均需要添加语言标记。
>
> // 不允许直接写参数名，必须是可使用、易替代的实际用例。如果非用户自定义填写，需通过注释进行说明。
> // 例如：var result = xxx.createExample(parameterOne); // parameterOne由扫描自动获取
>
> // 示例图布局清晰，配色简洁大方，图片有版权。
>
> // 注释要精简、突出要点。需提供注释的典型场景还有：
> // 1. 当代码不能说明变量命名的具体含义，或不能说明代码逻辑时，必须提供注释。
> // 2. 涉及到复杂算法或特殊语法时，必须提供注释。
> ```

示例：

```ts
// xxx.ets
@Entry
@Component
struct CheckboxExample {
  build() {
    Row() {
      // 生成一个多选框，默认选中，点击可显示多选框状态
      Checkbox({name: 'checkbox1',  group: 'checkboxGroup'})
        .select(true)
        .selectedColor(0xed6f21)
        .onChange((value: boolean) => {
          console.info('Checkbox1 change is'+ value)
        })
      // 生成一个多选框，默认不选中，点击可显示多选框状态
      Checkbox({name: 'checkbox2',  group: 'checkboxGroup'})
        .select(false)
        .selectedColor(0x39a2db)
        .onChange((value: boolean) => {
          console.info('Checkbox2 change is'+ value)
        })
    }
  }
}
```
<!--no_check-->