# API接口说明模板

## 总体写作说明

|      | 说明项                            | 细则                                                         |
| ---- | --------------------------------- | ------------------------------------------------------------ |
| 1    | 客户化写作基本要求                | **写作中，请变身开发者，对于开发者使用该API时所需的使用场景、参数选取原则、开发建议/经验、示例等信息进行清晰描述，达到指导开发者顺利使用本API进行开发的目标。** |
| 2    |                                   | **所有的写作说明，在完成写作后，都要删除。**                 |
| 3    | 上传路径                          | markdown文件：docs/zh-cn/application-dev/reference/apis<br>图片路径：docs/zh-cn/application-dev/reference/apis/figures，并在markdown文件中通过路径`![](figures/xxx.jpg)`或`![](figures/xxx.png)`引用。 |
| 4    | 文件命名                          | 一个d.ts对应一个js api文档，文件名称应与模块名称保持一致，格式为：**js-apis-模块名.md**。<br/>示例：<br/>媒体@ohos.multimedia.audio，文件命名为：js-apis-audio.md<br/>电话@ohos.telephony.sms，文件命名为：js-apis-sms.md |
| 5    | 目录修改                          | 新增文件，需要修改对应的Readme，即`docs/zh-cn/application-dev/reference/apis/Readme-CN.md`。 |
| 6    | 文档结构                          | - 模块说明<br/>- 起始版本说明<br/>- 导入模块/使用说明<br/>- 接口（属性、方法、枚举、自定义类型）<br/>  描述顺序和代码保持一致，如果某些接口具有逻辑顺序，请注意排列。 |
| 7    | 接口版本说明                      | 1. 每个模块要有起始版本说明，使用引用语法“>”对接口的起始版本进行说明。接口没有标记的，默认与模块同一个起始版本。<br/>2. 已有模块新增接口使用\<sup>标签标记对应版本号。写法：`<sup>版本号+</sup>`<br/> 例如`<sup>7+</sup>`<br/> 示例：API 6已有的模块，在API 7新增了一个属性字段，则在属性后加标记，即newAttribute<sup>7+</sup>。<br/>如果新增了一个方法，则在方法标题后增加标记，即 sim.getSimIccId<sup>7+</sup>，interface、class、枚举等同理。 |
| 8    | 废弃接口说明                      | 废弃内容不能直接删去，在废弃内容后面加标注deprecated，并使用“>”引用语法建议使用的替代方式，加上对应的链接。<br/>示例：abandonmentMethod<sup>(deprecated) </sup><br/>> 从API Version 7 开始不再维护，建议使用[newMethod]\(#newmethod)替代。 |
| 9    | 权限说明                          | 与代码保持一致，下沉到各个方法、枚举、属性字段中。<br/>1. 如果仅系统应用可申请，格式：<br/>    **需要权限：** ohos.permission.xxxx，仅系统应用可用。<br/>2. 如果该权限所有应用可申请，格式：<br/>    **需要权限：** ohos.permission.xxxx   <br/>3. 如果该接口涉及多个权限，则采用“和、或”进行分割，格式：<br/>    **需要权限：** ohos.permission.A 和 ohos.permission.B<br/>    **需要权限：** ohos.permission.A 或 ohos.permission.B |
| 10   | @syscap                           | 1. 每个方法都需要进行描述，格式：<br/>    **系统能力**：SystemCapability.xxx.xxx<br/>2. 每个表格（属性、枚举、常量、变量）可统一进行说明，分两种情况：<br/>    1）每个表格下系统能力无差异的，同方法的写法：<br/>          **系统能力**：SystemCapability.xxx.xxx<br/>    2）有差异的：在每一个表格项里进行描述。 |
| 11   | @system api                       | 1. 如果某个模块全部接口均为system api，则在模块开头的版本说明下一行，增加：<br/>    - 本模块接口为系统接口。<br/>2. 如果某个接口为system api，仅供OEM厂商使用，则需要在描述中增加：<br/>    **系统接口：** 此接口为系统接口。 |
| 12   | @FAModelOnly<br/>@StageModelOnly  | 1. 如果某个模块均只针对某模型实现，则在模块开头的版本说明下一行，增加：<br/>    - 本模块接口仅可在FA模型/Stage模型下使用。<br/>2. 如果某个接口只针对某模型实现，则需要在描述中增加：<br/>    **模型约束：** 此接口仅可在FA模型/Stage模型下使用。 |
| 13   | 异步接口说明（callback、Promise） | 对于callback、Promise在方法描述、参数说明、返回值说明的具体描述要求如下：<br/>**callback**的固定句式：<br/>方法介绍：xxx（方法描述）。使用callback异步回调。<br/>参数说明：<br/>**callback\<boolean>**：回调函数。返回true表示xxx；返回false表示xxx。<br/>**callback\<Object>**：回调函数，返回xxx。例如”回调函数，返回音频采集器对象。“<br/>**AsyncCallback\<void>**：回调函数。当具体的操作（视具体接口功能描述）成功，err为undefined，否则为错误对象。<br/>**AsyncCallback\<Object x>**：回调函数。当具体的操作（视具体接口功能描述）成功，err为undefined，data为获取到的Object x；否则为错误对象。<br/>**Promise**的固定句式：<br/>方法介绍：xxx（方法描述）。使用Promise异步回调。<br/>参数说明：<br/>**Promise\<boolean>**：Promise对象。返回true表示xxx；返回false表示xxx。<br/>**Promise\<Object>**：Promise对象，返回xxx。例如”Promise对象，返回音频采集器对象。“<br/>**Promise\<void>**：Promise对象。无返回结果的Promise对象。 |
| 14   | 示例代码语言                      | 所有的示例代码采用代码块的样式，并标记开发语言。<br/>JS和eTS通用的标注`js`；仅eTS可用的，标注`ts`。 |
| 15   | 链接写法                          | 格式：[链接文字]\(链接内容)<br/>跨文件夹链接：[指南]\(\.\./../xxx/xxx.md)，一个`../`表示上移一层文件夹。<br/>页面内链接：[接口A<sup>7+</sup>]\(#xxxa7)，页面内链接和需要链接到的标题保持一致，全小写无特殊符号无标签。 |

下面进入具体每个API的写作。

***

# 文档标题

> *写作说明*
>
> 1. **文档标题**：作为文档标题，要求使用中文短语概括本模块功能；但如果部分概念使用英文更便于开发者理解，可以直接使用。如Ability、SIM卡管理等。
> 2. **标题层级**：文档标题为一级标题，使用`# `；namespace下的属性字段、function、class、interface、enum、type为二级标题，使用`## `；class下的属性、function为三级标题，使用`### `。
> 3. **起始版本说明**：使用markdown的引用语法“>”对接口的起始版本进行说明，说明后需要换行。<br/>版本说明统一放在模块描述之后。一个模块只会有一个起始版本。<br/>采用标准句式：“本模块首批接口从API version x开始支持。后续版本的新增接口，采用上角标单独标记接口的起始版本。”x需要修改为对应的版本号。

模块描述。此处对该模块的定义、功能、使用场景、使用建议进行描述，采用如下固定句式。

（模块介绍，可选）xxx是xxx。

（功能描述，必选）xxx模块提供xxx能力，包括xxx、xxx等。——当模块名不够语义化时，推荐此句式。

或 本模块提供xxx能力，包括xxx、xxx等。——当模块名已经表达了清晰的语义时，推荐此句式。

（使用场景，可选）当需要xxx时，使用本模块接口xxx。

（使用建议或注意事项，可选）本模块接口可与xxx联合使用，以提升开发效率……。

**举例1**：“后台任务管理模块”的模块描述示例

本模块提供后台任务管理能力。
当应用或业务模块处于后台（无可见界面）时，如果有需要继续执行或者后续执行的业务，可基于业务类型，申请短时任务延迟挂起（Suspend），或长时任务避免进入挂起状态。

**举例2**：“拨打电话模块”的模块描述示例

本模块提供呼叫管理能力，包括拨打电话、跳转到拨号界面、获取通话状态、格式化电话号码等。
如需订阅通话状态，请使用observer.on('callStateChange')。

**举例3**：“分布式数据管理模块”的模块描述示例

分布式数据管理模块为应用程序提供不同设备间数据库的分布式协同能力。
通过调用分布式数据各个接口，应用程序可将数据保存到分布式数据库中，并可对分布式数据库中的数据进行增加、删除、修改、查询、同步等操作。

**举例4**：“线性容器ArrayList模块”的模块描述示例

ArrayList是一种线性数据结构，底层基于数组实现。ArrayList会根据实际需要动态调整容量，每次扩容增加50%。
ArrayList和Vector相似，都是基于数组实现。它们都可以动态调整容量，但Vector每次扩容增加1倍。
ArrayList和LinkedList相比，ArrayList的随机访问效率更高。但由于ArrayList的增删操作会影响数组内其他元素的移动，LinkedList的增加和删除操作效率更高。
当需要频繁读取集合中的元素时，推荐使用ArrayList。



> **说明：**<br/>
> 本模块首批接口从API version 8开始支持。后续版本的新增接口，采用上角标单独标记接口的起始版本。

## 导入模块

> *写作说明*
>
> 1. 根据实际情况填写导入模块。采用代码段的样式，给出import语句。
>
> 2. 如果没有导入模块，将“导入模块”修改为“使用说明”。<br/>使用说明案例：<br/>
>    在使用AbilityContext的功能前，需要通过\[getContext()]\(链接到对应的接口说明文件中.md)先获取Context对象。
>
> ```js
>    import ability_featureAbility from '@ohos.ability.featureAbility';
>    var context = ability_featureAbility.getContext();
> ```

```js
import call from '@ohos.telephony.call';
```

## 属性

> *写作说明*
>
> 1. 可选，如果没有属性可删除此二级标题。
>
> 2. 类型如果为自定义类型，需要建立链接到对应的interface或enum中。
>
> 3. 对于可读属性：如果取值为有特殊含义的有限值，需要进行枚举。
>
> 4. 对于可写属性：如果仅支持固定字段，需要进行说明。

**系统能力：** SystemCapability.xxx.xxx。（必选）

| 名称             | 类型                                      | 可读 | 可写 | 说明                                       |
| ---------------- | ----------------------------------------- | ---- | ---- | ------------------------------------------ |
| pluggedType      | [BatteryPluggedType](#batterypluggedtype) | 是   | 否   | 表示当前设备连接的充电器类型。             |
| isBatteryPresent | boolean                                   | 是   | 否   | 表示当前设备是否支持电池或者电池是否在位。 |

## 方法

> *写作说明*
>
> 1. 可选，如果没有可删除。如果有多个方法，请分多个二级内容描述，并使用“##”自行新建二级标题。
>
> 2. 二级标题名为方法名，采用导入类.方法名，如果是订阅方法，需要在方法名加上对应的订阅事件。
>
>    示例： sim.getSimIccId
>    订阅方法：sim.on('exampleEvent')
>
> 3. **方法具体调用形式**：和d.ts保持一致，需要包括参数类型、参数名、返回值类型。
>    示例：getNetworkState(slotId: number, callback: AsyncCallback\<NetworkState>): void
>    注意：尖括号<>可能会被识别为标签，导致界面显示失效，可增加一个\，以保证界面正常显示，如“\\<>”或使用转义字符\&lt; \&gt; 。
>
> 4. **方法描述**：对方法实现的功能进行描述，包括其使用的前提条件（*如：在xx方法调用后才能调用、需要确保网络已连接……*）、使用之后的影响（*如：调用该接口后再进行xx将不起效*）、**权限限制**、**系统能力**等。
>
> 5. **异步方法描述**：存在大量异步方法，其返回方式需要在方法描述处进行说明。具体写法参考总体写作说明第14项。
>
> 6. **表格内换行**：markdown语法中，换行采用特殊标记\<br>

*（在此处给出方法的具体调用形式。如果是静态方法需说明）* 方法名称(参数1名称：参数1类型，参数2名称：参数2类型，……)：返回值类型

在此处给出方法描述。说明请参考上述写作说明第4、5点。

**模型约束**：此接口仅可在FA模型下使用。（如不涉及可删除）

**系统接口**：此接口为系统接口。（如不涉及可删除）

**需要权限**：ohos.permission.xxx（如不涉及可删除，如果是系统权限要说明）

**系统能力**：SystemCapability.xxx.xxx（必选）

**参数：** （可选，如不涉及可删除）

| 参数名       | 类型                                          | 必填 | 说明                                                         |
| ------------ | --------------------------------------------- | ---- | ------------------------------------------------------------ |
| parameterOne | number \| string \| [CustomType](#customtype) | 是   | 参数描述。给出取值范围、建议值。如果有固定格式，需要给出格式样例，尤其是URI。<br/>自定义类型需要进行建链说明。 |
| callback     | Callback\<Array<[CustomType](#customtype)>>   | 否   | 参数描述。可选参数需要说明不填写该参数的后果。<br/>如：不填该参数则取消该type对应的所有回调。<br/>callback写法参考总体写作说明第14项。 |

**返回值**：（可选，如不涉及可删除）

| 类型                                       | 说明                                            |
| ------------------------------------------ | ----------------------------------------------- |
| string                                     | 返回值描述。取到返回值之后，可以用来做什么。    |
| Promise\<Array<[CustomType](#CustomType)>> | 返回值描述。Promise写法参考总体写作说明第14项。 |

**示例：**

```js
// 必选项。

// 所有的示例代码需要进行自检。
// 不能出现缺符号、变量前后不一致等低错。
// 所有使用到的变量要进行声明。

// 不允许直接写参数名，必须是可使用、易替代的实际用例。如果非用户自定义填写，需通过注释进行说明。
// 例如：var result = xxx.createExample(parameterOne); // parameterOne由扫描自动获取

// 注释要精简、突出要点。需提供注释的典型场景还有：
// 1. 当代码不能说明变量命名的具体含义，或不能说明代码逻辑时，必须提供注释。
// 2. 涉及到复杂算法或特殊语法时，必须提供注释。
```

## on/off订阅方法

> *写作说明*
>
> 1. 与[方法](#方法)要求一致，以下仅作差异项说明。
>
> 2. 二级标题名为方法名，采用导入类.方法名，需要在方法名加上对应的订阅事件。
>    示例：sim.on('exampleEvent') 、on('play' | 'pause' | 'stop' | 'reset')
>
> 3. **方法具体调用形式**：和d.ts保持一致，需要包括参数类型、事件名、参数名、返回值类型。
>    示例：on(type: 'ringerModeChange', callback: Callback\<AudioRingMode>): void
>    注意：尖括号<>可能会被识别为标签，导致界面显示失效，可增加一个\，以保证界面正常显示，如“\\<>”或使用转义字符\&lt; \&gt; 。

*（在此处给出方法的具体调用形式。如果是静态方法需说明）* 方法名称(参数1名称：参数1类型，参数2名称：参数2类型，……)：返回值类型

在此处给出方法描述。说明请参考上述写作说明第4、5点。

**模型约束**：此接口仅可在FA模型下使用。（如不涉及可删除）

**系统接口**：此接口为系统接口。（如不涉及可删除）

**需要权限**：ohos.permission.xxx（如不涉及可删除，如果是系统权限要说明）

**系统能力**：SystemCapability.xxx.xxx（必选）

**参数：** （可选，如不涉及可删除）

| 参数名   | 类型                                 | 必填 | 说明                                                         |
| -------- | ------------------------------------ | ---- | ------------------------------------------------------------ |
| type     | string                               | 是   | 事件描述，需要说明触发时机。如一个方法涉及多个事件，需要分开说明。<br/>**示例1（单个）：**<br/>事件回调类型，支持的事件为`'play'`，当`play()`调用完成，音频开始播放，触发该事件。<br/>**示例2（多个）：**<br/>事件回调类型，支持的事件包括：`'play'` \| `'dataLoad' `\|`'finish'`。<br/>\- `'play'`：完成`play()`调用，音频开始播放，触发该事件。<br/>\- `'dataLoad'`：完成音频数据加载后触发该事件，即src属性设置完成后触发该事件。<br/>\- `'finish'`：完成音频播放后触发该事件。 |
| callback | Callback\<[CustomType](#CustomType)> | 否   | 参数描述。与[方法](#方法)要求一致。                          |

**返回值：**（可选，如不涉及可删除）

| 类型   | 说明                                  |
| ------ | ------------------------------------- |
| string | 返回值描述。与[方法](#方法)要求一致。 |

**示例：**

```js
// 必选项。与方法要求一致。

// 所有的示例代码需要进行自检。
// 不能出现缺符号、变量前后不一致等低错。
// 所有使用到的变量要进行声明。

// 不允许直接写参数名，必须是可使用、易替代的实际用例。如果非用户自定义填写，需通过注释进行说明。
// 例如：var result = xxx.createExample(parameterOne); // parameterOne由扫描自动获取

// 注释要精简、突出要点。需提供注释的典型场景还有：
// 1. 当代码不能说明变量命名的具体含义，或不能说明代码逻辑时，必须提供注释。
// 2. 涉及到复杂算法或特殊语法时，必须提供注释。
```

## Class/Interface

> *写作说明*
>
> 1. 可选，如果没有可删除。如果有多个，请分多个二级内容描述，并使用“##”自行新建二级标题。
>
> 2. 二级标题名为class、interface的名称。
>
> 3. 如果该API中，既有属性，又有方法，需要先进行属性的写作，并使用“###”三级标题。
>    如果该API中，只有属性，那么不需要新建三级标题，直接使用表格陈列属性，具体示例参考[CustomType](#CustomType)。

类描述/interface描述。如果有使用限制，需要在这个地方说明。比方说，是否有前提条件，是否需要通过什么方法先构造一个实例。 

### 属性

> *写作说明*
>
> 除标题使用三级标题外，其余要求同[属性](#属性)。

### Class/Interface中的方法

> *写作说明*
>
> 1. 标题名为方法名，使用**三级标题，没有前缀**。如果是订阅方法，需要在方法名加上对应的订阅事件。
>    示例： getSimIccId
>    订阅方法：on('exampleEvent')
> 2. 其余与[方法](#方法)要求一致，不再重复。

## 枚举

> *写作说明*
>
> 1. 可选，如果没有可删除。如果有多个枚举，请分多个二级内容描述，并使用“##”自行新建二级标题。
>
> 2. 二级标题名为实际枚举名，比方说 BatteryHealthState 。

在此处给出该枚举类型的简要描述。如：表示连接的充电器类型的枚举。

**系统能力**：SystemCapability.xxx.xxx（必选）

| 名称 | 值   | 说明                       |
| ---- | ---- | -------------------------- |
| NONE | 1    | 表示连接的充电器类型未知。 |

## CustomType

仅有k-v键值对的自定义类型示例。
**系统能力：** SystemCapability.xxx.xxx（必选）

| 名称         | 类型                | 可读 | 可写 | 说明                                                         |
| ------------ | ------------------- | ---- | ---- | ------------------------------------------------------------ |
| parameterUrl | string              | 是   | 是   | 媒体输出URI。支持： <br/>1. 协议类型为“internal”的相对路径，示例如下： 临时目录：internal://cache/test.mp4 <br/>2. 文件的绝对路径，示例如下： file:///data/data/ohos.xxx.xxx/files/test.mp4 |
| parameterOne | [CustomEnum](#枚举) | 是   | 是   | 属性描述，要求与参数说明类似。                               |

## 变更日志
| 变更说明 | 日期 |
| -------- | ---- |
| 1. 总体写作说明整理为表格。<br/>2. “图片路径”中，增加图片的引用方式说明。<br/>3. 增加“文档结构”，对文档各节点顺序进行说明。<br/>4. “权限说明”中，增加多权限的描述方式。<br/>5. 增加@FAModelOnly/@StageModelOnly标记在文档的描述方式。<br/>6. 增加异步接口说明（callback、Promise）。<br/>7. 增加示例代码语言的标准和规范。<br/>8. 增加文档链接的标准写法。<br/>9. 增加模块描述的固定句式、示例。<br/>10. 增加“on/off”等订阅方法的说明。<br/>11. 修改@syscap的描述方式，除表格内的差异项，其余保持一致。 <br/>12. 修改@systemapi的描述方式，仅保留“该系统为系统接口。”。<br/>13. 删除MR版本说明。 |2022/6/24|

<!--no_check-->