# toolbar-item<a name="EN-US_TOPIC_0000001127125080"></a>

The  **<toolbar-item\>**  component is the child component of  **<toolbar\>**  to display an operation option on the toolbar.

## Child Component<a name="section9288143101012"></a>

None

## Attributes<a name="section19217161499"></a>

In addition to the attributes in  [Universal Attributes](js-components-common-attributes.md), the following attributes are supported.

<a name="table20633101642315"></a>
<table><thead align="left"><tr id="row663331618238"><th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.1"><p id="a45273e2103004ff3bdd3375013e96a2a"><a name="a45273e2103004ff3bdd3375013e96a2a"></a><a name="a45273e2103004ff3bdd3375013e96a2a"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.2"><p id="ad5b10d4a60e44bb4a8bbb3b4416d7b27"><a name="ad5b10d4a60e44bb4a8bbb3b4416d7b27"></a><a name="ad5b10d4a60e44bb4a8bbb3b4416d7b27"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="10.48%" id="mcps1.1.6.1.3"><p id="ab2ae3d9f60d6475ab95ba095851a9d07"><a name="ab2ae3d9f60d6475ab95ba095851a9d07"></a><a name="ab2ae3d9f60d6475ab95ba095851a9d07"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.5200000000000005%" id="mcps1.1.6.1.4"><p id="p824610360217"><a name="p824610360217"></a><a name="p824610360217"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="35.76%" id="mcps1.1.6.1.5"><p id="af5c3b773ed0a42e589819a6c8d257ca1"><a name="af5c3b773ed0a42e589819a6c8d257ca1"></a><a name="af5c3b773ed0a42e589819a6c8d257ca1"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1745453714917"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1345453714498"><a name="p1345453714498"></a><a name="p1345453714498"></a>value</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p8454537164910"><a name="p8454537164910"></a><a name="p8454537164910"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p645511377498"><a name="p645511377498"></a><a name="p645511377498"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p10455637114917"><a name="p10455637114917"></a><a name="p10455637114917"></a>Yes</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p18883831183010"><a name="p18883831183010"></a><a name="p18883831183010"></a>Text content of the operation option.</p>
</td>
</tr>
<tr id="row1937143418494"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p15372163494913"><a name="p15372163494913"></a><a name="p15372163494913"></a>icon</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p13726344494"><a name="p13726344494"></a><a name="p13726344494"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p937223417498"><a name="p937223417498"></a><a name="p937223417498"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p19372183413493"><a name="p19372183413493"></a><a name="p19372183413493"></a>Yes</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p837212344498"><a name="p837212344498"></a><a name="p837212344498"></a>Icon image path, which is displayed on the option text. The value is a local path. Supported image formats are PNG, JPG, and SVG.</p>
</td>
</tr>
</tbody>
</table>

## Styles<a name="section184493015533"></a>

Only the following style attributes are supported.

<a name="table1744514388541"></a>
<table><thead align="left"><tr id="row1244614388545"><th class="cellrowborder" valign="top" width="17.98%" id="mcps1.1.6.1.1"><p id="a4e80fb5a797c4328af30d59e2c570c71"><a name="a4e80fb5a797c4328af30d59e2c570c71"></a><a name="a4e80fb5a797c4328af30d59e2c570c71"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="15.82%" id="mcps1.1.6.1.2"><p id="a4238bd3a376645a3ad8498d3916ed6c8"><a name="a4238bd3a376645a3ad8498d3916ed6c8"></a><a name="a4238bd3a376645a3ad8498d3916ed6c8"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="12.379999999999999%" id="mcps1.1.6.1.3"><p id="a5ece9efc3a1d464a868f9557e4784a97"><a name="a5ece9efc3a1d464a868f9557e4784a97"></a><a name="a5ece9efc3a1d464a868f9557e4784a97"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.5200000000000005%" id="mcps1.1.6.1.4"><p id="p19451142418147"><a name="p19451142418147"></a><a name="p19451142418147"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="46.300000000000004%" id="mcps1.1.6.1.5"><p id="a2454f35c1eef44b4bb681caaa3ce48fc"><a name="a2454f35c1eef44b4bb681caaa3ce48fc"></a><a name="a2454f35c1eef44b4bb681caaa3ce48fc"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1968320716339"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="p16782113422516"><a name="p16782113422516"></a><a name="p16782113422516"></a>color</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><p id="p678210342255"><a name="p678210342255"></a><a name="p678210342255"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="p11782113462512"><a name="p11782113462512"></a><a name="p11782113462512"></a>#e6000000</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1945222451418"><a name="p1945222451418"></a><a name="p1945222451418"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><p id="p9782134122511"><a name="p9782134122511"></a><a name="p9782134122511"></a>Text color.</p>
</td>
</tr>
<tr id="row93711310173314"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="p15365537102518"><a name="p15365537102518"></a><a name="p15365537102518"></a>font-size</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><p id="p1636517375255"><a name="p1636517375255"></a><a name="p1636517375255"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="p7365103717256"><a name="p7365103717256"></a><a name="p7365103717256"></a>16px</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1452152481418"><a name="p1452152481418"></a><a name="p1452152481418"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><p id="p336663712252"><a name="p336663712252"></a><a name="p336663712252"></a>Text size.</p>
</td>
</tr>
<tr id="row48601612153319"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="p3376124017256"><a name="p3376124017256"></a><a name="p3376124017256"></a>allow-scale</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><p id="p1437654010251"><a name="p1437654010251"></a><a name="p1437654010251"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="p1376154072515"><a name="p1376154072515"></a><a name="p1376154072515"></a>true</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1452132471420"><a name="p1452132471420"></a><a name="p1452132471420"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><p id="p1937615404253"><a name="p1937615404253"></a><a name="p1937615404253"></a>Whether the text size changes with the system's font size settings.</p>
</td>
</tr>
<tr id="row1421915113312"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="p0781642162510"><a name="p0781642162510"></a><a name="p0781642162510"></a>font-style</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><p id="p107816428255"><a name="p107816428255"></a><a name="p107816428255"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="p17811342142514"><a name="p17811342142514"></a><a name="p17811342142514"></a>normal</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p11452162417140"><a name="p11452162417140"></a><a name="p11452162417140"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><p id="p197817427251"><a name="p197817427251"></a><a name="p197817427251"></a>Text font style. Available values are as follows:</p>
<a name="ol3712173853714"></a><a name="ol3712173853714"></a><ol id="ol3712173853714"><li><strong id="b533925573911"><a name="b533925573911"></a><a name="b533925573911"></a>normal</strong>: standard font style</li><li><strong id="b12117205710391"><a name="b12117205710391"></a><a name="b12117205710391"></a>italic</strong>: italic font style</li></ol>
</td>
</tr>
<tr id="row1373417172335"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="p9764174572513"><a name="p9764174572513"></a><a name="p9764174572513"></a>font-weight</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><p id="p37641045112510"><a name="p37641045112510"></a><a name="p37641045112510"></a>number|string</p>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="p1976434511252"><a name="p1976434511252"></a><a name="p1976434511252"></a>normal</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p24528247143"><a name="p24528247143"></a><a name="p24528247143"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><p id="p17641452258"><a name="p17641452258"></a><a name="p17641452258"></a>Text font weight. The number value must be an exact multiple of 100 ranging from 100 to 900. The default value is 400. A larger value indicates a bigger weight. Available values of the string type are <strong id="b1695811444515"><a name="b1695811444515"></a><a name="b1695811444515"></a>lighter</strong>, <strong id="b59669416457"><a name="b59669416457"></a><a name="b59669416457"></a>normal</strong>, <strong id="b896724144518"><a name="b896724144518"></a><a name="b896724144518"></a>bold</strong>, or <strong id="b196910415458"><a name="b196910415458"></a><a name="b196910415458"></a>bolder</strong>.</p>
</td>
</tr>
<tr id="row017015211338"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="p1693494732511"><a name="p1693494732511"></a><a name="p1693494732511"></a>text-decoration</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><p id="p7934124713256"><a name="p7934124713256"></a><a name="p7934124713256"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="p1493416479256"><a name="p1493416479256"></a><a name="p1493416479256"></a>none</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p9452124171410"><a name="p9452124171410"></a><a name="p9452124171410"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><p id="p18934647142514"><a name="p18934647142514"></a><a name="p18934647142514"></a>Text decoration. Available values are as follows:</p>
<a name="ol280935211386"></a><a name="ol280935211386"></a><ol id="ol280935211386"><li><strong id="b113241833938"><a name="b113241833938"></a><a name="b113241833938"></a>underline</strong>: An underline is used.</li><li><strong id="b1838734735"><a name="b1838734735"></a><a name="b1838734735"></a>line-through</strong>: A strikethrough is used.</li><li><strong id="b1177036435"><a name="b1177036435"></a><a name="b1177036435"></a>none</strong>: The standard text is used.</li></ol>
</td>
</tr>
<tr id="row458624153320"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="p1543212507250"><a name="p1543212507250"></a><a name="p1543212507250"></a>font-family</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><p id="p1243215092510"><a name="p1243215092510"></a><a name="p1243215092510"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="p34321750192510"><a name="p34321750192510"></a><a name="p34321750192510"></a>sans-serif</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1945217249142"><a name="p1945217249142"></a><a name="p1945217249142"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><p id="p134322050162510"><a name="p134322050162510"></a><a name="p134322050162510"></a>Font family, in which fonts are separated by commas (,). Each font is set using a font name or font family name. The first font in the family or the font specified by <a href="js-components-common-customizing-font.md">Custom Font Styles</a> is used for the text.</p>
</td>
</tr>
<tr id="row5132259115419"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="a473248d0f1ad4a6b87934aab462b09ce"><a name="a473248d0f1ad4a6b87934aab462b09ce"></a><a name="a473248d0f1ad4a6b87934aab462b09ce"></a>background</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><p id="a7c54e775a6bf4bbea277ff8927cc4c13"><a name="a7c54e775a6bf4bbea277ff8927cc4c13"></a><a name="a7c54e775a6bf4bbea277ff8927cc4c13"></a>&lt;linear-gradient&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="a5bbca83860ff4086bba1bf5b8698e28c"><a name="a5bbca83860ff4086bba1bf5b8698e28c"></a><a name="a5bbca83860ff4086bba1bf5b8698e28c"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p845216243143"><a name="p845216243143"></a><a name="p845216243143"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><p id="ad385002530a346f09c23e6745ca0e916"><a name="ad385002530a346f09c23e6745ca0e916"></a><a name="ad385002530a346f09c23e6745ca0e916"></a>This attribute supports <a href="js-components-common-gradient.md">Gradient Styles</a> only but is not compatible with <strong id="b0391974618"><a name="b0391974618"></a><a name="b0391974618"></a>background-color</strong> or <strong id="b740177766"><a name="b740177766"></a><a name="b740177766"></a>background-image</strong>.</p>
</td>
</tr>
<tr id="row1613225905418"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="af5c7b4fc3d8949b5aff81c5b49783259"><a name="af5c7b4fc3d8949b5aff81c5b49783259"></a><a name="af5c7b4fc3d8949b5aff81c5b49783259"></a>background-color</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><p id="a3f45d99020c04479943ad07f262a591c"><a name="a3f45d99020c04479943ad07f262a591c"></a><a name="a3f45d99020c04479943ad07f262a591c"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="add693215147d46e59c859940cc4520e8"><a name="add693215147d46e59c859940cc4520e8"></a><a name="add693215147d46e59c859940cc4520e8"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p545218247144"><a name="p545218247144"></a><a name="p545218247144"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><p id="acd48c077d9964749ae766636b8ada95c"><a name="acd48c077d9964749ae766636b8ada95c"></a><a name="acd48c077d9964749ae766636b8ada95c"></a>Background color.</p>
</td>
</tr>
<tr id="row20131459185410"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="a9ebf9bd289374413a2834bab0e3b46d4"><a name="a9ebf9bd289374413a2834bab0e3b46d4"></a><a name="a9ebf9bd289374413a2834bab0e3b46d4"></a>background-image</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><p id="a46c151a9e45b4ffcb4c45dfcb93214bd"><a name="a46c151a9e45b4ffcb4c45dfcb93214bd"></a><a name="a46c151a9e45b4ffcb4c45dfcb93214bd"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="a8be7284eb5884350ba591183a67d4060"><a name="a8be7284eb5884350ba591183a67d4060"></a><a name="a8be7284eb5884350ba591183a67d4060"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1045212441415"><a name="p1045212441415"></a><a name="p1045212441415"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><p id="aa236de4e56e349ff8c753d294e98abab"><a name="aa236de4e56e349ff8c753d294e98abab"></a><a name="aa236de4e56e349ff8c753d294e98abab"></a>Background image. Currently, this attribute is not compatible with <strong id="b13129246941242"><a name="b13129246941242"></a><a name="b13129246941242"></a>background-color</strong> or <strong id="b18855542241242"><a name="b18855542241242"></a><a name="b18855542241242"></a>background</strong>. Both online and local image resources are supported.</p>
</td>
</tr>
<tr id="row0131145914543"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="a5def9eea1a2b42e9b040f0f898a2fcdf"><a name="a5def9eea1a2b42e9b040f0f898a2fcdf"></a><a name="a5def9eea1a2b42e9b040f0f898a2fcdf"></a>background-size</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><a name="uc9d67b59ab8c4f5d8f766deb0f8f657b"></a><a name="uc9d67b59ab8c4f5d8f766deb0f8f657b"></a><ul id="uc9d67b59ab8c4f5d8f766deb0f8f657b"><li>string</li><li>&lt;length&gt; &lt;length&gt;</li><li>&lt;percentage&gt; &lt;percentage&gt;</li></ul>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="a2d537661fce74b13acbcc7a95ea56f08"><a name="a2d537661fce74b13acbcc7a95ea56f08"></a><a name="a2d537661fce74b13acbcc7a95ea56f08"></a>auto</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p10452132414149"><a name="p10452132414149"></a><a name="p10452132414149"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><p id="a0709b83d5c8e4b75b1f0bb42d913ac02"><a name="a0709b83d5c8e4b75b1f0bb42d913ac02"></a><a name="a0709b83d5c8e4b75b1f0bb42d913ac02"></a>Background image size.</p>
<a name="ub2423a2f8d96432f8c58c629288432c5"></a><a name="ub2423a2f8d96432f8c58c629288432c5"></a><ul id="ub2423a2f8d96432f8c58c629288432c5"><li>The <strong id="b1240813501139"><a name="b1240813501139"></a><a name="b1240813501139"></a>string</strong> values are as follows:<a name="uee8f5c89381a4ce682a5d557f8e558ee"></a><a name="uee8f5c89381a4ce682a5d557f8e558ee"></a><ul id="uee8f5c89381a4ce682a5d557f8e558ee"><li><strong id="b18294195114318"><a name="b18294195114318"></a><a name="b18294195114318"></a>contain</strong>: Expands the image to the maximum size so that the height and width of the image are applicable to the content area.</li><li><strong id="b10184452334"><a name="b10184452334"></a><a name="b10184452334"></a>cover</strong>: Extends the background image to a large enough size so that the background image completely covers the background area. Some parts of the image may not be displayed in the background area.</li><li><strong id="b14980752831"><a name="b14980752831"></a><a name="b14980752831"></a>auto</strong>: The original image width-height ratio is retained.</li></ul>
</li><li>The two <strong id="b57176531536"><a name="b57176531536"></a><a name="b57176531536"></a>&lt;length&gt;</strong> values are as follows:<p id="a5b969a49f8074aae96a12e4232e47c5d"><a name="a5b969a49f8074aae96a12e4232e47c5d"></a><a name="a5b969a49f8074aae96a12e4232e47c5d"></a>Width and height of the background image. The first value indicates the width, and the second value indicates the height. If you only set one value, the other value is set to <strong id="b14228456634"><a name="b14228456634"></a><a name="b14228456634"></a>auto</strong> by default.</p>
</li><li>The two <strong id="b4995195613312"><a name="b4995195613312"></a><a name="b4995195613312"></a>&lt;percentage&gt;</strong> values are as follows:<p id="a19ef0a7986ce47f2b7fe614975e23cd9"><a name="a19ef0a7986ce47f2b7fe614975e23cd9"></a><a name="a19ef0a7986ce47f2b7fe614975e23cd9"></a>Width and height of the background image in percentage of the parent element. The first value indicates the width, and the second value indicates the height. If you only set one value, the other value is set to <strong id="b1633231830"><a name="b1633231830"></a><a name="b1633231830"></a>auto</strong> by default.</p>
</li></ul>
</td>
</tr>
<tr id="row2017552715511"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="a8e820e26428c4e008a691a8fc8c23294"><a name="a8e820e26428c4e008a691a8fc8c23294"></a><a name="a8e820e26428c4e008a691a8fc8c23294"></a>background-repeat</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><p id="ab9ca7eb1f0fc48a9a3fc08b88fe11338"><a name="ab9ca7eb1f0fc48a9a3fc08b88fe11338"></a><a name="ab9ca7eb1f0fc48a9a3fc08b88fe11338"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="abbb032e6786d43568f7eea7b29611821"><a name="abbb032e6786d43568f7eea7b29611821"></a><a name="abbb032e6786d43568f7eea7b29611821"></a>repeat</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p16452102413147"><a name="p16452102413147"></a><a name="p16452102413147"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><p id="a64efc26d6e2c48a3a4032c71b8511085"><a name="a64efc26d6e2c48a3a4032c71b8511085"></a><a name="a64efc26d6e2c48a3a4032c71b8511085"></a>Repeating attribute of a background image. By default, a background image is repeated both horizontally and vertically.</p>
<a name="uee59e640d2304d56a0a5b396795a8cc5"></a><a name="uee59e640d2304d56a0a5b396795a8cc5"></a><ul id="uee59e640d2304d56a0a5b396795a8cc5"><li><strong id="b11277195719522"><a name="b11277195719522"></a><a name="b11277195719522"></a>repeat</strong>: Repeatedly draws images along the x-axis and y-axis at the same time.</li><li><strong id="b55279597525"><a name="b55279597525"></a><a name="b55279597525"></a>repeat-x</strong>: Repeatedly draws images along the x-axis.</li><li><strong id="b48462126535"><a name="b48462126535"></a><a name="b48462126535"></a>repeat-y</strong>: Repeatedly draws images along the y-axis.</li><li><strong id="b26935493141242"><a name="b26935493141242"></a><a name="b26935493141242"></a>no-repeat</strong>: The image is not drawn repeatedly.</li></ul>
</td>
</tr>
<tr id="row181756277552"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="a60e011e34e6c4b04a1c86ac873087eed"><a name="a60e011e34e6c4b04a1c86ac873087eed"></a><a name="a60e011e34e6c4b04a1c86ac873087eed"></a>background-position</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><a name="u2fe0f6beda39428780ca525d6dca1b30"></a><a name="u2fe0f6beda39428780ca525d6dca1b30"></a><ul id="u2fe0f6beda39428780ca525d6dca1b30"><li>string string</li><li>&lt;length&gt; &lt;length&gt;</li><li>&lt;percentage&gt; &lt;percentage&gt;</li></ul>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="ad96af7b5874e476db4b4cf968156a633"><a name="ad96af7b5874e476db4b4cf968156a633"></a><a name="ad96af7b5874e476db4b4cf968156a633"></a>0px 0px</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p445222451420"><a name="p445222451420"></a><a name="p445222451420"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><a name="ub1e24d41a33d4560a6637f7a16ee5140"></a><a name="ub1e24d41a33d4560a6637f7a16ee5140"></a><ul id="ub1e24d41a33d4560a6637f7a16ee5140"><li>Using keywords: If only one keyword is specified, the other value is <strong id="b5511326814"><a name="b5511326814"></a><a name="b5511326814"></a>center</strong> by default. The two values define the horizontal position and vertical position, respectively.<a name="uac6e07c1eb0244d79eeed180658cb6c6"></a><a name="uac6e07c1eb0244d79eeed180658cb6c6"></a><ul id="uac6e07c1eb0244d79eeed180658cb6c6"><li><strong id="b1554311179414"><a name="b1554311179414"></a><a name="b1554311179414"></a>left</strong>: leftmost in the horizontal direction</li><li><strong id="b737612182417"><a name="b737612182417"></a><a name="b737612182417"></a>right</strong>: rightmost in the horizontal direction</li><li><strong id="b1720014193413"><a name="b1720014193413"></a><a name="b1720014193413"></a>top</strong>: top in the vertical direction</li><li><strong id="b18452201349"><a name="b18452201349"></a><a name="b18452201349"></a>bottom</strong>: bottom in the vertical direction</li><li><strong id="b3875520242"><a name="b3875520242"></a><a name="b3875520242"></a>center</strong>: center position</li></ul>
</li></ul>
<a name="ua495746d9777430c973a5ec607309ac4"></a><a name="ua495746d9777430c973a5ec607309ac4"></a><ul id="ua495746d9777430c973a5ec607309ac4"><li>Using <strong id="b269119211746"><a name="b269119211746"></a><a name="b269119211746"></a>&lt;length&gt;</strong>: The first value indicates the horizontal position, and the second value indicates the vertical position. <strong id="b25271122446"><a name="b25271122446"></a><a name="b25271122446"></a>0 0</strong> indicates the upper left corner. The unit is pixel. If only one value is specified, the other one is <strong id="b132172242416"><a name="b132172242416"></a><a name="b132172242416"></a>50%</strong>.</li><li>Using <strong id="b111066252046"><a name="b111066252046"></a><a name="b111066252046"></a>&lt;percentage&gt;</strong>: The first value indicates the horizontal position, and the second value indicates the vertical position. <strong id="b48948251842"><a name="b48948251842"></a><a name="b48948251842"></a>0% 0%</strong> indicates the upper left corner. <strong id="b2756102611419"><a name="b2756102611419"></a><a name="b2756102611419"></a>100% 100%</strong> indicates the lower right corner. If only one value is specified, the other one is <strong id="b5578927747"><a name="b5578927747"></a><a name="b5578927747"></a>50%</strong>.</li><li>Using both <strong id="b154178914941242"><a name="b154178914941242"></a><a name="b154178914941242"></a>&lt;percentage&gt;</strong> and <strong id="b16022437541242"><a name="b16022437541242"></a><a name="b16022437541242"></a>&lt;length&gt;</strong>.</li></ul>
</td>
</tr>
<tr id="row31751127165514"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="a529a69841d634cdfa9637284412e5cf1"><a name="a529a69841d634cdfa9637284412e5cf1"></a><a name="a529a69841d634cdfa9637284412e5cf1"></a>opacity</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><p id="a0820f7d1c5b34d6eab999bd9dddfad6c"><a name="a0820f7d1c5b34d6eab999bd9dddfad6c"></a><a name="a0820f7d1c5b34d6eab999bd9dddfad6c"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="a35dd1b1eab3a421f9c95d512860d5bda"><a name="a35dd1b1eab3a421f9c95d512860d5bda"></a><a name="a35dd1b1eab3a421f9c95d512860d5bda"></a>1</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p14523246147"><a name="p14523246147"></a><a name="p14523246147"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><p id="a2e8d180f3c914356af72e679446f4ab5"><a name="a2e8d180f3c914356af72e679446f4ab5"></a><a name="a2e8d180f3c914356af72e679446f4ab5"></a>Opacity of an element. The value ranges from <strong id="b202809908441242"><a name="b202809908441242"></a><a name="b202809908441242"></a>0</strong> to <strong id="b99312114841242"><a name="b99312114841242"></a><a name="b99312114841242"></a>1</strong>. The value <strong id="b27854883241242"><a name="b27854883241242"></a><a name="b27854883241242"></a>1</strong> means opaque, and <strong id="b52017499041242"><a name="b52017499041242"></a><a name="b52017499041242"></a>0</strong> means completely transparent.</p>
</td>
</tr>
<tr id="row48391367556"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="a2e53aab1be1043489c29919ab37c6ea4"><a name="a2e53aab1be1043489c29919ab37c6ea4"></a><a name="a2e53aab1be1043489c29919ab37c6ea4"></a>display</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><p id="a38fa4b64eff24ff0bbb4220fb9026d73"><a name="a38fa4b64eff24ff0bbb4220fb9026d73"></a><a name="a38fa4b64eff24ff0bbb4220fb9026d73"></a>string</p>
<p id="a951b8ea86c6c45f99c84c93d6675d800"><a name="a951b8ea86c6c45f99c84c93d6675d800"></a><a name="a951b8ea86c6c45f99c84c93d6675d800"></a></p>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="add1e263e897d48a595bd7a7f81b2c0c1"><a name="add1e263e897d48a595bd7a7f81b2c0c1"></a><a name="add1e263e897d48a595bd7a7f81b2c0c1"></a>flex</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p134525242141"><a name="p134525242141"></a><a name="p134525242141"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><p id="a677d3f5076894546a1fc1404af757f26"><a name="a677d3f5076894546a1fc1404af757f26"></a><a name="a677d3f5076894546a1fc1404af757f26"></a>Type of the box containing an element. Available values are as follows:</p>
<a name="u20b5cc7616974e9d804498df629c48f1"></a><a name="u20b5cc7616974e9d804498df629c48f1"></a><ul id="u20b5cc7616974e9d804498df629c48f1"><li><strong id="b45227321849"><a name="b45227321849"></a><a name="b45227321849"></a>flex</strong>: flexible layout</li><li><strong id="b53233482941242"><a name="b53233482941242"></a><a name="b53233482941242"></a>none</strong>: The box is disabled.</li></ul>
</td>
</tr>
<tr id="row1483963614553"><td class="cellrowborder" valign="top" width="17.98%" headers="mcps1.1.6.1.1 "><p id="a74fb259ecfff44c7b47f54b335255419"><a name="a74fb259ecfff44c7b47f54b335255419"></a><a name="a74fb259ecfff44c7b47f54b335255419"></a>visibility</p>
</td>
<td class="cellrowborder" valign="top" width="15.82%" headers="mcps1.1.6.1.2 "><p id="a9a50e36f1fb246b0b1c193437d9ac37a"><a name="a9a50e36f1fb246b0b1c193437d9ac37a"></a><a name="a9a50e36f1fb246b0b1c193437d9ac37a"></a>string</p>
<p id="ab6e40650e55d48f3b666dce48145f2bd"><a name="ab6e40650e55d48f3b666dce48145f2bd"></a><a name="ab6e40650e55d48f3b666dce48145f2bd"></a></p>
</td>
<td class="cellrowborder" valign="top" width="12.379999999999999%" headers="mcps1.1.6.1.3 "><p id="a98ed5a2ff4dc4e6596afb58eea00d9e5"><a name="a98ed5a2ff4dc4e6596afb58eea00d9e5"></a><a name="a98ed5a2ff4dc4e6596afb58eea00d9e5"></a>visible</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1345202471410"><a name="p1345202471410"></a><a name="p1345202471410"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="46.300000000000004%" headers="mcps1.1.6.1.5 "><p id="a25930a9fa4bd4b8896aacc24e5202575"><a name="a25930a9fa4bd4b8896aacc24e5202575"></a><a name="a25930a9fa4bd4b8896aacc24e5202575"></a>Whether to display the box containing an element. The invisible box occupies layout space. (To remove the box, set the <strong id="b202816196553"><a name="b202816196553"></a><a name="b202816196553"></a>display</strong> attribute to <strong id="b173519194554"><a name="b173519194554"></a><a name="b173519194554"></a>none</strong>.) Available values are as follows:</p>
<a name="u2395105022844e08854f4266096995ea"></a><a name="u2395105022844e08854f4266096995ea"></a><ul id="u2395105022844e08854f4266096995ea"><li><strong id="b977043610416"><a name="b977043610416"></a><a name="b977043610416"></a>visible</strong>: The box is visible.</li><li><strong id="b7611237443"><a name="b7611237443"></a><a name="b7611237443"></a>hidden</strong>: The box is hidden but still takes up space.</li></ul>
<div class="note" id="nca29d306d97b4fbdbfd735b6c9fb57a4"><a name="nca29d306d97b4fbdbfd735b6c9fb57a4"></a><a name="nca29d306d97b4fbdbfd735b6c9fb57a4"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="a5196ede3623d46bbb930bc6254a55b9e"><a name="a5196ede3623d46bbb930bc6254a55b9e"></a><a name="a5196ede3623d46bbb930bc6254a55b9e"></a>If both <strong id="b852218381745"><a name="b852218381745"></a><a name="b852218381745"></a>visibility</strong> and <strong id="b1452217381449"><a name="b1452217381449"></a><a name="b1452217381449"></a>display</strong> are set, only <strong id="b6523143812412"><a name="b6523143812412"></a><a name="b6523143812412"></a>display</strong> takes effect.</p>
</div></div>
</td>
</tr>
</tbody>
</table>

## Events<a name="section571865310552"></a>

Events in  [Universal Events](js-components-common-events.md)  are supported.

## Method<a name="section568225514199"></a>

Not supported

## Example<a name="section1240714821316"></a>

```
<!-- xxx.hml -->
<toolbar style="position: fixed; bottom: 0px; ">    
   <toolbar-item icon='common/Icon/location.png' value='Option 1' >   </toolbar-item>
   <toolbar-item icon='common/Icon/heart.png' value='Option 2'>   </toolbar-item>    
   <toolbar-item icon='common/Icon/diamond.png' value='Option 3'  >   </toolbar-item>    
   <toolbar-item icon='common/Icon/heart.png' value='Option 4' >   </toolbar-item>    
   <toolbar-item icon='common/Icon/heart.png' value='Option 5' >   </toolbar-item>
   <toolbar-item icon='common/Icon/heart.png' value='Option 6'>   </toolbar-item> 
</toolbar>
```

![](figures/progress-7.jpg)

