# SIM卡管理

>**说明：** 
>
>本模块首批接口从API version 6开始支持。后续版本的新增接口，采用上角标单独标记接口的起始版本。

## 导入模块

```
import sim from '@ohos.telephony.sim';
```

## sim.isSimActive<a name=sim.isSimActive-callback></a>

isSimActive\(slotId: number, callback: AsyncCallback<boolean\>\): void

获取指定卡槽SIM卡是否激活，使用callback方式作为异步方法。

**需要权限**：ohos.permission.GET_TELEPHONY_STATE

**参数：**

| 参数名   | 类型                        | 必填 | 说明                                   |
| -------- | --------------------------- | ---- | -------------------------------------- |
| slotId   | number                      | 是   | 卡槽ID。<br/>- 0：卡槽1<br/>- 1：卡槽2 |
| callback | AsyncCallback&lt;boolean&gt; | 是   | 回调函数。                             |

**示例：**

```
sim.isSimActive(0, (err, data) => {
    console.log(`callback: err->${JSON.stringify(err)}, data->${JSON.stringify(data)}`);
});
```


## sim.isSimActive<a name=sim.isSimActive-promise></a>

isSimActive\(slotId: number\): Promise<string\>

获取指定卡槽SIM卡是否激活，使用Promise方式作为异步方法。

**需要权限**：ohos.permission.GET_TELEPHONY_STATE

**参数：**

| 参数名 | 类型   | 必填 | 说明                                   |
| ------ | ------ | ---- | -------------------------------------- |
| slotId | number | 是   | 卡槽ID。<br/>- 0：卡槽1<br/>- 1：卡槽2 |

**返回值：**

| 类型                  | 说明                               |
| --------------------- | ---------------------------------- |
| Promise&lt;boolean&gt; | 以Promise形式返回指定卡槽是否激活，如果激活返回true。 |

**示例：**

```
let promise = sim.isSimActive(0);
promise.then(data => {
    console.log(`isSimActive success, promise: data->${JSON.stringify(data)}`);
}).catch(err => {
    console.log(`isSimActive fail, promise: err->${JSON.stringify(err)}`);
});
```


## sim.getDefaultVoiceSlotId<sup>7+</sup><a name= sim.getDefaultVoiceSlotId-callback></a>

getDefaultVoiceSlotId\(callback: AsyncCallback<number\>\): void

获取默认语音业务的卡槽ID，使用callback方式作为异步方法。

**参数：**

| 参数名   | 类型                        | 必填 | 说明       |
| -------- | --------------------------- | ---- | ---------- |
| callback | AsyncCallback&lt;number&gt; | 是   | 回调函数。 |

**示例：**

```
sim.getDefaultVoiceSlotId((err, data) => {
    console.log(`callback: err->${JSON.stringify(err)}, data->${JSON.stringify(data)}`);
});
```


## sim.getDefaultVoiceSlotId<sup>7+</sup><a name=sim.getDefaultVoiceSlotId-promise></a>

getDefaultVoiceSlotId\(\): Promise<number\>

获取默认语音业务的卡槽ID，使用Promise方式作为异步方法。

**返回值：**

| 类型              | 说明                                    |
| ----------------- | --------------------------------------- |
| Promise\<number\> | 以Promise形式返回默认语音业务的卡槽ID。 |

**示例：**

```
let promise = sim.getDefaultVoiceSlotId();
promise.then(data => {
    console.log(`getDefaultVoiceSlotId success, promise: data->${JSON.stringify(data)}`);
}).catch(err => {
    console.log(`getDefaultVoiceSlotId fail, promise: err->${JSON.stringify(err)}`);
});
```


## sim.getISOCountryCodeForSim<a name=sim.getISOCountryCodeForSim-callback></a>

getISOCountryCodeForSim\(slotId: number, callback: AsyncCallback<string\>\): void

获取指定卡槽SIM卡的ISO国家码，使用callback方式作为异步方法。

**参数：**

| 参数名   | 类型                    | 必填 | 说明                                     |
| -------- | ----------------------- | ---- | ---------------------------------------- |
| slotId   | number                  | 是   | 卡槽ID。<br/>- 0：卡槽1<br/>- 1：卡槽2   |
| callback | AsyncCallback\<string\> | 是   | 回调函数。返回国家码，例如：CN（中国）。 |

**示例：**

```
sim.getISOCountryCodeForSim(0, (err, data) => {
    console.log(`callback: err->${JSON.stringify(err)}, data->${JSON.stringify(data)}`);
});
```


## sim.getISOCountryCodeForSim<a name=sim.getISOCountryCodeForSim-promise></a>

getISOCountryCodeForSim\(slotId: number\): Promise<string\>

获取指定卡槽SIM卡的ISO国家码，使用Promise方式作为异步方法。

**参数：**

| 参数名 | 类型   | 必填 | 说明                                   |
| ------ | ------ | ---- | -------------------------------------- |
| slotId | number | 是   | 卡槽ID。<br/>- 0：卡槽1<br/>- 1：卡槽2 |

**返回值：**

| 类型              | 说明                                                         |
| ----------------- | ------------------------------------------------------------ |
| Promise\<string\> | 以Promise形式返回获取指定卡槽SIM卡的ISO国家码，例如：CN（中国）。 |

**示例：**

```
let promise = sim.getISOCountryCodeForSim(0);
promise.then(data => {
    console.log(`getISOCountryCodeForSim success, promise: data->${JSON.stringify(data)}`);
}).catch(err => {
    console.log(`getISOCountryCodeForSim fail, promise: err->${JSON.stringify(err)}`);
});
```


## sim.getSimOperatorNumeric<a name=sim.getSimOperatorNumeric-callback></a>

getSimOperatorNumeric\(slotId: number, callback: AsyncCallback<string\>\): void

获取指定卡槽SIM卡的归属PLMN（Public Land Mobile Network）号，使用callback方式作为异步方法。

**参数：**

| 参数名   | 类型                    | 必填 | 说明                                   |
| -------- | ----------------------- | ---- | -------------------------------------- |
| slotId   | number                  | 是   | 卡槽ID。<br/>- 0：卡槽1<br/>- 1：卡槽2 |
| callback | AsyncCallback\<string\> | 是   | 回调函数。                             |

**示例：**

```
sim.getSimOperatorNumeric(0, (err, data) => {
    console.log(`callback: err->${JSON.stringify(err)}, data->${JSON.stringify(data)}`);
});
```


## sim.getSimOperatorNumeric<a name=sim.getSimOperatorNumeric-promise></a>

getSimOperatorNumeric\(slotId: number\): Promise<string\>

获取指定卡槽SIM卡的归属PLMN（Public Land Mobile Network）号，使用Promise方式作为异步方法。

**参数：**

| 参数名 | 类型   | 必填 | 说明                                   |
| ------ | ------ | ---- | -------------------------------------- |
| slotId | number | 是   | 卡槽ID。<br/>- 0：卡槽1<br/>- 1：卡槽2 |

**返回值：**

| 类型              | 说明                                             |
| ----------------- | ------------------------------------------------ |
| Promise\<string\> | 以Promise形式返回获取指定卡槽SIM卡的归属PLMN号。 |

**示例：**

```
let promise = sim.getSimOperatorNumeric(0);
promise.then(data => {
    console.log(`getSimOperatorNumeric success, promise: data->${JSON.stringify(data)}`);
}).catch(err => {
    console.log(`getSimOperatorNumeric fail, promise: err->${JSON.stringify(err)}`);
});
```


## sim.getSimSpn<a name=sim.getSimSpn-callback></a>

getSimSpn\(slotId: number, callback: AsyncCallback<string\>\): void

获取指定卡槽SIM卡的服务提供商名称（Service Provider Name，SPN），使用callback方式作为异步方法。

**参数：**

| 参数名   | 类型                    | 必填 | 说明                                   |
| -------- | ----------------------- | ---- | -------------------------------------- |
| slotId   | number                  | 是   | 卡槽ID。<br/>- 0：卡槽1<br/>- 1：卡槽2 |
| callback | AsyncCallback\<string\> | 是   | 回调函数。                             |

**示例：**

```
sim.getSimSpn(0, (err, data) => {
    console.log(`callback: err->${JSON.stringify(err)}, data->${JSON.stringify(data)}`);
});
```


## sim.getSimSpn<a name=sim.getSimSpn-promise></a>

getSimSpn\(slotId: number\): Promise<string\>

获取指定卡槽SIM卡的服务提供商名称（Service Provider Name，SPN），使用Promise方式作为异步方法。

**参数：**

| 参数名 | 类型   | 必填 | 说明                                   |
| ------ | ------ | ---- | -------------------------------------- |
| slotId | number | 是   | 卡槽ID。<br/>- 0：卡槽1<br/>- 1：卡槽2 |

**返回值：**

| 类型              | 说明                                      |
| ----------------- | ----------------------------------------- |
| Promise\<string\> | 以Promise形式返回获取指定卡槽SIM卡的SPN。 |

**示例：**

```
let promise = sim.getSimSpn(0);
promise.then(data => {
    console.log(`getSimSpn success, promise: data->${JSON.stringify(data)}`);
}).catch(err => {
    console.log(`getSimSpn fail, promise: err->${JSON.stringify(err)}`);
});
```


## sim.getSimState<a name=sim.getSimState-callback></a>

getSimState\(slotId: number, callback: AsyncCallback<SimState\>\): void

获取指定卡槽的SIM卡状态，使用callback方式作为异步方法。

**参数：**

| 参数名   | 类型                                   | 必填 | 说明                                   |
| -------- | -------------------------------------- | ---- | -------------------------------------- |
| slotId   | number                                 | 是   | 卡槽ID。<br/>- 0：卡槽1<br/>- 1：卡槽2 |
| callback | AsyncCallback\<[SimState](#SimState)\> | 是   | 回调函数。参考[SimState](#SimState)。  |

**示例：**

```
sim.getSimState(0, (err, data) => {
    console.log(`callback: err->${JSON.stringify(err)}, data->${JSON.stringify(data)}`);
});
```


## sim.getSimState<a name=sim.getSimState-promise></a>

getSimState\(slotId: number\): Promise<SimState\>

获取指定卡槽的SIM卡状态，使用Promise方式作为异步方法。

**参数：**

| 参数名 | 类型   | 必填 | 说明                                   |
| ------ | ------ | ---- | -------------------------------------- |
| slotId | number | 是   | 卡槽ID。<br/>- 0：卡槽1<br/>- 1：卡槽2 |

**返回值：**

| 类型                             | 说明                                       |
| -------------------------------- | ------------------------------------------ |
| Promise\<[SimState](#SimState)\> | 以Promise形式返回获取指定卡槽的SIM卡状态。 |

**示例：**

```
let promise = sim.getSimState(0);
promise.then(data => {
    console.log(`getSimState success, promise: data->${JSON.stringify(data)}`);
}).catch(err => {
    console.log(`getSimState fail, promise: err->${JSON.stringify(err)}`);
});
```

## sim.getCardType<a name=sim.getCardType-callback></a>

getCardType\(slotId: number, callback: AsyncCallback<CardType\>\): void

获取指定卡槽SIM卡的卡类型，使用callback方式作为异步方法。

**需要权限**：ohos.permission.GET_TELEPHONY_STATE

**参数：**

| 参数名   | 类型                    | 必填 | 说明                                   |
| -------- | ----------------------- | ---- | -------------------------------------- |
| slotId   | number                  | 是   | 卡槽ID。<br/>- 0：卡槽1<br/>- 1：卡槽2 |
| callback | AsyncCallback\<[CardType](#cardtype)\> | 是   | 回调函数。                             |

**示例：**

```
sim.getCardType(0, (err, data) => {
    console.log(`callback: err->${JSON.stringify(err)}, data->${JSON.stringify(data)}`);
});
```


## sim.getCardType<a name=sim.getCardType-promise></a>

getCardType\(slotId: number\): Promise<CardType\>

获取指定卡槽SIM卡的卡类型，使用Promise方式作为异步方法。

**需要权限**：ohos.permission.GET_TELEPHONY_STATE

**参数：**

| 参数名 | 类型   | 必填 | 说明                                   |
| ------ | ------ | ---- | -------------------------------------- |
| slotId | number | 是   | 卡槽ID。<br/>- 0：卡槽1<br/>- 1：卡槽2 |

**返回值：**

| 类型              | 说明                                                         |
| ----------------- | ------------------------------------------------------------ |
| Promise\<[CardType](#cardtype)\> | 以Promise形式返回指定卡槽SIM卡的卡类型。 |

**示例：**

```
let promise = sim.getCardType(0);
promise.then(data => {
    console.log(`getCardType success, promise: data->${JSON.stringify(data)}`);
}).catch(err => {
    console.log(`getCardType fail, promise: err->${JSON.stringify(err)}`);
});
```


## sim.hasSimCard<a name=sim.hasSimCard-callback></a>

hasSimCard\(slotId: number, callback: AsyncCallback<boolean\>\): void

获取指定卡槽SIM卡是否插卡，使用callback方式作为异步方法。

**需要权限**：ohos.permission.GET_TELEPHONY_STATE

**参数：**

| 参数名   | 类型                        | 必填 | 说明                                   |
| -------- | --------------------------- | ---- | -------------------------------------- |
| slotId   | number                      | 是   | 卡槽ID。<br/>- 0：卡槽1<br/>- 1：卡槽2 |
| callback | AsyncCallback&lt;boolean&gt; | 是   | 回调函数。                             |

**示例：**

```
sim.hasSimCard(0, (err, data) => {
    console.log(`callback: err->${JSON.stringify(err)}, data->${JSON.stringify(data)}`);
});
```


## sim.hasSimCard<a name=sim.hasSimCard-promise></a>

hasSimCard\(slotId: number\): Promise<string\>

获取指定卡槽SIM卡是否插卡，使用Promise方式作为异步方法。

**需要权限**：ohos.permission.GET_TELEPHONY_STATE

**参数：**

| 参数名 | 类型   | 必填 | 说明                                   |
| ------ | ------ | ---- | -------------------------------------- |
| slotId | number | 是   | 卡槽ID。<br/>- 0：卡槽1<br/>- 1：卡槽2 |

**返回值：**

| 类型                  | 说明                               |
| --------------------- | ---------------------------------- |
| Promise&lt;boolean&gt; | 以Promise形式返回指定卡槽是否插卡，如果插卡返回true。 |

**示例：**

```
let promise = sim.hasSimCard(0);
promise.then(data => {
    console.log(`hasSimCard success, promise: data->${JSON.stringify(data)}`);
}).catch(err => {
    console.log(`hasSimCard fail, promise: err->${JSON.stringify(err)}`);
});
```


## sim.getMaxSimCount

getMaxSimCount\(\): number

获取卡槽数量。

**需要权限**：ohos.permission.GET_TELEPHONY_STATE

**返回值：**

| 类型              | 说明                                                         |
| ----------------- | ------------------------------------------------------------ |
| number | 卡槽数量。 |

**示例：**

```
console.log(sim.getMaxSimCount())
```


## SimState<a name=SimState></a>

SIM卡状态。

| 变量                  | 说明                                                       |
| --------------------- | ---------------------------------------------------------- |
| SIM_STATE_UNKNOWN     | SIM卡状态未知，即无法获取准确的状态。                      |
| SIM_STATE_NOT_PRESENT | 表示SIM卡处于not present状态，即卡槽中没有插入SIM卡。      |
| SIM_STATE_LOCKED      | 表示SIM卡处于locked状态，即SIM卡被PIN、PUK或网络锁锁定。   |
| SIM_STATE_NOT_READY   | 表示SIM卡处于not ready状态，即SIM卡在位但无法正常工作。    |
| SIM_STATE_READY       | 表示SIM卡处于ready状态，即SIM卡在位且工作正常。            |
| SIM_STATE_LOADED      | 表示SIM卡处于loaded状态，即SIM卡在位且所有卡文件加载完毕。 |

## CardType

卡类型。

| 变量  | 值 | 说明 |
| ----- | ----- | ----- |
UNKNOWN_CARD | -1 | 未知类型 |
SINGLE_MODE_SIM_CARD | 10 | 单SIM卡 |
SINGLE_MODE_USIM_CARD | 20 | 单USIM卡 |
SINGLE_MODE_RUIM_CARD | 30 | 单RUIM卡 |
DUAL_MODE_CG_CARD | 40 | 双卡模式C+G |
CT_NATIONAL_ROAMING_CARD | 41 | 中国电信内部漫游卡 |
CU_DUAL_MODE_CARD | 42 | 中国联通双模卡 |
DUAL_MODE_TELECOM_LTE_CARD | 43 | 双模式电信LTE卡 |
DUAL_MODE_UG_CARD | 50 | 双模式UG卡 |
SINGLE_MODE_ISIM_CARD | 60 | 单一ISIM卡类型 |