# 应用事件打点概述

HiAppEvent提供了应用事件打点接口，为应用提供事件打点的功能，用于帮助应用记录在运行过程中发生的故障信息、统计信息、安全信息、用户行为信息，以支撑开发者分析应用的运行情况。

## 基本概念

HiAppEvent模块支持应用事件业务的开发，提供应用事件相关的功能，主要包括应用事件落盘、查询历史应用事件数据等功能。

- **打点**

  记录由用户操作引起的变化，提供业务数据信息，以供开发、产品、运维分析。

## 事件校验结果码

| 错误码 | 原因                        | 校验规则                                                     | 处理结果                                              |
| ------ | --------------------------- | ------------------------------------------------------------ | ----------------------------------------------------- |
| 0      | 无                          | 事件校验成功                                                 | 事件正常打点。                                        |
| -1     | 无效的事件名称              | 非空且长度在48个字符以内（含）。<br>只由以下字符组成：0-9、a-z、_。<br/>非数字以及下划线开头。 | 忽略该事件，不执行打点。                              |
| -2     | 无效的事件基本参数类型      | 事件名称参数必须为string。<br/>事件类型参数必须为number类型。<br/>keyValues参数必须为object类型。 | 忽略该事件，不执行打点。                              |
| -99    | 应用打点功能被关闭          | 应用打点功能被关闭。                                         | 忽略该事件，不执行打点。                              |
| -100   | 未知错误                    | 无。                                                         | 忽略该事件，不执行打点。                              |
| 1      | 无效的key参数名称           | 非空且长度在16个字符以内（含）。<br/>只由以下字符组成：0-9、a-z、_。<br/>非数字以及下划线开头。<br/>非下划线结尾。 | 忽略该键值对参数后，继续执行打点。                    |
| 2      | 无效的key参数类型           | Key参数必须为字符串类型。                                    | 忽略该键值对参数后，继续执行打点。                    |
| 3      | 无效的value参数类型         | value参数只支持以下类型：<br/>boolean、number、string、Array[基本类型]。<br/> | 忽略该键值对参数后，继续执行打点。                    |
| 4      | value参数值过长             | 参数值长度必须在8*1024个字符以内（含）。                     | 忽略该键值对参数后，继续执行打点。                    |
| 5      | key-value参数对数过多       | key-value参数对数必须在32对以内（含）。                      | 忽略后面多余的键值对参数后，继续执行打点。            |
| 6      | List类型的value参数容量过大 | List类型的value参数容量必须在100个以内（含）。               | 对List进行截断（只保留前100个元素）后，继续执行打点。 |
| 7      | 无效的List类型value参数     | List的泛型类型只能为基本类型。<br/>List内的参数必须为同一类型。 | 忽略该键值对参数后，继续执行打点。                    |