# OpenHarmony

——>——> Learn About the OpenHarmony Community

——>——>——> [OpenHarmony](OpenHarmony-Overview.md)

——>——>——> Learn About the OpenHarmony OS

——>——>——>——>[Kernel](readme/kernel.md)

——>——>——>——>[Driver](readme/driver.md)

——>——>——>——>[ARK Runtime](readme/ark-runtime.md)

——>——>——>——>[DFX](readme/dfx-subsystem.md)

——>——>——>——>[JS UI Framework](readme/js-ui-framework.md)

——>——>——>——>[Misc Services](readme/misc-services.md)

——>——>——>——>[XTS](readme/xts.md)

——>——>——>——>[Common Event and Notification](readme/common-event-notification.md)

——>——>——>——>[Globalization](readme/globalization.md)

——>——>——>——>[utils](readme/utils.md)

——>——>——>——>[Distributed Scheduler](readme/distributed-scheduler.md)

——>——>——>——>[Distributed Data Management](readme/distributed-data-management.md)

——>——>——>——>[Distributed File](readme/distributed-file.md)

——>——>——>——>[DSoftBus](readme/dsoftbus.md)

——>——>——>——>[Update](readme/update.md)

——>——>——>——>[Startup](readme/startup.md)

——>——>——>——>[Graphics](readme/graphics.md)

——>——>——>——>[Multimodal Input](readme/multimodal-input.md)

——>——>——>——>[Multimedia](readme/multimedia.md)

——>——>——>——>[Account](readme/account.md)

——>——>——>——>[Pan-Sensor](readme/pan-sensor.md)

——>——>——>——>[Test](readme/test.md)

——>——>——>——>[Power Management](readme/power-management.md)

——>——>——>——>[Telephony](readme/telephony.md)

——>——>——>——>[System Apps](readme/system-apps.md)

——>——>——>——>[Programming Language Runtime](readme/programming-language-runtime.md)

——>——>——>——>[AI](readme/ai.md)

——>——>——> [Glossary](device-dev/glossary/glossary.md)

——>——>——> [OpenHarmony Release Notes](release-notes/Readme.md)

——>——> Quick Start

——>——>——>[Mini and Small Systems](device-dev/quick-start/quickstart-lite.md)

——>——>——>——>[Overview of Mini and Small Systems](device-dev/quick-start/quickstart-lite-overview.md)

——>——>——>——>[Environment Setup for Mini and Small Systems](device-dev/quick-start/quickstart-lite-env-setup.md)

——>——>——>——>——>[Environment Setup Overview](device-dev/quick-start/quickstart-lite-env-setup-overview.md)

——>——>——>——>——>[Environment Setup FAQs](device-dev/quick-start/quickstart-lite-env-setup-faqs.md)

——>——>——>——>[Running Hello World](device-dev/quick-start/quickstart-lite-steps.md)

——>——>——>——>——>[Hi3861 Development Board](device-dev/quick-start/quickstart-lite-steps-hi3861.md)

——>——>——>——>——>——>[Setting Up the Environment](device-dev/quick-start/quickstart-lite-steps-hi3861-setting.md)

——>——>——>——>——>——>[Running a Hello World Program](device-dev/quick-start/quickstart-lite-steps-hi3816-running.md)

——>——>——>——>——>——>[FAQs](device-dev/quick-start/quickstart-lite-steps-hi3861-faqs.md)

——>——>——>——>——>[Hi3516 Development Board](device-dev/quick-start/quickstart-lite-steps-hi3516.md)

——>——>——>——>——>——>[Setting Up the Environment](device-dev/quick-start/quickstart-lite-steps-hi3516-setting.md)

——>——>——>——>——>——>[Running a Hello OHOS Program](device-dev/quick-start/quickstart-lite-steps-hi3516-running.md)

——>——>——>——>——>——>[FAQs](device-dev/quick-start/quickstart-lite-steps-hi3516-faqs.md)

——>——>——>——>——>[Hi3518 Development Board](device-dev/quick-start/quickstart-lite-steps-hi3518.md)

——>——>——>——>——>——>[Setting Up the Environment](device-dev/quick-start/quickstart-lite-steps-hi3518-setting.md)

——>——>——>——>——>——>[Running a Hello OHOS Program](device-dev/quick-start/quickstart-lite-steps-hi3518-running.md)

——>——>——>——>——>——>[FAQs](device-dev/quick-start/quickstart-lite-steps-hi3518-faqs.md)

——>——>——>——>[Introduction](device-dev/quick-start/quickstart-lite-introduction.md)

——>——>——>——>——>[Hi3861 Development Board](device-dev/quick-start/quickstart-lite-introduction-hi3861.md)

——>——>——>——>——>[Hi3516 Development Board](device-dev/quick-start/quickstart-lite-introduction-hi3516.md)

——>——>——>——>——>[Hi3518 Development Board](device-dev/quick-start/quickstart-lite-introduction-hi3518.md)

——>——>——>[Standard System](device-dev/quick-start/quickstart-standard.md)

——>——>——>——>[Standard System Introduction](device-dev/quick-start/quickstart-standard-overview.md)

——>——>——>——>[Running an Image](device-dev/quick-start/quickstart-standard-running.md)

——>——>——>——>[FAQs](device-dev/quick-start/quickstart-standard-faqs.md)

——>——> Compatibility and Security

——>——>——> [Privacy and Security](device-dev/security/security.md)

——>——>——>——> [Privacy Protection](device-dev/security/security-privacy-protection.md)

——>——>——>——> [Security Guidelines](device-dev/security/security-guidelines-overall.md)

——>——> Porting

——>——>——>[Mini System SoC Porting Guide](device-dev/porting/porting-minichip.md)

——>——>——>——>[Porting Preparations](device-dev/porting/porting-chip-prepare.md)

——>——>——>——>——>[Before You Start](device-dev/porting/oem_transplant_chip_prepare_knows.md)

——>——>——>——>——>[Building Adaptation Process](device-dev/porting/porting-chip-prepare-process.md)

——>——>——>——>[Kernel Porting](device-dev/porting/porting-chip-kernel.md)

——>——>——>——>——>[Overview](device-dev/porting/porting-chip-kernel-overview.md)

——>——>——>——>——>[Basic Kernel Adaptation](device-dev/porting/porting-chip-kernel-adjustment.md)

——>——>——>——>——>[Kernel Porting Verification](device-dev/porting/porting-chip-kernel-verify.md)

——>——>——>——>[Board-Level OS Porting](device-dev/porting/porting-chip-board.md)

——>——>——>——>——>[Overview](device-dev/porting/porting-chip-board-overview.md)

——>——>——>——>——>[Board-Level Driver Adaptation](device-dev/porting/porting-chip-board-driver.md)

——>——>——>——>——>[Implementation of APIs at the HAL](device-dev/porting/porting-chip-board-hal.md)

——>——>——>——>——>[System Modules](device-dev/porting/porting-chip-board-component.md)

——>——>——>——>——>[lwIP Module Adaptation](device-dev/porting/porting-chip-board-lwip.md)

——>——>——>——>——>[Third-party Module Adaptation](device-dev/porting/porting-chip-board-bundle.md)

——>——>——>——>——>[XTS](device-dev/porting/porting-chip-board-xts.md)

——>——>——>——>[FAQs](device-dev/porting/porting-chip-faqs.md)

——>——>——>[Small System SoC Porting Guide](device-dev/porting/porting-smallchip.md)

——>——>——>——>[Porting Preparations](device-dev/porting/porting-smallchip-prepare.md)

——>——>——>——>——>[Before You Start](device-dev/porting/porting-smallchip-prepare-needs.md)

——>——>——>——>——>[Compilation and Building](device-dev/porting/porting-smallchip-prepare-building.md)

——>——>——>——>[Kernel Porting](device-dev/porting/porting-smallchip-kernel.md)

——>——>——>——>——>[LiteOS Cortex-A](device-dev/porting/porting-smallchip-kernel-a.md)

——>——>——>——>——>[Linux Kernel](device-dev/porting/porting-smallchip-kernel-linux.md)

——>——>——>——>[Driver Porting](device-dev/porting/porting-smallchip-driver.md)

——>——>——>——>——>[Overview](device-dev/porting/porting-smallchip-driver-overview.md)

——>——>——>——>——>[Platform Driver Porting](device-dev/porting/porting-smallchip-driver-plat.md)

——>——>——>——>——>[Device Driver Porting](device-dev/porting/porting-smallchip-driver-oom.md)

——>——>——>[Standard System Porting Guide](device-dev/porting/standard-system-porting-guide.md)

——>——>——>——>[Standard System Porting Guide](device-dev/porting/standard-system-porting-guide.md)

——>——>——>——>[A Method for Rapidly Porting the OpenHarmony Linux Kernel](device-dev/porting/porting-linux-kernel.md)

——>——>——>[Third-Party Library Porting Guide for Mini and Small Systems](device-dev/porting/porting-thirdparty.md)

——>——>——>——>[Overview](device-dev/porting/porting-thirdparty-overview.md)

——>——>——>——>[Porting a Library Built Using CMake](device-dev/porting/porting-thirdparty-cmake.md)

——>——>——>——>[Porting a Library Built Using Makefile](device-dev/porting/porting-thirdparty-makefile.md)

——>——> Subsystem Development

——>——>——> [Kernel](device-dev/kernel/kernel.md)

——>——>——>——> [Kernel for the Mini System](device-dev/kernel/kernel-mini.md)

——>——>——>——>——> [Kernel Overview](device-dev/kernel/kernel-mini-overview.md)

——>——>——>——>——> [Basic Kernel](device-dev/kernel/kernel-mini-basic.md)

——>——>——>——>——>——> [Interrupt Management](device-dev/kernel/kernel-mini-basic-interrupt.md)

——>——>——>——>——>——> [Task Management](device-dev/kernel/kernel-mini-basic-task.md)

——>——>——>——>——>——> [Memory Management](device-dev/kernel/kernel-mini-basic-memory.md)

——>——>——>——>——>——>——> [Basic Concepts](device-dev/kernel/kernel-mini-basic-memory-basic.md)

——>——>——>——>——>——>——> [Static Memory](device-dev/kernel/kernel-mini-basic-memory-static.md)

——>——>——>——>——>——>——> [Dynamic Memory](device-dev/kernel/kernel-mini-basic-memory-dynamic.md)

——>——>——>——>——>——> [Kernel Communication Mechanisms](device-dev/kernel/kernel-mini-basic-ipc.md)

——>——>——>——>——>——>——> [Event](device-dev/kernel/kernel-mini-basic-ipc-event.md)

——>——>——>——>——>——>——> [Mutex](device-dev/kernel/kernel-mini-basic-ipc-mutex.md)

——>——>——>——>——>——>——> [Queue](device-dev/kernel/kernel-mini-basic-ipc-queue.md)

——>——>——>——>——>——>——> [Semaphore](device-dev/kernel/kernel-mini-basic-ipc-sem.md)

——>——>——>——>——>——> [Time Management](device-dev/kernel/kernel-basic-mini-time.md)

——>——>——>——>——>——> [Software Timer](device-dev/kernel/kernel-mini-basic-soft.md)

——>——>——>——>——> [Extended Components](device-dev/kernel/kernel-mini-extend.md)

——>——>——>——>——>——> [C++ Support](device-dev/kernel/kernel-mini-extend-support.md)

——>——>——>——>——>——> [CPUP](device-dev/kernel/kernel-mini-extend-cpup.md)

——>——>——>——>——>——> [Dynamic Loading](kernel-mini-extend-dynamic-loading.md) 

——>——>——>——>——>——> [File System](device-dev/kernel/kernel-mini-extend-file.md)

——>——>——>——>——>——>——> [FAT](device-dev/kernel/kernel-mini-extend-file-fat.md)

——>——>——>——>——>——>——> [LittleFS](device-dev/kernel/kernel-mini-extend-file-lit.md)

——>——>——>——>——> [Kernel Debugging](device-dev/kernel/kernel-memory-inner.md)

——>——>——>——>——>——> [Memory Debugging](device-dev/kernel/kernel-mini-memory-debug.md)

——>——>——>——>——>——>——> [Memory Information Statistics](device-dev/kernel/kernel-mini-memory-debug-mes.md)

——>——>——>——>——>——>——> [Memory Leak Check](device-dev/kernel/kernel-mini-imemory-debug-det.md)

——>——>——>——>——>——>——> [Memory Corruption Check](device-dev/kernel/kernel-mini-memory-debug-cet.md)

——>——>——>——>——>——> [Exception Debugging](device-dev/kernel/kernel-mini-memory-exception.md)

——>——>——>——>——>——> [Trace](device-dev/kernel/kernel-mini-memory-trace.md)

——>——>——>——>——>——> [LMS](device-dev/kernel/kernel-mini-debug-lms.md)

——>——>——>——>——> [Appendix](device-dev/kernel/kernel-mini-app.md)

——>——>——>——>——>——> [Kernel Coding Specification](device-dev/kernel/kernel-mini-appx-code.md)

——>——>——>——>——>——> [Basic Data Structure](device-dev/kernel/kernel-mini-appx-data.md)

——>——>——>——>——>——>——> [Doubly Linked List](device-dev/kernel/kernel-mini-appx-data-list.md)

——>——>——>——>——>——> [Standard Libraries](device-dev/kernel/kernel-mini-appx-lib.md)

——>——>——>——>——>——>——> [CMSIS Support](device-dev/kernel/kernel-mini-appx-lib-cmsis.md)

——>——>——>——>——>——>——> [POSIX Support](device-dev/kernel/kernel-mini-appx-lib-posix.md)

——>——>——>——> [Kernel for the Small System](device-dev/kernel/kernel-small.md)

——>——>——>——>——> [Kernel Overview](device-dev/kernel/kernel-small-overview.md)

——>——>——>——>——> [Kernel Startup](device-dev/kernel/kernel-small-start.md)

——>——>——>——>——>——> [Startup in Kernel Mode](device-dev/kernel/kernel-small-start-kernel.md)

——>——>——>——>——>——> [Startup in User Mode](device-dev/kernel/kernel-small-start-user.md)

——>——>——>——>——> [Basic Kernel](device-dev/kernel/kernel-small-basics.md)

——>——>——>——>——>——> [Interrupt and Exception Handling](device-dev/kernel/kernel-small-basic-interrupt.md)

——>——>——>——>——>——> [Process Management](device-dev/kernel/kernel-small-basic-process.md)

——>——>——>——>——>——>——> [Process](device-dev/kernel/kernel-small-basic-process-process.md)

——>——>——>——>——>——>——> [Task](device-dev/kernel/kernel-small-basic-process-thread.md)

——>——>——>——>——>——>——> [Scheduler](device-dev/kernel/kernel-small-basic-process-scheduler.md)

——>——>——>——>——>——> [Memory Management](device-dev/kernel/kernel-small-basic-memory.md)

——>——>——>——>——>——>——> [Heap Memory Management](device-dev/kernel/kernel-small-basic-memory-heap.md)

——>——>——>——>——>——>——> [Physical Memory Management](device-dev/kernel/kernel-small-basic-memory-physical.md)

——>——>——>——>——>——>——> [Virtual Memory Management](device-dev/kernel/kernel-small-basic-memory-virtual.md)

——>——>——>——>——>——>——> [Virtual-to-Physical Mapping](device-dev/kernel/kernel-small-basic-inner-reflect.md)

——>——>——>——>——>——> [Kernel Communication Mechanisms](device-dev/kernel/kernel-small-basic-trans.md)

——>——>——>——>——>——>——> [Event](device-dev/kernel/kernel-small-basic-trans-event.md)

——>——>——>——>——>——>——> [Semaphore](device-dev/kernel/kernel-small-basic-trans-semaphore.md)

——>——>——>——>——>——>——> [Mutex](device-dev/kernel/kernel-small-basic-trans-mutex.md)

——>——>——>——>——>——>——> [Queue](device-dev/kernel/kernel-small-basic-trans-queue.md)

——>——>——>——>——>——>——> [RW Lock](device-dev/kernel/kernel-small-basic-trans-rwlock.md)

——>——>——>——>——>——>——> [Futex](device-dev/kernel/kernel-small-basic-trans-user-mutex.md)

——>——>——>——>——>——>——> [Signal](device-dev/kernel/kernel-small-basic-trans-user-signal.md)

——>——>——>——>——>——> [Time Management](device-dev/kernel/kernel-small-basic-time.md)

——>——>——>——>——>——> [Software Timer](device-dev/kernel/kernel-small-basic-softtimer.md)

——>——>——>——>——>——> [Atomic Operation](device-dev/kernel/kernel-small-basic-atomic.md)

——>——>——>——>——> [Extended Components](device-dev/kernel/kernel-small-bundles.md)

——>——>——>——>——>——> [System Call](device-dev/kernel/kernel-small-bundles-system.md)

——>——>——>——>——>——> [Dynamic Loading and Linking](device-dev/kernel/kernel-small-bundles-linking.md)

——>——>——>——>——>——> [Virtual Dynamic Shared Object](device-dev/kernel/kernel-small-bundles-share.md)

——>——>——>——>——>——> [LiteIPC](device-dev/kernel/kernel-small-bundles-ipc.md)

——>——>——>——>——>——> [File Systems](device-dev/kernel/kernel-small-bundles-fs.md)

——>——>——>——>——>——>——> [Virtual File System](device-dev/kernel/kernel-small-bundles-fs-virtual.md)

——>——>——>——>——>——>——> [Supported File Systems](device-dev/kernel/kernel-small-bundles-fs-support.md)

——>——>——>——>——>——>——>——> [FAT](device-dev/kernel/kernel-small-bundles-fs-support-fat.md)

——>——>——>——>——>——>——>——> [JFFS2](device-dev/kernel/kernel-small-bundles-fs-support-jffs2.md)

——>——>——>——>——>——>——>——> [NFS](device-dev/kernel/kernel-small-bundles-fs-support-nfs.md)

——>——>——>——>——>——>——>——> [Ramfs](device-dev/kernel/kernel-small-bundles-fs-support-ramfs.md)

——>——>——>——>——>——>——>——> [procfs](device-dev/kernel/kernel-small-bundles-fs-support-procfs.md)

——>——>——>——>——>——>——> [File System Adaptation](device-dev/kernel/kernel-small-bundles-fs-new.md)

——>——>——>——>——> [Debugging and Tools](device-dev/kernel/kernel-small-debug.md)

——>——>——>——>——>——> [Shell](device-dev/kernel/kernel-small-debug-shell.md)

——>——>——>——>——>——>——> [Introduction to the Shell](device-dev/kernel/kernel-small-debug-shell-overview.md)

——>——>——>——>——>——>——> [Shell Command Development Guidelines](device-dev/kernel/kernel-small-debug-shell-guide.md)

——>——>——>——>——>——>——> [Shell Command Programming Example](device-dev/kernel/kernel-small-debug-shell-build.md)

——>——>——>——>——>——>——> [Shell Command Reference](device-dev/kernel/kernel-small-debug-shell-details.md)

——>——>——>——>——>——>——>——> [System Commands](device-dev/kernel/kernel-small-debug-shell-cmd.md)

——>——>——>——>——>——>——>——>——> [cpup](device-dev/kernel/kernel-small-debug-shell-cmd-cpup.md)

——>——>——>——>——>——>——>——>——> [date](device-dev/kernel/kernel-small-debug-shell-cmd-date.md)

——>——>——>——>——>——>——>——>——> [dmesg](device-dev/kernel/kernel-small-debug-shell-cmd-dmesg.md)

——>——>——>——>——>——>——>——>——> [exec](device-dev/kernel/kernel-small-debug-shell-cmd-exec.md)

——>——>——>——>——>——>——>——>——> [free](device-dev/kernel/kernel-small-debug-shell-cmd-free.md)

——>——>——>——>——>——>——>——>——> [help](device-dev/kernel/kernel-small-debug-shell-cmd-help.md)

——>——>——>——>——>——>——>——>——> [hwi](device-dev/kernel/kernel-small-debug-shell-cmd-hwi.md)

——>——>——>——>——>——>——>——>——> [kill](device-dev/kernel/kernel-small-debug-shell-cmd-kill.md)

——>——>——>——>——>——>——>——>——> [log](device-dev/kernel/kernel-small-debug-shell-cmd-log.md)

——>——>——>——>——>——>——>——>——> [memcheck](device-dev/kernel/kernel-small-debug-shell-cmd-memcheck.md)

——>——>——>——>——>——>——>——>——> [oom](device-dev/kernel/kernel-small-debug-shell-cmd-oom.md)

——>——>——>——>——>——>——>——>——> [pmm](device-dev/kernel/kernel-small-debug-shell-cmd-pmm.md)

——>——>——>——>——>——>——>——>——> [reset](device-dev/kernel/kernel-small-debug-shell-cmd-reset.md)

——>——>——>——>——>——>——>——>——> [sem](device-dev/kernel/kernel-small-debug-shell-cmd-sem.md)

——>——>——>——>——>——>——>——>——> [stack](device-dev/kernel/kernel-small-debug-shell-cmd-stack.md)

——>——>——>——>——>——>——>——>——> [su](device-dev/kernel/kernel-small-debug-shell-cmd-su.md)

——>——>——>——>——>——>——>——>——> [swtmr](device-dev/kernel/kernel-small-debug-shell-cmd-swtmr.md)

——>——>——>——>——>——>——>——>——> [systeminfo](device-dev/kernel/kernel-small-debug-shell-cmd-sysinfo.md)

——>——>——>——>——>——>——>——>——> [task](device-dev/kernel/kernel-small-debug-shell-cmd-task.md)

——>——>——>——>——>——>——>——>——> [uname](device-dev/kernel/kernel-small-debug-shell-cmd-uname.md)

——>——>——>——>——>——>——>——>——> [vmm](device-dev/kernel/kernel-small-debug-shell-cmd-vmm.md)

——>——>——>——>——>——>——>——>——> [watch](device-dev/kernel/kernel-small-debug-shell-cmd-watch.md)

——>——>——>——>——>——>——>——>——>[reboot](device-dev/kernel/kernel-small-debug-shell-cmd-reboot.md)

——>——>——>——>——>——>——>——>——>[top](device-dev/kernel/kernel-small-debug-shell-cmd-top.md)

——>——>——>——>——>——>——>——> [File Commands](device-dev/kernel/kernel-small-debug-shell-file.md)

——>——>——>——>——>——>——>——>——> [cat](device-dev/kernel/kernel-small-debug-shell-file-cat.md)

——>——>——>——>——>——>——>——>——> [cd](device-dev/kernel/kernel-small-debug-shell-file-cd.md)

——>——>——>——>——>——>——>——>——> [chgrp](device-dev/kernel/kernel-small-debug-shell-file-chgrp.md)

——>——>——>——>——>——>——>——>——> [chmod](device-dev/kernel/kernel-small-debug-shell-file-chmod.md)

——>——>——>——>——>——>——>——>——> [chown](device-dev/kernel/kernel-small-debug-shell-file-chown.md)

——>——>——>——>——>——>——>——>——> [cp](device-dev/kernel/kernel-small-debug-shell-file-cp.md)

——>——>——>——>——>——>——>——>——> [format](device-dev/kernel/kernel-small-debug-shell-file-format.md)

——>——>——>——>——>——>——>——>——> [ls](device-dev/kernel/kernel-small-debug-shell-file-ls.md)

——>——>——>——>——>——>——>——>——> [lsfd](device-dev/kernel/kernel-small-debug-shell-file-lsfd.md)

——>——>——>——>——>——>——>——>——> [mkdir](device-dev/kernel/kernel-small-debug-shell-file-mkdir.md)

——>——>——>——>——>——>——>——>——> [mount](device-dev/kernel/kernel-small-debug-shell-file-mount.md)

——>——>——>——>——>——>——>——>——> [partinfo](device-dev/kernel/kernel-small-debug-shell-file-partinfo.md)

——>——>——>——>——>——>——>——>——> [partition](device-dev/kernel/kernel-small-debug-shell-file-partition.md)

——>——>——>——>——>——>——>——>——> [pwd](device-dev/kernel/kernel-small-debug-shell-file-pwd.md)

——>——>——>——>——>——>——>——>——> [rm](device-dev/kernel/kernel-small-debug-shell-file-rm.md)

——>——>——>——>——>——>——>——>——> [rmdir](device-dev/kernel/kernel-small-debug-shell-file-rmdir.md)

——>——>——>——>——>——>——>——>——> [statfs](device-dev/kernel/kernel-small-debug-shell-file-statfs.md)

——>——>——>——>——>——>——>——>——> [sync](device-dev/kernel/kernel-small-debug-shell-file-sync.md)

——>——>——>——>——>——>——>——>——> [touch](device-dev/kernel/kernel-small-debug-shell-file-touch.md)

——>——>——>——>——>——>——>——>——> [writeproc](device-dev/kernel/kernel-small-debug-shell-file-write.md)

——>——>——>——>——>——>——>——>——> [umount](device-dev/kernel/kernel-small-debug-shell-file-umount.md)

——>——>——>——>——>——>——>——>——>[du](device-dev/kernel/kernel-small-debug-shell-file-du.md)

——>——>——>——>——>——>——>——>——>[mv](device-dev/kernel/kernel-small-debug-shell-file-mv.md)

——>——>——>——>——>——>——>——> [Network Commands](device-dev/kernel/kernel-small-debug-shell-net.md)

——>——>——>——>——>——>——>——>——> [arp](device-dev/kernel/kernel-small-debug-shell-net-arp.md)

——>——>——>——>——>——>——>——>——> [dhclient](device-dev/kernel/kernel-small-debug-shell-net-dhclient.md)

——>——>——>——>——>——>——>——>——> [ifconfig](device-dev/kernel/kernel-small-debug-shell-net-ifconfig.md)

——>——>——>——>——>——>——>——>——> [ipdebug](device-dev/kernel/kernel-small-debug-shell-net-ipdebug.md)

——>——>——>——>——>——>——>——>——> [netstat](device-dev/kernel/kernel-small-debug-shell-net-netstat.md)

——>——>——>——>——>——>——>——>——> [ntpdate](device-dev/kernel/kernel-small-debug-shell-net-ntpdate.md)

——>——>——>——>——>——>——>——>——> [ping](device-dev/kernel/kernel-small-debug-shell-net-ping.md)

——>——>——>——>——>——>——>——>——> [ping6](device-dev/kernel/kernel-small-debug-shell-net-ping6.md)

——>——>——>——>——>——>——>——>——> [telnet](device-dev/kernel/kernel-small-debug-shell-net-telnet.md)

——>——>——>——>——>——>——>——>——> [tftp](device-dev/kernel/kernel-small-debug-shell-net-tftp.md)

——>——>——>——>——>——>——> [Magic Key](device-dev/kernel/kernel-small-debug-shell-magickey.md)

——>——>——>——>——>——>——> [User-Mode Exception Information](device-dev/kernel/kernel-small-debug-shell-error.md)

——>——>——>——>——>——> [Trace](device-dev/kernel/kernel-small-debug-trace.md)

——>——>——>——>——>——> [Process Commissioning](device-dev/kernel/kernel-small-debug-process.md)

——>——>——>——>——>——>——> [CPUP](device-dev/kernel/kernel-small-debug-process-cpu.md)

——>——>——>——>——>——> [Kernel-Mode Memory Debugging](device-dev/kernel/kernel-small-debug-memory.md)

——>——>——>——>——>——>——> [Memory Information Statistics](device-dev/kernel/kernel-small-debug-memory-info.md)

——>——>——>——>——>——>——> [Memory Leak Check](device-dev/kernel/kernel-small-debug-memory-leak.md)

——>——>——>——>——>——>——> [Memory Corruption Check](device-dev/kernel/kernel-small-debug-memory-corrupt.md)

——>——>——>——>——>——>[User-Mode Memory Debugging](device-dev/kernel/kernel-small-debug-user.md)

——>——>——>——>——>——>——>[Basic Concepts](device-dev/kernel/kernel-small-debug-user-concept.md)

——>——>——>——>——>——>——>[Working Principles](device-dev/kernel/kernel-small-debug-user-function.md)

——>——>——>——>——>——>——>[Usage](device-dev/kernel/kernel-small-debug-user-guide.md)

——>——>——>——>——>——>——>——>[API Description](device-dev/kernel/kernel-small-debug-user-guide-api.md)

——>——>——>——>——>——>——>——>[How to Use](device-dev/kernel/kernel-small-debug-user-guide-use.md)

——>——>——>——>——>——>——>——>——>[Calling APIs](device-dev/kernel/kernel-small-debug-user-guide-use-api.md)

——>——>——>——>——>——>——>——>——>[Using the CLI](device-dev/kernel/kernel-small-debug-user-guide-use-cli.md)

——>——>——>——>——>——>——>[Typical Memory Problems](device-dev/kernel/kernel-small-debug-user-faqs.md)

——>——>——>——>——>——> [Other Kernel Debugging Methods](device-dev/kernel/kernel-small-debug-other.md)

——>——>——>——>——>——>——> [Dying Gasp](device-dev/kernel/kernel-small-debug-trace-other-lastwords.md)

——>——>——>——>——>——>——> [Common Fault Locating Methods](device-dev/kernel/kernel-small-debug-trace-other-faqs.md)

——>——>——>——>——> [Appendix](device-dev/kernel/kernel-small-apx.md)

——>——>——>——>——>——> [Basic Data Structure](device-dev/kernel/kernel-small-apx-structure.md)

——>——>——>——>——>——>——> [Doubly Linked List](device-dev/kernel/kernel-small-apx-dll.md)

——>——>——>——>——>——>——> [Bitwise Operation](device-dev/kernel/kernel-small-apx-bitwise.md)

——>——>——>——>——>——> [Standard Library](device-dev/kernel/kernel-small-apx-library.md)

——>——>——>——> [Kernel for Standard System](device-dev/kernel/kernel-standard.md)

——>——>——>——>——> [Linux Kernel Overview](device-dev/kernel/kernel-standard-overview.md)

——>——>——>——>——> [Guidelines for Using Patches on OpenHarmony Development Boards](device-dev/kernel/kernel-standard-patch.md)

——>——>——>——>——> [Guidelines for Compiling and Building the Linux Kernel](device-dev/kernel/kernel-standard-build.md)

——>——>——> [Driver](device-dev/driver/driver.md)

——>——>——>——>[HDF](device-dev/driver/driver-hdf.md)

——>——>——>——>——>[HDF Overview](device-dev/driver/driver-hdf-overview.md)

——>——>——>——>——>[Driver Development](device-dev/driver/driver-hdf-development.md)

——>——>——>——>——>[Driver Service Management](device-dev/driver/driver-hdf-servicemanage.md)

——>——>——>——>——>[Driver Message Mechanism Management](device-dev/driver/driver-hdf-message-management.md)

——>——>——>——>——>[Driver Configuration Management](device-dev/driver/driver-hdf-manage.md)

——>——>——>——>——>[HDF Development Example](device-dev/driver/driver-hdf-sample.md)

——>——>——>——>[Platform Driver Development](device-dev/driver/driver-develop.md)

——>——>——>——>——>[ADC](device-dev/driver/driver-platform-adc-develop.md)

——>——>——>——>——>[GPIO](device-dev/driver/driver-platform-gpio-develop.md)

——>——>——>——>——>[HDMI](device-dev/driver/driver-platform-hdmi-develop.md)

——>——>——>——>——>[I2C](device-dev/driver/driver-platform-i2c-develop.md)

——>——>——>——>——>[I3C](device-dev/driver/driver-platform-i3c-develop.md)

——>——>——>——>——>[MIPI CSI](device-dev/driver/driver-platform-mipicsi-develop.md)

——>——>——>——>——>[MIPI DSI](device-dev/driver/driver-platform-mipidsi-develop.md)

——>——>——>——>——>[MMC](device-dev/driver/driver-platform-mmc-develop.md)

——>——>——>——>——>[PWM](device-dev/driver/driver-platform-pwm-develop.md)

——>——>——>——>——>[RTC](device-dev/driver/driver-platform-rtc-develop.md)

——>——>——>——>——>[SDIO](device-dev/driver/driver-platform-sdio-develop.md)

——>——>——>——>——>[SPI](device-dev/driver/driver-platform-spi-develop.md)

——>——>——>——>——>[UART](device-dev/driver/driver-platform-uart-develop.md)

——>——>——>——>——>[Watchdog](device-dev/driver/driver-platform-watchdog-develop.md)

——>——>——>——>[Driver Platform Usage](device-dev/driver/driver-platform.md)

——>——>——>——>——>[ADC](device-dev/driver/driver-platform-adc-des.md)

——>——>——>——>——>[GPIO](device-dev/driver/driver-platform-gpio-des.md)

——>——>——>——>——>[HDMI](device-dev/driver/driver-platform-hdmi-des.md)

——>——>——>——>——>[I2C](device-dev/driver/driver-platform-i2c-des.md)

——>——>——>——>——>[I3C](device-dev/driver/driver-platform-i3c-des.md)

——>——>——>——>——>[MIPI CSI](device-dev/driver/driver-platform-mipicsi-des.md)

——>——>——>——>——>[MIPI DSI](device-dev/driver/driver-platform-mipidsi-des.md)

——>——>——>——>——>[PWM](device-dev/driver/driver-platform-pwm-des.md)

——>——>——>——>——>[RTC](device-dev/driver/driver-platform-rtc-des.md)

——>——>——>——>——>[SDIO](device-dev/driver/driver-platform-sdio-des.md)

——>——>——>——>——>[SPI](device-dev/driver/driver-platform-spi-des.md)

——>——>——>——>——>[UART](device-dev/driver/driver-platform-uart-des.md)

——>——>——>——>——>[Watchdog](device-dev/driver/driver-platform-watchdog-des.md)

——>——>——>——>[Peripheral Driver Usage](device-dev/driver/driver-peripherals.md)

——>——>——>——>——>[LCD](device-dev/driver/driver-peripherals-lcd-des.md)

——>——>——>——>——>[Touchscreen](device-dev/driver/driver-peripherals-touch-des.md)

——>——>——>——>——>[Sensor](device-dev/driver/driver-peripherals-sensor-des.md)

——>——>——>——>——>[WLAN](device-dev/driver/driver-peripherals-external-des.md)

——>——>——>——>——>[Audio](device-dev/driver/driver-peripherals-audio-des.md)

——>——>——>——>——>[USB](device-dev/driver/driver-peripherals-usb-des.md)

——>——>——>——>——>[Camera](device-dev/driver/driver-peripherals-camera-des.md)

——>——>——> [Compilation and Building](device-dev/subsystems/subsys-build.md)

——>——>——>——> [Building Guidelines for Mini and Small Systems](device-dev/subsystems/subsys-build-mini-lite.md)

——>——>——>——> [Building Guidelines for Standard Systems](device-dev/subsystems/subsys-build-standard-large.md)

——>——>——>——>[Build System Coding Specifications and Best Practices](device-dev/subsystems/subsys-build-gn-coding-style-and-best-practice.md)

——>——>——> [Distributed Remote Startup](device-dev/subsystems/subsys-remote-start.md)

——>——>——> [Graphics](device-dev/subsystems/subsys-graphics.md)

——>——>——>——> [Graphics](device-dev/subsystems/subsys-graphics-overview.md)

——>——>——>——> [Development Guidelines on Container Components](device-dev/subsystems/subsys-graphics-container-guide.md)

——>——>——>——> [Development Guidelines on Layout Container Components](device-dev/subsystems/subsys-graphics-layout-guide.md)

——>——>——>——> [Development Guidelines on Common Components](device-dev/subsystems/subsys-graphics-common-guide.md)

——>——>——>——> [Development Guidelines on Animators](device-dev/subsystems/subsys-graphics-animation-guide.md)

——>——>——> [Multimedia](device-dev/subsystems/subsys-multimedia.md)

——>——>——>——> [Camera](device-dev/subsystems/subsys-multimedia-camera.md)

——>——>——>——>——> [Overview](device-dev/subsystems/subsys-multimedia-camera-overview.md)

——>——>——>——>——> [Development Guidelines on Photographing](device-dev/subsystems/subsys-multimedia-camera-photo-guide.md)

——>——>——>——>——> [Development Guidelines on Video Recording](device-dev/subsystems/subsys-multimedia-camera-record-guide.md)

——>——>——>——>——> [Development Guidelines on Previewing](device-dev/subsystems/subsys-multimedia-camera-preview-guide.md)

——>——>——>——> [Audio/Video](device-dev/subsystems/subsys-multimedia-video.md)

——>——>——>——>——> [Overview](device-dev/subsystems/subsys-multimedia-video-overview.md)

——>——>——>——>——> [Development Guidelines on Media Playback](device-dev/subsystems/subsys-multimedia-video-play-guide.md)

——>——>——>——>——> [Development Guidelines on Media Recording](device-dev/subsystems/subsys-multimedia-video-record-guide.md)

——>——>——> [Utils](device-dev/subsystems/subsys-utils.md)

——>——>——>——> [Utils Overview](device-dev/subsystems/subsys-utils-overview.md)

——>——>——>——> [Utils Development Guidelines](device-dev/subsystems/subsys-utils-guide.md)

——>——>——>——> [Utils FAQ](device-dev/subsystems/subsys-utils-faqs.md)

——>——>——> [AI Framework](device-dev/subsystems/subsys-aiframework.md)

——>——>——>——> [AI Engine Framework](device-dev/subsystems/subsys-aiframework-guide.md)

——>——>——>——> [Development Environment](device-dev/subsystems/subsys-aiframework-envbuild.md)

——>——>——>——> [Technical Specifications](device-dev/subsystems/subsys-aiframework-tech.md)

——>——>——>——>——> [Code Management](device-dev/subsystems/subsys-aiframework-tech-codemanage.md)

——>——>——>——>——> [Naming](device-dev/subsystems/subsys-aiframework-tech-name.md)

——>——>——>——>——> [API Development](device-dev/subsystems/subsys-aiframework-tech-interface.md)

——>——>——>——> [Development Guidelines](device-dev/subsystems/subsys-aiframework-devguide.md)

——>——>——>——>——> [SDK](device-dev/subsystems/subsys-aiframework-devguide-sdk.md)

——>——>——>——>——> [Plug-in](device-dev/subsystems/subsys-aiframework-devguide-plugin.md)

——>——>——>——>——> [Configuration File](device-dev/subsystems/subsys-aiframework-devguide-conf.md)

——>——>——>——> [Development Examples](device-dev/subsystems/subsys-aiframework-demo.md)

——>——>——>——>——> [KWS SDK](device-dev/subsystems/subsys-aiframework-demo-sdk.md)

——>——>——>——>——> [KWS Plug-in](device-dev/subsystems/subsys-aiframework-demo-plugin.md)

——>——>——>——>——> [KWS Configuration File](device-dev/subsystems/subsys-aiframework-demo-conf.md)

——>——>——> [Sensor](device-dev/subsystems/subsys-sensor.md)

——>——>——>——> [Sensor Overview](device-dev/subsystems/subsys-sensor-overview.md)

——>——>——>——> [Sensor Usage Guidelines](device-dev/subsystems/subsys-sensor-guide.md)

——>——>——>——> [Sensor Usage Example](device-dev/subsystems/subsys-sensor-demo.md)

——>——>——> [Application Framework](device-dev/subsystems/subsys-application-framework.md)

——>——>——>——> [Overview](device-dev/subsystems/subsys-application-framework-overview.md)

——>——>——>——> [Setting Up a Development Environment](device-dev/subsystems/subsys-application-framework-envbuild.md)

——>——>——>——> [Development Guidelines](device-dev/subsystems/subsys-application-framework-guide.md)

——>——>——>——> [Development Example](device-dev/subsystems/subsys-application-framework-demo.md)

——>——>——> [OTA Update](device-dev/subsystems/subsys-ota-guide.md)

——>——>——>[Telephony Service](device-dev/subsystems/subsys-tel.md)

——>——>——> [Security](device-dev/subsystems/subsys-security.md)

——>——>——>——> [Overview](device-dev/subsystems/subsys-security-overview.md)

——>——>——>——> [Development Guidelines on Application Signature Verification](device-dev/subsystems/subsys-security-sigverify.md)

——>——>——>——> [Development Guidelines on Application Permission Management](device-dev/subsystems/subsys-security-rightmanagement.md)

——>——>——>——> [Development Guidelines on IPC Authentication](device-dev/subsystems/subsys-security-communicationverify.md)

——>——>——> [Startup](device-dev/subsystems/subsys-boot.md)

——>——>——>——> [Startup](device-dev/subsystems/subsys-boot-overview.md)

——>——>——>——> [init Module](device-dev/subsystems/subsys-boot-init.md)

——>——>——>——> [appspawn Module](device-dev/subsystems/subsys-boot-appspawn.md)

——>——>——>——> [bootstrap Module](device-dev/subsystems/subsys-boot-bootstrap.md)

——>——>——>——> [syspara Module](device-dev/subsystems/subsys-boot-syspara.md)

——>——>——>——> [FAQs](device-dev/subsystems/subsys-boot-faqs.md)

——>——>——>——> [Reference](device-dev/subsystems/subsys-boot-ref.md)

——>——>——> [DFX](device-dev/subsystems/subsys-dfx.md)

——>——>——>——>[DFX Overview](device-dev/subsystems/subsys-dfx-overview.md)

——>——>——>——>[HiLog Development](device-dev/subsystems/subsys-dfx-hilog-rich.md)

——>——>——>——>[HiLog_Lite Development](device-dev/subsystems/subsys-dfx-hilog-lite.md)

——>——>——>——>[HiTrace Development](device-dev/subsystems/subsys-dfx-hitrace.md)

——>——>——>——>[HiCollie Development](device-dev/subsystems/subsys-dfx-hicollie.md)

——>——>——>——>[HiSysEvent Development](device-dev/subsystems/subsys-dfx-hisysevent.md)

——>——>——>——>——>[HiSysEvent Logging Configuration](device-dev/subsystems/subsys-dfx-hisysevent-logging-config.md)

——>——>——>——>——>[HiSysEvent Logging](device-dev/subsystems/subsys-dfx-hisysevent-logging.md)

——>——>——>——>——>[HiSysEvent Listening](device-dev/subsystems/subsys-dfx-hisysevent-listening.md)

——>——>——>——>——>[HiSysEvent Query](device-dev/subsystems/subsys-dfx-hisysevent-query.md)

——>——>——>——>——>[HiSysEvent Tool Usage](device-dev/subsystems/subsys-dfx-hisysevent-tool.md)

——>——> Featured Topics

——>——>——> [Bundle Development](device-dev/bundles/bundles.md)

——>——>——>——> [Bundle Development Specifications](device-dev/bundles/oem_bundle_standard_des.md)

——>——>——>——> [Development Guidelines](device-dev/bundles/bundles-guide.md)

——>——>——>——>——> [Overview](device-dev/bundles/bundles-guide-overview.md)

——>——>——>——>——> [Installing hpm-cli Tool](device-dev/bundles/bundles-guide-prepare.md)

——>——>——>——>——> [Developing Bundles](device-dev/bundles/bundles-guide-develop.md)

——>——>——>——> [HPM User Guide](device-dev/bundles/bundles-demo.md)

——>——>——>——>——> [Introduction](device-dev/bundles/bundles-demo-hpmdescription.md)

——>——>——>——>——> [Configuring the Compilation Environment](device-dev/bundles/bundles-demo-environment.md)

——>——>——>——>——> [Development Example](device-dev/bundles/bundles-demo-devsample.md)

——>——> Device Development Examples

——>——>——> [Mini- and Small-System Devices](device-dev/guide/device-lite.md)

——>——>——>——> [WLAN-connected Products](device-dev/guide/device-wlan.md)

——>——>——>——>——> [LED Peripheral Control](device-dev/guide/device-wlan-led-control.md)

——>——>——>——>——> [Third-Party SDK Integration](device-dev/guide/device-wlan-sdk.md)

——>——>——>——> [Cameras Without a Screen](device-dev/guide/device-iotcamera.md)

——>——>——>——>——> [Camera Control](device-dev/guide/device-iotcamera-control.md)

——>——>——>——>——>——> [Overview](device-dev/guide/device-iotcamera-control-overview.md)

——>——>——>——>——>——> [Development Guidelines](device-dev/guide/device-iotcamera-control-demo.md)

——>——>——>——>——>——>——> [Photographing](device-dev/guide/device-iotcamera-control-demo-photodevguide.md)

——>——>——>——>——>——>——> [Video Recording](device-dev/guide/device-iotcamera-control-demo-videodevguide.md)

——>——>——>——>——>——> [Use Case](device-dev/guide/device-iotcamera-control-example.md)

——>——>——>——> [Cameras with a Screen](device-dev/guide/device-camera.md)

——>——>——>——>——> [Screen and Camera Control](device-dev/guide/device-camera-control.md)

——>——>——>——>——>——> [Overview](device-dev/guide/device-camera-control-overview.md)

——>——>——>——>——>——> [Development Guidelines](device-dev/guide/device-camera-control-demo.md)

——>——>——>——>——>——>——> [Photographing](device-dev/guide/device-camera-control-demo-photoguide.md)

——>——>——>——>——>——>——> [Video Recording](device-dev/guide/device-camera-control-demo-videoguide.md)

——>——>——>——>——>——>——> [Previewing](device-dev/guide/device-camera-control-demo-previewguide.md)

——>——>——>——>——>——> [Use Case](device-dev/guide/device-camera-control-example.md)

——>——>——>——>——> [Visual Application Development](device-dev/guide/device-camera-visual.md)

——>——>——>——>——>——> [Overview](device-dev/guide/device-camera-visual-overview.md)

——>——>——>——>——>——> [Preparations](device-dev/guide/device-camera-visual-prepare.md)

——>——>——>——>——>——> [Adding Pages](device-dev/guide/device-camera-visual-addpage.md)

——>——>——>——>——>——> [Building the Home Page](device-dev/guide/device-camera-visual-firstpage.md)

——>——>——>——>——>——> [Building the Details Page](device-dev/guide/device-camera-visual-details.md)

——>——>——>——>——>——> [Debugging and Packaging](device-dev/guide/device-camera-visual-debug.md)

——>——>——>——>——>——> [Running on the Device](device-dev/guide/device-camera-visual-run.md)

——>——>——>——>——>——> [FAQs]](device-dev/guide/device-camera-visual-faqs.md)

——>——>——> [Standard-System Devices](device-dev/guide/device-standard.md)

——>——>——>——> [Development Guidelines on Clock Apps](device-dev/guide/device-clock-guide.md)

——>——>——>——> [Development Example for Platform Drivers](device-dev/guide/device-driver-demo.md)

——>——>——>——> [Development Example for Peripheral Drivers](device-dev/guide/device-outerdriver-demo.md)

——>——> Application Development

——>——>——> [Getting Started](application-dev/quick-start)

——>——>——>——> [Preparations](application-dev/quick-start/start-overview.md)

——>——>——>——> [Getting Started with JavaScript](application-dev/quick-start/start-with-js.md)

——>——>——> ArkUI

——>——>——>——> JavaScript-based Web-like Development Paradigm

——>——>——>——>——> [Overview](application-dev/ui/ui-js-overview.md)

——>——>——>——>——> Framework

——>——>——>——>——>——> [File Organization](application-dev/ui/js-framework-file.md)

——>——>——>——>——>——> ["js" Tag](application-dev/ui/js-framework-js-tag.md)

——>——>——>——>——>——> [app.js](application-dev/ui/js-framework-js-file.md)

——>——>——>——>——>——> Syntax

——>——>——>——>——>——>——> [HML](application-dev/ui/js-framework-syntax-hml.md)

——>——>——>——>——>——>——> [CSS](application-dev/ui/js-framework-syntax-css.md)

——>——>——>——>——>——>——> [JavaScript](application-dev/ui/js-framework-syntax-js.md)

——>——>——>——>——>——> [Lifecycle](application-dev/ui/js-framework-lifecycle.md)

——>——>——>——>——>——> [Resource Limitations and Access](application-dev/ui/js-framework-resource-restriction.md)

——>——>——>——>——>——> [Multi-Language Capability](application-dev/ui/js-framework-multiple-languages.md)

——>——>——>——>——> Building the UI

——>——>——>——>——>——> [Component Overview](application-dev/ui/ui-js-building-ui-component.md)

——>——>——>——>——>——> Building the Layout

——>——>——>——>——>——>——> [Layout Description](application-dev/ui/ui-js-building-ui-layout-intro.md)

——>——>——>——>——>——>——> [Adding Title and Paragraph Text](application-dev/ui/ui-js-building-ui-layout-text.md)

——>——>——>——>——>——>——> [Adding an Image](application-dev/ui/ui-js-building-ui-layout-image.md)

——>——>——>——>——>——>——> [Adding a Comment](application-dev/ui/ui-js-building-ui-layout-comment.md)

——>——>——>——>——>——>——> [Adding a Container](application-dev/ui/ui-js-building-ui-layout-external-container.md)

——>——>——>——>——>——> [Adding Interactions](application-dev/ui/ui-js-building-ui-interactions.md)

——>——>——>——>——>——> [Developing Animations](application-dev/ui/ui-js-building-ui-animation.md)

——>——>——>——>——>——> [Defining Events](application-dev/ui/ui-js-building-ui-event.md)

——>——>——>——>——>——> [Defining Page Routes](application-dev/ui/ui-js-building-ui-routes.md)

——>——>——>——>——> Common Component Development Guidelines

——>——>——>——>——>——> [Text](application-dev/ui/ui-js-components-text.md)

——>——>——>——>——>——> [Input](application-dev/ui/ui-js-components-input.md)

——>——>——>——>——>——> [Button](application-dev/ui/ui-js-components-button.md)

——>——>——>——>——>——> [List](application-dev/ui/ui-js-components-list.md)

——>——>——>——>——>——> [Picker](application-dev/ui/ui-js-components-picker.md)

——>——>——>——>——>——> [Dialog](application-dev/ui/ui-js-components-dialog.md)

——>——>——>——>——>——> [Form](application-dev/ui/ui-js-components-form.md)

——>——>——>——>——>——> [Stepper](application-dev/ui/ui-js-components-stepper.md)

——>——>——>——>——>——> [Tabs](application-dev/ui/ui-js-component-tabs.md)

——>——>——>——>——>——> [Image](application-dev/ui/ui-js-components-images.md)

——>——>——>——>——> Animation Development Guidelines

——>——>——>——>——>——> CSS Animation

——>——>——>——>——>——>——> [Defining Attribute Style Animations](application-dev/ui/ui-js-animate-attribute-style.md)

——>——>——>——>——>——>——> [Defining Animations with the transform Attribute](application-dev/ui/ui-js-animate-transform.md)

——>——>——>——>——>——>——> [Defining Animations with the background-position Attribute](application-dev/ui/ui-js-animate-background-position-style.md)

——>——>——>——>——>——> JS Animation

——>——>——>——>——>——>——> [Component Animation](application-dev/ui/ui-js-animate-component.md)

——>——>——>——>——>——>——> Interpolator Animation

——>——>——>——>——>——>——>——> [Animation Effect](application-dev/ui/ui-js-animate-dynamic-effects.md)

——>——>——>——>——>——>——>——> [Animation Frame](application-dev/ui/ui-js-animate-frame.md)

——>——>——>——>——> [Custom Components](application-dev/ui/ui-js-custom-components.md)

——>——>——>——> TypeScript-based Declarative Development Paradigm

——>——>——>——>——> [Overview](application-dev/ui/ui-ts-overview.md)

——>——>——>——>——> Framework Overview

——>——>——>——>——>——> File Organization

——>——>——>——>——>——>——> [Directory Structure](application-dev/ui/ts-framework-directory.md)

——>——>——>——>——>——>——> [Rules for Accessing Application Code Files](application-dev/ui/ts-framework-file-access-rules.md)

——>——>——>——>——>——> ["js" Tag](application-dev/ui/ts-framework-js-tag.md)

——>——>——>——>——>——> Resource Access

——>——>——>——>——>——>——> [Media Resource Types](application-dev/ui/ts-media-resource-type.md)

——>——>——>——>——>——> [Pixel Units](application-dev/ui/ts-pixel-units.md)

——>——>——>——>——>——> [Types](application-dev/ui/ts-types.md)

——>——>——>——>——> Declarative Syntax

——>——>——>——>——>——> [Overview](application-dev/ui/ts-syntax-intro.md)

——>——>——>——>——>——> General UI Description Specifications

——>——>——>——>——>——>——> [Basic Concepts](application-dev/ui/ts-general-ui-concepts.md)

——>——>——>——>——>——>——> Declarative UI Description Specifications

——>——>——>——>——>——>——>——> [Configuration Without Parameters](application-dev/ui/ts-parameterless-configuration.md)

——>——>——>——>——>——>——>——> [Configuration with Mandatory Parameters](application-dev/ui/ts-configuration-with-mandatory-parameters.md)

——>——>——>——>——>——>——>——> [Attribute Configuration](application-dev/ui/ts-attribution-configuration.md)

——>——>——>——>——>——>——>——> [Event Configuration](application-dev/ui/ts-event-configuration.md)

——>——>——>——>——>——>——>——> [Child Component Configuration](application-dev/ui/ts-child-component-configuration.md)

——>——>——>——>——>——>——> Componentization

——>——>——>——>——>——>——>——> [@Component](application-dev/ui/ts-component-based-component.md)

——>——>——>——>——>——>——>——> [@Entry](application-dev/ui/ts-component-based-entry.md)

——>——>——>——>——>——>——>——> [@Preview](application-dev/ui/ts-component-based-preview.md)

——>——>——>——>——>——>——>——> [@Builder](application-dev/ui/ts-component-based-builder.md)

——>——>——>——>——>——>——>——> [@Extend](application-dev/ui/ts-component-based-extend.md)

——>——>——>——>——>——>——>——> [@CustomDialog](application-dev/ui/ts-component-based-customdialog.md)

——>——>——>——>——>——> About UI State Management

——>——>——>——>——>——>——> [Basic Concepts](application-dev/ui/ts-ui-state-mgmt-concepts.md)

——>——>——>——>——>——>——> Managing Component States

——>——>——>——>——>——>——>——> [@State](application-dev/ui/ts-component-states-state.md)

——>——>——>——>——>——>——>——> [@Prop](application-dev/ui/ts-component-states-prop.md)

——>——>——>——>——>——>——>——> [@Link](application-dev/ui/ts-component-states-link.md)

——>——>——>——>——>——>——> Managing Application States

——>——>——>——>——>——>——>——> Interfaces

——>——>——>——>——>——>——>——>——> [AppStorage](application-dev/ui/ts-application-states-appstorage.md)

——>——>——>——>——>——>——>——>——> [PersistentStorage](application-dev/ui/ts-application-states-apis-persistentstorage.md)

——>——>——>——>——>——>——>——>——> [Environment](application-dev/ui/ts-application-states-apis-environment.md)

——>——>——>——>——>——>——>——> [Synchronization Between AppStorage and Components](application-dev/ui/ts-application-states-storagelink-storageprop.md)

——>——>——>——>——>——>——> Managing Other States

——>——>——>——>——>——>——>——> [@Observed and @ObjectLink](application-dev/ui/ts-other-states-observed-objectlink.md)

——>——>——>——>——>——>——>——> [@Consume and @Provide](application-dev/ui/ts-other-states-consume-provide.md)

——>——>——>——>——>——>——>——> [@Watch](application-dev/ui/ts-other-states-watch.md)

——>——>——>——>——>——> About Rendering Control Syntax

——>——>——>——>——>——>——> [if/else](application-dev/ui/ts-rending-control-syntax-if-else.md)

——>——>——>——>——>——>——> [ForEach](application-dev/ui/ts-rending-control-syntax-foreach.md)

——>——>——>——>——>——>——> [LazyForEach](application-dev/ui/ts-rending-control-syntax-lazyforeach.md)

——>——>——>——>——>——> About @Component

——>——>——>——>——>——>——> [build Function](application-dev/ui/ts-function-build.md)

——>——>——>——>——>——>——> [Initialization of Custom Components' Member Variables](application-dev/ui/ts-custom-component-initialization.md)

——>——>——>——>——>——>——> [Custom Component Lifecycle Callbacks](application-dev/ui/ts-custom-component-lifecycle-callbacks.md)

——>——>——>——>——>——>——> [Component Creation and Re-initialization](application-dev/ui/ts-component-creation-re-initialization.md)

——>——>——>——>——>——> About Syntactic Sugar

——>——>——>——>——>——>——> [@Decorator](application-dev/ui/ts-syntactic-sugar-decorator.md)

——>——>——>——>——>——>——> [Chain Call](application-dev/ui/ts-syntactic-sugar-chaining.md)

——>——>——>——>——>——>——> [struct](application-dev/ui/ts-syntactic-sugar-struct.md)

——>——>——>——>——>——>——> [Instantiating a struct Without the new Keyword](application-dev/ui/ts-instantiating-a-struct-without-new-keyword.md)

——>——>——>——>——>——>——> [Using a Separate Line for New Component](application-dev/ui/ts-using-a-separate-line-for-new-component.md)

——>——>——>——>——>——>——> [Restrictions on Using TypeScript for Generators](application-dev/ui/ts-restrictions-for-generators.md)

——>——>——>——>——> Experiencing the Declarative UI

——>——>——>——>——>——> [Creating a Declarative UI Project](application-dev/ui/ui-ts-creating-project.md)

——>——>——>——>——>——> [Getting to Know Components](application-dev/ui/ui-ts-components.md)

——>——>——>——>——>——> [Creating a Simple Page](application-dev/ui/ui-ts-creating-simple-page.md)

——>——>——>——>——> Defining Page Layout and Connection

——>——>——>——>——>——> [Building a Food Data Model](application-dev/ui/ui-ts-building-data-model.md)

——>——>——>——>——>——> [Building a Food Category List Layout](application-dev/ui/ui-ts-building-category-list-layout.md)

——>——>——>——>——>——> [Building a Food Category Grid Layout](application-dev/ui/ui-ts-building-category-grid-layout.md)

——>——>——>——>——>——> [Implementing Page Redirection and Data Transmission](application-dev/ui/ui-ts-page-redirection-data-transmission.md)

——>——>——> Media

——>——>——>——> Audio

——>——>——>——>——> [Audio Overview](application-dev/media/audio-overview.md)

——>——>——>——>——> [Audio Playback Development](application-dev/media/audio-playback.md)

——>——>——>——>——> [Audio Management Development](application-dev/media/audio-management.md)

——>——>——>——>——> [Audio Recording Development](application-dev/media/audio-recorder.md)

——>——>——>——>——> [Audio Playback Development Using AudioRenderer](application-dev/media/audio-renderer.md)

——>——>——>——>——> [Audio Recorder Development Using AudioCapturer](application-dev/media/audio-capturer.md)

——>——>——> User Authentication

——>——>——>——> [User Authentication Overview](application-dev/security/userauth-overview.md)

——>——>——>——> [User Authentication Development](application-dev/security/userauth-guidelines.md)

——>——>——> IPC & RPC

——>——>——>——> [IPC & RPC Overview](application-dev/connectivity/ipc-rpc-overview.md)

——>——>——>——> [IPC & RPC Development Guidelines](application-dev/connectivity/ipc-rpc-development-guideline.md)

——>——>——>——> [Subscribing to State Changes of a Remote Object](application-dev/connectivity/subscribe-remote-state.md)

——>——>——> Data Management

——>——>——>——> Distributed Data Service

——>——>——>——> [Distributed Data Service Overview](application-dev/database/database-mdds-overview.md)

——>——>——>——> [Distributed Data Service Development](application-dev/database/database-mdds-guidelines.md)

——>——>——>——> Relational Database Overview

——>——>——>——> [RDB Overview](application-dev/database/database-relational-overview.md)

——>——>——>——> [RDB Development](application-dev/database/database-relational-guidelines.md)

——>——>——>——> Lightweight Data Store

——>——>——>——> [Lightweight Data Store Overview](application-dev/database/database-preference-overview.md)

——>——>——>——> [Lightweight Data Store Development](application-dev/database/database-preference-guidelines.md)

——>——>——> USB Service

——>——>——>——> [USB Service Overview](application-dev/usb/usb-overview.md)

——>——>——>——> [USB Service Development](application-dev/usb/usb-guidelines.md)

——>——>——> DFX

——>——>——>——> [Overview of Application Event Logging](application-dev/dfx/hiappevent-overview.md)

——>——>——>——> [Development Guidelines on Application Event Logging](application-dev/dfx/hiappevent-guidelines.md)

——>——>——> [DevEco Studio \(OpenHarmony\) User Guide](application-dev/quick-start/deveco-studio-user-guide-for-openharmony.md)

——>——>——>——> [Overview](application-dev/quick-start/deveco-studio-overview.md)

——>——>——>——> [Version Change History](application-dev/quick-start/deveco-studio-release-notes.md)

——>——>——>——> [Configuring the OpenHarmony SDK](application-dev/quick-start/configuring-openharmony-sdk.md)

——>——>——>——> [Creating an OpenHarmony Project](application-dev/quick-start/create-openharmony-project.md)

——>——>——>——>——> [Using the Project Wizard to Create a Project](application-dev/quick-start/use-wizard-to-create-project.md)

——>——>——>——>——> [Importing a Sample to Create a Project](application-dev/quick-start/import-sample-to-create-project.md)

——>——>——>——> [Configuring the OpenHarmony App Signature](application-dev/quick-start/configuring-openharmony-app-signature.md)

——>——>——>——> [Installing and Running Your OpenHarmony App](application-dev/quick-start/installing-openharmony-app.md)

——>——> Debugging

——>——>——> [Test Subsystem](device-dev/subsystems/subsys-testguide-test.md)

——>——>——> [R&D Tools](device-dev/subsystems/subsys-toolchain.md)

——>——>——>——> [bytrace Usage Guidelines](device-dev/subsystems/subsys-toolchain-bytrace-guide.md)

——>——>——>——> [hdc\_std Usage Guidelines](device-dev/subsystems/subsys-toolchain-hdc-guide.md)

——>——> XTS Certification

——>——>——> [XTS](device-dev/subsystems/subsys-xts-guide.md)

——>——> Tools

——>——>——> [Docker Environment](device-dev/get-code/gettools-acquire.md)

——>——>——> [IDE](device-dev/get-code/gettools-ide.md)

——>——> References

——>——>——> [JS APIs](application-dev/reference/apis/Readme-EN.md)

——>——>——>——> Ability Framework

——>——>——>——>——> [FeatureAbility Module](application-dev/reference/apis/js-apis-featureAbility.md)

——>——>——>——>——> [ParticleAbility Module](application-dev/reference/apis/js-apis-particleAbility.md)

——>——>——>——>——> [DataAbilityHelper Module](application-dev/reference/apis/js-apis-dataAbilityHelper.md)

——>——>——>——>——> [DataUriUtils Module](application-dev/reference/apis/js-apis-DataUriUtils.md)

——>——>——>——>——> [Bundle Module](application-dev/reference/apis/js-apis-Bundle.md)

——>——>——>——>——> [CommonEvent Module](application-dev/reference/apis/js-apis-commonEvent.md)

——>——>——>——>——> [Notification Module](application-dev/reference/apis/js-apis-notification.md)

——>——>——>——>——> [Context Module](application-dev/reference/apis/js-apis-Context.md)

——>——>——>——> Resource Management

——>——>——>——>——> [Resource Manager](application-dev/reference/apis/js-apis-resource-manager.md)

——>——>——>——>——> [Internationalization \(i18n\) ](application-dev/reference/apis/js-apis-i18n.md)

——>——>——>——>——> [Internationalization \(intl\) ](application-dev/reference/apis/js-apis-intl.md)

——>——>——>——> Media

——>——>——>——>——> [Audio Management](application-dev/reference/apis/js-apis-audio.md)

——>——>——>——>——> [Media](application-dev/reference/apis/js-apis-media.md)

——>——>——>——> Security

——>——>——>——>——> [User Authentication](application-dev/reference/apis/js-apis-useriam-userauth.md)

——>——>——>——>——> [Access Control](application-dev/reference/apis/js-apis-abilityAccessCtrl.md)

——>——>——>——> Data Management

——>——>——>——>——> [Lightweight Storage (deprecated since 8)](application-dev/reference/apis/js-apis-data-storage.md)

——>——>——>——>——> [Distributed Data Management](application-dev/reference/apis/js-apis-distributed-data.md)

——>——>——>——>——> [Relational Database](application-dev/reference/apis/js-apis-data-rdb.md)

——>——>——>——>——> [Result Set](application-dev/reference/apis/js-apis-data-resultset.md)

——>——>——>——>——> [DataAbilityPredicates](application-dev/reference/apis/js-apis-data-ability.md)

——>——>——>——>——> [Settings](application-dev/reference/apis/js-apis-settings.md)

——>——>——>——> File Management

——>——>——>——>——> [File Management](application-dev/reference/apis/js-apis-fileio.md)

——>——>——>——>——> [Statfs](application-dev/reference/apis/js-apis-statfs.md)

——>——>——>——>——> [Environment](application-dev/reference/apis/js-apis-environment.md)

——>——>——>——>——> [Public File Access and Management](application-dev/reference/apis/js-apis-filemanager.md)

——>——>——>——>——> [App Storage Statistics](application-dev/reference/apis/js-apis-storage-statistics.md)

——>——>——>——>——> [Volume Management](application-dev/reference/apis/js-apis-volumemanager.md)

——>——>——>——> Account Management

——>——>——>——>——> [Distributed Account Management](application-dev/reference/apis/js-apis-distributed-account.md)

——>——>——>——>——> [Application Account Management](application-dev/reference/apis/js-apis-appAccount.md)

——>——>——>——> Telephony Service

——>——>——>——>——> [Call](application-dev/reference/apis/js-apis-call.md)

——>——>——>——>——> [SMS](application-dev/reference/apis/js-apis-sms.md)

——>——>——>——>——> [SIM Management](application-dev/reference/apis/js-apis-sim.md)

——>——>——>——>——> [Radio](application-dev/reference/apis/js-apis-radio.md)

——>——>——>——> Network and Connectivity

——>——>——>——>——> [WLAN](application-dev/reference/apis/js-apis-wifi.md)  

——>——>——>——>——> [Bluetooth](application-dev/reference/apis/js-apis-bluetooth.md)

——>——>——>——> Device Management

——>——>——>——>——> [Sensor](application-dev/reference/apis/js-apis-sensor.md)

——>——>——>——>——> [Vibrator](application-dev/reference/apis/js-apis-vibrator.md)

——>——>——>——>——> [Brightness](application-dev/reference/apis/js-apis-brightness.md)

——>——>——>——>——> [Battery Info](application-dev/reference/apis/js-apis-battery-info.md)

——>——>——>——>——> [Power Management](application-dev/reference/apis/js-apis-power.md)

——>——>——>——>——> [Running Lock](application-dev/reference/apis/js-apis-runninglock.md)

——>——>——>——>——> [Device Info](application-dev/reference/apis/js-apis-device-info.md)

——>——>——>——>——> [systemParameter](application-dev/reference/apis/js-apis-system-parameter.md)

——>——>——>——>——> [Device Management](application-dev/reference/apis/js-apis-device-manager.md)

——>——>——>——>——> [Window](application-dev/reference/apis/js-apis-window.md)

——>——>——>——>——> [Display](application-dev/reference/apis/js-apis-display.md)

——>——>——>——>——> [Update](application-dev/reference/apis/js-apis-update.md) 

——>——>——>——>——> [USB](application-dev/reference/apis/js-apis-usb.md)

——>——>——>——> Basic Features

——>——>——>——>——> [Application Context](application-dev/reference/apis/js-apis-basic-features-app-context.md)

——>——>——>——>——> [Console Logs](application-dev/reference/apis/js-apis-basic-features-logs.md)

——>——>——>——>——> [Page Routing](application-dev/reference/apis/js-apis-basic-features-routes.md)

——>——>——>——>——> [Pop-up Window](application-dev/reference/apis/js-apis-basic-features-pop-up.md)

——>——>——>——>——> [Application Configuration](application-dev/reference/apis/js-apis-basic-features-configuration.md)

——>——>——>——>——> [Timer](application-dev/reference/apis/js-apis-basic-features-timer.md)

——>——>——>——>——> [Setting the System Time](application-dev/reference/apis/js-apis-system-time.md)

——>——>——>——>——> [Animation](application-dev/reference/apis/js-apis-basic-features-animator.md)

——>——>——>——>——> [WebGL](application-dev/reference/apis/js-apis-webgl.md)

——>——>——>——>——> [WebGL2](application-dev/reference/apis/js-apis-webgl2.md)

——>——>——>——> DFX

——>——>——>——>——> [HiAppEvent](application-dev/reference/apis/js-apis-hiappevent.md)

——>——>——>——>——> [Performance Tracing](application-dev/reference/apis/js-apis-hitracemeter.md)

——>——>——>——>——> [Fault Logger](application-dev/reference/apis/js-apis-faultLogger.md)

——>——>——>——>——> [Distributed Call Chain Tracing](application-dev/reference/apis/js-apis-hitracechain.md)

——>——>——>——>——> [HiLog](application-dev/reference/apis/js-apis-hilog.md)

——>——>——>——>——> [HiChecker](application-dev/reference/apis/js-apis-hichecker.md)

——>——>——>——>——> [HiDebug](application-dev/reference/apis/js-apis-hidebug.md)

——>——>——>——> Language Base Class Library

——>——>——>——>——> [Obtaining Process Information](application-dev/reference/apis/js-apis-process.md)

——>——>——>——>——> [URL String Parsing](application-dev/reference/apis/js-apis-url.md)

——>——>——>——>——> [URI String Parsing](application-dev/reference/apis/js-apis-uri.md)

——>——>——>——>——> [Util](application-dev/reference/apis/js-apis-util.md)

——>——>——>——>——> [XML Parsing and Generation](application-dev/reference/apis/js-apis-xml.md)

——>——>——>——>——> [XML-to-JavaScript Conversion](application-dev/reference/apis/js-apis-convertxml.md)

——>——>——>——>——> [Worker Startup](application-dev/reference/apis/js-apis-worker.md)

——>——>——> ArkUI Component References

——>——>——>——> [TypeScript-based Declarative Development Paradigm](application-dev/reference/arkui-js/Readme-EN.md)

——>——>——>——>——> Components

——>——>——>——>——>——> Common

——>——>——>——>——>——>——> [Universal Attributes](application-dev/reference/arkui-js/js-components-common-attributes.md)

——>——>——>——>——>——>——> [Universal Styles](application-dev/reference/arkui-js/js-components-common-styles.md)

——>——>——>——>——>——>——> [Universal Events](application-dev/reference/arkui-js/js-components-common-events.md)

——>——>——>——>——>——>——> [Universal Methods](application-dev/reference/arkui-js/js-components-common-methods.md)

——>——>——>——>——>——>——> [Animation Styles](application-dev/reference/arkui-js/js-components-common-animation.md)

——>——>——>——>——>——>——> [Gradient Styles](application-dev/reference/arkui-js/js-components-common-gradient.md)

——>——>——>——>——>——>——> [Transition Styles](application-dev/reference/arkui-js/js-components-common-transition.md)

——>——>——>——>——>——>——> [Media Query](application-dev/reference/arkui-js/js-components-common-mediaquery.md)

——>——>——>——>——>——>——> [Custom Font Styles](application-dev/reference/arkui-js/js-components-common-customizing-font.md)

——>——>——>——>——>——>——> [Atomic Layout](application-dev/reference/arkui-js/js-components-common-atomic-layout.md)

——>——>——>——>——>——> Container Component

——>——>——>——>——>——>——> [badge](application-dev/reference/arkui-js/js-components-container-badge.md)

——>——>——>——>——>——>——> [dialog](application-dev/reference/arkui-js/js-components-container-dialog.md)

——>——>——>——>——>——>——> [div](application-dev/reference/arkui-js/js-components-container-div.md)

——>——>——>——>——>——>——> [form](application-dev/reference/arkui-js/js-components-container-form.md)

——>——>——>——>——>——>——> [list](application-dev/reference/arkui-js/js-components-container-list.md)

——>——>——>——>——>——>——> [list-item](application-dev/reference/arkui-js/js-components-container-list-item.md)

——>——>——>——>——>——>——> [list-item-group](application-dev/reference/arkui-js/js-components-container-list-item-group.md)

——>——>——>——>——>——>——> [panel](application-dev/reference/arkui-js/js-components-container-panel.md)

——>——>——>——>——>——>——> [popup](application-dev/reference/arkui-js/js-components-container-popup.md)

——>——>——>——>——>——>——> [refresh](application-dev/reference/arkui-js/js-components-container-refresh.md)

——>——>——>——>——>——>——> [stack](application-dev/reference/arkui-js/js-components-container-stack.md)

——>——>——>——>——>——>——> [stepper](application-dev/reference/arkui-js/js-components-container-stepper.md)

——>——>——>——>——>——>——> [stepper-item](application-dev/reference/arkui-js/js-components-container-stepper-item.md)

——>——>——>——>——>——>——> [swiper](application-dev/reference/arkui-js/js-components-container-swiper.md)

——>——>——>——>——>——>——> [tabs](application-dev/reference/arkui-js/js-components-container-tabs.md)

——>——>——>——>——>——>——> [tab-bar](application-dev/reference/arkui-js/js-components-container-tab-bar.md)

——>——>——>——>——>——>——> [tab-content](application-dev/reference/arkui-js/js-components-container-tab-content.md)

——>——>——>——>——>——> Basic Components

——>——>——>——>——>——>——> [button](application-dev/reference/arkui-js/js-components-basic-button.md)

——>——>——>——>——>——>——> [chart](application-dev/reference/arkui-js/js-components-basic-chart.md)

——>——>——>——>——>——>——> [divider](application-dev/reference/arkui-js/js-components-basic-divider.md)

——>——>——>——>——>——>——> [image](application-dev/reference/arkui-js/js-components-basic-image.md)

——>——>——>——>——>——>——> [image-animator](application-dev/reference/arkui-js/js-components-basic-image-animator.md)

——>——>——>——>——>——>——> [input](application-dev/reference/arkui-js/js-components-basic-input.md)

——>——>——>——>——>——>——> [label](application-dev/reference/arkui-js/js-components-basic-label.md)

——>——>——>——>——>——>——> [marquee](application-dev/reference/arkui-js/js-components-basic-marquee.md)

——>——>——>——>——>——>——> [menu](application-dev/reference/arkui-js/js-components-basic-menu.md)

——>——>——>——>——>——>——> [option](application-dev/reference/arkui-js/js-components-basic-option.md)

——>——>——>——>——>——>——> [picker](application-dev/reference/arkui-js/js-components-basic-picker.md)

——>——>——>——>——>——>——> [picker-view](application-dev/reference/arkui-js/js-components-basic-picker-view.md)

——>——>——>——>——>——>——> [piece](application-dev/reference/arkui-js/js-components-basic-piece.md)

——>——>——>——>——>——>——> [progress](application-dev/reference/arkui-js/js-components-basic-progress.md)

——>——>——>——>——>——>——> [qrcode](application-dev/reference/arkui-js/js-components-basic-qrcode.md)

——>——>——>——>——>——>——> [rating](application-dev/reference/arkui-js/js-components-basic-rating.md)

——>——>——>——>——>——>——> [richtext](application-dev/reference/arkui-js/js-components-basic-richtext.md)

——>——>——>——>——>——>——> [search](application-dev/reference/arkui-js/js-components-basic-search.md)

——>——>——>——>——>——>——> [select](application-dev/reference/arkui-js/js-components-basic-select.md)

——>——>——>——>——>——>——> [slider](application-dev/reference/arkui-js/js-components-basic-slider.md)

——>——>——>——>——>——>——> [span](application-dev/reference/arkui-js/js-components-basic-span.md)

——>——>——>——>——>——>——> [switch](application-dev/reference/arkui-js/js-components-basic-switch.md)

——>——>——>——>——>——>——> [text](application-dev/reference/arkui-js/js-components-basic-text.md)

——>——>——>——>——>——>——> [textarea](application-dev/reference/arkui-js/js-components-basic-textarea.md)

——>——>——>——>——>——>——> [toolbar](application-dev/reference/arkui-js/js-components-basic-toolbar.md)

——>——>——>——>——>——>——> [toolbar-item](application-dev/reference/arkui-js/js-components-basic-toolbar-item.md)

——>——>——>——>——>——>——> [toggle](application-dev/reference/arkui-js/js-components-basic-toggle.md)

——>——>——>——>——>——> Media Components

——>——>——>——>——>——>——> [video](application-dev/reference/arkui-js/js-components-media-video.md)

——>——>——>——>——>——> Canvas Components

——>——>——>——>——>——>——> [canvas](application-dev/reference/arkui-js/js-components-canvas-canvas.md)

——>——>——>——>——>——>——> [CanvasRenderingContext2D](application-dev/reference/arkui-js/js-components-canvas-canvasrenderingcontext2d.md)

——>——>——>——>——>——>——> [Image](application-dev/reference/arkui-js/js-components-canvas-image.md)

——>——>——>——>——>——>——> [CanvasGradient](application-dev/reference/arkui-js/js-components-canvas-canvasgradient.md)

——>——>——>——>——>——>——> [ImageData](application-dev/reference/arkui-js/js-components-canvas-imagedata.md)

——>——>——>——>——>——>——> [Path2D](application-dev/reference/arkui-js/js-components-canvas-path2d.md)

——>——>——>——>——>——>——> [ImageBitmap](application-dev/reference/arkui-js/js-components-canvas-imagebitmap.md)

——>——>——>——>——>——>——> [OffscreenCanvas](application-dev/reference/arkui-js/js-components-canvas-offscreencanvas.md)

——>——>——>——>——>——>——> [OffscreenCanvasRenderingContext2D](application-dev/reference/arkui-js/js-offscreencanvasrenderingcontext2d.md)

——>——>——>——>——>——> Grid

——>——>——>——>——>——>——> [Basic Concepts](application-dev/reference/arkui-js/js-components-grid-basic-concepts.md)

——>——>——>——>——>——>——> [grid-container](application-dev/reference/arkui-js/js-components-grid-container.md)

——>——>——>——>——>——>——> [grid-row](application-dev/reference/arkui-js/js-components-grid-row.md)

——>——>——>——>——>——>——> [grid-col](application-dev/reference/arkui-js/js-components-grid-col.md)

——>——>——>——>——>——> SVG Components

——>——>——>——>——>——>——> [Universal Attributes](application-dev/reference/arkui-js/js-components-svg-common-attributes.md)

——>——>——>——>——>——>——> [svg](application-dev/reference/arkui-js/js-components-svg.md)

——>——>——>——>——>——>——> [rect](application-dev/reference/arkui-js/js-components-svg-rect.md)

——>——>——>——>——>——>——> [circle](application-dev/reference/arkui-js/js-components-svg-circle.md)

——>——>——>——>——>——>——> [ellipse](application-dev/reference/arkui-js/js-components-svg-ellipse.md)

——>——>——>——>——>——>——> [path](application-dev/reference/arkui-js/js-components-svg-path.md)

——>——>——>——>——>——>——> [line](application-dev/reference/arkui-js/js-components-svg-line.md)

——>——>——>——>——>——>——> [polyline](application-dev/reference/arkui-js/js-components-svg-polyline.md)

——>——>——>——>——>——>——> [polygon](application-dev/reference/arkui-js/js-components-svg-polygon.md)

——>——>——>——>——>——>——> [text](application-dev/reference/arkui-js/js-components-svg-text.md)

——>——>——>——>——>——>——> [tspan](application-dev/reference/arkui-js/js-components-svg-tspan.md)

——>——>——>——>——>——>——> [textPath](application-dev/reference/arkui-js/js-components-svg-textpath.md)

——>——>——>——>——>——>——> [animate](application-dev/reference/arkui-js/js-components-svg-animate.md)

——>——>——>——>——>——>——> [animateMotion](application-dev/reference/arkui-js/js-components-svg-animatemotion.md)

——>——>——>——>——>——>——> [animateTransform](application-dev/reference/arkui-js/js-components-svg-animatetransform.md)

——>——>——>——>——> Custom Components

——>——>——>——>——>——> [Basic Usage](application-dev/reference/arkui-js/js-components-custom-basic-usage.md)

——>——>——>——>——>——> [Custom Events](application-dev/reference/arkui-js/js-components-custom-events.md)

——>——>——>——>——>——> [props](application-dev/reference/arkui-js/js-components-custom-props.md)

——>——>——>——>——>——> [Event Parameter](application-dev/reference/arkui-js/js-components-custom-event-parameter.md)

——>——>——>——>——>——> [slot](application-dev/reference/arkui-js/js-components-custom-slot.md)

——>——>——>——>——>——> [Lifecycle Definition](application-dev/reference/arkui-js/js-components-custom-lifecycle.md)

——>——>——>——>——> [Appendix](application-dev/reference/arkui-js/js-appendix.md)

——>——>——>——>——>——> [Type Attributes](application-dev/reference/arkui-js/js-appendix-types.md)

——>——>——>——> [TypeScript-based Declarative Development Paradigm](application-dev/reference/arkui-ts/Readme-EN.md)

——>——>——>——>——> Components

——>——>——>——>——>——> Universal Components

——>——>——>——>——>——>——> [Universal Events](application-dev/reference/arkui-ts/ts-universal-events.md)

——>——>——>——>——>——>——>——> [Click Event](application-dev/reference/arkui-ts/ts-universal-events-click.md)

——>——>——>——>——>——>——>——> [Touch](application-dev/reference/arkui-ts/ts-universal-events-touch.md)

——>——>——>——>——>——>——>——> [Show/Hide Event](application-dev/reference/arkui-ts/ts-universal-events-show-hide.md)

——>——>——>——>——>——>——>——> [Key Event](application-dev/reference/arkui-ts/ts-universal-events-key.md)

——>——>——>——>——>——>——>——>[Component Area Change Event](application-dev/reference/arkui-ts/ts-universal-events-component-area-change.md)

——>——>——>——>——>——>——> Universal Attributes

——>——>——>——>——>——>——>——> [Size](application-dev/reference/arkui-ts/ts-universal-attributes-size.md)

——>——>——>——>——>——>——>——> [Location](application-dev/reference/arkui-ts/ts-universal-attributes-location.md)

——>——>——>——>——>——>——>——> [Layout Constraints](application-dev/reference/arkui-ts/ts-universal-attributes-layout-constraints.md)

——>——>——>——>——>——>——>——> [Flex Layout](application-dev/reference/arkui-ts/ts-universal-attributes-flex-layout.md)

——>——>——>——>——>——>——>——> [Border Configuration](application-dev/reference/arkui-ts/ts-universal-attributes-border.md)

——>——>——>——>——>——>——>——> [Background](application-dev/reference/arkui-ts/ts-universal-attributes-background.md)

——>——>——>——>——>——>——>——> [Opacity](application-dev/reference/arkui-ts/ts-universal-attributes-opacity.md)

——>——>——>——>——>——>——>——> [Visibility](application-dev/reference/arkui-ts/ts-universal-attributes-visibility.md)

——>——>——>——>——>——>——>——> [Enable/Disable](application-dev/reference/arkui-ts/ts-universal-attributes-enable.md)

——>——>——>——>——>——>——>——> [Overlay](application-dev/reference/arkui-ts/ts-universal-attributes-overlay.md)

——>——>——>——>——>——>——>——> [Z-order Control](application-dev/reference/arkui-ts/ts-universal-attributes-z-order.md)

——>——>——>——>——>——>——>——> [Transformation](application-dev/reference/arkui-ts/ts-universal-attributes-transformation.md)

——>——>——>——>——>——>——>——> [Image Effect Configuration](application-dev/reference/arkui-ts/ts-universal-attributes-image-effect.md)

——>——>——>——>——>——>——>——> [Shape Clipping](application-dev/reference/arkui-ts/ts-universal-attributes-sharp-clipping.md)

——>——>——>——>——>——>——>——> [Text Style](application-dev/reference/arkui-ts/ts-universal-attributes-text-style.md)

——>——>——>——>——>——>——>——> [Grid](application-dev/reference/arkui-ts/ts-universal-attributes-grid.md)

——>——>——>——>——>——>——>——> [Gradient Color](application-dev/reference/arkui-ts/ts-universal-attributes-gradient-color.md)

——>——>——>——>——>——>——>——> [Popup Control](application-dev/reference/arkui-ts/ts-universal-attributes-popup.md)

——>——>——>——>——>——>——>——> [Menu Control](application-dev/reference/arkui-ts/ts-universal-attributes-menu.md)

——>——>——>——>——>——>——>——>[Click Control](application-dev/reference/arkui-ts/ts-universal-attributes-touchable.md)

——>——>——>——>——>——>——>——>[Touch Target](application-dev/reference/arkui-ts/ts-universal-attributes-response-region.md)

——>——>——>——>——>——>——> Gesture Processing

——>——>——>——>——>——>——>——> [Gesture Binding Methods](application-dev/reference/arkui-ts/ts-gesture-settings.md)

——>——>——>——>——>——>——>——> Basic Gestures

——>——>——>——>——>——>——>——>——> [TapGesture](application-dev/reference/arkui-ts/ts-basic-gestures-tapgesture.md)

——>——>——>——>——>——>——>——>——> [LongPressGesture](application-dev/reference/arkui-ts/ts-basic-gestures-longpressgesture.md)

——>——>——>——>——>——>——>——>——> [PanGesture](application-dev/reference/arkui-ts/ts-basic-gestures-pangesture.md)

——>——>——>——>——>——>——>——>——> [PinchGesture](application-dev/reference/arkui-ts/ts-basic-gestures-pinchgesture.md)

——>——>——>——>——>——>——>——>——> [RotationGesture](application-dev/reference/arkui-ts/ts-basic-gestures-rotationgesture.md)

——>——>——>——>——>——>——>——>——> [SwipeGesture](application-dev/reference/arkui-ts/ts-basic-gestures-swipegesture.md)

——>——>——>——>——>——>——>——> [Combined Gestures](application-dev/reference/arkui-ts/ts-combined-gestures.md)

——>——>——>——>——>——> Basic Components

——>——>——>——>——>——>——> [Blank](application-dev/reference/arkui-ts/ts-basic-components-blank.md)

——>——>——>——>——>——>——> [Button](application-dev/reference/arkui-ts/ts-basic-components-button.md)

——>——>——>——>——>——>——> [DataPanel](application-dev/reference/arkui-ts/ts-basic-components-datapanel.md)

——>——>——>——>——>——>——> [Divider](application-dev/reference/arkui-ts/ts-basic-components-divider.md)

——>——>——>——>——>——>——>[Gauge](application-dev/reference/arkui-ts/ts-basic-components-gauge.md)

——>——>——>——>——>——>——> [Image](application-dev/reference/arkui-ts/ts-basic-components-image.md)

——>——>——>——>——>——>——> [ImageAnimator](application-dev/reference/arkui-ts/ts-basic-components-imageanimator.md)

——>——>——>——>——>——>——> [Progress](application-dev/reference/arkui-ts/ts-basic-components-progress.md)

——>——>——>——>——>——>——> [QRCode](application-dev/reference/arkui-ts/ts-basic-components-qrcode.md)

——>——>——>——>——>——>——> [Rating](application-dev/reference/arkui-ts/ts-basic-components-rating.md)

——>——>——>——>——>——>——> [Span](application-dev/reference/arkui-ts/ts-basic-components-span.md)

——>——>——>——>——>——>——> [Slider](application-dev/reference/arkui-ts/ts-basic-components-slider.md)

——>——>——>——>——>——>——> [Text](application-dev/reference/arkui-ts/ts-basic-components-text.md)

——>——>——>——>——>——>——> [TextArea](application-dev/reference/arkui-ts/ts-basic-components-textarea.md)

——>——>——>——>——>——>——> [TextInput](application-dev/reference/arkui-ts/ts-basic-components-textinput.md)

——>——>——>——>——>——>——> [Toggle](application-dev/reference/arkui-ts/ts-basic-components-toggle.md)

——>——>——>——>——>——> Container Components

——>——>——>——>——>——>——> [AlphabetIndexer](application-dev/reference/arkui-ts/ts-container-alphabet-indexer.md)

——>——>——>——>——>——>——> [Badge](application-dev/reference/arkui-ts/ts-container-badge.md)

——>——>——>——>——>——>——> [Column](application-dev/reference/arkui-ts/ts-container-column.md)

——>——>——>——>——>——>——> [ColumnSplit](application-dev/reference/arkui-ts/ts-container-columnsplit.md)

——>——>——>——>——>——>——> [Counter](application-dev/reference/arkui-ts/ts-container-counter.md)

——>——>——>——>——>——>——> [Flex](application-dev/reference/arkui-ts/ts-container-flex.md)

——>——>——>——>——>——>——> [GridContainer](application-dev/reference/arkui-ts/ts-container-gridcontainer.md)

——>——>——>——>——>——>——> [Grid](application-dev/reference/arkui-ts/ts-container-grid.md)

——>——>——>——>——>——>——> [GridItem](application-dev/reference/arkui-ts/ts-container-griditem.md)

——>——>——>——>——>——>——> [List](application-dev/reference/arkui-ts/ts-container-list.md)

——>——>——>——>——>——>——> [ListItem](application-dev/reference/arkui-ts/ts-container-listitem.md)

——>——>——>——>——>——>——> [Navigator](application-dev/reference/arkui-ts/ts-container-navigator.md)

——>——>——>——>——>——>——> [Navigation](application-dev/reference/arkui-ts/ts-container-navigation.md)

——>——>——>——>——>——>——> [Panel](application-dev/reference/arkui-ts/ts-container-panel.md)

——>——>——>——>——>——>——> [Row](application-dev/reference/arkui-ts/ts-container-row.md)

——>——>——>——>——>——>——> [RowSplit](application-dev/reference/arkui-ts/ts-container-rowsplit.md)

——>——>——>——>——>——>——> [Scroll](application-dev/reference/arkui-ts/ts-container-scroll.md)

——>——>——>——>——>——>——> [ScrollBar](application-dev/reference/arkui-ts/ts-container-scrollbar.md)

——>——>——>——>——>——>——> [Stack](application-dev/reference/arkui-ts/ts-container-stack.md)

——>——>——>——>——>——>——> [Swiper](application-dev/reference/arkui-ts/ts-container-swiper.md)

——>——>——>——>——>——>——> [Tabs](application-dev/reference/arkui-ts/ts-container-tabs.md)

——>——>——>——>——>——>——> [TabContent](application-dev/reference/arkui-ts/ts-container-tabcontent.md)

——>——>——>——>——>——>——> [Stepper](application-dev/reference/arkui-ts/ts-container-stepper.md)

——>——>——>——>——>——>——> [StepperItem](application-dev/reference/arkui-ts/ts-container-stepperitem.md)

——>——>——>——>——>——> Drawing Components

——>——>——>——>——>——>——> [Circle](application-dev/reference/arkui-ts/ts-drawing-components-circle.md)

——>——>——>——>——>——>——> [Ellipse](application-dev/reference/arkui-ts/ts-drawing-components-ellipse.md)

——>——>——>——>——>——>——> [Line](application-dev/reference/arkui-ts/ts-drawing-components-line.md)

——>——>——>——>——>——>——> [Polyline](application-dev/reference/arkui-ts/ts-drawing-components-polyline.md)

——>——>——>——>——>——>——> [Polygon](application-dev/reference/arkui-ts/ts-drawing-components-polygon.md)

——>——>——>——>——>——>——> [Path](application-dev/reference/arkui-ts/ts-drawing-components-path.md)

——>——>——>——>——>——>——> [Rect](application-dev/reference/arkui-ts/ts-drawing-components-rect.md)

——>——>——>——>——>——>——> [Shape](application-dev/reference/arkui-ts/ts-drawing-components-shape.md)‘

——>——>——>——>——>——> Canvas Components

——>——>——>——>——>——>——>[Canvas](application-dev/reference/arkui-ts/ts-components-canvas-canvas.md)

——>——>——>——>——>——>——>[Lottie](application-dev/reference/arkui-ts/ts-components-canvas-lottie.md)

——>——>——>——>——> Animation

——>——>——>——>——>——> [Attribute Animation](application-dev/reference/arkui-ts/ts-animatorproperty.md)

——>——>——>——>——>——> [Explicit Animation](application-dev/reference/arkui-ts/ts-explicit-animation.md)

——>——>——>——>——>——> Transition Animation

——>——>——>——>——>——>——> [Page Transition](application-dev/reference/arkui-ts/ts-page-transition-animation.md)

——>——>——>——>——>——>——> [Component Transition](application-dev/reference/arkui-ts/ts-transition-animation-component.md)

——>——>——>——>——>——>——> [Transition of Shared Elements](application-dev/reference/arkui-ts/ts-transition-animation-shared-elements.md)

——>——>——>——>——>——> [Motion Path Animation](application-dev/reference/arkui-ts/ts-motion-path-animation.md)

——>——>——>——>——>——> [Matrix Transformation](application-dev/reference/arkui-ts/ts-matrix-transformation.md)

——>——>——>——>——>——> [Interpolation Calculation](application-dev/reference/arkui-ts/ts-interpolation-calculation.md)

——>——>——>——>——> Global UI Methods

——>——>——>——>——>——> [Alert Dialog Box](application-dev/reference/arkui-ts/ts-methods-alert-dialog-box.md)

——>——>——>——>——>——> [Custom Dialog box](application-dev/reference/arkui-ts/ts-methods-custom-dialog-box.md)

——>——>——>——>——>——> [Image Cache](application-dev/reference/arkui-ts/ts-methods-image-cache.md)

——>——>——>——>——>——> [Media Query](application-dev/reference/arkui-ts/ts-methods-media-query.md)

——>——>——>——>——>——> [List Selection Dialog Box](application-dev/reference/arkui-ts/ts-methods-action-sheet.md)

——>——>——>——>——> Appendix

——>——>——>——>——>——> [Built-in Enums](application-dev/reference/arkui-ts/ts-appendix-enums.md)

——>——>——>[Directory Structure](application-dev/quick-start/package-structure.md)

——>——>——> FAQs-Device Management

——>——>——>——>[Overview of FAQs](device-dev/faqs/faqs-overview.md)

——>——>——>——>[Environment Setup](device-dev/faqs/faqs-environment-setup.md)

——>——>——>——>[Compilation and Building Subsystem](device-dev/faqs/faqs-building.md)

——>——>——>——>[Burning](device-dev/faqs/faqs-burning.md)

——>——>——>——>[Kernel](device-dev/faqs/faqs-kernel.md)

——>——>——>——>[Porting](device-dev/faqs/faqs-porting.md)

——>——>——>——>[Startup](device-dev/faqs/faqs-startup.md)

——>——>——>——>[System Applications](device-dev/faqs/faqs-system-applications.md)

——>——> Contribution

——>——>——>[Contribution](contribute/contribution.md)

——>——>——> [Code of Conduct](contribute/code-of-conduct.md)

——>——>——>[Code Contribution](contribute/code-contribution.md)

——>——>——>[Contribution Process](contribute/contribution-process.md)

——>——>——> [Documentation Contribution](contribute/documentation-contribution.md)

——>——>——>——>[Writing Instructions](contribute/writing-instructions.md)

——>——>——>——>[Writing Documents for a Release](contribute/docs-release-process.md)

——>——>——>[Communication in Community](contribute/communication-in-community.md)

——>——>——>[FAQ](contribute/FAQ.md)
