# Ellipse<a name="EN-US_TOPIC_0000001193075096"></a>

>![](../../public_sys-resources/icon-note.gif) **NOTE:** 
>This component is supported since API version 7. Updates will be marked with a superscript to indicate their earliest API version.

The  **<Ellipse\>**  component is used to draw an ellipse.

## Required Permissions<a name="section53281531154915"></a>

None

## Child Components<a name="section121862320423"></a>

None

## APIs<a name="section1870194144317"></a>

ellipse\(options?: \{width: Lenght, height: Length\}\)

-   Parameters

    <a name="table193606194544"></a>
    <table><thead align="left"><tr id="row536071910541"><th class="cellrowborder" valign="top" width="15.47%" id="mcps1.1.6.1.1"><p id="p436112199544"><a name="p436112199544"></a><a name="p436112199544"></a>Name</p>
    </th>
    <th class="cellrowborder" valign="top" width="17.22%" id="mcps1.1.6.1.2"><p id="p19361319115410"><a name="p19361319115410"></a><a name="p19361319115410"></a>Type</p>
    </th>
    <th class="cellrowborder" valign="top" width="12.49%" id="mcps1.1.6.1.3"><p id="p9361201975417"><a name="p9361201975417"></a><a name="p9361201975417"></a>Mandatory</p>
    </th>
    <th class="cellrowborder" valign="top" width="18.6%" id="mcps1.1.6.1.4"><p id="p43611199542"><a name="p43611199542"></a><a name="p43611199542"></a>Default Value</p>
    </th>
    <th class="cellrowborder" valign="top" width="36.22%" id="mcps1.1.6.1.5"><p id="p1136141975419"><a name="p1136141975419"></a><a name="p1136141975419"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row10361101915545"><td class="cellrowborder" valign="top" width="15.47%" headers="mcps1.1.6.1.1 "><p id="p1361119155417"><a name="p1361119155417"></a><a name="p1361119155417"></a>options</p>
    </td>
    <td class="cellrowborder" valign="top" width="17.22%" headers="mcps1.1.6.1.2 "><p id="p8361181913548"><a name="p8361181913548"></a><a name="p8361181913548"></a>Object</p>
    </td>
    <td class="cellrowborder" valign="top" width="12.49%" headers="mcps1.1.6.1.3 "><p id="p153611119195411"><a name="p153611119195411"></a><a name="p153611119195411"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="18.6%" headers="mcps1.1.6.1.4 "><p id="p1436114193546"><a name="p1436114193546"></a><a name="p1436114193546"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="36.22%" headers="mcps1.1.6.1.5 "><p id="p328155017218"><a name="p328155017218"></a><a name="p328155017218"></a>For details, see the <a href="#li155660864616">options parameters</a>.</p>
    </td>
    </tr>
    </tbody>
    </table>

-   <a name="li155660864616"></a>options parameters

    <a name="table14581481462"></a>
    <table><thead align="left"><tr id="row858019813463"><th class="cellrowborder" valign="top" width="16.11%" id="mcps1.1.6.1.1"><p id="p195806814619"><a name="p195806814619"></a><a name="p195806814619"></a>Name</p>
    </th>
    <th class="cellrowborder" valign="top" width="14.01%" id="mcps1.1.6.1.2"><p id="p85805884615"><a name="p85805884615"></a><a name="p85805884615"></a>Type</p>
    </th>
    <th class="cellrowborder" valign="top" width="14.499999999999998%" id="mcps1.1.6.1.3"><p id="p12580384465"><a name="p12580384465"></a><a name="p12580384465"></a>Mandatory</p>
    </th>
    <th class="cellrowborder" valign="top" width="13.170000000000002%" id="mcps1.1.6.1.4"><p id="p758019818465"><a name="p758019818465"></a><a name="p758019818465"></a>Default Value</p>
    </th>
    <th class="cellrowborder" valign="top" width="42.21%" id="mcps1.1.6.1.5"><p id="p17580138174617"><a name="p17580138174617"></a><a name="p17580138174617"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row55808810465"><td class="cellrowborder" valign="top" width="16.11%" headers="mcps1.1.6.1.1 "><p id="p15801681465"><a name="p15801681465"></a><a name="p15801681465"></a>width</p>
    </td>
    <td class="cellrowborder" valign="top" width="14.01%" headers="mcps1.1.6.1.2 "><p id="p6580583466"><a name="p6580583466"></a><a name="p6580583466"></a>Length</p>
    </td>
    <td class="cellrowborder" valign="top" width="14.499999999999998%" headers="mcps1.1.6.1.3 "><p id="p1658017854614"><a name="p1658017854614"></a><a name="p1658017854614"></a>Yes</p>
    </td>
    <td class="cellrowborder" valign="top" width="13.170000000000002%" headers="mcps1.1.6.1.4 "><p id="p1758016813461"><a name="p1758016813461"></a><a name="p1758016813461"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="42.21%" headers="mcps1.1.6.1.5 "><p id="p958078184617"><a name="p958078184617"></a><a name="p958078184617"></a>Width.</p>
    </td>
    </tr>
    <tr id="row1958178174619"><td class="cellrowborder" valign="top" width="16.11%" headers="mcps1.1.6.1.1 "><p id="p11581208194613"><a name="p11581208194613"></a><a name="p11581208194613"></a>height</p>
    </td>
    <td class="cellrowborder" valign="top" width="14.01%" headers="mcps1.1.6.1.2 "><p id="p45811884612"><a name="p45811884612"></a><a name="p45811884612"></a>Length</p>
    </td>
    <td class="cellrowborder" valign="top" width="14.499999999999998%" headers="mcps1.1.6.1.3 "><p id="p15581188104613"><a name="p15581188104613"></a><a name="p15581188104613"></a>Yes</p>
    </td>
    <td class="cellrowborder" valign="top" width="13.170000000000002%" headers="mcps1.1.6.1.4 "><p id="p18581198134615"><a name="p18581198134615"></a><a name="p18581198134615"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="42.21%" headers="mcps1.1.6.1.5 "><p id="p115810824615"><a name="p115810824615"></a><a name="p115810824615"></a>Height.</p>
    </td>
    </tr>
    </tbody>
    </table>


## Attributes<a name="section177298713218"></a>

<a name="table7575164093416"></a>
<table><thead align="left"><tr id="row56061840133420"><th class="cellrowborder" valign="top" width="19.999999999999996%" id="mcps1.1.6.1.1"><p id="p16606940103416"><a name="p16606940103416"></a><a name="p16606940103416"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="19.999999999999996%" id="mcps1.1.6.1.2"><p id="p1760794013418"><a name="p1760794013418"></a><a name="p1760794013418"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="19.999999999999996%" id="mcps1.1.6.1.3"><p id="p156079409343"><a name="p156079409343"></a><a name="p156079409343"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="16.799999999999997%" id="mcps1.1.6.1.4"><p id="p760716403344"><a name="p760716403344"></a><a name="p760716403344"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="23.199999999999996%" id="mcps1.1.6.1.5"><p id="p166074401343"><a name="p166074401343"></a><a name="p166074401343"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1360714053412"><td class="cellrowborder" valign="top" width="19.999999999999996%" headers="mcps1.1.6.1.1 "><p id="p20607104019345"><a name="p20607104019345"></a><a name="p20607104019345"></a>width</p>
</td>
<td class="cellrowborder" valign="top" width="19.999999999999996%" headers="mcps1.1.6.1.2 "><p id="p1860764010342"><a name="p1860764010342"></a><a name="p1860764010342"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="19.999999999999996%" headers="mcps1.1.6.1.3 "><p id="p260744012348"><a name="p260744012348"></a><a name="p260744012348"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="16.799999999999997%" headers="mcps1.1.6.1.4 "><p id="p16075402342"><a name="p16075402342"></a><a name="p16075402342"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="23.199999999999996%" headers="mcps1.1.6.1.5 "><p id="p26071640153415"><a name="p26071640153415"></a><a name="p26071640153415"></a>Width of the rectangle where the ellipse is located.</p>
</td>
</tr>
<tr id="row16607194014341"><td class="cellrowborder" valign="top" width="19.999999999999996%" headers="mcps1.1.6.1.1 "><p id="p160714012344"><a name="p160714012344"></a><a name="p160714012344"></a>height</p>
</td>
<td class="cellrowborder" valign="top" width="19.999999999999996%" headers="mcps1.1.6.1.2 "><p id="p14607140153410"><a name="p14607140153410"></a><a name="p14607140153410"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="19.999999999999996%" headers="mcps1.1.6.1.3 "><p id="p7607124033412"><a name="p7607124033412"></a><a name="p7607124033412"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="16.799999999999997%" headers="mcps1.1.6.1.4 "><p id="p8607144003418"><a name="p8607144003418"></a><a name="p8607144003418"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="23.199999999999996%" headers="mcps1.1.6.1.5 "><p id="p17607144013418"><a name="p17607144013418"></a><a name="p17607144013418"></a>Height of the rectangle where the ellipse is located.</p>
</td>
</tr>
</tbody>
</table>

## Example<a name="section4459736105512"></a>

```
@Entry
@Component
struct EllipseExample {
  build() {
    Flex({ justifyContent: FlexAlign.SpaceAround }) {
      // Draw an ellipse in a 150 x 70 rectangle.
      Ellipse({ width: 150, height: 80 })
      // Draw an ellipse in a 150 x 70 rectangle.
      Ellipse().width(150).height(80)
    }.width('100%').margin({ top: 5 })
  }
}
```

![](figures/ellipse.png)

