# ImageBitmap<a name="EN-US_TOPIC_0000001192915114"></a>

>![](../../public_sys-resources/icon-note.gif) **NOTE:** 
>This component is supported since API version 8. Updates will be marked with a superscript to indicate their earliest API version.

**ImageBitmap**  allows you to add an image bitmap.

## APIs<a name="section475132292218"></a>

ImageBitmap\(src: string\)

-   Parameters

    <a name="table193606194544"></a>
    <table><thead align="left"><tr id="row536071910541"><th class="cellrowborder" valign="top" width="12.540000000000001%" id="mcps1.1.6.1.1"><p id="p436112199544"><a name="p436112199544"></a><a name="p436112199544"></a>Name</p>
    </th>
    <th class="cellrowborder" valign="top" width="20.150000000000002%" id="mcps1.1.6.1.2"><p id="p19361319115410"><a name="p19361319115410"></a><a name="p19361319115410"></a>Type</p>
    </th>
    <th class="cellrowborder" valign="top" width="12.49%" id="mcps1.1.6.1.3"><p id="p9361201975417"><a name="p9361201975417"></a><a name="p9361201975417"></a>Mandatory</p>
    </th>
    <th class="cellrowborder" valign="top" width="18.6%" id="mcps1.1.6.1.4"><p id="p43611199542"><a name="p43611199542"></a><a name="p43611199542"></a>Default Value</p>
    </th>
    <th class="cellrowborder" valign="top" width="36.22%" id="mcps1.1.6.1.5"><p id="p1136141975419"><a name="p1136141975419"></a><a name="p1136141975419"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row10361101915545"><td class="cellrowborder" valign="top" width="12.540000000000001%" headers="mcps1.1.6.1.1 "><p id="p1361119155417"><a name="p1361119155417"></a><a name="p1361119155417"></a>src</p>
    </td>
    <td class="cellrowborder" valign="top" width="20.150000000000002%" headers="mcps1.1.6.1.2 "><p id="p8361181913548"><a name="p8361181913548"></a><a name="p8361181913548"></a>string</p>
    </td>
    <td class="cellrowborder" valign="top" width="12.49%" headers="mcps1.1.6.1.3 "><p id="p153611119195411"><a name="p153611119195411"></a><a name="p153611119195411"></a>Yes</p>
    </td>
    <td class="cellrowborder" valign="top" width="18.6%" headers="mcps1.1.6.1.4 "><p id="p1436114193546"><a name="p1436114193546"></a><a name="p1436114193546"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="36.22%" headers="mcps1.1.6.1.5 "><p id="p328155017218"><a name="p328155017218"></a><a name="p328155017218"></a>Path of the image bitmap object.</p>
    </td>
    </tr>
    </tbody>
    </table>


## Attributes<a name="section12589251192117"></a>

<a name="table858917515217"></a>
<table><thead align="left"><tr id="row458711513210"><th class="cellrowborder" valign="top" width="20%" id="mcps1.1.6.1.1"><p id="p11587165172115"><a name="p11587165172115"></a><a name="p11587165172115"></a>Attribute</p>
</th>
<th class="cellrowborder" valign="top" width="20%" id="mcps1.1.6.1.2"><p id="p1558745192116"><a name="p1558745192116"></a><a name="p1558745192116"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="20%" id="mcps1.1.6.1.3"><p id="p11587551182110"><a name="p11587551182110"></a><a name="p11587551182110"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="20%" id="mcps1.1.6.1.4"><p id="p75879518212"><a name="p75879518212"></a><a name="p75879518212"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="20%" id="mcps1.1.6.1.5"><p id="p145872518214"><a name="p145872518214"></a><a name="p145872518214"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row458835117215"><td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.1 "><p id="p18587651132114"><a name="p18587651132114"></a><a name="p18587651132114"></a>width</p>
</td>
<td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.2 "><p id="p05871051142111"><a name="p05871051142111"></a><a name="p05871051142111"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.3 "><p id="p135871151102115"><a name="p135871151102115"></a><a name="p135871151102115"></a>0px</p>
</td>
<td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.4 "><p id="p65889512215"><a name="p65889512215"></a><a name="p65889512215"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.5 "><p id="p165881151162119"><a name="p165881151162119"></a><a name="p165881151162119"></a>Image width.</p>
</td>
</tr>
<tr id="row5588651152112"><td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.1 "><p id="p65881951162115"><a name="p65881951162115"></a><a name="p65881951162115"></a>height</p>
</td>
<td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.2 "><p id="p4883529131919"><a name="p4883529131919"></a><a name="p4883529131919"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.3 "><p id="p658810511214"><a name="p658810511214"></a><a name="p658810511214"></a>0px</p>
</td>
<td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.4 "><p id="p13588195120219"><a name="p13588195120219"></a><a name="p13588195120219"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.5 "><p id="p5588105172111"><a name="p5588105172111"></a><a name="p5588105172111"></a>Image height.</p>
</td>
</tr>
</tbody>
</table>

Example

```
@Entry
@Component
struct DrawImageExample {
  private settings:RenderingContextSettings = new RenderingContextSettings(true)
  private context: CanvasRenderingContext2D = new CanvasRenderingContext2D(this.settings)
  private img:ImageBitmap = new ImageBitmap("common/images/example.jpg")

  build() {
    Flex({ direction: FlexDirection.Column, alignItems: ItemAlign.Center, justifyContent: FlexAlign.Center }) {
      Canvas(this.context)
        .width('100%')
        .height('100%')
        .backgroundColor('#ffff00')
        .onReady(() =>{
           this.context.drawImage( this.img,0,0,400,200)
        })
     }
    .width('100%')
    .height('100%')
  }
}
```

![](figures/en-us_image_0000001192595194.png)

