# TypeScript-based Declarative Development Paradigm

-   [Components](ts-components.md)
    -   [Universal Components](ts-universal-components.md)
        -   [Universal Events](ts-universal-events.md)
            -   [Click Event](ts-universal-events-click.md)
            -   [Touch](ts-universal-events-touch.md)
            -   [Show/Hide Event](ts-universal-events-show-hide.md)
            -   [Key Event](ts-universal-events-key.md)
            -   [Component Area Change Event](ts-universal-events-component-area-change.md)

        -   [Universal Attributes](ts-universal-attributes.md)
            -   [Size](ts-universal-attributes-size.md)
            -   [Location](ts-universal-attributes-location.md)
            -   [Layout Constraints](ts-universal-attributes-layout-constraints.md)
            -   [Flex Layout](ts-universal-attributes-flex-layout.md)
            -   [Border Configuration](ts-universal-attributes-border.md)
            -   [Background](ts-universal-attributes-background.md)
            -   [Opacity](ts-universal-attributes-opacity.md)
            -   [Visibility](ts-universal-attributes-visibility.md)
            -   [Enable/Disable](ts-universal-attributes-enable.md)
            -   [Overlay](ts-universal-attributes-overlay.md)
            -   [Z-order Control](ts-universal-attributes-z-order.md)
            -   [Transformation](ts-universal-attributes-transformation.md)
            -   [Image Effect Configuration](ts-universal-attributes-image-effect.md)
            -   [Shape Clipping](ts-universal-attributes-sharp-clipping.md)
            -   [Text Style](ts-universal-attributes-text-style.md)
            -   [Grid](ts-universal-attributes-grid.md)
            -   [Gradient Color](ts-universal-attributes-gradient-color.md)
            -   [Popup Control](ts-universal-attributes-popup.md)
            -   [Menu Control](ts-universal-attributes-menu.md)
            -   [Click Control](ts-universal-attributes-touchable.md)
            -   [Touch Target](ts-universal-attributes-response-region.md)

        -   [Gesture Processing](ts-gesture-processing.md)
            -   [Gesture Binding Methods](ts-gesture-settings.md)
            -   [Basic Gestures](ts-basic-gestures.md)
                -   [TapGesture](ts-basic-gestures-tapgesture.md)
                -   [LongPressGesture](ts-basic-gestures-longpressgesture.md)
                -   [PanGesture](ts-basic-gestures-pangesture.md)
                -   [PinchGesture](ts-basic-gestures-pinchgesture.md)
                -   [RotationGesture](ts-basic-gestures-rotationgesture.md)
                -   [SwipeGesture](ts-basic-gestures-swipegesture.md)

            -   [Combined Gestures](ts-combined-gestures.md)

    -   [Basic Components](ts-basic-components.md)
        -   [Blank](ts-basic-components-blank.md)
        -   [Button](ts-basic-components-button.md)
        -   [DataPanel](ts-basic-components-datapanel.md)
        -   [Divider](ts-basic-components-divider.md)
        -   [Gauge](ts-basic-components-gauge.md)
        -   [Image](ts-basic-components-image.md)
        -   [ImageAnimator](ts-basic-components-imageanimator.md)
        -   [LoadingProgress](ts-basic-components-loadingprogress.md)
        -   [Marquee](ts-basic-components-marquee.md)
        -   [Progress](ts-basic-components-progress.md)
        -   [QRCode](ts-basic-components-qrcode.md)
        -   [Rating](ts-basic-components-rating.md)
        -   [Select](ts-basic-components-select.md)
        -   [Slider](ts-basic-components-slider.md)
        -   [Span](ts-basic-components-span.md)
        -   [Text](ts-basic-components-text.md)
        -   [TextArea](ts-basic-components-textarea.md)
        -   [TextInput](ts-basic-components-textinput.md)
        -   [Toggle](ts-basic-components-toggle.md)
        -   [TextClock](ts-basic-components-textclock.md)
    
    -   [Container Components](ts-components-container.md)
        -   [AlphabetIndexer](ts-container-alphabet-indexer.md)
        -   [Badge](ts-container-badge.md)
        -   [Column](ts-container-column.md)
        -   [ColumnSplit](ts-container-columnsplit.md)
        -   [Counter](ts-container-counter.md)
        -   [Flex](ts-container-flex.md)
        -   [GridContainer](ts-container-gridcontainer.md)
        -   [Grid](ts-container-grid.md)
        -   [GridItem](ts-container-griditem.md)
        -   [List](ts-container-list.md)
        -   [ListItem](ts-container-listitem.md)
        -   [Navigator](ts-container-navigator.md)
        -   [Navigation](ts-container-navigation.md)
        -   [Panel](ts-container-panel.md)
        -   [Row](ts-container-row.md)
        -   [RowSplit](ts-container-rowsplit.md)
        -   [Scroll](ts-container-scroll.md)
        -   [ScrollBar](ts-container-scrollbar.md)
        -   [Stack](ts-container-stack.md)
        -   [Swiper](ts-container-swiper.md)
        -   [Tabs](ts-container-tabs.md)
        -   [TabContent](ts-container-tabcontent.md)
        
        -   [Refresh](ts-container-refresh.md)
    -   [Drawing Components](ts-drawing-components.md)
        
        -   [Circle](ts-drawing-components-circle.md)
        -   [Ellipse](ts-drawing-components-ellipse.md)
        -   [Line](ts-drawing-components-line.md)
        -   [Polyline](ts-drawing-components-polyline.md)
        -   [Polygon](ts-drawing-components-polygon.md)
    -   [Path](ts-drawing-components-path.md)
        -   [Rect](ts-drawing-components-rect.md)
        -   [Shape](ts-drawing-components-shape.md)
    
    -   [Canvas Components](ts-components-canvas.md)
        -   [Canvas](ts-components-canvas-canvas.md)
        -   [CanvasRenderingContext2D](ts-canvasrenderingcontext2d.md)
        -   [OffscreenCanvasRenderingConxt2D](ts-offscreencanvasrenderingcontext2d.md)
        -   [Lottie](ts-components-canvas-lottie.md)
        -   [Path2D](ts-components-canvas-path2d.md)
    -   [CanvasGradient](ts-components-canvas-canvasgradient.md)
        -   [ImageBitmap](ts-components-canvas-imagebitmap.md)
        -   [ImageData](ts-components-canvas-imagedata.md)
-   [Animation](ts-animation.md)
    -   [Attribute Animation](ts-animatorproperty.md)
    -   [Explicit Animation](ts-explicit-animation.md)
    -   [Transition Animation](ts-transition-animation.md)
        -   [Page Transition](ts-page-transition-animation.md)
        -   [Component Transition](ts-transition-animation-component.md)
        -   [Transition of Shared Elements](ts-transition-animation-shared-elements.md)

    -   [Motion Path Animation](ts-motion-path-animation.md)
    -   [Matrix Transformation](ts-matrix-transformation.md)
    -   [Interpolation Calculation](ts-interpolation-calculation.md)

-   [Global UI Methods](ts-global-ui-methods.md)
    -   [Alert Dialog Box](ts-methods-alert-dialog-box.md)
    -   [Custom Dialog box](ts-methods-custom-dialog-box.md)
    -   [Image Cache](ts-methods-image-cache.md)
    -   [Media Query](ts-methods-media-query.md)
    -   [List Selection Dialog Box](ts-methods-action-sheet.md)

-   [Appendix](ts-appendix.md)
    
    -   [Built-in Enums](ts-appendix-enums.md)

