# Running Lock

> ![icon-note.gif](public_sys-resources/icon-note.gif) **NOTE**
> The initial APIs of this module are supported since API version 7. Newly added APIs will be marked with a superscript to indicate their earliest API version.


## Modules to Import

```
import runninglock from '@ohos.runningLock';
```


## System Capabilities

SystemCapability.PowerManager.PowerManager


## RunningLockType

Enumerates the types of **RunningLock** objects.

| Name| Default Value| Description|
| -------- | -------- | -------- |
| BACKGROUND | 1 | Defines a **RunningLock** object.|
| PROXIMITY_SCREEN_CONTROL | 2 | A lock that determines whether to turn on or off the screen based on the distance away from the screen.|


## isRunningLockTypeSupported

isRunningLockTypeSupported(type: RunningLockType, callback: AsyncCallback&lt;boolean&gt;): void

Checks whether a specified type of RunningLock is supported. This function uses an asynchronous callback to return the result.

**Parameters**

| Name| Type| Mandatory| Description|
| -------- | -------- | -------- | -------- |
| type | RunningLockType | Yes| Type of the **RunningLock** object.|
| callback | AsyncCallback&lt;boolean&gt; | Yes| Callback used to obtain the return value. <br/>The value **true** indicates that the specified type of **RunningLock** is supported, and value **false** indicates the opposite.|

**Example**

```
runningLock.isRunningLockTypeSupported(runningLock.RunningLockType.BACKGROUND, (error, supported) => {
    if (typeof error === "undefined") {
        console.info('BACKGROUND support status is ' + supported);
    } else {
        console.log('error: ' + error);
    }
})
```


## isRunningLockTypeSupported

isRunningLockTypeSupported(type: RunningLockType): Promise&lt;boolean&gt;

Checks whether a specified type of **RunningLock** is supported. This function uses an asynchronous callback to return the result.

**Parameters**

| Name| Type| Mandatory| Description|
| -------- | -------- | -------- | -------- |
| type | RunningLockType | Yes| Type of the **RunningLock** object.|

**Return value**

| Type| Description|
| -------- | -------- |
| Promise&lt;boolean&gt; | Promise used to asynchronously obtain the return value. The value **true** indicates that the specified type of **RunningLock** is supported, and value **false** indicates the opposite.|

**Example**

```
runningLock.isRunningLockTypeSupported(runningLock.RunningLockType.PROXIMITY_SCREEN_CONTROL)
.then(supported => {
    console.info('PROXIMITY_SCREEN_CONTROL support status is ' + supported);
})
.catch(error => {
    console.log('error: ' + error);
});
```


## createRunningLock

createRunningLock(name: string, type: RunningLockType, callback: AsyncCallback&lt;RunningLock&gt;): void

Creates a **RunningLock** object.

Before using this API, you must declare the **ohos.permission.RUNNING_LOCK** permission.

**Parameters**

| Name| Type| Mandatory| Description|
| -------- | -------- | -------- | -------- |
| name | string | Yes| Name of the **RunningLock** object.|
| type | RunningLockType | Yes| Type of the **RunningLock** object to be created.|
| callback | AsyncCallback&lt;[RunningLock](#runninglock)&gt; | Yes| Callback used to obtain the return value.|

**Example**

```
runningLock.createRunningLock("running_lock_test", runningLock.RunningLockType.BACKGROUND)
.then(runninglock => {
    var used = runninglock.isUsed();
    console.info('runninglock is used: ' + used);
    runninglock.lock(500);
    used = runninglock.isUsed();
    console.info('after lock runninglock is used ' + used);
})
.catch(error => {
    console.log('create runningLock test error: ' + error);
})
```


## createRunningLock

createRunningLock(name: string, type: RunningLockType): Promise&lt;RunningLock&gt;

Creates a **RunningLock** object.

Before using this API, you must declare the **ohos.permission.RUNNING_LOCK** permission.

**Parameters**

| Name| Type| Mandatory| Description|
| -------- | -------- | -------- | -------- |
| name | string | Yes| Name of the **RunningLock** object.|
| type | RunningLockType | Yes| Type of the **RunningLock** object to be created.|

**Return value**

| Type| Description|
| -------- | -------- |
| Promise&lt;[RunningLock](#runninglock)&gt; | Promise used to asynchronously obtain the returned **RunningLock** object.|

**Example**

```
runningLock.createRunningLock("running_lock_test", runningLock.RunningLockType.BACKGROUND)
.then(runninglock => {
    console.info('create runningLock success');
})
.catch(error => {
    console.log('create runningLock test error: ' + error);
})
```


## RunningLock

Defines a **RunningLock** object.


### lock

lock(timeout: number): void

Locks and holds a **RunningLock** object.

**Parameters**

| Name| Type| Mandatory| Description|
| -------- | -------- | -------- | -------- |
| timeout | number | No| Duration for locking and holding the **RunningLock** object.|

**Example**

```
runningLock.createRunningLock("running_lock_test", runningLock.RunningLockType.BACKGROUND)
.then(runningLock => {
    runningLock.lock(100)
    console.info('create runningLock success')
})
.catch(error => {
    console.log('Lock runningLock test error: ' + error)
});
```


### unlock

unlock(): void

Releases a **Runninglock** object.

**Example**

```
runningLock.createRunningLock("running_lock_test", runningLock.RunningLockType.BACKGROUND)
.then(runningLock => {
    runningLock.unlock()
    console.info('unLock runningLock success')
})
.catch(error => {
    console.log('unLock runningLock test error: ' + error)
});
```


### isUsed

isUsed(): boolean

Checks the status of the **Runninglock** object.

**Return value**
| Type| Description|
| -------- | -------- |
| boolean | Returns **true** if the **Runninglock** object is held; returns **false** if the **Runninglock** object is released.|

**Example**

```
runningLock.createRunningLock("running_lock_test", runningLock.RunningLockType.BACKGROUND)
.then(runningLock => {
    var used = runningLock.isUsed()
    console.info('runningLock used status: ' + used)
})
.catch(error => {
    console.log('runningLock isUsed test error: ' + error)
});
```
