# tabs<a name="EN-US_TOPIC_0000001173324585"></a>

The  **<tabs\>**  component provides a tab container.

## Required Permissions<a name="section11257113618419"></a>

None

## Child Components<a name="section9288143101012"></a>

A  **<tabs\>**  can wrap at most one  **<[tab-bar](js-components-container-tab-bar.md)\>**  and at most one  **<[tab-content](js-components-container-tab-content.md)\>**.

## Attributes<a name="section2907183951110"></a>

In addition to the attributes in  [Universal Attributes](js-components-common-attributes.md), the following attributes are supported.

<a name="table20633101642315"></a>
<table><thead align="left"><tr id="row663331618238"><th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.1"><p id="aa872998ac2d84843a3c5161889afffef"><a name="aa872998ac2d84843a3c5161889afffef"></a><a name="aa872998ac2d84843a3c5161889afffef"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.2"><p id="ab2111648ee0e4f6d881be8954e7acaab"><a name="ab2111648ee0e4f6d881be8954e7acaab"></a><a name="ab2111648ee0e4f6d881be8954e7acaab"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="10.48%" id="mcps1.1.6.1.3"><p id="ab377d1c90900478ea4ecab51e9a058af"><a name="ab377d1c90900478ea4ecab51e9a058af"></a><a name="ab377d1c90900478ea4ecab51e9a058af"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.5200000000000005%" id="mcps1.1.6.1.4"><p id="p824610360217"><a name="p824610360217"></a><a name="p824610360217"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="35.76%" id="mcps1.1.6.1.5"><p id="a1d574a0044ed42ec8a2603bc82734232"><a name="a1d574a0044ed42ec8a2603bc82734232"></a><a name="a1d574a0044ed42ec8a2603bc82734232"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row188481425182510"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1123011311254"><a name="p1123011311254"></a><a name="p1123011311254"></a>index</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p1223193122517"><a name="p1223193122517"></a><a name="p1223193122517"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p1523183172515"><a name="p1523183172515"></a><a name="p1523183172515"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p623183182516"><a name="p623183182516"></a><a name="p623183182516"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p13231103192517"><a name="p13231103192517"></a><a name="p13231103192517"></a>Index of the active tab.</p>
</td>
</tr>
<tr id="row0461622112513"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p12311131122516"><a name="p12311131122516"></a><a name="p12311131122516"></a>vertical</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p423110319253"><a name="p423110319253"></a><a name="p423110319253"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p1023118318252"><a name="p1023118318252"></a><a name="p1023118318252"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p42311331102516"><a name="p42311331102516"></a><a name="p42311331102516"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p10231123114251"><a name="p10231123114251"></a><a name="p10231123114251"></a>Whether the tab is vertical. Available values are as follows:</p>
<a name="ul8231123114251"></a><a name="ul8231123114251"></a><ul id="ul8231123114251"><li><strong id="b12577236554"><a name="b12577236554"></a><a name="b12577236554"></a>false</strong>: The <strong id="b17955203312912"><a name="b17955203312912"></a><a name="b17955203312912"></a>&lt;tab-bar&gt;</strong> and <strong id="b14567123617917"><a name="b14567123617917"></a><a name="b14567123617917"></a>&lt;tab-content&gt;</strong> are arranged vertically.</li><li><strong id="b188320450320"><a name="b188320450320"></a><a name="b188320450320"></a>true</strong>: The <strong id="b108915451032"><a name="b108915451032"></a><a name="b108915451032"></a>&lt;tab-bar&gt;</strong> and <strong id="b168917451631"><a name="b168917451631"></a><a name="b168917451631"></a>&lt;tab-content&gt;</strong> are arranged horizontally.</li></ul>
</td>
</tr>
</tbody>
</table>

## Styles<a name="section169548171376"></a>

Styles in  [Universal Styles](js-components-common-styles.md)  are supported.

## Events<a name="section3892191911214"></a>

In addition to the events in  [Universal Events](js-components-common-events.md), the following events are supported.

<a name="table836435619510"></a>
<table><thead align="left"><tr id="row153658563517"><th class="cellrowborder" valign="top" width="24.852485248524854%" id="mcps1.1.4.1.1"><p id="a426b8903842d48fa8012a24ff3c997eb"><a name="a426b8903842d48fa8012a24ff3c997eb"></a><a name="a426b8903842d48fa8012a24ff3c997eb"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="29.552955295529554%" id="mcps1.1.4.1.2"><p id="a53448ba47e5e4ae9bf7774c90820e970"><a name="a53448ba47e5e4ae9bf7774c90820e970"></a><a name="a53448ba47e5e4ae9bf7774c90820e970"></a>Parameter</p>
</th>
<th class="cellrowborder" valign="top" width="45.5945594559456%" id="mcps1.1.4.1.3"><p id="add489ff50c444f24b759162c7f4bad9a"><a name="add489ff50c444f24b759162c7f4bad9a"></a><a name="add489ff50c444f24b759162c7f4bad9a"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row4918151132616"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p661018582267"><a name="p661018582267"></a><a name="p661018582267"></a>change</p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p15610135815262"><a name="p15610135815262"></a><a name="p15610135815262"></a>{ index: indexValue }</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p161015852613"><a name="p161015852613"></a><a name="p161015852613"></a>Triggered upon tab switching.</p>
<div class="note" id="note1551155885118"><a name="note1551155885118"></a><a name="note1551155885118"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p1251125818519"><a name="p1251125818519"></a><a name="p1251125818519"></a>This event is not triggered when the <strong id="b3802133719811"><a name="b3802133719811"></a><a name="b3802133719811"></a>index</strong> value is dynamically changed.</p>
</div></div>
</td>
</tr>
</tbody>
</table>

## Example<a name="section14993155318710"></a>

```
<!-- xxx.hml -->
<div class="container">
  <tabs class = "tabs" index="0" vertical="false" onchange="change">
    <tab-bar class="tab-bar" mode="fixed">
      <text class="tab-text">Home</text>
      <text class="tab-text">Index</text>
      <text class="tab-text">Detail</text>
    </tab-bar>
    <tab-content class="tabcontent" scrollable="true">
      <div class="item-content" >
        <text class="item-title">First screen</text>
      </div>
      <div class="item-content" >
        <text class="item-title">Second screen</text>
      </div>
      <div class="item-content" >
        <text class="item-title">Third screen</text>
      </div>
    </tab-content>
  </tabs>
</div>
```

```
/* xxx.css */
.container {
  flex-direction: column;
  justify-content: flex-start;
  align-items: center;
}
.tabs {
  width: 100%;
}
.tabcontent {
  width: 100%;
  height: 80%;
  justify-content: center;
}
.item-content {
  height: 100%;
  justify-content: center;
}
.item-title {
  font-size: 60px;
}
.tab-bar {
  margin: 10px;
  height: 60px;
  border-color: #007dff;
  border-width: 1px;
}
.tab-text {
  width: 300px;
  text-align: center;
}
```

```
// xxx.js
export default {
  change: function(e) {
    console.log("Tab index: " + e.index);
  },
}
```

![](figures/tab.gif)

