# Application Development Overview

The application development documents provide reference for you to develop applications using the APIs provided by OpenHarmony. They walk you through how to use JavaScript APIs to develop applications on the standard system.

The documents are carefully organized as follows:

### Getting Started

[Here](quick-start/start-overview.md) you'll learn how to quickly get started with OpenHarmony application development.

Browse the documents on the instructions for quickly building your first application and the basics about OpenHarmony applications.

Check out the development fundamentals, which comprise descriptions of the package structure configuration file for OpenHarmony applications and the instructions for use of resource files.

### Development

To facilitate your application development, we provide development guidelines for key features.

First thing first, familiarize yourself with the two cornerstone frameworks in OpenHarmony applications:

- Application framework: [Ability Development](ability/fa-brief.md)
- UI framework: [UI Development](ui/arkui-overview.md)

All applications should be developed on top of these frameworks.

Then, equip yourself for developing the key features, with the following guidelines:
- [Common Event and Notification](notification/notification-brief.md)
- [Window Manager](windowmanager/window-overview.md)
- [WebGL](webgl/webgl-overview.md)
- [Media](media/audio-overview.md)
- [Security](security/userauth-overview.md)
- [Connectivity](connectivity/ipc-rpc-overview.md)
- [Telephony](telephony/telephony-overview.md)
- [Data Management](database/database-mdds-overview.md)
- [Task Management](task-management/background-task-overview.md)
- [Device](device/usb-overview.md)
- [Device Usage Statistics](device-usage-statistics/device-usage-statistics-overview.md)
- [DFX](dfx/hiappevent-overview.md)
- [Internationalization](internationalization/international-overview.md)
- [OpenHarmony IDL Specifications and User Guide](IDL/idl-guidelines.md)
- [Using Native APIs in Application Projects](napi/napi-guidelines.md)

### Tools

DevEco Studio is a high-performance integrated development environment (IDE) recommended for developing OpenHarmony applications.
[Here](https://developer.harmonyos.com/en/docs/documentation/doc-guides/ohos-deveco-studio-overview-0000001263280421) you can learn everything about DevEco Studio, including how to use this tool to create a project and sign, debug, and run an application.

### Hands-On Tutorials

To make you better understand how functions work together and jumpstart your application development projects, we provide stripped-down, real-world [samples](https://gitee.com/openharmony/app_samples/blob/master/README.md) and [codelabs](https://gitee.com/openharmony/codelabs).

### API References

API references encompass all components and APIs available in OpenHarmony, helping you use and integrate APIs more effectively.

They are organized as follows:
-   [JS and TS APIs](reference/apis/js-apis-DataUriUtils.md)
-   Native APIs
    -   [Standard Library](reference/native-lib/third_party_libc/musl.md)
    -   [Node_API](reference/native-lib/third_party_napi/napi.md)

