# 文件管理子系统JS API变更

OpenHarmony 3.2 Beta3版本相较于OpenHarmony 3.2 Beta2版本，文件管理子系统的API变更如下:

## 接口变更

| 模块名 | 类名 | 方法/属性/枚举/常量 | 变更类型 |
|---|---|---|---|
| ohos.data.fileAccess                 | FileAccessHelper  | getRoots(): Promise\<RootIterator>;<br>getRoots(callback:AsyncCallback\<RootIterator>) : void;                                                                                                                                                                                                               | 新增 |
| ohos.data.fileAccess                 | FileAccessHelper  | access(sourceFileUri: string) : Promise\<boolean>;<br>access(sourceFileUri: string, callback: AsyncCallback\<boolean>) : void;                                                                                                                                                                               | 新增 |
| ohos.data.fileAccess                 | FileAccessHelper  | rename(uri: string, displayName: string) : Promise\<string>;<br>rename(uri: string, displayName: string, callback: AsyncCallback\<string>) : void;                                                                                                                                                           | 新增 |
| ohos.data.fileAccess                 | FileAccessHelper  | move(sourceFile: string, destFile: string) : Promise\<string>;<br>move(sourceFile: string, destFile: string, callback: AsyncCallback\<string>) : void;                                                                                                                                                       | 新增 |
| ohos.data.fileAccess                 | FileAccessHelper  | delete(uri: string) : Promise\<number>;<br>delete(uri: string, callback: AsyncCallback\<number>) : void;                                                                                                                                                                                                     | 新增 |
| ohos.data.fileAccess                 | FileAccessHelper  | mkDir(parentUri: string, displayName: string) : Promise\<string>;<br>mkDir(parentUri: string, displayName: string, callback: AsyncCallback\<string>) : void;                                                                                                                                                 | 新增 |
| ohos.data.fileAccess                 | FileAccessHelper  | createFile(uri: string, displayName: string) : Promise\<string>;<br>createFile(uri: string, displayName: string, callback: AsyncCallback\<string>) : void;                                                                                                                                                   | 新增 |
| ohos.data.fileAccess                 | FileAccessHelper  | openFile(uri: string, flags: OPENFLAGS) : Promise\<number>;<br>openFile(uri: string, flags: OPENFLAGS, callback: AsyncCallback\<number>) : void;                                                                                                                                                             | 新增 |
| ohos.data.fileAccess                 | OPENFLAGS         | WRITE_READ = 0o2                                                                                                                                                                                                                                                                                              | 新增 |
| ohos.data.fileAccess                 | OPENFLAGS         | WRITE = 0o1                                                                                                                                                                                                                                                                                                   | 新增 |
| ohos.data.fileAccess                 | OPENFLAGS         | READ = 0o0                                                                                                                                                                                                                                                                                                    | 新增 |
| ohos.data.fileAccess                 | RootIterator      | next(): {value: RootInfo, done: boolean}                                                                                                                                                                                                                                                                      | 新增 |
| ohos.data.fileAccess                 | RootInfo          | scanFile(filter?: Filter): FileIterator;                                                                                                                                                                                                                                                                      | 新增 |
| ohos.data.fileAccess                 | RootInfo          | listFile(filter?: Filter): FileIterator;                                                                                                                                                                                                                                                                      | 新增 |
| ohos.data.fileAccess                 | RootInfo          | deviceFlags: number;                                                                                                                                                                                                                                                                                          | 新增 |
| ohos.data.fileAccess                 | RootInfo          | displayName: string;                                                                                                                                                                                                                                                                                          | 新增 |
| ohos.data.fileAccess                 | RootInfo          | uri: string;                                                                                                                                                                                                                                                                                                  | 新增 |
| ohos.data.fileAccess                 | RootInfo          | deviceType: number;                                                                                                                                                                                                                                                                                           | 新增 |
| ohos.data.fileAccess                 | FileIterator      | next(): {value: FileInfo, done: boolean}                                                                                                                                                                                                                                                                      | 新增 |
| ohos.data.fileAccess                 | FileInfo          | scanFile(filter?: Filter): FileIterator;                                                                                                                                                                                                                                                                      | 新增 |
| ohos.data.fileAccess                 | FileInfo          | listFile(filter?: Filter): FileIterator;                                                                                                                                                                                                                                                                      | 新增 |
| ohos.data.fileAccess                 | FileInfo          | mimeType: string;                                                                                                                                                                                                                                                                                             | 新增 |
| ohos.data.fileAccess                 | FileInfo          | mtime: number;                                                                                                                                                                                                                                                                                                | 新增 |
| ohos.data.fileAccess                 | FileInfo          | size: number;                                                                                                                                                                                                                                                                                                 | 新增 |
| ohos.data.fileAccess                 | FileInfo          | mode: number;                                                                                                                                                                                                                                                                                                 | 新增 |
| ohos.data.fileAccess                 | FileInfo          | fileName: string;                                                                                                                                                                                                                                                                                             | 新增 |
| ohos.data.fileAccess                 | FileInfo          | uri: string;                                                                                                                                                                                                                                                                                                  | 新增 |
| ohos.data.fileAccess                 | fileAccess        | createFileAccessHelper(context: Context): FileAccessHelper;<br>createFileAccessHelper(context: Context, wants: Array\<Want>): FileAccessHelper;                                                                                                                                            | 新增 |
| ohos.data.fileAccess                 | fileAccess        | getFileAccessAbilityInfo(callback: AsyncCallback\<Array\<Want>>): void;<br>getFileAccessAbilityInfo(): Promise\<Array\<Want>>;                                                                                                                                                             | 新增 |
| ohos.fileExtensionInfo               | DocumentFlag      | const SUPPORTS_WRITE = 0b1000;                                                                                                                                                                                                                                                                                | 新增 |
| ohos.fileExtensionInfo               | DocumentFlag      | const SUPPORTS_READ = 0b100;                                                                                                                                                                                                                                                                                  | 新增 |
| ohos.fileExtensionInfo               | DocumentFlag      | const REPRESENTS_DIR = 0b10;                                                                                                                                                                                                                                                                                  | 新增 |
| ohos.fileExtensionInfo               | DocumentFlag      | const REPRESENTS_FILE = 0b1;                                                                                                                                                                                                                                                                                  | 新增 |
| ohos.fileExtensionInfo               | DeviceFlag        | const SUPPORTS_WRITE = 0b10;                                                                                                                                                                                                                                                                                  | 新增 |
| ohos.fileExtensionInfo               | DeviceFlag        | const SUPPORTS_READ = 0b1;                                                                                                                                                                                                                                                                                    | 新增 |
| ohos.fileExtensionInfo               | DeviceType        | DEVICE_EXTERNAL_CLOUD                                                                                                                                                                                                                                                                                         | 新增 |
| ohos.fileExtensionInfo               | DeviceType        | DEVICE_EXTERNAL_USB                                                                                                                                                                                                                                                                                           | 新增 |
| ohos.fileExtensionInfo               | DeviceType        | DEVICE_EXTERNAL_MTP                                                                                                                                                                                                                                                                                           | 新增 |
| ohos.fileExtensionInfo               | DeviceType        | DEVICE_NETWORK_NEIGHBORHOODS                                                                                                                                                                                                                                                                                  | 新增 |
| ohos.fileExtensionInfo               | DeviceType        | DEVICE_SHARED_TERMINAL                                                                                                                                                                                                                                                                                        | 新增 |
| ohos.fileExtensionInfo               | DeviceType        | DEVICE_SHARED_DISK                                                                                                                                                                                                                                                                                            | 新增 |
| ohos.fileExtensionInfo               | DeviceType        | DEVICE_LOCAL_DISK = 1                                                                                                                                                                                                                                                                                         | 新增 |
| ohos.filemanagement.userfile_manager | VirtualAlbum      | getFileAssets(type: Array\<MediaType>, options: MediaFetchOptions, callback: AsyncCallback\<FetchFileResult>): void;<br>getFileAssets(type: Array\<MediaType>, options: MediaFetchOptions): Promise\<FetchFileResult>;                                                                                       | 新增 |
| ohos.filemanagement.userfile_manager | VirtualAlbumType  | TYPE_TRASH                                                                                                                                                                                                                                                                                                    | 新增 |
| ohos.filemanagement.userfile_manager | VirtualAlbumType  | TYPE_FAVORITE                                                                                                                                                                                                                                                                                                 | 新增 |
| ohos.filemanagement.userfile_manager | PeerInfo          | readonly isOnline: boolean;                                                                                                                                                                                                                                                                                   | 新增 |
| ohos.filemanagement.userfile_manager | PeerInfo          | readonly networkId: string;                                                                                                                                                                                                                                                                                   | 新增 |
| ohos.filemanagement.userfile_manager | PeerInfo          | readonly deviceName: string;                                                                                                                                                                                                                                                                                  | 新增 |
| ohos.filemanagement.userfile_manager | Size              | height: number;                                                                                                                                                                                                                                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | Size              | width: number;                                                                                                                                                                                                                                                                                                | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | release(callback: AsyncCallback\<void>): void;<br>release(): Promise\<void>;                                                                                                                                                                                                                                 | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | getAllPeers(callback: AsyncCallback\<Array\<PeerInfo>>): void;<br>getAllPeers(): Promise\<Array\<PeerInfo>>;                                                                                                                                                                                                 | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | getActivePeers(callback: AsyncCallback\<Array\<PeerInfo>>): void;<br>getActivePeers(): Promise\<Array\<PeerInfo>>;                                                                                                                                                                                           | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | getPrivateAlbum(type: VirtualAlbumType, callback: AsyncCallback\<Array\<VirtualAlbum>>): void;<br>getPrivateAlbum(type: VirtualAlbumType): Promise\<Array\<VirtualAlbum>>;                                                                                                                                   | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | getAlbums(type: Array\<MediaType>, options: MediaFetchOptions, callback: AsyncCallback\<Array\<Album>>): void;<br>getAlbums(type: Array\<MediaType>, options: MediaFetchOptions): Promise\<Array\<Album>>;                                                                                                   | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | deleteAsset(uri: string, callback: AsyncCallback\<void>): void;<br>deleteAsset(uri: string): Promise\<void>;                                                                                                                                                                                                 | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | createAsset(mediaType: MediaType, displayName: string, relativePath: string, callback: AsyncCallback\<FileAsset>): void;<br>createAsset(mediaType: MediaType, displayName: string, relativePath: string): Promise\<FileAsset>;                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                                                                                          | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                                                                                          | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                                                                                          | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                                                                                          | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                                                                                          | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                                                                                          | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | off(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback?: Callback\<void>): void;                                                                                                                                                          | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                                                                                            | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                                                                                            | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                                                                                            | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                                                                                            | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                                                                                            | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                                                                                            | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | on(type: 'deviceChange'\|'albumChange'\|'imageChange'\|'audioChange'\|'videoChange'\|'fileChange'\|'remoteFileChange', callback: Callback\<void>): void;                                                                                                                                                            | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | getFileAssets(type: Array\<MediaType>, options: MediaFetchOptions, callback: AsyncCallback\<FetchFileResult>): void;<br>getFileAssets(type: Array\<MediaType>, options: MediaFetchOptions): Promise\<FetchFileResult>;                                                                                       | 新增 |
| ohos.filemanagement.userfile_manager | UserFileManager   | getPublicDirectory(type: DirectoryType, callback: AsyncCallback\<string>): void;<br>getPublicDirectory(type: DirectoryType): Promise\<string>;                                                                                                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | DirectoryType     | DIR_DOWNLOAD                                                                                                                                                                                                                                                                                                  | 新增 |
| ohos.filemanagement.userfile_manager | DirectoryType     | DIR_DOCUMENTS                                                                                                                                                                                                                                                                                                 | 新增 |
| ohos.filemanagement.userfile_manager | DirectoryType     | DIR_AUDIO                                                                                                                                                                                                                                                                                                     | 新增 |
| ohos.filemanagement.userfile_manager | DirectoryType     | DIR_IMAGE                                                                                                                                                                                                                                                                                                     | 新增 |
| ohos.filemanagement.userfile_manager | DirectoryType     | DIR_VIDEO                                                                                                                                                                                                                                                                                                     | 新增 |
| ohos.filemanagement.userfile_manager | DirectoryType     | DIR_CAMERA = 0                                                                                                                                                                                                                                                                                                | 新增 |
| ohos.filemanagement.userfile_manager | Album             | getFileAssets(type: Array\<MediaType>, callback: AsyncCallback\<FetchFileResult>): void;<br>getFileAssets(type: Array\<MediaType>, options: MediaFetchOptions, callback: AsyncCallback\<FetchFileResult>): void;<br>getFileAssets(type: Array\<MediaType>, options?: MediaFetchOptions): Promise\<FetchFileResult>; | 新增 |
| ohos.filemanagement.userfile_manager | Album             | commitModify(callback: AsyncCallback\<void>): void;<br>commitModify(): Promise\<void>;                                                                                                                                                                                                                       | 新增 |
| ohos.filemanagement.userfile_manager | Album             | readonly coverUri: string;                                                                                                                                                                                                                                                                                    | 新增 |
| ohos.filemanagement.userfile_manager | Album             | readonly relativePath: string;                                                                                                                                                                                                                                                                                | 新增 |
| ohos.filemanagement.userfile_manager | Album             | readonly count: number;                                                                                                                                                                                                                                                                                       | 新增 |
| ohos.filemanagement.userfile_manager | Album             | readonly dateModified: number;                                                                                                                                                                                                                                                                                | 新增 |
| ohos.filemanagement.userfile_manager | Album             | readonly albumUri: string;                                                                                                                                                                                                                                                                                    | 新增 |
| ohos.filemanagement.userfile_manager | Album             | albumName: string;                                                                                                                                                                                                                                                                                            | 新增 |
| ohos.filemanagement.userfile_manager | FetchFileResult   | getPositionObject(index: number, callback: AsyncCallback\<FileAsset>): void;<br>getPositionObject(index: number): Promise\<FileAsset>;                                                                                                                                                                       | 新增 |
| ohos.filemanagement.userfile_manager | FetchFileResult   | getLastObject(callback: AsyncCallback\<FileAsset>): void;<br>getLastObject(): Promise\<FileAsset>;                                                                                                                                                                                                           | 新增 |
| ohos.filemanagement.userfile_manager | FetchFileResult   | getNextObject(callback: AsyncCallback\<FileAsset>): void;<br>getNextObject(): Promise\<FileAsset>;                                                                                                                                                                                                           | 新增 |
| ohos.filemanagement.userfile_manager | FetchFileResult   | getFirstObject(callback: AsyncCallback\<FileAsset>): void;<br>getFirstObject(): Promise\<FileAsset>;                                                                                                                                                                                                         | 新增 |
| ohos.filemanagement.userfile_manager | FetchFileResult   | close(): void;                                                                                                                                                                                                                                                                                                | 新增 |
| ohos.filemanagement.userfile_manager | FetchFileResult   | isAfterLast(): boolean;                                                                                                                                                                                                                                                                                       | 新增 |
| ohos.filemanagement.userfile_manager | FetchFileResult   | getCount(): number;                                                                                                                                                                                                                                                                                           | 新增 |
| ohos.filemanagement.userfile_manager | MediaFetchOptions | selectionArgs: Array\<string>;                                                                                                                                                                                                                                                                                | 新增 |
| ohos.filemanagement.userfile_manager | MediaFetchOptions | selections: string;                                                                                                                                                                                                                                                                                           | 新增 |
| ohos.filemanagement.userfile_manager | AlbumKey          | DATE_MODIFIED = "date_modified"                                                                                                                                                                                                                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | AlbumKey          | DATE_ADDED = "date_added"                                                                                                                                                                                                                                                                                     | 新增 |
| ohos.filemanagement.userfile_manager | AlbumKey          | DISPLAY_NAME = "display_name"                                                                                                                                                                                                                                                                                 | 新增 |
| ohos.filemanagement.userfile_manager | AlbumKey          | RELATIVE_PATH = "relative_path"                                                                                                                                                                                                                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | AlbumKey          | URI = "uri"                                                                                                                                                                                                                                                                                                   | 新增 |
| ohos.filemanagement.userfile_manager | ImageVideoKey     | DATE_TAKEN = "date_taken"                                                                                                                                                                                                                                                                                     | 新增 |
| ohos.filemanagement.userfile_manager | ImageVideoKey     | HEIGHT = "height"                                                                                                                                                                                                                                                                                             | 新增 |
| ohos.filemanagement.userfile_manager | ImageVideoKey     | WIDTH = "width"                                                                                                                                                                                                                                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | ImageVideoKey     | DURATION = "duration"                                                                                                                                                                                                                                                                                         | 新增 |
| ohos.filemanagement.userfile_manager | ImageVideoKey     | TITLE = "title"                                                                                                                                                                                                                                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | ImageVideoKey     | DATE_MODIFIED = "date_modified"                                                                                                                                                                                                                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | ImageVideoKey     | DATE_ADDED = "date_added"                                                                                                                                                                                                                                                                                     | 新增 |
| ohos.filemanagement.userfile_manager | ImageVideoKey     | DISPLAY_NAME = "display_name"                                                                                                                                                                                                                                                                                 | 新增 |
| ohos.filemanagement.userfile_manager | ImageVideoKey     | RELATIVE_PATH = "relative_path"                                                                                                                                                                                                                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | ImageVideoKey     | URI = "uri"                                                                                                                                                                                                                                                                                                   | 新增 |
| ohos.filemanagement.userfile_manager | AudioKey          | DURATION = "duration"                                                                                                                                                                                                                                                                                         | 新增 |
| ohos.filemanagement.userfile_manager | AudioKey          | AUDIOALBUM = "audio_album"                                                                                                                                                                                                                                                                                    | 新增 |
| ohos.filemanagement.userfile_manager | AudioKey          | ARTIST = "artist"                                                                                                                                                                                                                                                                                             | 新增 |
| ohos.filemanagement.userfile_manager | AudioKey          | TITLE = "title"                                                                                                                                                                                                                                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | AudioKey          | DATE_MODIFIED = "date_modified"                                                                                                                                                                                                                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | AudioKey          | DATE_ADDED = "date_added"                                                                                                                                                                                                                                                                                     | 新增 |
| ohos.filemanagement.userfile_manager | AudioKey          | DISPLAY_NAME = "display_name"                                                                                                                                                                                                                                                                                 | 新增 |
| ohos.filemanagement.userfile_manager | AudioKey          | RELATIVE_PATH = "relative_path"                                                                                                                                                                                                                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | AudioKey          | URI = "uri"                                                                                                                                                                                                                                                                                                   | 新增 |
| ohos.filemanagement.userfile_manager | FileKey           | TITLE = "title"                                                                                                                                                                                                                                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | FileKey           | DATE_MODIFIED = "date_modified"                                                                                                                                                                                                                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | FileKey           | DATE_ADDED = "date_added"                                                                                                                                                                                                                                                                                     | 新增 |
| ohos.filemanagement.userfile_manager | FileKey           | DISPLAY_NAME = "display_name"                                                                                                                                                                                                                                                                                 | 新增 |
| ohos.filemanagement.userfile_manager | FileKey           | RELATIVE_PATH = "relative_path"                                                                                                                                                                                                                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | FileKey           | URI = "uri"                                                                                                                                                                                                                                                                                                   | 新增 |
| ohos.filemanagement.userfile_manager | FileAsset         | isTrash(callback: AsyncCallback\<boolean>): void;<br>isTrash():Promise\<boolean>;                                                                                                                                                                                                                            | 新增 |
| ohos.filemanagement.userfile_manager | FileAsset         | trash(isTrash: boolean, callback: AsyncCallback\<void>): void;<br>trash(isTrash: boolean): Promise\<void>;                                                                                                                                                                                                   | 新增 |
| ohos.filemanagement.userfile_manager | FileAsset         | isFavorite(callback: AsyncCallback\<boolean>): void;<br>isFavorite():Promise\<boolean>;                                                                                                                                                                                                                      | 新增 |
| ohos.filemanagement.userfile_manager | FileAsset         | favorite(isFavorite: boolean, callback: AsyncCallback\<void>): void;<br>favorite(isFavorite: boolean): Promise\<void>;                                                                                                                                                                                       | 新增 |
| ohos.filemanagement.userfile_manager | FileAsset         | getThumbnail(callback: AsyncCallback\<image.PixelMap>): void;<br>getThumbnail(size: Size, callback: AsyncCallback\<image.PixelMap>): void;<br>getThumbnail(size?: Size): Promise\<image.PixelMap>;                                                                                                          | 新增 |
| ohos.filemanagement.userfile_manager | FileAsset         | close(fd: number, callback: AsyncCallback\<void>): void;<br>close(fd: number): Promise\<void>;                                                                                                                                                                                                               | 新增 |
| ohos.filemanagement.userfile_manager | FileAsset         | open(mode: string, callback: AsyncCallback\<number>): void;<br>open(mode: string): Promise\<number>;                                                                                                                                                                                                         | 新增 |
| ohos.filemanagement.userfile_manager | FileAsset         | commitModify(callback: AsyncCallback\<void>): void;<br>commitModify(): Promise\<void>;                                                                                                                                                                                                                       | 新增 |
| ohos.filemanagement.userfile_manager | FileAsset         | isDirectory(callback: AsyncCallback\<boolean>): void;<br>isDirectory():Promise\<boolean>;                                                                                                                                                                                                                    | 新增 |
| ohos.filemanagement.userfile_manager | FileAsset         | displayName: string;                                                                                                                                                                                                                                                                                          | 新增 |
| ohos.filemanagement.userfile_manager | FileAsset         | readonly mediaType: MediaType;                                                                                                                                                                                                                                                                                | 新增 |
| ohos.filemanagement.userfile_manager | FileAsset         | readonly uri: string;                                                                                                                                                                                                                                                                                         | 新增 |
| ohos.filemanagement.userfile_manager | MediaType         | AUDIO                                                                                                                                                                                                                                                                                                         | 新增 |
| ohos.filemanagement.userfile_manager | MediaType         | VIDEO                                                                                                                                                                                                                                                                                                         | 新增 |
| ohos.filemanagement.userfile_manager | MediaType         | IMAGE                                                                                                                                                                                                                                                                                                         | 新增 |
| ohos.filemanagement.userfile_manager | MediaType         | FILE = 0                                                                                                                                                                                                                                                                                                      | 新增 |
| ohos.filemanagement.userfile_manager | userfile_manager  | getUserFileMgr(): UserFileManager;<br>getUserFileMgr(context: Context): UserFileManager;                                                                                                                                                                                                   | 新增 |
| ohos.document | document | show(uri: string, type: string): Promise\<void>;<br>show(uri: string, type: string, callback: AsyncCallback\<void>): void;                                              | 废弃 |
| ohos.document | document | choose(types?: string[]): Promise\<string>;<br>choose(callback: AsyncCallback\<string>): void;<br>choose(types: string[], callback: AsyncCallback\<string>): void; | 废弃 |