# 设备开发

- [设备开发导读](device-dev-guide.md) 
- 了解OpenHarmony
  - [了解OpenHarmony开源项目](../OpenHarmony-Overview_zh.md) 
  - [术语](../glossary.md) 
  - [版本说明](../release-notes/Readme.md) 
- 快速开始
  - [快速入门](quick-start/Readme-CN.md) 	
- 兼容性与安全       
  - [隐私与安全规范](security/Readme-CN.md)
- 移植
  - 移植指导
      - [轻量和小型系统三方库移植指导](porting/porting-thirdparty-overview.md)
      - [轻量系统芯片移植指导](porting/porting-minichip-overview.md)
      - [小型系统芯片移植指导](porting/porting-smallchip-prepare-needs.md)
      - [标准系统芯片移植指导](porting/standard-system-porting-guide.md)
  - 移植案例
      - 轻量系统芯片移植案例
          - [带屏解决方案之恒玄芯片移植案例](porting/porting-bes2600w-on-minisystem-display-demo.md) 
          - [Combo解决方案之ASR芯片移植案例](porting/porting-asr582x-combo-demo.md)    
          - [物联网解决方案之芯海cst85芯片移植案例](porting/porting-cst85f01-combo-demo.md)    
          - [轻量系统STM32F407芯片移植案例](porting/porting-stm32f407-on-minisystem-eth.md)    
          - [Combo解决方案之W800芯片移植案例](porting/porting-w800-combo-demo.md)
      - 小型系统芯片移植案例
          - [小型设备STM32MP1芯片移植案例](porting/porting-stm32mp15xx-on-smallsystem.md)
      - 标准系统芯片移植案例
          - [标准系统方案之瑞芯微RK3568移植案例](porting/porting-dayu200-on_standard-demo.md) 
          - [标准系统方案之瑞芯微RK3566移植案例](https://gitee.com/openharmony/vendor_kaihong/blob/master/khdvk_3566b/porting-khdvk_3566b-on_standard-demo.md)	
- 子系统开发
  - 内核 
    - [轻量系统内核](kernel/kernel-mini-overview.md)
    - [小型系统内核](kernel/kernel-small-overview.md)
    - [标准系统内核](kernel/kernel-standard-overview.md)
  - [驱动](driver/Readme-CN.md) 
  - [编译构建](subsystems/subsys-build-all.md) 
  - [分布式远程启动](subsystems/subsys-remote-start.md)
  - [图形图像](subsystems/subsys-graphics-overview.md)	
  - [媒体](subsystems/subsys-multimedia-camera-overview.md)
  - [公共基础](subsystems/subsys-utils-overview.md)
  - [AI框架](subsystems/subsys-ai-aiframework-devguide.md) 	
  - [数据管理](subsystems/subsys-data-relational-database-overview.md)
  - [Sensor服务](subsystems/subsys-sensor-overview.md)
  - [USB服务](subsystems/subsys-usbservice-overview.md)
  - [用户程序框架](subsystems/subsys-application-framework-overview.md)
  - [OTA升级](subsystems/subsys-ota-guide.md)
  - [电话服务](subsystems/subsys-tel-overview.md)
  - [安全](subsystems/subsys-security-overview.md)
  - [启动恢复](subsystems/subsys-boot-overview.md)	
  - [DFX](subsystems/subsys-dfx-overview.md)
- 专题开发
  - [HPM Part](hpm-part/Readme-CN.md) 	 
- 设备开发示例
  - [轻量和小型系统设备开发示例](guide/device-wlan-led-control.md) 
  - [标准系统设备开发示例](guide/device-clock-guide.md) 
- 调测
  - [设备测试](device-test/Readme-CN.md)	
  - [调测工具](subsystems/subsys-toolchain-hdc-guide.md) 
- 工具
  - [Docker编译环境](get-code/gettools-acquire.md)
  - [IDE集成开发环境](get-code/gettools-ide.md)
- 示例教程
  - [Demo示例](https://growing.openharmony.cn/mainPlay/sample)
  - [Codelabs](https://gitee.com/openharmony/codelabs/blob/master/README.md) 
- 参考
  - [常见问题-设备开发](faqs/Readme-CN.md)
  - [HDI接口参考](reference/hdi-apis/Readme-CN.md)
  - [CMSIS API参考](reference/kernel/cmsis/Readme-CN.md)
- 贡献
  - [参与贡献](../contribute/贡献文档.md) 