# OpenHarmony应用开发文档

- [应用开发导读](application-dev-guide.md)
- 入门
  - 快速入门
    - [开发准备](quick-start/start-overview.md)
    - [使用ArkTS语言开发（Stage模型）](quick-start/start-with-ets-stage.md)
    - [使用ArkTS语言开发（FA模型）](quick-start/start-with-ets-fa.md)
    - [使用JS语言开发（FA模型）](quick-start/start-with-js-fa.md)
  - 开发基础知识
    - 应用程序包基础知识
      - [应用程序包概述](quick-start/application-package-overview.md)
      - 应用程序包结构
        - [Stage模型应用程序包结构](quick-start/application-package-structure-stage.md)
        - [FA模型应用程序包结构](quick-start/application-package-structure-fa.md)
        - [HAR包结构](quick-start/har-structure.md)
      - 应用程序包多HAP机制
        - [多HAP机制设计目标](quick-start/multi-hap-objective.md)
        - [多HAP构建视图](quick-start/multi-hap-build-view.md)
        - [多HAP的开发调试与发布部署流程](quick-start/multi-hap-release-deployment.md)
        - [多HAP使用规则](quick-start/multi-hap-rules.md)
        - [多HAP运行机制及数据通信方式](quick-start/multi-hap-principles.md)
      - [应用程序包安装和卸载流程](quick-start/application-package-install-uninstall.md)
    - 应用配置文件（Stage模型）
      - [应用配置文件概述（Stage模型）](quick-start/application-configuration-file-overview-stage.md)
      - [app.json5配置文件](quick-start/app-configuration-file.md)
      - [module.json5配置文件](quick-start/module-configuration-file.md)
    - 应用配置文件（FA模型）
      - [应用配置文件概述（FA模型）](quick-start/application-configuration-file-overview-fa.md)
      - [app对象内部结构](quick-start/app-structure.md)
      - [deviceConfig内部结构](quick-start/deviceconfig-structure.md)
      - [module对象内部结构](quick-start/module-structure.md)
    - [资源分类与访问](quick-start/resource-categories-and-access.md)
    - 学习ArkTS语言
      - [初识ArkTS语言](quick-start/arkts-get-started.md)
      - ArkTS语法（声明式UI）
        - [基本UI描述](quick-start/arkts-basic-ui-description.md)
        - 状态管理
          - [基本概念](quick-start/arkts-state-mgmt-concepts.md)
          - [页面级变量的状态管理](quick-start/arkts-state-mgmt-page-level.md)
          - [应用级变量的状态管理](quick-start/arkts-state-mgmt-application-level.md)
        - [动态构建UI元素](quick-start/arkts-dynamic-ui-elememt-building.md)
        - [渲染控制](quick-start/arkts-rendering-control.md)
        - [使用限制与扩展](quick-start/arkts-restrictions-and-extensions.md)
- 开发
  - 应用模型
    - 应用模型概述
      - [OpenHarmony应用模型的构成要素](application-models/application-model-composition.md)
      - [OpenHarmony应用模型解读](application-models/application-model-description.md)
    - Stage模型开发指导
      - [Stage模型开发概述](application-models/stage-model-development-overview.md)
      - Stage模型应用组件
        - [应用/组件级配置](application-models/application-component-configuration-stage.md)
        - UIAbility组件
          - [UIAbility组件概述](application-models/uiability-overview.md)
          - [UIAbility组件生命周期](application-models/uiability-lifecycle.md)
          - [UIAbility组件启动模式](application-models/uiability-launch-type.md)
          - [UIAbility组件基本用法](application-models/uiability-usage.md)
          - [UIAbility组件与UI的数据同步](application-models/uiability-data-sync-with-ui.md)
          - [UIAbility组件间交互（设备内）](application-models/uiability-intra-device-interaction.md)
        - ExtensionAbility组件
          - [ExtensionAbility组件概述](application-models/extensionability-overview.md)
          - [ServiceExtensionAbility](application-models/serviceextensionability.md)
          - [DataShareExtensionAbility（仅对系统应用开放）](application-models/datashareextensionability.md)
          - [FormExtensionAbility（服务卡片）](application-models/widget-development-stage.md)
        - [AbilityStage组件容器](application-models/abilitystage.md)
        - [应用上下文Context](application-models/application-context-stage.md)
        - 信息传递载体Want
          - [Want概述](application-models/want-overview.md)
          - [显式Want与隐式Want匹配规则](application-models/explicit-implicit-want-mappings.md)
          - [常见action与entities](application-models/actions-entities.md)
          - [使用显式Want启动Ability](application-models/ability-startup-with-explicit-want.md)
          - [使用隐式Want打开网址](application-models/ability-startup-with-implicit-want.md)
          - [应用间使用Want分享数据](application-models/data-share-via-want.md)
        - [组件启动规则](application-models/component-startup-rules.md)
        - 应用组件跨设备交互（流转）
          - [流转概述](application-models/inter-device-interaction-hop-overview.md)
          - [跨端迁移（仅对系统应用开放）](application-models/hop-cross-device-migration.md)
          - [多端协同（仅对系统应用开放）](application-models/hop-multi-device-collaboration.md)
      - 进程间通信
        - [进程模型](application-models/process-model-stage.md)
        - 公共事件
          - [公共事件简介](application-models/common-event-overview.md)
          - [公共事件订阅](application-models/common-event-subscription.md)
          - [公共事件发布](application-models/common-event-publish.md)
          - [公共事件取消订阅](application-models/common-event-unsubscription.md)
        - [后台服务](application-models/background-services.md)
      - 线程间通信
        - [线程模型](application-models/thread-model-stage.md)
        - [使用Emitter进行线程间通信](application-models/itc-with-emitter.md)
        - [使用Worker进行线程间通信](application-models/itc-with-worker.md)
      - 任务管理
        - [任务管理场景介绍](application-models/mission-management-overview.md)
        - [任务管理与启动模式](application-models/mission-management-launch-type.md)
        - [页面栈及任务链](application-models/page-mission-stack.md)
    - FA模型开发指导
      - [FA模型开发概述](application-models/fa-model-development-overview.md)
      - FA模型应用组件
        - [应用/组件级配置](application-models/application-component-configuration-fa.md)
        - PageAbility组件开发指导
          - [PageAbility组件概述](application-models/pageability-overview.md)
          - [PageAbility组件配置](application-models/pageability-configuration.md)
          - [PageAbility的生命周期](application-models/pageability-lifecycle.md)
          - [PageAbility的启动模式](application-models/pageability-launch-type.md)
          - [创建PageAbility](application-models/create-pageability.md)
          - [启动本地PageAbility](application-models/start-local-pageability.md)
          - [停止PageAbility](application-models/stop-pageability.md)
          - [启动远程PageAbility（仅对系统应用开放）](application-models/start-remote-pageability.md)
          - [启动指定页面](application-models/start-page.md)
          - [窗口属性](application-models/window-properties.md)
          - [申请授权](application-models/request-permissions.md)
          - [跳转规则](application-models/redirection-rules.md)
        - ServiceAbility组件开发指导
          - [ServiceAbility组件概述](application-models/serviceability-overview.md)
          - [ServiceAbility组件配置](application-models/serviceability-configuration.md)
          - [ServiceAbility的生命周期](application-models/serviceability-lifecycle.md)
          - [创建ServiceAbility](application-models/create-serviceability.md)
          - [启动ServiceAbility](application-models/start-serviceability.md)
          - [连接ServiceAbility](application-models/connect-serviceability.md)
        - DataAbility组件开发指导
          - [DataAbility组件概述](application-models/dataability-overview.md)
          - [DataAbility组件配置](application-models/dataability-configuration.md)
          - [DataAbility的生命周期](application-models/dataability-lifecycle.md)
          - [创建DataAbility](application-models/create-dataability.md)
          - [启动DataAbility](application-models/start-dataability.md)
          - [访问DataAbility](application-models/access-dataability.md)
          - [DataAbility权限控制](application-models/dataability-permission-control.md)
        - [服务卡片开发指导](application-models/widget-development-fa.md)
        - [FA模型的Context](application-models/application-context-fa.md)
        - [信息传递载体Want](application-models/want-fa.md)
      - 进程间通信
        - [进程模型](application-models/process-model-fa.md)
        - [公共事件](application-models/common-event-fa.md)
        - [后台服务](application-models/rpc.md)
      - 线程间通信
        - [线程模型](application-models/thread-model-fa.md)
        - [线程间通信](application-models/itc-fa-overview.md)
      - [任务管理](application-models/mission-management-fa.md)
    - FA模型与Stage模型应用组件互通指导
      - [FA模型与Stage模型应用组件互通综述](application-models/fa-stage-interaction-overview.md)
      - [FA模型启动Stage模型UIAbility](application-models/start-uiability-from-fa.md)
      - [FA模型绑定Stage模型ServiceExtensionAbility](application-models/bind-serviceextensionability-from-fa.md)
      - [FA模型访问Stage模型DataShareExtensionAbility](application-models/access-datashareextensionability-from-fa.md)
      - [Stage模型启动FA模型PageAbility](application-models/start-pageability-from-stage.md)
      - [Stage模型绑定FA模型ServiceAbility](application-models/bind-serviceability-from-stage.md)
    - FA模型切换Stage模型指导
      - [模型切换概述](application-models/model-switch-overview.md)
      - 配置文件切换
        - [配置文件的差异](application-models/configuration-file-diff.md)
        - [app和deviceConfig的切换](application-models/app-deviceconfig-switch.md)
        - [module的切换](application-models/module-switch.md)
      - 组件切换
        - [PageAbility切换](application-models/pageability-switch.md)
        - [ServiceAbility切换](application-models/serviceability-switch.md)
        - [DataAbility切换](application-models/dataability-switch.md)
      - [卡片切换](application-models/widget-switch.md)
      - API切换
        - [API切换概述](application-models/api-switch-overview.md)
        - [Context接口切换](application-models/context-switch.md)
        - [featureAbility接口切换](application-models/featureability-switch.md)
        - [particleAbility接口切换](application-models/particleability-switch.md)
        - [LifecycleForm接口切换](application-models/lifecycleform-switch.md)
        - [LifecycleApp接口切换](application-models/lifecycleapp-switch.md)
        - [LifecycleService接口切换](application-models/lifecycleservice-switch.md)
        - [LifecycleData接口切换](application-models/lifecycledata-switch.md)
        - [DataAbilityHelper接口切换](application-models/dataabilityhelper-switch.md)
        - [mediaLibrary接口切换](application-models/medialibrary-switch.md)
        - [request接口切换](application-models/request-switch.md)
        - [resourceManager接口切换](application-models/resourcemanager-switch.md)
        - [window接口切换](application-models/window-switch.md)
        - [Storage接口切换](application-models/storage-switch.md)
  - UI开发
    - [方舟开发框架（ArkUI）概述](ui/arkui-overview.md)
    - 基于ArkTS的声明式开发范式
      - [概述](ui/ui-ts-overview.md)
      - [声明式UI开发指导](ui/ui-ts-developing-intro.md)
      - 声明式UI开发实例
        - [创建简单视图](ui/ui-ts-creating-simple-page.md)
        - 构建完整实例
          - [构建食物数据模型](ui/ui-ts-building-data-model.md)
          - [构建食物列表List布局](ui/ui-ts-building-category-list-layout.md)
          - [构建食物分类Grid布局](ui/ui-ts-building-category-grid-layout.md)
          - [页面跳转与数据传递](ui/ui-ts-page-redirection-data-transmission.md)
        - 添加闪屏动画
          - [绘制图像](ui/ui-ts-drawing-feature.md)
          - [添加动画效果](ui/ui-ts-animation-feature.md)
      - [常用组件说明](ui/ui-ts-components-intro.md)
      - 常见布局开发指导
        - 自适应布局
          - [线性布局](ui/ui-ts-layout-linear.md)
          - [层叠布局](ui/ui-ts-layout-stack.md)
          - [弹性布局](ui/ui-ts-layout-flex.md)
          - [网格布局](ui/ui-ts-layout-grid.md)
        - 响应式布局
          - [栅格布局](ui/ui-ts-layout-grid-container-new.md)
          - [媒体查询](ui/ui-ts-layout-mediaquery.md)
      - [自定义组件的生命周期](ui/ui-ts-custom-component-lifecycle-callbacks.md)
      - [Web组件开发指导](ui/ui-ts-components-web.md)
      - [性能提升的推荐方法](ui/ui-ts-performance-improvement-recommendation.md)
    - 兼容JS的类Web开发范式
      - [概述](ui/ui-js-overview.md)
      - 框架说明
        - [文件组织](ui/js-framework-file.md)
        - [js标签配置](ui/js-framework-js-tag.md)
        - [app.js](ui/js-framework-js-file.md)
        - 语法
          - [HML语法参考](ui/js-framework-syntax-hml.md)
          - [CSS语法参考](ui/js-framework-syntax-css.md)
          - [JS语法参考](ui/js-framework-syntax-js.md)
        - [生命周期](ui/js-framework-lifecycle.md)
        - [资源限定与访问](ui/js-framework-resource-restriction.md)
        - [多语言支持](ui/js-framework-multiple-languages.md)
      - 构建用户界面
        - [组件介绍](ui/ui-js-building-ui-component.md)
        - 构建布局
          - [布局说明](ui/ui-js-building-ui-layout-intro.md)
          - [添加标题行和文本区域](ui/ui-js-building-ui-layout-text.md)
          - [添加图片区域](ui/ui-js-building-ui-layout-image.md)
          - [添加留言区域](ui/ui-js-building-ui-layout-comment.md)
          - [添加容器](ui/ui-js-building-ui-layout-external-container.md)
        - [添加交互](ui/ui-js-building-ui-interactions.md)
        - [动画](ui/ui-js-building-ui-animation.md)
        - [手势事件](ui/ui-js-building-ui-event.md)
        - [页面路由](ui/ui-js-building-ui-routes.md)
      - 常见组件开发指导
        - 容器组件
          - [List开发指导](ui/ui-js-components-list.md)
          - [Dialog开发指导](ui/ui-js-components-dialog.md)
          - [Form开发指导](ui/ui-js-components-form.md)
          - [Stepper开发指导](ui/ui-js-components-stepper.md)
          - [Tabs开发指导](ui/ui-js-component-tabs.md)
          - [Swiper开发指导](ui/ui-js-components-swiper.md)
        - 基础组件
          - [Text开发指导](ui/ui-js-components-text.md)
          - [Input开发指导](ui/ui-js-components-input.md)
          - [Button开发指导](ui/ui-js-components-button.md)
          - [Picker开发指导](ui/ui-js-components-picker.md)
          - [Image开发指导](ui/ui-js-components-images.md)
          - [Image-animator开发指导](ui/ui-js-components-image-animator.md)
          - [Rating开发指导](ui/ui-js-components-rating.md)
          - [Slider开发指导](ui/ui-js-components-slider.md)
          - [Chart开发指导](ui/ui-js-components-chart.md)
          - [Switch开发指导](ui/ui-js-components-switch.md)
          - [Toolbar开发指导](ui/ui-js-components-toolbar.md)
          - [Menu开发指导](ui/ui-js-components-menu.md)
          - [Marquee开发指导](ui/ui-js-components-marquee.md)
          - [Qrcode开发指导](ui/ui-js-components-qrcode.md)
          - [Search开发指导](ui/ui-js-components-search.md)
        - Canvas开发指导
          - [Canvas对象](ui/ui-js-components-canvas.md)
          - [CanvasRenderingContext2D对象](ui/ui-js-components-canvasrenderingcontext2d.md)
          - [Path2D对象](ui/ui-js-components-path2d.md)
          - [OffscreenCanvas对象](ui/ui-js-components-offscreencanvas.md)
        - [栅格布局](ui/ui-js-components-grid.md)
        - Svg开发指导
          - [基础知识](ui/ui-js-components-svg-overview.md)
          - [绘制图形](ui/ui-js-components-svg-graphics.md)
          - [绘制路径](ui/ui-js-components-svg-path.md)
          - [绘制文本](ui/ui-js-components-svg-text.md)
      - 动效开发指导
        - CSS动画
          - [属性样式动画](ui/ui-js-animate-attribute-style.md)
          - [transform样式动画](ui/ui-js-animate-transform.md)
          - [background-position样式动画](ui/ui-js-animate-background-position-style.md)
          - [svg动画](ui/ui-js-animate-svg.md)
        - JS动画
          - [组件动画](ui/ui-js-animate-component.md)
          - 插值器动画
            - [动画动效](ui/ui-js-animate-dynamic-effects.md)
            - [动画帧](ui/ui-js-animate-frame.md)
      - [自定义组件](ui/ui-js-custom-components.md)
  - 通知
    - [通知概述](notification/notification-overview.md)
    - [订阅通知（仅对系统应用开放）](notification/notification-subscription.md)
    - [使能通知开关](notification/notification-enable.md)
    - 发布通知
      - [发布基础类型通知](notification/text-notification.md)
      - [发布进度条类型通知](notification/progress-bar-notification.md)
      - [为通知添加行为意图](notification/notification-with-wantagent.md)
  - 窗口管理
    - [窗口开发概述](windowmanager/window-overview.md)
    - [管理应用窗口（Stage模型）](windowmanager/application-window-stage.md)
    - [管理应用窗口（FA模型）](windowmanager/application-window-fa.md)
    - [管理系统窗口（仅Stage模型支持）](windowmanager/system-window-stage.md)
  - WebGL
    - [WebGL开发概述](webgl/webgl-overview.md)
    - [WebGL开发指导](webgl/webgl-guidelines.md)
  - 媒体
    - 音频
      - [音频开发概述](media/audio-overview.md)
      - [音频播放开发指导](media/audio-playback.md)
      - [音频录制开发指导](media/audio-recorder.md)
      - [音频渲染开发指导](media/audio-renderer.md)
      - [音频流管理开发指导](media/audio-stream-manager.md)
      - [音频采集开发指导](media/audio-capturer.md)
      - [OpenSL ES播放开发指导](media/opensles-playback.md)
      - [OpenSL ES录音开发指导](media/opensles-capture.md)
      - [音频焦点模式开发指导](media/audio-interruptmode.md)
      - [音量管理开发指导](media/audio-volume-manager.md)
      - [路由、设备管理开发指导](media/audio-routing-manager.md)
    - 视频
      - [视频播放开发指导](media/video-playback.md)
      - [视频录制开发指导](media/video-recorder.md)
    - 媒体会话
      - [AVSession开发概述](media/avsession-overview.md)
      - [AVSession开发指导](media/avsession-guidelines.md)
    - 图片
      - [图片开发指导](media/image.md)
    - 相机
      - [相机开发指导](media/camera.md)
      - [分布式相机开发指导](media/remote-camera.md)
  - 安全
    - 访问控制
      - [访问控制开发概述](security/accesstoken-overview.md)
      - [访问控制授权申请指导](security/accesstoken-guidelines.md)
      - [访问控制权限校验指导](security/permission-verify-guidelines.md)
      - [权限定义列表](security/permission-list.md)
    - 用户认证
      - [用户认证开发概述](security/userauth-overview.md)
      - [用户认证开发指导](security/userauth-guidelines.md)
    - 密钥管理
      - [HUKS开发概述](security/huks-overview.md)
      - [HUKS开发指导](security/huks-guidelines.md)
    - 加密算法库框架
      - [加密算法库框架概述](security/cryptoFramework-overview.md)
      - [加密算法框架开发指导](security/cryptoFramework-guidelines.md)
    - Hap包签名工具
      - [Hap包签名工具概述](security/hapsigntool-overview.md)
      - [Hap包签名工具指导](security/hapsigntool-guidelines.md)
      - [HarmonyAppProvision配置文件](security/app-provision-structure.md)
  - 网络与连接
    - 网络管理
      - [网络管理开发概述](connectivity/net-mgmt-overview.md)
      - [HTTP数据请求](connectivity/http-request.md)
      - [WebSocket连接](connectivity/websocket-connection.md)
      - [Socket连接](connectivity/socket-connection.md)
    - IPC与RPC通信
      - [IPC与RPC通信概述](connectivity/ipc-rpc-overview.md)
      - [IPC与RPC通信开发指导](connectivity/ipc-rpc-development-guideline.md)
      - [远端状态订阅开发实例](connectivity/subscribe-remote-state.md)
  - 电话服务
    - [电话服务开发概述](telephony/telephony-overview.md)
    - [跳转拨号界面](telephony/jumping-to-the-dial-screen.md)
    - [获取当前蜂窝网络信号信息](telephony/cellular-network-signal-info.md)
  - 数据管理
    - 分布式数据服务
      - [分布式数据服务概述](database/database-mdds-overview.md)
      - [分布式数据服务开发指导](database/database-mdds-guidelines.md)
    - 关系型数据库
      - [关系型数据库概述](database/database-relational-overview.md)
      - [关系型数据库开发指导](database/database-relational-guidelines.md)
    - 首选项
      - [首选项概述](database/database-preference-overview.md)
      - [首选项开发指导](database/database-preference-guidelines.md)
    - 分布式数据对象
      - [分布式数据对象概述](database/database-distributedobject-overview.md)
      - [分布式数据对象开发指导](database/database-distributedobject-guidelines.md)
    - 数据共享
      - [数据共享概述](database/database-datashare-overview.md)
      - [数据共享开发指导](database/database-datashare-guidelines.md)
  - 文件管理
    - 媒体库管理
      - [媒体库开发概述](file-management/medialibrary-overview.md)
      - [媒体资源使用指导](file-management/medialibrary-resource-guidelines.md)
      - [文件路径使用指导](file-management/medialibrary-filepath-guidelines.md)
      - [相册资源使用指导](file-management/medialibrary-album-guidelines.md)
    - 文件访问框架
      - [用户公共文件访问框架概述](file-management/file-access-framework-overview.md)
  - 任务管理
    - 后台任务
      - [后台任务概述](task-management/background-task-overview.md)
      - [短时任务开发指导](task-management/transient-task-dev-guide.md)
      - [长时任务开发指导](task-management/continuous-task-dev-guide.md)
      - [延迟任务开发指导](task-management/work-scheduler-dev-guide.md)
      - [申请能效资源开发指导](task-management/efficiency-resources-apply-dev-guide.md)
    - 后台代理提醒
      - [后台代理提醒开发概述](task-management/reminder-agent-overview.md)
      - [后台代理提醒开发指导](task-management/reminder-agent-development.md)
  - 设备管理
    - USB服务
      - [USB服务开发概述](device/usb-overview.md)
      - [USB服务开发指导](device/usb-guidelines.md)
    - 位置
      - [位置开发概述](device/device-location-overview.md)
      - [获取设备的位置信息](device/device-location-info.md)
      - [（逆）地理编码转化](device/device-location-geocoding.md)
    - 传感器
      - [传感器开发概述](device/sensor-overview.md)
      - [传感器开发指导](device/sensor-guidelines.md)
    - 振动
      - [振动开发概述](device/vibrator-overview.md)
      - [振动开发指导](device/vibrator-guidelines.md)
    - 多模输入
      - [输入设备开发指导](device/inputdevice-guidelines.md)
      - [鼠标光标开发指导](device/pointerstyle-guidelines.md)
    - 升级服务
      - [示例服务器开发概述](device/sample-server-overview.md)
      - [示例服务器开发指导](device/sample-server-guidelines.md)
  - 设备使用信息统计
    - [设备使用信息统计概述](device-usage-statistics/device-usage-statistics-overview.md)
    - [设备使用信息统计开发指导](device-usage-statistics/device-usage-statistics-use-guide.md)
  - DFX
    - [应用事件打点开发指导](dfx/hiappevent-guidelines.md)
    - [性能打点跟踪开发指导](dfx/hitracemeter-guidelines.md)
    - [分布式跟踪开发指导](dfx/hitracechain-guidelines.md)
    - 错误管理
      - [错误管理开发指导](dfx/errormanager-guidelines.md)
      - [应用恢复开发指导](dfx/apprecovery-guidelines.md)
  - 国际化
    - [国际化开发概述](internationalization/international-overview.md)
    - [Intl开发指导](internationalization/intl-guidelines.md)
    - [I18n开发指导](internationalization/i18n-guidelines.md)
  - 应用测试
    - [自动化测试框架使用指导](application-test/arkxtest-guidelines.md)
    - [SmartPerf性能工具使用指导](application-test/smartperf-guidelines.md)
    - [wukong稳定性工具使用指导](application-test/wukong-guidelines.md)
  - 一次开发，多端部署
    - [前言](key-features/multi-device-app-dev/foreword.md)
    - [简介](key-features/multi-device-app-dev/introduction.md)
    - [从一个例子开始](key-features/multi-device-app-dev/start-with-a-example.md)
    - 应用UX设计
      - [设计原则和要点](key-features/multi-device-app-dev/design-principles.md)
      - 应用架构设计
        - [应用导航结构设计要求](key-features/multi-device-app-dev/navigation-design.md)
        - [应用页面结构设计](key-features/multi-device-app-dev/page-design.md)
      - 界面布局
        - [概述](key-features/multi-device-app-dev/interface-layout-design-intro.md)
        - 布局基础
          - [栅格系统](key-features/multi-device-app-dev/design-grid.md)
          - [自适应布局](key-features/multi-device-app-dev/design-adaptive-layout.md)
          - [响应式布局](key-features/multi-device-app-dev/design-responsive-layout.md)
        - [布局基础运用案例](key-features/multi-device-app-dev/design-layout-cases.md)
      - 人机交互
        - [交互基础](key-features/multi-device-app-dev/interaction-basics.md)
        - [常见输入方式](key-features/multi-device-app-dev/common-input-modes.md)
        - [交互事件归一](key-features/multi-device-app-dev/design-interaction-event-normalization.md)
      - 视觉风格
        - [视觉基础](key-features/multi-device-app-dev/visual-basics.md)
        - [色彩](key-features/multi-device-app-dev/visual-style-color.md)
        - [字体](key-features/multi-device-app-dev/visual-style-font.md)
        - [图标](key-features/multi-device-app-dev/visual-style-icon.md)
      - [多态控件](key-features/multi-device-app-dev/design-polymorphic-controls.md)
      - [设计自检表](key-features/multi-device-app-dev/design-checklist.md)
      - [设计交付](key-features/multi-device-app-dev/design-delivery.md)
      - [资源](key-features/multi-device-app-dev/design-resources.md)
    - [工程管理](key-features/multi-device-app-dev/ide-using.md)
    - 页面开发的一多能力介绍
      - [简介](key-features/multi-device-app-dev/page-development-intro.md)
      - 布局能力
        - [布局简介](key-features/multi-device-app-dev/layout-intro.md)
        - [自适应布局](key-features/multi-device-app-dev/adaptive-layout.md)
        - [响应式布局](key-features/multi-device-app-dev/responsive-layout.md)
        - [典型布局场景](key-features/multi-device-app-dev/typical-layout-scenario.md)
        - 典型页面场景
          - [应用市场首页](key-features/multi-device-app-dev/appgallery-home-page.md)
          - [音乐专辑页](key-features/multi-device-app-dev/music-album-page.md)
      - [交互归一](key-features/multi-device-app-dev/interaction-event-normalization.md)
      - [多态组件](key-features/multi-device-app-dev/polymorphic-controls.md)
      - [资源使用](key-features/multi-device-app-dev/resource-usage.md)
    - [功能开发的一多能力介绍](key-features/multi-device-app-dev/development-intro.md)
    - [案例应用](key-features/multi-device-app-dev/case.md)
    - [常见问题](key-features/multi-device-app-dev/faq.md)
  - [IDL工具规格及使用说明书](IDL/idl-guidelines.md)
  - Native API的相关指导
    - [Native API在应用工程中的使用指导](napi/napi-guidelines.md)
    - [Drawing开发指导](napi/drawing-guidelines.md)
    - [Rawfile开发指导](napi/rawfile-guidelines.md)
    - [Window开发指导](napi/native-window-guidelines.md)
    - [使用MindSpore Lite引擎进行模型推理](napi/mindspore-lite-guidelines.md)
    - [Neural Network Runtime对接AI推理框架开发指导](napi/neural-network-runtime-guidelines.md)
- 工具
  - [DevEco Studio（OpenHarmony）使用指南](quick-start/deveco-studio-user-guide-for-openharmony.md)
  - 调试工具
    - [aa工具](tools/aa-tool.md)
    - [bm工具](tools/bm-tool.md)
    - 打包拆包工具
      - [打包工具](tools/packing-tool.md)
      - [拆包工具](tools/unpacking-tool.md)
    - [anm工具](tools/anm-tool.md)
    - [cem工具](tools/cem-tool.md)
- 示例教程
  - [示例代码](https://gitee.com/openharmony/applications_app_samples/blob/master/README_zh.md)
  - [Codelabs](https://gitee.com/openharmony/codelabs/blob/master/README.md)
- API参考
  - [系统能力SystemCapability使用指南](reference/syscap.md)
  - [系统能力SystemCapability列表](reference/syscap-list.md)
  - 组件参考（基于ArkTS的声明式开发范式）
    - [组件导读](reference/arkui-ts/ts-components-summary.md)
    - 组件通用信息
      - 通用事件
        - [点击事件](reference/arkui-ts/ts-universal-events-click.md)
        - [触摸事件](reference/arkui-ts/ts-universal-events-touch.md)
        - [挂载卸载事件](reference/arkui-ts/ts-universal-events-show-hide.md)
        - [拖拽事件](reference/arkui-ts/ts-universal-events-drag-drop.md)
        - [按键事件](reference/arkui-ts/ts-universal-events-key.md)
        - [焦点事件](reference/arkui-ts/ts-universal-focus-event.md)
        - [鼠标事件](reference/arkui-ts/ts-universal-mouse-key.md)
        - [组件区域变化事件](reference/arkui-ts/ts-universal-component-area-change-event.md)
        - [组件可见区域变化事件](reference/arkui-ts/ts-universal-component-visible-area-change-event.md)
      - 通用属性
        - [尺寸设置](reference/arkui-ts/ts-universal-attributes-size.md)
        - [位置设置](reference/arkui-ts/ts-universal-attributes-location.md)
        - [布局约束](reference/arkui-ts/ts-universal-attributes-layout-constraints.md)
        - [Flex布局](reference/arkui-ts/ts-universal-attributes-flex-layout.md)
        - [边框设置](reference/arkui-ts/ts-universal-attributes-border.md)
        - [图片边框设置](reference/arkui-ts/ts-universal-attributes-border-image.md)
        - [背景设置](reference/arkui-ts/ts-universal-attributes-background.md)
        - [透明度设置](reference/arkui-ts/ts-universal-attributes-opacity.md)
        - [显隐控制](reference/arkui-ts/ts-universal-attributes-visibility.md)
        - [禁用控制](reference/arkui-ts/ts-universal-attributes-enable.md)
        - [浮层](reference/arkui-ts/ts-universal-attributes-overlay.md)
        - [Z序控制](reference/arkui-ts/ts-universal-attributes-z-order.md)
        - [图形变换](reference/arkui-ts/ts-universal-attributes-transformation.md)
        - [图像效果](reference/arkui-ts/ts-universal-attributes-image-effect.md)
        - [形状裁剪](reference/arkui-ts/ts-universal-attributes-sharp-clipping.md)
        - [文本样式设置](reference/arkui-ts/ts-universal-attributes-text-style.md)
        - [栅格设置](reference/arkui-ts/ts-universal-attributes-grid.md)
        - [颜色渐变](reference/arkui-ts/ts-universal-attributes-gradient-color.md)
        - [Popup控制](reference/arkui-ts/ts-universal-attributes-popup.md)
        - [Menu控制](reference/arkui-ts/ts-universal-attributes-menu.md)
        - [点击控制](reference/arkui-ts/ts-universal-attributes-click.md)
        - [焦点控制](reference/arkui-ts/ts-universal-attributes-focus.md)
        - [悬浮态效果](reference/arkui-ts/ts-universal-attributes-hover-effect.md)
        - [组件标识](reference/arkui-ts/ts-universal-attributes-component-id.md)
        - [触摸热区设置](reference/arkui-ts/ts-universal-attributes-touch-target.md)
        - [多态样式](reference/arkui-ts/ts-universal-attributes-polymorphic-style.md)
        - [触摸测试控制](reference/arkui-ts/ts-universal-attributes-hit-test-behavior.md)
        - [背景模糊设置](reference/arkui-ts/ts-universal-attributes-backgroundBlurStyle.md)
        - [分布式迁移标识](reference/arkui-ts/ts-universal-attributes-restoreId.md)
      - 手势处理
        - [绑定手势方法](reference/arkui-ts/ts-gesture-settings.md)
        - 基础手势
          - [TapGesture](reference/arkui-ts/ts-basic-gestures-tapgesture.md)
          - [LongPressGesture](reference/arkui-ts/ts-basic-gestures-longpressgesture.md)
          - [PanGesture](reference/arkui-ts/ts-basic-gestures-pangesture.md)
          - [PinchGesture](reference/arkui-ts/ts-basic-gestures-pinchgesture.md)
          - [RotationGesture](reference/arkui-ts/ts-basic-gestures-rotationgesture.md)
          - [SwipeGesture](reference/arkui-ts/ts-basic-gestures-swipegesture.md)
        - [组合手势](reference/arkui-ts/ts-combined-gestures.md)
    - 基础组件
      - [Blank](reference/arkui-ts/ts-basic-components-blank.md)
      - [Button](reference/arkui-ts/ts-basic-components-button.md)
      - [Checkbox](reference/arkui-ts/ts-basic-components-checkbox.md)
      - [CheckboxGroup](reference/arkui-ts/ts-basic-components-checkboxgroup.md)
      - [DataPanel](reference/arkui-ts/ts-basic-components-datapanel.md)
      - [DatePicker](reference/arkui-ts/ts-basic-components-datepicker.md)
      - [Divider](reference/arkui-ts/ts-basic-components-divider.md)
      - [Gauge](reference/arkui-ts/ts-basic-components-gauge.md)
      - [Image](reference/arkui-ts/ts-basic-components-image.md)
      - [ImageAnimator](reference/arkui-ts/ts-basic-components-imageanimator.md)
      - [LoadingProgress](reference/arkui-ts/ts-basic-components-loadingprogress.md)
      - [Marquee](reference/arkui-ts/ts-basic-components-marquee.md)
      - [Navigation](reference/arkui-ts/ts-basic-components-navigation.md)
      - [NavRouter](reference/arkui-ts/ts-basic-components-navrouter.md)
      - [NavDestination](reference/arkui-ts/ts-basic-components-navdestination.md)
      - [PatternLock](reference/arkui-ts/ts-basic-components-patternlock.md)
      - [PluginComponent](reference/arkui-ts/ts-basic-components-plugincomponent.md)
      - [Progress](reference/arkui-ts/ts-basic-components-progress.md)
      - [QRCode](reference/arkui-ts/ts-basic-components-qrcode.md)
      - [Radio](reference/arkui-ts/ts-basic-components-radio.md)
      - [Rating](reference/arkui-ts/ts-basic-components-rating.md)
      - [RemoteWindow](reference/arkui-ts/ts-basic-components-remotewindow.md)
      - [RichText](reference/arkui-ts/ts-basic-components-richtext.md)
      - [ScrollBar](reference/arkui-ts/ts-basic-components-scrollbar.md)
      - [Search](reference/arkui-ts/ts-basic-components-search.md)
      - [Select](reference/arkui-ts/ts-basic-components-select.md)
      - [Slider](reference/arkui-ts/ts-basic-components-slider.md)
      - [Span](reference/arkui-ts/ts-basic-components-span.md)
      - [Stepper](reference/arkui-ts/ts-basic-components-stepper.md)
      - [StepperItem](reference/arkui-ts/ts-basic-components-stepperitem.md)
      - [Text](reference/arkui-ts/ts-basic-components-text.md)
      - [TextArea](reference/arkui-ts/ts-basic-components-textarea.md)
      - [TextClock](reference/arkui-ts/ts-basic-components-textclock.md)
      - [TextInput](reference/arkui-ts/ts-basic-components-textinput.md)
      - [TextPicker](reference/arkui-ts/ts-basic-components-textpicker.md)
      - [TextTimer](reference/arkui-ts/ts-basic-components-texttimer.md)
      - [TimePicker](reference/arkui-ts/ts-basic-components-timepicker.md)
      - [Toggle](reference/arkui-ts/ts-basic-components-toggle.md)
      - [Web](reference/arkui-ts/ts-basic-components-web.md)
      - [XComponent](reference/arkui-ts/ts-basic-components-xcomponent.md)
    - 容器组件
      - [AbilityComponent](reference/arkui-ts/ts-container-ability-component.md)
      - [AlphabetIndexer](reference/arkui-ts/ts-container-alphabet-indexer.md)
      - [Badge](reference/arkui-ts/ts-container-badge.md)
      - [Column](reference/arkui-ts/ts-container-column.md)
      - [ColumnSplit](reference/arkui-ts/ts-container-columnsplit.md)
      - [Counter](reference/arkui-ts/ts-container-counter.md)
      - [Flex](reference/arkui-ts/ts-container-flex.md)
      - [FlowItem](reference/arkui-ts/ts-container-flowitem.md)
      - [GridCol](reference/arkui-ts/ts-container-gridcol.md)
      - [GridRow](reference/arkui-ts/ts-container-gridrow.md)
      - [Grid](reference/arkui-ts/ts-container-grid.md)
      - [GridItem](reference/arkui-ts/ts-container-griditem.md)
      - [List](reference/arkui-ts/ts-container-list.md)
      - [ListItem](reference/arkui-ts/ts-container-listitem.md)
      - [ListItemGroup](reference/arkui-ts/ts-container-listitemgroup.md)
      - [Navigator](reference/arkui-ts/ts-container-navigator.md)
      - [Panel](reference/arkui-ts/ts-container-panel.md)
      - [Refresh](reference/arkui-ts/ts-container-refresh.md)
      - [RelativeContainer](reference/arkui-ts/ts-container-relativecontainer.md)
      - [Row](reference/arkui-ts/ts-container-row.md)
      - [RowSplit](reference/arkui-ts/ts-container-rowsplit.md)
      - [Scroll](reference/arkui-ts/ts-container-scroll.md)
      - [SideBarContainer](reference/arkui-ts/ts-container-sidebarcontainer.md)
      - [Stack](reference/arkui-ts/ts-container-stack.md)
      - [Swiper](reference/arkui-ts/ts-container-swiper.md)
      - [Tabs](reference/arkui-ts/ts-container-tabs.md)
      - [TabContent](reference/arkui-ts/ts-container-tabcontent.md)
      - [WaterFlow](reference/arkui-ts/ts-container-waterflow.md)
    - 媒体组件
      - [Video](reference/arkui-ts/ts-media-components-video.md)
    - 绘制组件
      - [Circle](reference/arkui-ts/ts-drawing-components-circle.md)
      - [Ellipse](reference/arkui-ts/ts-drawing-components-ellipse.md)
      - [Line](reference/arkui-ts/ts-drawing-components-line.md)
      - [Polyline](reference/arkui-ts/ts-drawing-components-polyline.md)
      - [Polygon](reference/arkui-ts/ts-drawing-components-polygon.md)
      - [Path](reference/arkui-ts/ts-drawing-components-path.md)
      - [Rect](reference/arkui-ts/ts-drawing-components-rect.md)
      - [Shape](reference/arkui-ts/ts-drawing-components-shape.md)
    - 画布组件
      - [Canvas](reference/arkui-ts/ts-components-canvas-canvas.md)
      - [CanvasRenderingContext2D对象](reference/arkui-ts/ts-canvasrenderingcontext2d.md)
      - [CanvasGradient对象](reference/arkui-ts/ts-components-canvas-canvasgradient.md)
      - [ImageBitmap对象](reference/arkui-ts/ts-components-canvas-imagebitmap.md)
      - [ImageData对象](reference/arkui-ts/ts-components-canvas-imagedata.md)
      - [OffscreenCanvasRenderingContext2D对象](reference/arkui-ts/ts-offscreencanvasrenderingcontext2d.md)
      - [Path2D对象](reference/arkui-ts/ts-components-canvas-path2d.md)
      - [Lottie](reference/arkui-ts/ts-components-canvas-lottie.md)
    - 动画
      - [属性动画](reference/arkui-ts/ts-animatorproperty.md)
      - [显式动画](reference/arkui-ts/ts-explicit-animation.md)
      - 转场动画
        - [页面间转场](reference/arkui-ts/ts-page-transition-animation.md)
        - [组件内转场](reference/arkui-ts/ts-transition-animation-component.md)
        - [共享元素转场](reference/arkui-ts/ts-transition-animation-shared-elements.md)
      - [路径动画](reference/arkui-ts/ts-motion-path-animation.md)
    - 全局UI方法
      - 弹窗
        - [警告弹窗](reference/arkui-ts/ts-methods-alert-dialog-box.md)
        - [列表选择弹窗](reference/arkui-ts/ts-methods-action-sheet.md)
        - [自定义弹窗](reference/arkui-ts/ts-methods-custom-dialog-box.md)
        - [日期选择弹窗](reference/arkui-ts/ts-methods-datepicker-dialog.md)
        - [时间选择弹窗](reference/arkui-ts/ts-methods-timepicker-dialog.md)
        - [文本选择弹窗](reference/arkui-ts/ts-methods-textpicker-dialog.md)
      - [菜单](reference/arkui-ts/ts-methods-menu.md)
    - [应用级变量的状态管理](reference/arkui-ts/ts-state-management.md)
    - [像素单位](reference/arkui-ts/ts-pixel-units.md)
    - [枚举说明](reference/arkui-ts/ts-appendix-enums.md)
    - [类型说明](reference/arkui-ts/ts-types.md)
    - 已停止维护的组件
      - [GridContainer](reference/arkui-ts/ts-container-gridcontainer.md)
  - 组件参考（兼容JS的类Web开发范式）
    - 组件通用信息
      - [通用属性](reference/arkui-js/js-components-common-attributes.md)
      - [通用样式](reference/arkui-js/js-components-common-styles.md)
      - [通用事件](reference/arkui-js/js-components-common-events.md)
      - [通用方法](reference/arkui-js/js-components-common-methods.md)
      - [动画样式](reference/arkui-js/js-components-common-animation.md)
      - [渐变样式](reference/arkui-js/js-components-common-gradient.md)
      - [转场样式](reference/arkui-js/js-components-common-transition.md)
      - [媒体查询](reference/arkui-js/js-components-common-mediaquery.md)
      - [自定义字体样式](reference/arkui-js/js-components-common-customizing-font.md)
      - [原子布局](reference/arkui-js/js-components-common-atomic-layout.md)
    - 容器组件
      - [badge](reference/arkui-js/js-components-container-badge.md)
      - [dialog](reference/arkui-js/js-components-container-dialog.md)
      - [div](reference/arkui-js/js-components-container-div.md)
      - [form](reference/arkui-js/js-components-container-form.md)
      - [list](reference/arkui-js/js-components-container-list.md)
      - [list-item](reference/arkui-js/js-components-container-list-item.md)
      - [list-item-group](reference/arkui-js/js-components-container-list-item-group.md)
      - [panel](reference/arkui-js/js-components-container-panel.md)
      - [popup](reference/arkui-js/js-components-container-popup.md)
      - [refresh](reference/arkui-js/js-components-container-refresh.md)
      - [stack](reference/arkui-js/js-components-container-stack.md)
      - [stepper](reference/arkui-js/js-components-container-stepper.md)
      - [stepper-item](reference/arkui-js/js-components-container-stepper-item.md)
      - [swiper](reference/arkui-js/js-components-container-swiper.md)
      - [tabs](reference/arkui-js/js-components-container-tabs.md)
      - [tab-bar](reference/arkui-js/js-components-container-tab-bar.md)
      - [tab-content](reference/arkui-js/js-components-container-tab-content.md)
    - 基础组件
      - [button](reference/arkui-js/js-components-basic-button.md)
      - [chart](reference/arkui-js/js-components-basic-chart.md)
      - [divider](reference/arkui-js/js-components-basic-divider.md)
      - [image](reference/arkui-js/js-components-basic-image.md)
      - [image-animator](reference/arkui-js/js-components-basic-image-animator.md)
      - [input](reference/arkui-js/js-components-basic-input.md)
      - [label](reference/arkui-js/js-components-basic-label.md)
      - [marquee](reference/arkui-js/js-components-basic-marquee.md)
      - [menu](reference/arkui-js/js-components-basic-menu.md)
      - [option](reference/arkui-js/js-components-basic-option.md)
      - [picker](reference/arkui-js/js-components-basic-picker.md)
      - [picker-view](reference/arkui-js/js-components-basic-picker-view.md)
      - [piece](reference/arkui-js/js-components-basic-piece.md)
      - [progress](reference/arkui-js/js-components-basic-progress.md)
      - [qrcode](reference/arkui-js/js-components-basic-qrcode.md)
      - [rating](reference/arkui-js/js-components-basic-rating.md)
      - [richtext](reference/arkui-js/js-components-basic-richtext.md)
      - [search](reference/arkui-js/js-components-basic-search.md)
      - [select](reference/arkui-js/js-components-basic-select.md)
      - [slider](reference/arkui-js/js-components-basic-slider.md)
      - [span](reference/arkui-js/js-components-basic-span.md)
      - [switch](reference/arkui-js/js-components-basic-switch.md)
      - [text](reference/arkui-js/js-components-basic-text.md)
      - [textarea](reference/arkui-js/js-components-basic-textarea.md)
      - [toolbar](reference/arkui-js/js-components-basic-toolbar.md)
      - [toolbar-item](reference/arkui-js/js-components-basic-toolbar-item.md)
      - [toggle](reference/arkui-js/js-components-basic-toggle.md)
      - [web](reference/arkui-js/js-components-basic-web.md)
      - [xcomponent](reference/arkui-js/js-components-basic-xcomponent.md)
    - 媒体组件
      - [video](reference/arkui-js/js-components-media-video.md)
    - 画布组件
      - [canvas组件](reference/arkui-js/js-components-canvas-canvas.md)
      - [CanvasRenderingContext2D对象](reference/arkui-js/js-components-canvas-canvasrenderingcontext2d.md)
      - [Image对象](reference/arkui-js/js-components-canvas-image.md)
      - [CanvasGradient对象](reference/arkui-js/js-components-canvas-canvasgradient.md)
      - [ImageData对象](reference/arkui-js/js-components-canvas-imagedata.md)
      - [Path2D对象](reference/arkui-js/js-components-canvas-path2d.md)
      - [ImageBitmap对象](reference/arkui-js/js-components-canvas-imagebitmap.md)
      - [OffscreenCanvas对象](reference/arkui-js/js-components-canvas-offscreencanvas.md)
      - [OffscreenCanvasRenderingContext2D对象](reference/arkui-js/js-offscreencanvasrenderingcontext2d.md)
    - 栅格组件
      - [基本概念](reference/arkui-js/js-components-grid-basic-concepts.md)
      - [grid-container](reference/arkui-js/js-components-grid-container.md)
      - [grid-row](reference/arkui-js/js-components-grid-row.md)
      - [grid-col](reference/arkui-js/js-components-grid-col.md)
    - svg组件
      - [通用属性](reference/arkui-js/js-components-svg-common-attributes.md)
      - [svg](reference/arkui-js/js-components-svg.md)
      - [rect](reference/arkui-js/js-components-svg-rect.md)
      - [circle](reference/arkui-js/js-components-svg-circle.md)
      - [ellipse](reference/arkui-js/js-components-svg-ellipse.md)
      - [path](reference/arkui-js/js-components-svg-path.md)
      - [line](reference/arkui-js/js-components-svg-line.md)
      - [polyline](reference/arkui-js/js-components-svg-polyline.md)
      - [polygon](reference/arkui-js/js-components-svg-polygon.md)
      - [text](reference/arkui-js/js-components-svg-text.md)
      - [tspan](reference/arkui-js/js-components-svg-tspan.md)
      - [textPath](reference/arkui-js/js-components-svg-textpath.md)
      - [animate](reference/arkui-js/js-components-svg-animate.md)
      - [animateMotion](reference/arkui-js/js-components-svg-animatemotion.md)
      - [animateTransform](reference/arkui-js/js-components-svg-animatetransform.md)
    - 自定义组件
      - [基本用法](reference/arkui-js/js-components-custom-basic-usage.md)
      - [数据传递与处理](reference/arkui-js/js-components-custom-props.md)
      - [继承样式](reference/arkui-js/js-components-custom-style.md)
      - [slot插槽](reference/arkui-js/js-components-custom-slot.md)
      - [生命周期定义](reference/arkui-js/js-components-custom-lifecycle.md)
    - [动态创建组件](reference/arkui-js/js-components-create-elements.md)
    - [数据类型说明](reference/arkui-js/js-appendix-types.md)
  - JS服务卡片UI组件参考
    - JS服务卡片UI框架说明
      - [文件组织](reference/js-service-widget-ui/js-service-widget-file.md)
      - 语法
        - [HML语法参考](reference/js-service-widget-ui/js-service-widget-syntax-hml.md)
        - [CSS语法参考](reference/js-service-widget-ui/js-service-widget-syntax-css.md)
      - [多语言支持](reference/js-service-widget-ui/js-service-widget-multiple-languages.md)
      - [版本兼容适配](reference/js-service-widget-ui/js-service-widget-version-compatibility.md)
      - [设置主题样式](reference/js-service-widget-ui/js-service-widget-theme.md)
    - 组件
      - 通用
        - [通用属性](reference/js-service-widget-ui/js-service-widget-common-attributes.md)
        - [通用样式](reference/js-service-widget-ui/js-service-widget-common-styles.md)
        - [通用事件](reference/js-service-widget-ui/js-service-widget-common-events.md)
        - [渐变样式](reference/js-service-widget-ui/js-service-widget-common-gradient.md)
        - [媒体查询](reference/js-service-widget-ui/js-service-widget-common-mediaquery.md)
        - [自定义字体样式](reference/js-service-widget-ui/js-service-widget-common-customizing-font.md)
        - [无障碍](reference/js-service-widget-ui/js-service-widget-common-accessibility.md)
        - [原子布局](reference/js-service-widget-ui/js-service-widget-common-atomic-layout.md)
      - 容器组件
        - [badge](reference/js-service-widget-ui/js-service-widget-container-badge.md)
        - [div](reference/js-service-widget-ui/js-service-widget-container-div.md)
        - [list](reference/js-service-widget-ui/js-service-widget-container-list.md)
        - [list-item](reference/js-service-widget-ui/js-service-widget-container-list-item.md)
        - [stack](reference/js-service-widget-ui/js-service-widget-container-stack.md)
        - [swiper](reference/js-service-widget-ui/js-service-widget-container-swiper.md)
      - 基础组件
        - [button](reference/js-service-widget-ui/js-service-widget-basic-button.md)
        - [calendar](reference/js-service-widget-ui/js-service-widget-basic-calendar.md)
        - [chart](reference/js-service-widget-ui/js-service-widget-basic-chart.md)
        - [clock](reference/js-service-widget-ui/js-service-widget-basic-clock.md)
        - [divider](reference/js-service-widget-ui/js-service-widget-basic-divider.md)
        - [image](reference/js-service-widget-ui/js-service-widget-basic-image.md)
        - [input](reference/js-service-widget-ui/js-service-widget-basic-input.md)
        - [progress](reference/js-service-widget-ui/js-service-widget-basic-progress.md)
        - [span](reference/js-service-widget-ui/js-service-widget-basic-span.md)
        - [text](reference/js-service-widget-ui/js-service-widget-basic-text.md)
    - [自定义组件使用说明](reference/js-service-widget-ui/js-service-widget-custom-basic-usage.md)
    - [数据类型说明](reference/js-service-widget-ui/js-service-widget-appendix-types.md)
  - 接口参考（ArkTS及JS API）
    - [开发说明](reference/apis/development-intro.md)
    - Ability框架
      - Stage模型能力的接口（推荐）
        - [@ohos.app.ability.Ability (Ability基类)](reference/apis/js-apis-app-ability-ability.md)
        - [@ohos.app.ability.AbilityConstant (AbilityConstant)](reference/apis/js-apis-app-ability-abilityConstant.md)
        - [@ohos.app.ability.abilityLifecycleCallback (AbilityLifecycleCallback)](reference/apis/js-apis-app-ability-abilityLifecycleCallback.md)
        - [@ohos.app.ability.AbilityStage (AbilityStage)](reference/apis/js-apis-app-ability-abilityStage.md)
        - [@ohos.app.ability.common (应用上下文Context)](reference/apis/js-apis-app-ability-common.md)
        - [@ohos.app.ability.contextConstant (ContextConstant)](reference/apis/js-apis-app-ability-contextConstant.md)
        - [@ohos.app.ability.EnvironmentCallback (EnvironmentCallback)](reference/apis/js-apis-app-ability-environmentCallback.md)
        - [@ohos.app.ability.ExtensionAbility (扩展能力基类)](reference/apis/js-apis-app-ability-extensionAbility.md)
        - [@ohos.app.ability.ServiceExtensionAbility (ServiceExtensionAbility)](reference/apis/js-apis-app-ability-serviceExtensionAbility.md)
        - [@ohos.app.ability.StartOptions (StartOptions)](reference/apis/js-apis-app-ability-startOptions.md)
        - [@ohos.app.ability.UIAbility (UIAbility)](reference/apis/js-apis-app-ability-uiAbility.md)
        - [@ohos.app.form.FormExtensionAbility (FormExtensionAbility)](reference/apis/js-apis-app-form-formExtensionAbility.md)
      - Stage模型能力的接口（待停用）
        - [@ohos.application.Ability (Ability)](reference/apis/js-apis-application-ability.md)
        - [@ohos.application.AbilityConstant (AbilityConstant)](reference/apis/js-apis-application-abilityConstant.md)
        - [@ohos.application.AbilityLifecycleCallback (AbilityLifecycleCallback)](reference/apis/js-apis-application-abilityLifecycleCallback.md)
        - [@ohos.application.AbilityStage (AbilityStage)](reference/apis/js-apis-application-abilityStage.md)
        - [@ohos.application.context (Context)](reference/apis/js-apis-application-context.md)
        - [@ohos.application.DataShareExtensionAbility (数据共享扩展能力)](reference/apis/js-apis-application-dataShareExtensionAbility.md)
        - [@ohos.application.EnvironmentCallback (EnvironmentCallback)](reference/apis/js-apis-application-environmentCallback.md)
        - [@ohos.application.ExtensionAbility (ExtensionAbility)](reference/apis/js-apis-application-extensionAbility.md)
        - [@ohos.application.FormExtension (FormExtension)](reference/apis/js-apis-application-formExtension.md)
        - [@ohos.application.ServiceExtensionAbility (ServiceExtensionAbility)](reference/apis/js-apis-application-serviceExtensionAbility.md)
        - [@ohos.application.StartOptions (StartOptions)](reference/apis/js-apis-application-startOptions.md)
        - [@ohos.application.StaticSubscriberExtensionAbility (StaticSubscriberExtensionAbility)](reference/apis/js-apis-application-staticSubscriberExtensionAbility.md)
      - FA模型能力的接口
        - [@ohos.ability.ability (Ability)](reference/apis/js-apis-ability-ability.md)
        - [@ohos.ability.featureAbility (FeatureAbility模块)](reference/apis/js-apis-ability-featureAbility.md)
        - [@ohos.ability.particleAbility (ParticleAbility模块)](reference/apis/js-apis-ability-particleAbility.md)
      - 通用能力的接口（推荐）
        - [@ohos.app.ability.abilityDelegatorRegistry (AbilityDelegatorRegistry)](reference/apis/js-apis-app-ability-abilityDelegatorRegistry.md)
        - [@ohos.app.ability.abilityManager (AbilityManager)](reference/apis/js-apis-app-ability-abilityManager.md)
        - [@ohos.app.ability.appManager (appManager)](reference/apis/js-apis-app-ability-appManager.md)
        - [@ohos.app.ability.appRecovery (appRecovery)](reference/apis/js-apis-app-ability-appRecovery.md)
        - [@ohos.app.ability.Configuration (Configuration)](reference/apis/js-apis-app-ability-configuration.md)
        - [@ohos.app.ability.ConfigurationConstant (ConfigurationConstant)](reference/apis/js-apis-app-ability-configurationConstant.md)
        - [@ohos.app.ability.dataUriUtils (DataUriUtils模块)](reference/apis/js-apis-app-ability-dataUriUtils.md)
        - [@ohos.app.ability.errorManager (ErrorManager)](reference/apis/js-apis-app-ability-errorManager.md)
        - [@ohos.app.ability.missionManager (missionManager)](reference/apis/js-apis-app-ability-missionManager.md)
        - [@ohos.app.ability.quickFixManager (quickFixManager)](reference/apis/js-apis-app-ability-quickFixManager.md)
        - [@ohos.app.ability.Want (Want)](reference/apis/js-apis-app-ability-want.md)
        - [@ohos.app.ability.wantAgent (WantAgent模块)](reference/apis/js-apis-app-ability-wantAgent.md)
        - [@ohos.app.ability.wantConstant (wantConstant)](reference/apis/js-apis-app-ability-wantConstant.md)
        - [@ohos.app.form.formBindingData (卡片数据绑定类)](reference/apis/js-apis-app-form-formBindingData.md)
        - [@ohos.app.form.formHost (FormHost)](reference/apis/js-apis-app-form-formHost.md)
        - [@ohos.app.form.formInfo (FormInfo)](reference/apis/js-apis-app-form-formInfo.md)
        - [@ohos.app.form.formProvider (FormProvider)](reference/apis/js-apis-app-form-formProvider.md)
      - 通用能力的接口（待停用）
        - [@ohos.ability.dataUriUtils (DataUriUtils模块)](reference/apis/js-apis-ability-dataUriUtils.md)
        - [@ohos.ability.errorCode (ErrorCode)](reference/apis/js-apis-ability-errorCode.md)
        - [@ohos.ability.wantConstant (wantConstant)](reference/apis/js-apis-ability-wantConstant.md)
        - [@ohos.application.abilityDelegatorRegistry (AbilityDelegatorRegistry)](reference/apis/js-apis-application-abilityDelegatorRegistry.md)
        - [@ohos.application.abilityManager (AbilityManager)](reference/apis/js-apis-application-abilityManager.md)
        - [@ohos.application.appManager (appManager)](reference/apis/js-apis-application-appManager.md)
        - [@ohos.application.Configuration (Configuration)](reference/apis/js-apis-application-configuration.md)
        - [@ohos.application.ConfigurationConstant (ConfigurationConstant)](reference/apis/js-apis-application-configurationConstant.md)
        - [@ohos.application.errorManager (ErrorManager)](reference/apis/js-apis-application-errorManager.md)
        - [@ohos.application.formBindingData (卡片数据绑定类)](reference/apis/js-apis-application-formBindingData.md)
        - [@ohos.application.formError (FormError)](reference/apis/js-apis-application-formError.md)
        - [@ohos.application.formHost (FormHost)](reference/apis/js-apis-application-formHost.md)
        - [@ohos.application.formInfo (FormInfo)](reference/apis/js-apis-application-formInfo.md)
        - [@ohos.application.formProvider (FormProvider)](reference/apis/js-apis-application-formProvider.md)
        - [@ohos.application.missionManager (missionManager)](reference/apis/js-apis-application-missionManager.md)
        - [@ohos.application.Want (Want)](reference/apis/js-apis-application-want.md)
        - [@ohos.wantAgent (WantAgent模块)](reference/apis/js-apis-wantAgent.md)
      - 接口依赖的元素及定义
        - ability
          - [abilityResult](reference/apis/js-apis-inner-ability-abilityResult.md)
          - [connectOptions](reference/apis/js-apis-inner-ability-connectOptions.md)
          - [dataAbilityHelper](reference/apis/js-apis-inner-ability-dataAbilityHelper.md)
          - [dataAbilityOperation](reference/apis/js-apis-inner-ability-dataAbilityOperation.md)
          - [dataAbilityResult](reference/apis/js-apis-inner-ability-dataAbilityResult.md)
          - [startAbilityParameter](reference/apis/js-apis-inner-ability-startAbilityParameter.md)
          - [want](reference/apis/js-apis-inner-ability-want.md)
        - app
          - [appVersionInfo](reference/apis/js-apis-inner-app-appVersionInfo.md)
          - [context](reference/apis/js-apis-inner-app-context.md)
          - [processInfo](reference/apis/js-apis-inner-app-processInfo.md)
        - application
          - [AbilityContext](reference/apis/js-apis-ability-context.md)
          - [abilityDelegator](reference/apis/js-apis-inner-application-abilityDelegator.md)
          - [abilityDelegatorArgs](reference/apis/js-apis-inner-application-abilityDelegatorArgs.md)
          - [abilityMonitor](reference/apis/js-apis-inner-application-abilityMonitor.md)
          - [AbilityRunningInfo](reference/apis/js-apis-inner-application-abilityRunningInfo.md)
          - [AbilityStageContext](reference/apis/js-apis-inner-application-abilityStageContext.md)
          - [AbilityStateData](reference/apis/js-apis-inner-application-abilityStateData.md)
          - [abilityStageMonitor](reference/apis/js-apis-inner-application-abilityStageMonitor.md)
          - [ApplicationContext](reference/apis/js-apis-inner-application-applicationContext.md)
          - [ApplicationStateObserver](reference/apis/js-apis-inner-application-applicationStateObserver.md)
          - [AppStateData](reference/apis/js-apis-inner-application-appStateData.md)
          - [BaseContext](reference/apis/js-apis-inner-application-baseContext.md)
          - [Context](reference/apis/js-apis-inner-application-context.md)
          - [ContinueCallback](reference/apis/js-apis-inner-application-continueCallback.md)
          - [ContinueDeviceInfo](reference/apis/js-apis-inner-application-continueDeviceInfo.md)
          - [ErrorObserver](reference/apis/js-apis-inner-application-errorObserver.md)
          - [ExtensionContext](reference/apis/js-apis-inner-application-extensionContext.md)
          - [ExtensionRunningInfo](reference/apis/js-apis-inner-application-extensionRunningInfo.md)
          - [FormExtensionContext](reference/apis/js-apis-inner-application-formExtensionContext.md)
          - [MissionCallbacks](reference/apis/js-apis-inner-application-missionCallbacks.md)
          - [MissionDeviceInfo](reference/apis/js-apis-inner-application-missionDeviceInfo.md)
          - [MissionInfo](reference/apis/js-apis-inner-application-missionInfo.md)
          - [MissionListener](reference/apis/js-apis-inner-application-missionListener.md)
          - [MissionParameter](reference/apis/js-apis-inner-application-missionParameter.md)
          - [MissionSnapshot](reference/apis/js-apis-inner-application-missionSnapshot.md)
          - [PermissionRequestResult](reference/apis/js-apis-inner-application-permissionRequestResult.md)
          - [ProcessData](reference/apis/js-apis-inner-application-processData.md)
          - [ProcessRunningInfo](reference/apis/js-apis-inner-application-processRunningInfo.md)
          - [ProcessRunningInformation](reference/apis/js-apis-inner-application-processRunningInformation.md)
          - [ServiceExtensionContext](reference/apis/js-apis-inner-application-serviceExtensionContext.md)
          - [UIAbilityContext](reference/apis/js-apis-inner-application-uiAbilityContext.md)
          - [shellCmdResult](reference/apis/js-apis-inner-application-shellCmdResult.md)
        - wantAgent
          - [triggerInfo](reference/apis/js-apis-inner-wantAgent-triggerInfo.md)
          - [wantAgentInfo](reference/apis/js-apis-inner-wantAgent-wantAgentInfo.md)
      - 流转
        - [@ohos.continuation.continuationManager (continuationManager)](reference/apis/js-apis-continuation-continuationManager.md)
        - continuation
          - [continuationExtraParams](reference/apis/js-apis-continuation-continuationExtraParams.md)
          - [continuationResult](reference/apis/js-apis-continuation-continuationResult.md)
    - 公共事件与通知
      - [@ohos.commonEventManager (公共事件模块)](reference/apis/js-apis-commonEventManager.md)
      - [@ohos.events.emitter (Emitter)](reference/apis/js-apis-emitter.md)
      - [@ohos.notificationManager (NotificationManager模块)(推荐)](reference/apis/js-apis-notificationManager.md)
      - [@ohos.notificationSubscribe (NotificationSubscribe模块)(推荐)](reference/apis/js-apis-notificationSubscribe.md)
      - [@ohos.commonEvent (公共事件模块)(待停用)](reference/apis/js-apis-commonEvent.md)
      - [@ohos.notification (Notification模块)(待停用)](reference/apis/js-apis-notification.md)
      - application
        - [EventHub](reference/apis/js-apis-inner-application-eventHub.md)
    - 包管理
      - [@ohos.bundle.appControl(appControl模块)](reference/apis/js-apis-appControl.md)
      - [@ohos.bundle.bundleManager (bundleManager模块)](reference/apis/js-apis-bundleManager.md)
      - [@ohos.bundle.bundleMonitor (bundleMonitor模块)](reference/apis/js-apis-bundleMonitor.md)
      - [@ohos.bundle.defaultAppManager (默认应用管理)](reference/apis/js-apis-defaultAppManager.md)
      - [@ohos.bundle.distributedBundle (distributedBundle模块)](reference/apis/js-apis-distributedBundle.md)
      - [@ohos.bundle.freeInstall (freeInstall模块)](reference/apis/js-apis-freeInstall.md)
      - [@ohos.bundle.installer (installer模块)](reference/apis/js-apis-installer.md)
      - [@ohos.bundle.launcherBundleManager (launcherBundleManager模块)](reference/apis/js-apis-launcherBundleManager.md)
      - [@ohos.zlib (Zip模块)](reference/apis/js-apis-zlib.md)
      - bundleManager
        - [abilityInfo](reference/apis/js-apis-bundleManager-abilityInfo.md)
        - [applicationInfo](reference/apis/js-apis-bundleManager-applicationInfo.md)
        - [bundleInfo](reference/apis/js-apis-bundleManager-bundleInfo.md)
        - [dispatchInfo](reference/apis/js-apis-bundleManager-dispatchInfo.md)
        - [elementName](reference/apis/js-apis-bundleManager-elementName.md)
        - [extensionAbilityInfo](reference/apis/js-apis-bundleManager-extensionAbilityInfo.md)
        - [hapModuleInfo](reference/apis/js-apis-bundleManager-hapModuleInfo.md)
        - [launcherAbilityInfo](reference/apis/js-apis-bundleManager-launcherAbilityInfo.md)
        - [metadata](reference/apis/js-apis-bundleManager-metadata.md)
        - [packInfo](reference/apis/js-apis-bundleManager-packInfo.md)
        - [permissionDef](reference/apis/js-apis-bundleManager-permissionDef.md)
        - [remoteAbilityInfo](reference/apis/js-apis-bundleManager-remoteAbilityInfo.md)
        - [shortcutInfo](reference/apis/js-apis-bundleManager-shortcutInfo.md)
    - UI界面
      - [@ohos.animator (动画)](reference/apis/js-apis-animator.md)
      - [@ohos.curves (插值计算)](reference/apis/js-apis-curve.md)
      - [@ohos.matrix4 (矩阵变换)](reference/apis/js-apis-matrix4.md)
      - [@ohos.mediaquery (媒体查询)](reference/apis/js-apis-mediaquery.md)
      - [@ohos.promptAction (弹窗)](reference/apis/js-apis-promptAction.md)
      - [@ohos.router (页面路由)](reference/apis/js-apis-router.md)
    - 图形图像
      - [@ohos.animation.windowAnimationManager (窗口动画管理)](reference/apis/js-apis-windowAnimationManager.md)
      - [@ohos.application.WindowExtensionAbility (窗口扩展能力)](reference/apis/js-apis-application-windowExtensionAbility.md)
      - [@ohos.display (屏幕属性)](reference/apis/js-apis-display.md)
      - [@ohos.effectKit (图像效果)](reference/apis/js-apis-effectKit.md)
      - [@ohos.graphics.colorSpaceManager (色彩管理)](reference/apis/js-apis-colorSpaceManager.md)
      - [@ohos.screen (屏幕)](reference/apis/js-apis-screen.md)
      - [@ohos.screenshot (屏幕截图)](reference/apis/js-apis-screenshot.md)
      - [@ohos.window (窗口)](reference/apis/js-apis-window.md)
      - webgl
        - [webgl (WebGL)](reference/apis/js-apis-webgl.md)
        - [webgl2 (WebGL2)](reference/apis/js-apis-webgl2.md)
    - 媒体
      - [@ohos.multimedia.audio (音频管理)](reference/apis/js-apis-audio.md)
      - [@ohos.multimedia.avsession (媒体会话管理)](reference/apis/js-apis-avsession.md)
      - [@ohos.multimedia.camera (相机管理)](reference/apis/js-apis-camera.md)
      - [@ohos.multimedia.image (图片处理)](reference/apis/js-apis-image.md)
      - [@ohos.multimedia.media (媒体服务)](reference/apis/js-apis-media.md)
    - 资源管理
      - [@ohos.i18n (国际化-I18n)](reference/apis/js-apis-i18n.md)
      - [@ohos.intl (国际化-Intl)](reference/apis/js-apis-intl.md)
      - [@ohos.resourceManager (资源管理)](reference/apis/js-apis-resource-manager.md)
    - 资源调度
      - [@ohos.distributedMissionManager (分布式任务管理)](reference/apis/js-apis-distributedMissionManager.md)
      - [@ohos.reminderAgentManager (后台代理提醒)](reference/apis/js-apis-reminderAgentManager.md)
      - [@ohos.resourceschedule.backgroundTaskManager (后台任务管理)](reference/apis/js-apis-resourceschedule-backgroundTaskManager.md)
      - [@ohos.resourceschedule.workScheduler (延迟任务调度)](reference/apis/js-apis-resourceschedule-workScheduler.md)
      - [@ohos.resourceschedule.usageStatistics (设备使用信息统计)](reference/apis/js-apis-resourceschedule-deviceUsageStatistics.md)
      - [@ohos.WorkSchedulerExtensionAbility (延迟任务调度回调)](reference/apis/js-apis-WorkSchedulerExtensionAbility.md)
    - 安全
      - [@ohos.abilityAccessCtrl (程序访问控制管理)](reference/apis/js-apis-abilityAccessCtrl.md)
      - [@ohos.privacyManager (隐私管理)](reference/apis/js-apis-privacyManager.md)
      - [@ohos.security.cryptoFramework (加解密算法库框架)](reference/apis/js-apis-cryptoFramework.md)
      - [@ohos.security.huks (通用密钥库系统)](reference/apis/js-apis-huks.md)
      - [@ohos.userIAM.faceAuth (人脸认证)](reference/apis/js-apis-useriam-faceauth.md)
      - [@ohos.userIAM.userAuth (用户认证)](reference/apis/js-apis-useriam-userauth.md)
      - [@system.cipher (加密算法)](reference/apis/js-apis-system-cipher.md)
    - 数据管理
      - [@ohos.data.dataAbility (DataAbility谓词)](reference/apis/js-apis-data-ability.md)
      - [@ohos.data.dataShare (数据共享)](reference/apis/js-apis-data-dataShare.md)
      - [@ohos.data.dataSharePredicates (数据共享谓词)](reference/apis/js-apis-data-dataSharePredicates.md)
      - [@ohos.data.dataShareResultSet (数据共享结果集)](reference/apis/js-apis-data-DataShareResultSet.md)
      - [@ohos.data.distributedDataObject (分布式数据对象)](reference/apis/js-apis-data-distributedobject.md)
      - [@ohos.data.distributedKVStore (分布式键值数据库)](reference/apis/js-apis-distributedKVStore.md)
      - [@ohos.data.preferences (首选项)](reference/apis/js-apis-data-preferences.md)
      - [@ohos.data.rdb (关系型数据库)](reference/apis/js-apis-data-rdb.md)
      - [@ohos.data.ValuesBucket (数据集)](reference/apis/js-apis-data-valuesBucket.md)
      - data/rdb
        - [resultSet (结果集)](reference/apis/js-apis-data-resultset.md)
    - 文件管理
      - [@ohos.environment (目录环境能力)](reference/apis/js-apis-environment.md)
      - [@ohos.data.fileAccess (公共文件访问与管理)](reference/apis/js-apis-fileAccess.md)
      - [@ohos.fileExtensionInfo (公共文件访问与管理属性信息)](reference/apis/js-apis-fileExtensionInfo.md)
      - [@ohos.fileio (文件管理)](reference/apis/js-apis-fileio.md)
      - [@ohos.filemanagement.userFileManager (用户数据管理)](reference/apis/js-apis-userFileManager.md)
      - [@ohos.multimedia.medialibrary (媒体库管理)](reference/apis/js-apis-medialibrary.md)
      - [@ohos.securityLabel (数据标签)](reference/apis/js-apis-securityLabel.md)
      - [@ohos.statfs (statfs)](reference/apis/js-apis-statfs.md)
      - [@ohos.storageStatistics (应用空间统计)](reference/apis/js-apis-storage-statistics.md)
      - [@ohos.volumeManager (卷管理)](reference/apis/js-apis-volumemanager.md)
    - 电话服务
      - [@ohos.contact (联系人)](reference/apis/js-apis-contact.md)
      - [@ohos.telephony.call (拨打电话)](reference/apis/js-apis-call.md)
      - [@ohos.telephony.data (蜂窝数据)](reference/apis/js-apis-telephony-data.md)
      - [@ohos.telephony.observer (observer)](reference/apis/js-apis-observer.md)
      - [@ohos.telephony.radio (网络搜索)](reference/apis/js-apis-radio.md)
      - [@ohos.telephony.sim (SIM卡管理)](reference/apis/js-apis-sim.md)
      - [@ohos.telephony.sms (短信服务)](reference/apis/js-apis-sms.md)
    - 网络管理
      - [@ohos.net.connection (网络连接管理)](reference/apis/js-apis-net-connection.md)
      - [@ohos.net.ethernet (以太网连接管理)](reference/apis/js-apis-net-ethernet.md)
      - [@ohos.net.http (数据请求)](reference/apis/js-apis-http.md)
      - [@ohos.net.sharing (网络共享管理)](reference/apis/js-apis-net-sharing.md)
      - [@ohos.net.socket (Socket连接)](reference/apis/js-apis-socket.md)
      - [@ohos.net.webSocket (WebSocket连接)](reference/apis/js-apis-webSocket.md)
      - [@ohos.request (上传下载)](reference/apis/js-apis-request.md)
    - 通信与连接
      - [@ohos.bluetooth (蓝牙)](reference/apis/js-apis-bluetooth.md)
      - [@ohos.connectedTag (有源标签)](reference/apis/js-apis-connectedTag.md)
      - [@ohos.nfc.cardEmulation (标准NFC-cardEmulation)](reference/apis/js-apis-cardEmulation.md)
      - [@ohos.nfc.controller (标准NFC)](reference/apis/js-apis-nfcController.md)
      - [@ohos.nfc.tag (标准NFC-Tag)](reference/apis/js-apis-nfcTag.md)
      - [@ohos.rpc (RPC通信)](reference/apis/js-apis-rpc.md)
      - [@ohos.wifiManager (WLAN)(推荐)](reference/apis/js-apis-wifiManager.md)
      - [@ohos.wifiManagerExt (WLAN扩展接口)(推荐)](reference/apis/js-apis-wifiManagerExt.md)
      - [@ohos.wifi (WLAN)(待停用)](reference/apis/js-apis-wifi.md)
      - [@ohos.wifiext (WLAN扩展接口)(待停用)](reference/apis/js-apis-wifiext.md)
      - tag
        - [nfctech (标准NFC-Tag Nfc 技术)](reference/apis/js-apis-nfctech.md)
        - [tagSession (标准NFC-Tag TagSession)](reference/apis/js-apis-tagSession.md)
    - 系统基础能力
      - [@ohos.accessibility (辅助功能)](reference/apis/js-apis-accessibility.md)
      - [@ohos.accessibility.config (系统辅助功能配置)](reference/apis/js-apis-accessibility-config.md)
      - [@ohos.accessibility.GesturePath (手势路径)](reference/apis/js-apis-accessibility-GesturePath.md)
      - [@ohos.accessibility.GesturePoint (手势触摸点)](reference/apis/js-apis-accessibility-GesturePoint.md)
      - [@ohos.application.AccessibilityExtensionAbility (辅助功能扩展能力)](reference/apis/js-apis-application-accessibilityExtensionAbility.md)
      - [@ohos.faultLogger (故障日志获取)](reference/apis/js-apis-faultLogger.md)
      - [@ohos.hichecker (检测模式)](reference/apis/js-apis-hichecker.md)
      - [@ohos.hidebug (Debug调试)](reference/apis/js-apis-hidebug.md)
      - [@ohos.hilog (HiLog日志打印)](reference/apis/js-apis-hilog.md)
      - [@ohos.hiSysEvent (系统事件打点)](reference/apis/js-apis-hisysevent.md)
      - [@ohos.hiTraceChain (分布式跟踪)](reference/apis/js-apis-hitracechain.md)
      - [@ohos.hiTraceMeter (性能打点)](reference/apis/js-apis-hitracemeter.md)
      - [@ohos.hiviewdfx.hiAppEvent (应用事件打点)](reference/apis/js-apis-hiviewdfx-hiappevent.md)
      - [@ohos.inputMethod (输入法框架)](reference/apis/js-apis-inputmethod.md)
      - [@ohos.inputMethodEngine (输入法服务)](reference/apis/js-apis-inputmethodengine.md)
      - [@ohos.InputMethodExtensionAbility (InputMethodExtensionAbility)](reference/apis/js-apis-inputmethod-extension-ability.md)
      - [@ohos.InputMethodExtensionContext (InputMethodExtensionContext)](reference/apis/js-apis-inputmethod-extension-context.md)
      - [@ohos.InputMethodSubtype (输入法子类型)](reference/apis/js-apis-inputmethod-subtype.md)
      - [@ohos.pasteboard (剪贴板)](reference/apis/js-apis-pasteboard.md)
      - [@ohos.screenLock (锁屏管理)](reference/apis/js-apis-screen-lock.md)
      - [@ohos.systemTime (系统时间、时区)](reference/apis/js-apis-system-time.md)
      - [@ohos.systemTimer (系统定时器)](reference/apis/js-apis-system-timer.md)
      - [@ohos.wallpaper (壁纸)](reference/apis/js-apis-wallpaper.md)
      - [@ohos.web.webview (Webview)](reference/apis/js-apis-webview.md)
      - [console (日志打印)](reference/apis/js-apis-logs.md)
      - [Timer (定时器)](reference/apis/js-apis-timer.md)
      - application
        - [AccessibilityExtensionContext (辅助功能扩展上下文)](reference/apis/js-apis-inner-application-accessibilityExtensionContext.md)
    - 设备管理
      - [@ohos.batteryInfo (电量信息)](reference/apis/js-apis-battery-info.md)
      - [@ohos.batteryStatistics (耗电统计)](reference/apis/js-apis-batteryStatistics.md)
      - [@ohos.brightness (屏幕亮度)](reference/apis/js-apis-brightness.md)
      - [@ohos.deviceInfo (设备信息)](reference/apis/js-apis-device-info.md)
      - [@ohos.distributedHardware.deviceManager (设备管理)](reference/apis/js-apis-device-manager.md)
      - [@ohos.geoLocationManager (位置服务)](reference/apis/js-apis-geoLocationManager.md)
      - [@ohos.multimodalInput.inputConsumer (组合按键)](reference/apis/js-apis-inputconsumer.md)
      - [@ohos.multimodalInput.inputDevice (输入设备)](reference/apis/js-apis-inputdevice.md)
      - [@ohos.multimodalInput.inputDeviceCooperate (键鼠穿越)](reference/apis/js-apis-cooperate.md)
      - [@ohos.multimodalInput.inputEvent (输入事件)](reference/apis/js-apis-inputevent.md)
      - [@ohos.multimodalInput.inputEventClient (按键注入)](reference/apis/js-apis-inputeventclient.md)
      - [@ohos.multimodalInput.inputMonitor (输入监听)](reference/apis/js-apis-inputmonitor.md)
      - [@ohos.multimodalInput.keyCode (键值)](reference/apis/js-apis-keycode.md)
      - [@ohos.multimodalInput.keyEvent (按键输入事件)](reference/apis/js-apis-keyevent.md)
      - [@ohos.multimodalInput.mouseEvent (鼠标输入事件)](reference/apis/js-apis-mouseevent.md)
      - [@ohos.multimodalInput.pointer (鼠标指针)](reference/apis/js-apis-pointer.md)
      - [@ohos.multimodalInput.touchEvent (触摸输入事件)](reference/apis/js-apis-touchevent.md)
      - [@ohos.power (系统电源管理)](reference/apis/js-apis-power.md)
      - [@ohos.runningLock (Runninglock锁)](reference/apis/js-apis-runninglock.md)
      - [@ohos.sensor (传感器)](reference/apis/js-apis-sensor.md)
      - [@ohos.settings (设置数据项名称)](reference/apis/js-apis-settings.md)
      - [@ohos.stationary (设备状态感知框架)](reference/apis/js-apis-stationary.md)
      - [@ohos.systemCapability (系统能力)](reference/apis/js-apis-system-capability.md)
      - [@ohos.systemParameterV9 (系统属性)](reference/apis/js-apis-system-parameterV9.md)
      - [@ohos.thermal (热管理)](reference/apis/js-apis-thermal.md)
      - [@ohos.update (升级)](reference/apis/js-apis-update.md)
      - [@ohos.usbV9 (USB管理)](reference/apis/js-apis-usb.md)
      - [@ohos.vibrator (振动)](reference/apis/js-apis-vibrator.md)
    - 帐号管理
      - [@ohos.account.appAccount (应用帐号管理)](reference/apis/js-apis-appAccount.md)
      - [@ohos.account.distributedAccount (分布式帐号管理)](reference/apis/js-apis-distributed-account.md)
      - [@ohos.account.osAccount (系统帐号管理)](reference/apis/js-apis-osAccount.md)
    - 定制管理
      - [@ohos.configPolicy (配置策略)](reference/apis/js-apis-configPolicy.md)
      - [@ohos.enterprise.deviceInfo (设备信息管理)](reference/apis/js-apis-enterprise-deviceInfo.md)
      - [@ohos.enterprise.EnterpriseAdminExtensionAbility (EnterpriseAdminExtensionAbility)](reference/apis/js-apis-EnterpriseAdminExtensionAbility.md)
      - [@ohos.enterprise.adminManager (企业设备管理)](reference/apis/js-apis-enterprise-adminManager.md)
      - [@ohos.enterprise.dateTimeManager (系统时间管理)](reference/apis/js-apis-enterprise-dateTimeManager.md)
    - 语言基础类库
      - [@ohos.buffer (Buffer)](reference/apis/js-apis-buffer.md)
      - [@ohos.convertxml (xml转换JavaScript)](reference/apis/js-apis-convertxml.md)
      - [@ohos.process (获取进程相关的信息)](reference/apis/js-apis-process.md)
      - [@ohos.uri (URI字符串解析)](reference/apis/js-apis-uri.md)
      - [@ohos.url (URL字符串解析)](reference/apis/js-apis-url.md)
      - [@ohos.util (util工具函数)](reference/apis/js-apis-util.md)
      - [@ohos.util.ArrayList (线性容器ArrayList)](reference/apis/js-apis-arraylist.md)
      - [@ohos.util.Deque (线性容器Deque)](reference/apis/js-apis-deque.md)
      - [@ohos.util.HashMap (非线性容器HashMap)](reference/apis/js-apis-hashmap.md)
      - [@ohos.util.HashSet (非线性容器HashSet)](reference/apis/js-apis-hashset.md)
      - [@ohos.util.LightWeightMap (非线性容器LightWeightMap)](reference/apis/js-apis-lightweightmap.md)
      - [@ohos.util.LightWeightSet (非线性容器LightWeightSet)](reference/apis/js-apis-lightweightset.md)
      - [@ohos.util.LinkedList (线性容器LinkedList)](reference/apis/js-apis-linkedlist.md)
      - [@ohos.util.List (线性容器List)](reference/apis/js-apis-list.md)
      - [@ohos.util.PlainArray (非线性容器PlainArray)](reference/apis/js-apis-plainarray.md)
      - [@ohos.util.Queue (线性容器Queue)](reference/apis/js-apis-queue.md)
      - [@ohos.util.Stack (线性容器Stack)](reference/apis/js-apis-stack.md)
      - [@ohos.util.TreeMap (非线性容器TreeMap)](reference/apis/js-apis-treemap.md)
      - [@ohos.util.TreeSet (非线性容器TreeSet)](reference/apis/js-apis-treeset.md)
      - [@ohos.util.Vector (线性容器Vector)](reference/apis/js-apis-vector.md)
      - [@ohos.worker (启动一个Worker)](reference/apis/js-apis-worker.md)
      - [@ohos.xml (xml解析与生成)](reference/apis/js-apis-xml.md)
    - 测试
      - [@ohos.application.testRunner (TestRunner)](reference/apis/js-apis-application-testRunner.md)
      - [@ohos.uitest (UiTest)](reference/apis/js-apis-uitest.md)
    - 已停止维护的接口
      - [@ohos.backgroundTaskManager (后台任务管理)](reference/apis/js-apis-backgroundTaskManager.md)
      - [@ohos.bundle (Bundle模块)](reference/apis/js-apis-Bundle.md)
      - [@ohos.bundle.innerBundleManager (innerBundleManager模块)](reference/apis/js-apis-Bundle-InnerBundleManager.md)
      - [@ohos.bundleState (设备使用信息统计)](reference/apis/js-apis-deviceUsageStatistics.md)
      - [@ohos.bytrace (性能打点)](reference/apis/js-apis-bytrace.md)
      - [@ohos.data.storage (轻量级存储)](reference/apis/js-apis-data-storage.md)
      - [@ohos.data.distributedData (分布式数据管理)](reference/apis/js-apis-distributed-data.md)
      - [@ohos.distributedBundle (分布式包管理)](reference/apis/js-apis-Bundle-distributedBundle.md)
      - [@ohos.document (文件交互)](reference/apis/js-apis-document.md)
      - [@ohos.geolocation (位置服务)](reference/apis/js-apis-geolocation.md)
      - [@ohos.hiAppEvent (应用打点)](reference/apis/js-apis-hiappevent.md)
      - [@ohos.prompt (弹窗)](reference/apis/js-apis-prompt.md)
      - [@ohos.reminderAgent (后台代理提醒)](reference/apis/js-apis-reminderAgent.md)
      - [@ohos.systemParameter (系统属性)](reference/apis/js-apis-system-parameter.md)
      - [@ohos.usb (USB管理)](reference/apis/js-apis-usb-deprecated.md)
      - [@system.app (应用上下文)](reference/apis/js-apis-system-app.md)
      - [@system.battery (电量信息)](reference/apis/js-apis-system-battery.md)
      - [@system.bluetooth (蓝牙)](reference/apis/js-apis-system-bluetooth.md)
      - [@system.brightness (屏幕亮度)](reference/apis/js-apis-system-brightness.md)
      - [@system.configuration (应用配置)](reference/apis/js-apis-system-configuration.md)
      - [@system.device (设备信息)](reference/apis/js-apis-system-device.md)
      - [@system.fetch (数据请求)](reference/apis/js-apis-system-fetch.md)
      - [@system.file (文件存储)](reference/apis/js-apis-system-file.md)
      - [@system.geolocation (地理位置)](reference/apis/js-apis-system-location.md)
      - [@system.mediaquery (媒体查询)](reference/apis/js-apis-system-mediaquery.md)
      - [@system.network (网络状态)](reference/apis/js-apis-system-network.md)
      - [@system.notification (通知消息)](reference/apis/js-apis-system-notification.md)
      - [@system.package (应用管理)](reference/apis/js-apis-system-package.md)
      - [@system.prompt (弹窗)](reference/apis/js-apis-system-prompt.md)
      - [@system.request (上传下载)](reference/apis/js-apis-system-request.md)
      - [@system.router (页面路由)](reference/apis/js-apis-system-router.md)
      - [@system.sensor (传感器)](reference/apis/js-apis-system-sensor.md)
      - [@system.storage (数据存储)](reference/apis/js-apis-system-storage.md)
      - [@system.vibrator (振动)](reference/apis/js-apis-system-vibrate.md)
      - bundle
        - [abilityInfo](reference/apis/js-apis-bundle-AbilityInfo.md)
        - [applicationInfo](reference/apis/js-apis-bundle-ApplicationInfo.md)
        - [bundleInfo](reference/apis/js-apis-bundle-BundleInfo.md)
        - [bundleInstaller](reference/apis/js-apis-bundle-BundleInstaller.md)
        - [bundleStatusCallback](reference/apis/js-apis-Bundle-BundleStatusCallback.md)
        - [customizeData](reference/apis/js-apis-bundle-CustomizeData.md)
        - [elementName](reference/apis/js-apis-bundle-ElementName.md)
        - [hapModuleInfo](reference/apis/js-apis-bundle-HapModuleInfo.md)
        - [launcherAbilityInfo](reference/apis/js-apis-bundle-LauncherAbilityInfo.md)
        - [moduleInfo](reference/apis/js-apis-bundle-ModuleInfo.md)
        - [PermissionDef](reference/apis/js-apis-bundle-PermissionDef.md)
        - [remoteAbilityInfo](reference/apis/js-apis-bundle-remoteAbilityInfo.md)
        - [shortcutInfo](reference/apis/js-apis-bundle-ShortcutInfo.md)
  - 错误码参考
    - [通用错误码](reference/errorcodes/errorcode-universal.md)
    - Ability框架
      - [元能力子系统错误码](reference/errorcodes/errorcode-ability.md)
      - [DistributedSchedule错误码](reference/errorcodes/errorcode-DistributedSchedule.md)
      - [卡片错误码](reference/errorcodes/errorcode-form.md)
    - 包管理
      - [包管理子系统通用错误码](reference/errorcodes/errorcode-bundle.md)
      - [zlib子系统错误码](reference/errorcodes/errorcode-zlib.md)
    - 公共事件与通知
      - [事件错误码](reference/errorcodes/errorcode-CommonEventService.md)
      - [DistributedNotificationService错误码](reference/errorcodes/errorcode-DistributedNotificationService.md)
    - UI界面
      - [动画错误码](reference/errorcodes/errorcode-animator.md)
      - [弹窗错误码](reference/errorcodes/errorcode-promptAction.md)
      - [页面路由错误码](reference/errorcodes/errorcode-router.md)
    - 图形图像
      - [色彩管理错误码](reference/errorcodes/errorcode-colorspace-manager.md)
      - [屏幕错误码](reference/errorcodes/errorcode-display.md)
      - [窗口错误码](reference/errorcodes/errorcode-window.md)
    - 媒体
      - [Audio错误码](reference/errorcodes/errorcode-audio.md)
      - [Media错误码](reference/errorcodes/errorcode-media.md)
      - [媒体会话管理错误码](reference/errorcodes/errorcode-avsession.md)
    - 资源管理
      - [I18n错误码](reference/errorcodes/errorcode-i18n.md)
      - [资源管理错误码](reference/errorcodes/errorcode-resource-manager.md)
    - 资源调度
      - [backgroundTaskManager错误码](reference/errorcodes/errorcode-backgroundTaskMgr.md)
      - [DeviceUsageStatistics错误码](reference/errorcodes/errorcode-DeviceUsageStatistics.md)
      - [reminderAgentManager错误码](reference/errorcodes/errorcode-reminderAgentManager.md)
      - [workScheduler错误码](reference/errorcodes/errorcode-workScheduler.md)
    - 安全
      - [AccessToken错误码](reference/errorcodes/errorcode-access-token.md)
      - [HUKS错误码](reference/errorcodes/errorcode-huks.md)
      - [用户认证错误码](reference/errorcodes/errorcode-useriam.md)
    - 数据管理
      - [关系型数据库错误码](reference/errorcodes/errorcode-data-rdb.md)
      - [数据共享错误码](reference/errorcodes/errorcode-datashare.md)
      - [分布式数据对象错误码](reference/errorcodes/errorcode-distributed-dataObject.md)
      - [分布式键值数据库错误码](reference/errorcodes/errorcode-distributedKVStore.md)
      - [首选项错误码](reference/errorcodes/errorcode-preferences.md)
    - 文件管理
      - [文件管理子系统错误码](reference/errorcodes/errorcode-filemanagement.md)
    - 网络管理
      - [上传下载错误码](reference/errorcodes/errorcode-request.md)
    - 通信与连接
      - [NFC错误码](reference/errorcodes/errorcode-nfc.md)
      - [RPC错误码](reference/errorcodes/errorcode-rpc.md)
    - 系统基础能力
      - [无障碍子系统错误码](reference/errorcodes/errorcode-accessibility.md)
      - [Faultlogger错误码](reference/errorcodes/errorcode-faultlogger.md)
      - [应用事件打点错误码](reference/errorcodes/errorcode-hiappevent.md)
      - [系统事件错误码](reference/errorcodes/errorcode-hisysevent.md)
      - [Hidebug错误码](reference/errorcodes/errorcode-hiviewdfx-hidebug.md)
      - [输入法框架错误码](reference/errorcodes/errorcode-inputmethod-framework.md)
      - [剪贴板错误码](reference/errorcodes/errorcode-pasteboard.md)
      - [锁屏服务错误码](reference/errorcodes/errorcode-screenlock.md)
      - [Webview错误码](reference/errorcodes/errorcode-webview.md)
    - 帐号管理
      - [Account错误码](reference/errorcodes/errorcode-account.md)
      - [应用帐号错误码](reference/errorcodes/errorcode-app-account.md)
    - 设备管理
      - [耗电统计错误码](reference/errorcodes/errorcode-batteryStatistics.md)
      - [屏幕亮度错误码](reference/errorcodes/errorcode-brightness.md)
      - [系统电源管理错误码](reference/errorcodes/errorcode-power.md)
      - [RunningLock锁错误码](reference/errorcodes/errorcode-runninglock.md)
      - [热管理错误码](reference/errorcodes/errorcode-thermal.md)
      - [设备管理错误码](reference/errorcodes/errorcode-device-manager.md)
      - [位置服务子系统错误码](reference/errorcodes/errorcode-geoLocationManager.md)
      - [键鼠穿越管理错误码](reference/errorcodes/errorcode-multimodalinput.md)
      - [传感器错误码](reference/errorcodes/errorcode-sensor.md)
      - [振动错误码](reference/errorcodes/errorcode-vibrator.md)
      - [系统参数错误码](reference/errorcodes/errorcode-system-parameterV9.md)
      - [USB服务错误码](reference/errorcodes/errorcode-usb.md)
      - [升级错误码](reference/errorcodes/errorcode-update.md)
    - 定制管理
      - [企业设备管理错误码](reference/errorcodes/errorcode-enterpriseDeviceManager.md)
    - 语言基础类库
      - [语言基础类库错误码](reference/errorcodes/errorcode-utils.md)
    - 测试
      - [uitest错误码](reference/errorcodes/errorcode-uitest.md)
  - 接口参考（Native API）
    - 模块
      - [Native XComponent](reference/native-apis/_o_h___native_x_component.md)
      - [HiLog](reference/native-apis/_hi_log.md)
      - [NativeWindow](reference/native-apis/_native_window.md)
      - [OH_NativeBuffer](reference/native-apis/_o_h___native_buffer.md)
      - [Drawing](reference/native-apis/_drawing.md)
      - [OH_NativeImage](reference/native-apis/_o_h___native_image.md)
      - [NativeVsync](reference/native-apis/_native_vsync.md)
      - [Image](reference/native-apis/image.md)
      - [Rawfile](reference/native-apis/rawfile.md)
      - [MindSpore](reference/native-apis/_mind_spore.md)
      - [NeuralNeworkRuntime](reference/native-apis/_neural_nework_runtime.md)
      - [AudioDecoder](reference/native-apis/_audio_decoder.md)
      - [AudioEncoder](reference/native-apis/_audio_encoder.md)
      - [CodecBase](reference/native-apis/_codec_base.md)
      - [VideoDecoder](reference/native-apis/_video_decoder.md)
      - [VideoEncoder](reference/native-apis/_video_encoder.md)
      - [Core](reference/native-apis/_core.md)
    - 头文件
      - [drawing_bitmap.h](reference/native-apis/drawing__bitmap_8h.md)
      - [drawing_brush.h](reference/native-apis/drawing__brush_8h.md)
      - [drawing_canvas.h](reference/native-apis/drawing__canvas_8h.md)
      - [drawing_color.h](reference/native-apis/drawing__color_8h.md)
      - [drawing_font_collection.h](reference/native-apis/drawing__font__collection_8h.md)
      - [drawing_path.h](reference/native-apis/drawing__path_8h.md)
      - [drawing_pen.h](reference/native-apis/drawing__pen_8h.md)
      - [drawing_text_declaration.h](reference/native-apis/drawing__text__declaration_8h.md)
      - [drawing_text_typography.h](reference/native-apis/drawing__text__typography_8h.md)
      - [drawing_types.h](reference/native-apis/drawing__types_8h.md)
      - [external_window.h](reference/native-apis/external__window_8h.md)
      - [image_pixel_map_napi.h](reference/native-apis/image__pixel__map__napi_8h.md)
      - [log.h](reference/native-apis/log_8h.md)
      - [native_buffer.h](reference/native-apis/native__buffer_8h.md)
      - [native_image.h](reference/native-apis/native__image_8h.md)
      - [native_interface_xcomponent.h](reference/native-apis/native__interface__xcomponent_8h.md)
      - [native_vsync.h](reference/native-apis/native__vsync_8h.md)
      - [raw_dir.h](reference/native-apis/raw__dir_8h.md)
      - [raw_file_manager.h](reference/native-apis/raw__file__manager_8h.md)
      - [raw_file.h](reference/native-apis/raw__file_8h.md)
      - [context.h](reference/native-apis/context_8h.md)
      - [data_type.h](reference/native-apis/data__type_8h.md)
      - [format.h](reference/native-apis/format_8h.md)
      - [model.h](reference/native-apis/model_8h.md)
      - [status.h](reference/native-apis/status_8h.md)
      - [tensor.h](reference/native-apis/tensor_8h.md)
      - [types.h](reference/native-apis/types_8h.md)
      - [neural_network_runtime_type.h](reference/native-apis/neural__network__runtime__type_8h.md)
      - [neural_network_runtime.h](reference/native-apis/neural__network__runtime_8h.md)
      - [native_avcodec_audiodecoder.h](reference/native-apis/native__avcodec__audiodecoder_8h.md)
      - [native_avcodec_audioencoder.h](reference/native-apis/native__avcodec__audioencoder_8h.md)
      - [native_avcodec_base.h](reference/native-apis/native__avcodec__base_8h.md)
      - [native_avcodec_videodecoder.h](reference/native-apis/native__avcodec__videodecoder_8h.md)
      - [native_avcodec_videoencoder.h](reference/native-apis/native__avcodec__videoencoder_8h.md)
      - [native_averrors.h](reference/native-apis/native__averrors_8h.md)
      - [native_avformat.h](reference/native-apis/native__avformat_8h.md)
      - [native_avmemory.h](reference/native-apis/native__avmemory_8h.md)
    - 结构体
      - [OH_Drawing_BitmapFormat](reference/native-apis/_o_h___drawing___bitmap_format.md)
      - [OH_NativeBuffer_Config](reference/native-apis/_o_h___native_buffer___config.md)
      - [OH_NativeXComponent_Callback](reference/native-apis/_o_h___native_x_component___callback.md)
      - [OH_NativeXComponent_MouseEvent](reference/native-apis/_o_h___native_x_component___mouse_event.md)
      - [OH_NativeXComponent_MouseEvent_Callback](reference/native-apis/_o_h___native_x_component___mouse_event___callback.md)
      - [OH_NativeXComponent_TouchEvent](reference/native-apis/_o_h___native_x_component___touch_event.md)
      - [OH_NativeXComponent_TouchPoint](reference/native-apis/_o_h___native_x_component___touch_point.md)
      - [OHExtDataHandle](reference/native-apis/_o_h_ext_data_handle.md)
      - [OHHDRMetaData](reference/native-apis/_o_h_h_d_r_meta_data.md)
      - [OhosPixelMapInfo](reference/native-apis/_ohos_pixel_map_info.md)
      - [RawFileDescriptor](reference/native-apis/_raw_file_descriptor.md)
      - [Region](reference/native-apis/_region.md)
      - [Rect](reference/native-apis/_rect.md)
      - [OH_AI_CallBackParam](reference/native-apis/_o_h___a_i___call_back_param.md)
      - [OH_AI_ShapeInfo](reference/native-apis/_o_h___a_i___shape_info.md)
      - [OH_AI_TensorHandleArray](reference/native-apis/_o_h___a_i___tensor_handle_array.md)
      - [OH_NN_Memory](reference/native-apis/_o_h___n_n___memory.md)
      - [OH_NN_QuantParam](reference/native-apis/_o_h___n_n___quant_param.md)
      - [OH_NN_Tensor](reference/native-apis/_o_h___n_n___tensor.md)
      - [OH_NN_UInt32Array](reference/native-apis/_o_h___n_n___u_int32_array.md)
      - [OH_AVCodecAsyncCallback](reference/native-apis/_o_h___a_v_codec_async_callback.md)
      - [OH_AVCodecBufferAttr](reference/native-apis/_o_h___a_v_codec_buffer_attr.md)
    - 标准库
      - [Node_API](reference/native-lib/third_party_napi/napi.md)
      - [libuv](reference/native-lib/third_party_libuv/libuv.md)
      - [支持的标准库介绍](reference/native-lib/third_party_libc/musl.md)
      - 附录
        - [Native api中没有导出的符号列表](reference/native-lib/third_party_libc/musl-peculiar-symbol.md)
        - [Native api中导出的EGL符号列表](reference/native-lib/third_party_opengl/egl-symbol.md)
        - [Native api中导出的OpenGL ES 3.0符号列表](reference/native-lib/third_party_opengl/openglesv3-symbol.md)  
- 常见问题
  - [full-SDK替换指南](quick-start/full-sdk-switch-guide.md)
  - [开发语言常见问题](faqs/faqs-language.md)
  - [Ability框架开发常见问题](faqs/faqs-ability.md)
  - [应用程序包管理开发常见问题](faqs/faqs-bundle.md)
  - [ArkUI组件（ArkTS）开发常见问题](faqs/faqs-ui-ets.md)
  - [ArkUI Web组件（ArkTS）开发常见问题](faqs/faqs-web-arkts.md)
  - [UI框架（JS）开发常见问题](faqs/faqs-ui-js.md)
  - [公共事件与通知开发常见问题](faqs/faqs-event-notification.md)
  - [图形图像开发常见问题](faqs/faqs-graphics.md)
  - [文件管理开发常见问题](faqs/faqs-file-management.md)
  - [媒体开发常见问题](faqs/faqs-media.md)
  - [网络与连接开发常见问题](faqs/faqs-connectivity.md)
  - [数据管理开发常见问题](faqs/faqs-data-management.md)
  - [设备管理开发常见问题](faqs/faqs-device-management.md)
  - [DFX开发常见问题](faqs/faqs-dfx.md)
  - [国际化开发常见问题](faqs/faqs-international.md)
  - [Native API使用常见问题](faqs/faqs-native.md)
  - [三四方库使用常见问题](faqs/faqs-third-party-library.md)
  - [IDE使用常见问题](faqs/faqs-ide.md)
  - [hdc_std命令使用常见问题](faqs/faqs-hdc-std.md)
  - [开发板使用常见问题](faqs/faqs-development-board.md)
