# 组件介绍

组件（Component）是构建页面的核心，每个组件通过对数据和方法的简单封装，实现独立的可视、可交互功能单元。组件之间相互独立，随取随用，也可以在需求相同的地方重复使用。关于组件的详细参考文档请参见[组件](../reference/arkui-js/js-components-common-attributes.md)。


开发者还可以通过组件间合理的搭配定义满足业务需求的新组件，减少开发量，自定义组件的开发方法请参见[自定义组件](../ui/ui-js-custom-components.md)。


## 组件分类

根据组件的功能，可以分为以下六大类：

| 组件类型 | 主要组件 |
| -------- | -------- |
| 容器组件 | badge、dialog、div、form、list、list-item、list-item-group、panel、popup、refresh、stack、stepper、stepper-item、swiper、tabs、tab-bar、tab-content |
| 基础组件 | button、chart、divider、image、image-animator、input、label、marquee、menu、option、picker、picker-view、piece、progress、qrcode、rating、richtext、search、select、slider、span、switch、text、textarea、toolbar、toolbar-item、toggle |
| 媒体组件 | video |
| 画布组件 | canvas |
| 栅格组件 | grid-container、grid-row、grid-col |
| svg组件 | svg、rect、circle、ellipse、path、line、polyline、polygon、text、tspan、textPath、animate、animateMotion、animateTransform |



## 相关实例

针对组件开发，有以下相关实例可供参考：

- [`JsComponentCollection`：组件集合（JS）（API9）](https://gitee.com/openharmony/applications_app_samples/tree/master/UI/JsComponentCollection)

- [`JsPanel`：内容展示面板（JS）（API8）](https://gitee.com/openharmony/applications_app_samples/tree/master/UI/JsPanel)

- [`Popup`：气泡（JS）（API8）](https://gitee.com/openharmony/applications_app_samples/tree/master/UI/Popup)

- [`RefreshContainer`：下拉刷新容器（JS）（API8）](https://gitee.com/openharmony/applications_app_samples/tree/master/UI/RefreshContainer)

- [`JSComponments`：Js组件（JS）（API8）](https://gitee.com/openharmony/applications_app_samples/tree/master/UI/JSComponments)

- [`JsUserRegistration`：用户注册（JS）（API8）](https://gitee.com/openharmony/applications_app_samples/tree/master/UI/JsUserRegistration)

- [`Badge`：事件标记控件（JS）（API8）](https://gitee.com/openharmony/app_samples/tree/master/UI/Badge)

- [`JsVideo`：视频播放（JS）（API8）](https://gitee.com/openharmony/applications_app_samples/tree/master/media/JsVideo)

- [rating（JS）（API8）](https://gitee.com/openharmony/codelabs/tree/master/JSUI/RatingApplication)

- [简易视频播放器（JS）（API8）](https://gitee.com/openharmony/codelabs/tree/master/Media/VideoOpenHarmony)
