# 后台任务概述

后台应用频繁活动，会造成用户设备耗电快、卡顿等现象。因此，为了支撑性能、功耗诉求，系统仅允许应用在后台执行规范内的活动，规范外的活动默认会被挂起，当资源不足时会被回收。
针对应用或业务模块处于后台（无可见界面）时，有需要继续执行或者后续执行的业务，可基于业务类型，申请[短时任务](#短时任务)延迟挂起或者[长时任务](#长时任务)避免进入挂起状态；使用[延迟调度任务](#延迟任务)，执行对实时性要求不高的任务；同时针对特权应用，如果需要更加灵活的配置，可以申请[能效资源](#申请能效资源)。


## 后台任务类型

OpenHarmony将后台任务分为四种类型，并提供了一个资源申请的扩展功能：

 **无后台业务** ：应用或业务模块退到后台后，无任务需要处理。

 **短时任务** ：应用或业务模块退到后台后，如果有紧急不可推迟且短时间能完成的任务，如应用退后台要进行数据压缩，不可中断，则使用短时任务申请延迟进入挂起（Suspend）状态。

 **长时任务** ：如果是用户发起的可感知业务需要长时间后台运行，如后台播放音乐、导航、设备连接、VoIP等，则使用长时任务避免进入挂起（Suspend）状态。

 **延迟任务** ：延迟任务调度给应用提供一个机制，允许应用根据系统安排，在系统空闲时执行实时性不高的任务。当满足设定条件的时候，任务会被放入待调度队列，当系统空闲时调度该任务。

 **能效资源** ：能效资源包括CPU资源、WORK_SCHEDULER资源、软件资源(COMMON_EVENT, TIMER)、硬件资源(GPS, BLUETOOTH)。如果应用或者进程申请了能效资源，那么根据能效资源的类型会拥有相应的特权，例如申请了CPU资源的可以不被挂起，申请了WORK_SCHEDULER后延时任务可以拥有更长的执行时间。

## 最佳后台任务选择

![后台任务选择](figures/bgtask_choice.png)

## 短时任务

退到后台的应用有不可中断且短时间能完成的任务时，可以使用短时任务机制。该机制允许应用在后台短时间内完成任务，保障应用业务运行不受后台生命周期管理的影响。

> **说明：**
> 短时任务仅针对应用的临时任务提供资源使用生命周期保障，限制单次最大使用时长为3分钟，全天使用配额默认为10分钟（具体时长系统根据应用场景和系统状态智能调整）。


### 短时任务使用约束

短时任务的使用需要遵从如下约束和规则：

- **申请时机**：允许应用在前台时，或退后台在被挂起之前（应用退到后台默认有6~12秒的运行时长，具体时长由系统根据具体场景决定）申请延迟挂起，否则可能被挂起（Suspend），导致申请失败。

- **超时**：延迟挂起即将超时（Timeout），系统通过回调知会应用，应用需要取消对应的延迟挂起。如果超时不取消，该应用会被强制终止。

- **取消时机**：任务完成后，应用应主动取消延迟挂起，不要等到系统回调后再取消，否则会影响该应用的后台允许运行时长配额。

- **配额机制**：为了防止应用滥用保活，或者申请后不取消，每个应用每天都会有一定配额（会根据用户的使用习惯动态调整），配额消耗完就不再允许申请短时任务，所以应用完成短时任务后应立刻取消延迟挂起，避免消耗配额。（注：该配额指的是申请的时长，系统默认应用在后台运行的时间不计算在内）。

## 长时任务
长时任务给用户能够直观感受到的且需要一直在后台运行的业务提供后台运行生命周期的保障。比如：业务需要在后台播放声音、需要在后台持续导航定位等。此类用户可以直观感知到的后台业务行为，可以通过使用长时任务对应的后台模式保障业务在后台的运行，支撑应用完成在后台的业务。

### 后台模式分类
OpenHarmony提供了九种后台模式，供需要在后台做长时任务的业务使用，具体的后台模式类型如下：

**表1** 长时任务种类

| 后台模式                  | 说明                        | 通知栏显示提示      | 备注                        |
| --------------------- | ------------------------- | ------------ | ------------------------- |
| dataTransfer          | 通过网络/对端设备进行数据下载、备份、分享、传输等 | 正在运行数据传输任务   | -                         |
| audioPlayback         | 音频输出                      | 正在运行音频播放任务   | -                         |
| audioRecording        | 音频输入                      | 正在运行录音任务     | -                         |
| location              | 定位、导航                     | 正在运行定位任务     | -                         |
| bluetoothInteraction  | 蓝牙传输                      | 正在运行蓝牙相关任务   | -                         |
| multiDeviceConnection | 分布式互联任务                   | 正在运行分布式任务    | -                         |
| wifiInteraction       | WLAN传输                    | 正在运行WLAN相关任务 | System API，仅对System权限应用开放 |
| voip                  | 音视频电话、VOIP                | 正在运行通话相关任务   | System API，仅对System权限应用开放 |
| taskKeeping           | 计算任务                      | 正在运行计算任务     | 仅在特定设备生效                  |

### 长时任务使用约束
- 如果用户选择可感知业务（如播音、导航等），触发对应后台模式，在任务启动时，系统会强制弹出通知提醒用户。
- 如果任务结束，应用应主动退出后台模式。若在后台运行期间，系统检测到应用并未使用对应后台模式的资源，则会被挂起（Suspend）。
- 避免不合理地申请后台长时任务，长时任务类型要与应用的业务类型匹配。如果执行的任务和申请的类型不匹配，也会被系统检测到并被挂起（Suspend）。
- 长时任务是为了真正在后台长时间执行某个任务，如果一个应用申请了长时任务，但在实际运行过程中，并未真正运行或执行此类任务时，也会被系统检测到并被挂起（Suspend）。
- 一个Ability同一时刻只能申请运行一个长时任务。

## 延迟任务
延迟任务调度给应用提供一个机制，允许应用根据系统安排，在系统空闲时执行实时性要求不高的任务，比如设备空闲时候做一次数据学习等场景。当应用申请延迟任务的时候，任务会被放入待调度队列，系统会根据当前状态，如内存、功耗、温度等统一决策最优的调度时机。同时支持任务的持久化，应用退出或者设备重启，设置的任务同样能够被触发。

### 延迟任务调度约束

延迟调度任务的使用需要遵从如下约束和规则：

- **超时**：系统会设置超时机制，延迟任务回调只允许运行一段时间，超时之后，系统会主动停止。默认的超时限制为2分钟，对于系统应用，可以通过[申请能效资源](efficiency-resources-apply-dev-guide.md)获取更长的执行时间（充电状态20分钟，非充电状态10分钟）。
- **执行频率**：系统会根据应用的活跃度对延迟任务做分级管控，限制延迟任务调度的执行频率。对于通过能效资源接口申请了WORK_SCHEDULER资源的应用，在资源的有效期内，它的延迟任务执行频率不受限制。

    | 应用分组                                     | 延迟任务执行频率约束 |
    | ---------------------------------------- | ---------- |
    | 活跃                                       | 最小间隔2小时    |
    | 每日使用                                     | 最小间隔4小时    |
    | 经常使用                                     | 最小间隔24小时   |
    | 不经常使用                                    | 最小间隔48小时   |
    | 受限分组                                     | 禁止         |
    | 未使用分组                                    | 禁止         |
    | [能效资源豁免分组](../reference/apis/js-apis-resourceschedule-backgroundTaskManager.md#resourcetype) | 执行频率不受限制   |

- **WorkInfo设置参数约束** 

  - workId、bundleName、abilityName为必填项，bundleName必须填本应用，否则校验失败。

  - 至少要设置一个满足的条件。

  - 重复任务时间间隔至少20分钟，当设置重复任务时间间隔时，必须设置始终重复和重复次数中的一个。

  - 携带参数信息支持number、string、bool三种类型。

## 申请能效资源
能效资源可以分为四种：CPU资源，WORK_SCHEDULER资源，软件资源(COMMON_EVENT，TIMER)，硬件资源(GPS,BLUETOOTH,AUDIO)。

应用或进程申请能效资源后能够获得相应特权：
  * 申请CPU资源后可以不被挂起，直到任务完成。
  * 申请WORK_SCHEDULER资源后不受延迟任务执行频率约束，且任务执行时间增加
  * 申请COMMON_EVENT资源后，应用在后台处于挂起状态时，仍然能够接收到系统公共事件，申请TIMER资源后，应用能够使用定时器执行精确定时任务、
  * 申请硬件资源后，应用在后台被挂起后，依然能够被相关服务唤醒，执行相应的任务。


**表1** 能效资源种类

| 参数名            | 参数值  | 描述                  |
| -------------- | ---- | ------------------- |
| CPU            | 1    | CPU资源，申请后不被挂起       |
| COMMON_EVENT   | 2    | 公共事件，申请后挂起状态下不被代理掉  |
| TIMER          | 4    | 计时器，申请后挂起状态下不被代理掉   |
| WORK_SCHEDULER | 8    | 延迟任务，申请后有更长的执行时间    |
| BLUETOOTH      | 16   | 蓝牙相关，申请后挂起状态下不被代理掉  |
| GPS            | 32   | GPS相关，申请后挂起状态下不被代理掉 |
| AUDIO          | 64   | 音频资源，申请后挂起状态下不被代理掉  |

### 能效资源使用约束
- 能效资源申请或者释放可以由进程或者应用发起，由应用发起的资源释放会释放属于它的同类型的所有资源，包括进程申请的资源。例如应用申请了CPU资源,进程申请了CPU和WORK_SCHEDULER资源，当应用释放CPU资源的时候，会将进程的CPU资源一同释放，同时不同类型的WORK_SCHEDULER资源不受影响。由进程发起的资源释放对应用申请的资源没有影响，例如当应用和进程同时申请了CPU，进程发起了CPU资源释放，应用的CPU资源不会被释放。
- 同时申请同一类持久资源和非持久资源，持久资源会覆盖非持久资源，在超时时不会释放资源。例如应用首先申请了10s的CPU资源，然后在第5s的时候申请了持久的CPU资源，那么资源会变成持久的，非持久的CPU资源记录会被持久化的CPU资源记录覆盖，到了第10s的时候资源不会被释放，如果在第8s的时候提前释放了资源，那么会将CPU资源释放，无法单独释放其中非持久的或者持久的CPU资源。
- WORK_SCHEDULER资源只能由应用申请和释放，不能由进程申请和释放。
- 需要使用能效资源的应用，需要向应用中心提出申请，获取相应的特权。
